/* SHGIMPOR.C --------------------------------------------------*
 * Import-Support for SHG-Files into ThinHelp...		*
 *--------------------------------------------------------------*/

/* Documented in "Microsoft Windows 3.1 Programmer's 
   Referenece Volume 4, Resources. Not in WINDOWS.H.
   This is the header for a Placeable Metafile        */
typedef struct tagMETAFILEHEADER
{
    DWORD  key;
    WORD   hmf;      /* Must be 0 */
    struct { short left, top, right, bottom; } bbox;
    WORD   inch;
    DWORD  reserved; /* Must be 0 */
    WORD   checksum;
}
METAFILEHEADER, FAR *LPMETAFILEHEADER;


/* -----------------------------------------------
 * SHGImport
 *
 * Does convert a Memory-Block that signifies an SHG-File into
 * a DIB-Bitmap and Segmentation-Information in SEG-File Format
 *
 * Returns:
 * TRUE : On Successfull Execution
 * FALSE: On Errors
 * -----------------------------------------------*/
#ifdef __cplusplus
extern "C"
#endif
BOOL WINAPI SHGImport(          // defined in SHGIMPOR.C
		HWND	         hwParent,  	  // Parent-Window for error Messages
		LPVOID           SHGData,   	  // Input Data Block
                HGLOBAL FAR *    lphDib,    	  // DIB-Handle
                HMETAFILE FAR*   lphMetaFile,	  // Metafile-Handle for SHG containing WMF
                LPMETAFILEHEADER lpMetaFileHeader,// Will be filled with Informations on placeable Metafiles
                HGLOBAL FAR *    lphSegInfo 	  // Segmentation Informations
		);




/* -----------------------------------------------
 * SHGExports
 *
 * Does convert a DIB-Handle and a SEGINFOHEADER-Structure
 * Into a memory Block in SHG-File Format
 *
 * Returns:
 * SHG-Memory Block
 * NULL : On Errors
 * -----------------------------------------------*/
#ifdef __cplusplus
extern "C"
#endif
HGLOBAL WINAPI SHGExport(		// defined in SHGEXPOR.C
		HWND	         hwParent,  	  // Parent-Window for error Messages
                HGLOBAL 	 hDib,    	  // DIB-Handle
                HGLOBAL 	 hSegInfo 	  // Segmentation Informations
		);

