;****************************************************************
;*                                                              *
;*      Convert (C) 1997 RonSoft.                               *
;*                                                              *
;*      A handy tool at the command line. Convert numbers       *
;*      between Hex, Dec and Bin.                               *
;*      Usage:                                                  *
;*      Convert <number> <input type>.                          *
;*      Input type can be H, D or B.                            *
;*                                                              *
;*      Comments, suggestions ?                                 *
;*                                                              *
;*      Ronald Nordberg                                         *
;*      Silvervgen 3                                           *
;*      907 50 Ume                                             *
;*      Sweden                                                  *
;*      christine.martinson@swipnet.se                          *
;*      http://home2.swipnet.se/~w-20064                        *
;*                                                              *
;*      ALL PUBLIC DOMAIN FREEWARE.                             *
;*      LET E'M KNOW IF YOU USE MY CODE.                        *
;*                                                              *
;****************************************************************

msdos           equ     21h             ;MSDOS irq
fwrite          equ     40h             ;write to file with handle
exit            equ     4c00h           ;msdos exit

[BITS 16]
[SECTION .text]
[ORG 100h]
        mov     ax,cs                   ;get code segment
        mov     ds,ax                   ;use it now

        mov     si,0080h                ;DOS command line page 0
        lodsb                           ;load size of command line
        cmp     al,0                    ;anything on command line ?
        jbe     usage                   ;noo, show usage
        cbw                             ;extend AL to AX
        xchg    bx,ax                   ;swap size to bx for indexing
        mov     byte [bx+si],0          ;null terminate command line
        call    parse                   ;parse command line
        jmp     main                    ;go on with main
usage:  mov     bx,utext                ;pointer usage text
        jmp     errout                  ;skip this
main:
        xor     eax,eax                 ;wanna clean registers
        xor     ebx,ebx
        xor     ecx,ecx
        xor     edx,edx
                                       ;calculate length of 1:st arg
        mov     si,inbuff              ;get input buffer
get0:   lodsb                          ;load AL
        cmp     al,0                   ;end of arg ?
        je      got0                   ;yeahh
        inc     cx                     ;noo, increase length count
        jmp     get0                   ;check next
got0:                                  ;first arg len in CX now
        mov     si,inbuff              ;get command line
dump:   lodsb
        cmp    al,0                    ;second command ?
        jne    dump                    ;noo
        lodsb
        and    al,0dfh                 ;force upper case
        cmp    al,'H'                  ;hex input ?
        je     dohex
        cmp    al,'D'                  ;decimal ?
        je     dodec
        cmp    al,'B'                  ;binary ?
        jne    usage                   ;noo, let us know we're wrong
                                       
                                       ;check for valid BIN input
        mov     si,inbuff              ;command line buffer
        mov     bx,errt1               ;error text
isbin:  lodsb                          ;load AL
        cmp     al,'0'                 ;a zero ?
        je      bindo                  ;yeahh
        cmp     al,'1'                 ;a 1 ?
        je      bindo                  ;yeahh
        jmp     errout                 ;noo, not binary input, skip this
bindo   loop    isbin
        call    binascbin              ;make ascii bin
        jmp     output                 ;do the output job

dohex:
        mov     si,inbuff              ;check for valid HEX input
        mov     bx,errt2               ;proper text
ishex:  lodsb                          ;get the char
        cmp     al,'0'
        jb      errout
        and     al,0dfh                ;force UPPERCASE
        cmp     al,'F'                 ;>F ?
        ja      errout                 ;yeahh, dump this
        loop    ishex
        call    hexbin                 ;make hex bin
        jmp     output
dodec:
        mov     si,inbuff              ;check for valid DEC input
        mov     bx,errt3
isdec:  lodsb
        cmp     al,'9'                 ;>9 ?
        ja      errout                 ;yeahh, skip
        loop    isdec
        lodsb
        call    decbin                 ;make dec bin
output:
        call    showit                 ;show the stuff
        jmp     quit

errout:  call   write                  ;land here if error
quit:
         mov    ax,exit
         int    msdos
 
;********************************************************
;*      Convert ascii decmimal to 32bit binary
;*      Input command line buffer, output EDX
;********************************************************
decbin:
        mov     si,inbuff               ;command line buffer
        xor     ebx,ebx                 ;clear binary output
ascdecbin:
        lodsb                           ;get ascii value into AL
        cmp     al,'0'                  ;ASCII to decimal
        jb      noascii                 ;exit if invalid ASCII
        cmp     al,'9'                  ;test for highest value
        ja      noascii                 ;exit if larger than 9
        sub     al,30h                  ;make bin decimal
        cbw                             ;byte to word
        cwd                             ;word to dword
        push    eax                     ;save digit on stack
        mov     eax,ebx                 ;move into output register
        mov     ecx,10                  ;decimal multiplier
        mul     ecx                     ;AX = AX * 10
        mov     ebx,eax                 ;move product to output register
        pop     eax                     ;restore decimal digit
        add     ebx,eax                 ;add in digit
        jmp     ascdecbin
noascii: 
        mov     edx,ebx                 ;copy to EDX
        ret

;***********************************************************
;*      Convert ascii hex to 32 bit binary
;*      Input = command line buffer, output EDX
;***********************************************************
hexbin:
        mov     si,inbuff               ;pointer command line buffer
        xor     edx,edx                 ;clear binary output
aschexbin:
        lodsb
        cmp     al,'0'                  ;< 0
        jb      notasc                  ;yes invalid character
        cmp     al,'9'                  ;<= 9
        jbe     astrip                  ;yes, strip high 4 bits
        and     al,05fh                 ;force upper case
        cmp     al,'A'                  ;< ascii A
        jb      notasc                  ;yes, invalid character
        cmp     al,'F'                  ;> ascii F
        ja      notasc                  ;yes, invalid character
        add     al,9                    ;ok, add 9 for strip
astrip:
        and     al,0fh                  ;strip high 4 bits
        mov     cx,4                    ;set shift count
        shl     edx,cl                  ;rotate EDX 4 bits
        xor     ah,ah                   ;zero out AH
        cbw
        add     edx,eax                 ;add digit to value
        jmp     aschexbin               ;continue
notasc: ret

;************************************************************
;*      Convert ascii binary to 32bit binary
;*      Input command line buffer, out EDX
;*************************************************************
binascbin:
        mov     di,inbuff               ;get command line
        mov     si,di                   ;get a copy
bdump:  cmp     byte [di],0             ;check out length of arg
        je      dok
        inc     di
        jmp     bdump
dok:    mov     ebx,2                   ;2 = binary base value
        mov     ecx,1                   ;multiplier
        xor     eax,eax                 ;clear that
nextbin:
        cmp     di,si                   ;end of command line ?
        je      binok                   ;yeahh
        dec     di                      ;next character to left
        mov     dl,[di]                 ;load the character
        sub     dl,30h                  ;convert to decimal
        xor     dh,dh                   ;clear that
        push    ecx                     ;save ECX
        xchg    eax,ecx                 ;AX = multiplier
        mul     edx                     ;digit value * multiplier
        add     ecx,eax                 ;add to partial value
        pop     eax                     ;restore multiplier
        mul     ebx                     ;base times multiplier
        xchg    eax,ecx                 ;EAX = partial value
        jmp     nextbin                 ;go do next digit
binok: 
        mov     edx,eax                 ;save result in EDX
        ret

;****************************************************************
;*      Convert binary 32bit to hex ascii                    
;*      Input EDX, output numbuff                               
;****************************************************************
binhex:
        push    edx
        mov     di,numbuff             ;output buffer
        mov     cx,8                   ;count 8 digits
hexit:
        push    cx                     ;save counter
        mov     cl,4                   ;one nibble
        rol     edx,cl                 ;rotate source left
        mov     al,dl                  ;move digit into AL
        and     al,15                  ;clear high nibble
        daa                            ;adjust AL if A-F
        add     al,240                 ;bump the carry
        adc     al,40h                 ;convert hex to ASCII
        stosb                          ;store in buffer
        pop     cx                     ;restore digit counter
        loop    hexit                  ;continue with next digit
        mov     al,0                   ;null terminate buffer
        stosb
        pop     edx
        ret

;**********************************************************
;*      Convert binary 32bit to decimal ascii
;*      Input EDX, output numbuff
;***********************************************************
bindec:
        push    edx
        mov     esi,divtab              ;pointer subtract values
        mov     di,numbuff              ;output buffer
        mov     cx,10                   ;10 digits
sublop: xor     al,al                   ;clear counter
sblop:  cmp     edx,[esi]               ;number < subractor ?
        jb      tolow                   ;yeah
        sub     edx,[esi]               ;noo, subtract
        add     al,1                    ;incrase times subtracted
        jmp     sblop                   ;subtract again
tolow:  add     al,30h                  ;make ascii
        stosb                           ;store in buffer
        add     si,4                    ;next subtractor
        loop    sublop                  ;do it
        mov     al,0                    ;null terminate buffer
        stosb
        pop     edx
        ret

;****************************************************************
;*      Convert binary 32bit to binary ascii
;*      Input EDX, output numbuff
;****************************************************************
binbin:
        push    edx
        mov     di,numbuff                               ;output buffer
        mov     cx,32                                    ;32 bits
bscan:  mov     al,'0'                                   ;assume that
        test    edx,10000000000000000000000000000000B    ;bit set ?
        jz      zero                                     ;noo
        mov     al,'1'                                   ;yeahh
zero:   stosb                                            ;store in buffer
        shl     edx,1                                    ;shift in next bit
        loop    bscan                                    ;do next bit
        mov     al,0                                     ;null terminate
        stosb
        pop     edx
        ret

;****************************************************************
;*      Show the results
;****************************************************************
showit:
showhex:
         mov    bx,htext                ;show hex
         call   write
         call   binhex                  ;convert
         mov    si,numbuff
         call   strip                   ;get rid of leading zeroes
         mov    bx,si
         call   write                   ;show value
         mov    bx,lfeed                ;cr,lf
         call   write
showdec:
         mov    bx,dtext                ;show dec
         call   write
         call   bindec
         mov    si,numbuff
         call   strip
         mov    bx,si
         call   write
         mov    bx,lfeed
         call   write
         
showbin:
         mov    bx,btext               ;show bin
         call   write
         call   binbin
         mov    si,numbuff
         call   strip
         mov    bx,si
         call   write
         mov    bx,lfeed
         call   write
         ret

;*************************************************************************
;*       Writes out the NULL terminated text supplied in BX.             *
;*************************************************************************
write   push    edx
        mov     si,bx                   ;copy to SI
        mov     cx,0                    ;clear count
wloop   lodsb                           ;load AL with SI
        cmp     al,0                    ;end of line ?
        je      wdone                   ;yeahh
        inc     cx                      ;no, incrase byte count
        jmp     wloop                   ;test next byte
wdone   mov     dx,bx                   ;text address in DX
        mov     bx,1                    ;filehandle standard output = 1
        mov     ah,fwrite               ;MS-DOS write with handle is 40h
        int     msdos                   ;write to standard output
        pop     edx
        ret                             ;done

;***********************************************************************
;       Strip off leading zeroes in buffer at SI
;***********************************************************************
strip:
        lodsb                           ;load byte
        cmp     al,'0'                  ;any leading zeroes ?
        jne     nozero                  ;noo
        jmp     strip                   ;yeahh, check next
nozero: dec     si                      ;adjust that back one byte
        ret

;*************************************************************************
;*      My kind of command line parsing. It just checks if theres
;*      any blankspaces between the options. The parameters ends up
;*      in the inbuff separated by 0:s, binary zeroes.
;*************************************************************************
parse:
        mov     di,inbuff               ;our buffer
        inc     si                      ;dump that
        mov     cx,1                    ;were here, so we got one arg
copy1:  lodsb                           ;load byte SI to AL
        cmp     al,0                    ;0 ?(end of line)
        je      done                    ;yeahh
        cmp     al,32                   ;SPACE ?
        je      copy2                   ;yeah
        stosb                           ;noo, move AL to DI, incrase DI
        jmp     copy1                   ;go on
copy2:  mov     byte [di],0             ;null terminate
        add     cx,1
        inc     di                      ;dump that byte(SPACE)
        jmp     copy1                   ;back
done:   mov     byte [di],0             ;null terminate
        ret                             ;return

;**************************** DATA STUFF ********************************

divtab: dd 1000000000                   ;subractor values
        dd  100000000
        dd   10000000
        dd    1000000
        dd     100000
        dd      10000           
        dd       1000
        dd        100
        dd         10
        dd          1

ten     dd      10

inbuff:   times 128 db 0                ;command line buffer
numbuff:  times  34 db 0                ;number buffer
utext:    db    'Convert (C) 1997 RonSoft.',13,10
          db    'Usage:',13,10
          db    'Convert <number> <input type>.',13,10
          db    'H = Hexadecimal input',13,10
          db    'D = Decmial input',13,10
          db    'B = Binary input',13,10,0
htext:    db    'Hex: ',0
dtext:    db    'Dec: ',0
btext:    db    'Bin: ',0
lfeed:    db    13,10,0
errt1:    db    "That's not binary.",13,10,0
errt2:    db    "That's not hexadecimal.",13,10,0
errt3:    db    "That's not decimal.",13,10,0
cmdlen:   db    0

END             
