/*---------------------------------------------------------------------
  L H A L I B . L I B
  Library to be used in Microsoft windows Programs
  makes it possible to extract LHA-Archives.
 ---------------------------------------------------------------------*/

//----------- Options ------------------------------------------------
#define LHA_OVERWRITE 0x0001	// Codes for Options-Parameter
#define LHA_ATTRIB    0x0010	// Set File Attributes

//----------- Callback Routine Messages ------------------------------
#define LHAM_PEEK	  1		// Nothing special
#define LHAM_NEXTFILE	  2		// Start processing next File

//------------- Error Codes -------------------------------------------
// The Errorcode are selected to be between 2000 and 2100, so it's easyer
// to store the error text in an Resource File

#define LHAE_ARCHIVNOTFOUND	 2020		// Archiv File not Found
#define LHAE_BROKEN		 2021		// Broken Archiv
#define LHAE_METHOD		 2022		// Compression Method not supported
#define LHAE_WRITE		 2023		// Error creating/writing File
#define LHAE_CRC		 2024		// CRC error
#define LHAE_CALLBACK		 2025		// Callbackroutine returned LHAN_STOP
#define LHAE_NOTANARCHIV	 2026		// Not an LHA-Archiv

//------------- Callback-Notification-Codes -----
#define LHAN_OK			 0		// Nothing special
#define LHAN_IGNOREFILE		 1		// Used with LHAM_NEXTFILE : Irgnore this File
#define LHAN_STOP		 2		// Used with LHAM_PEEK     : Stop Decompression of Archive immediatly


typedef struct {
	BYTE  HeadSiz;		// Header Size in Bytes
	BYTE  HeadChk;		// Header Checksum
	BYTE  HeadID[3];	// Header ID Code
	BYTE  Method;		// Compression Method
	BYTE  free1;
	DWORD PacSiz;		// Packed File Size
	DWORD OrgSiz;		// Original File Size not decompressed yet
	WORD FTime;		// File Time an Date Stamp
	WORD FDate;		// File Time an Date Stamp
	WORD FAttr;		// File Attributes
	BYTE FnLen;
	char FName[0x80];	// File Name
	DWORD FileSize;		// Original File Size
	DWORD UserData;		// User Data from original LHAExpand-Call
	DWORD ArcSize,		// Size of LZH-Archiv File
	      ArcRead;		// Count of Bytes read from Archiv until now (not Exact)			
	} LZHEAD;

typedef LZHEAD FAR *LPLZHEAD;

typedef int (CALLBACK* PEEKPROC)(int, LPLZHEAD);

int FAR PASCAL LHAExpand(  LPCSTR   ArchivName, // Name of LZH-Archiv-File
			   LPCSTR   PathName,	// Destination-Root-Path for decompressed Files
			   int      Options,	// LHA_xxxx Flag-Values
			   PEEKPROC PeekProc,	// Callback-Procedure
			   DWORD    UserData);	// User-Data for the Callback

