#include <windows.h>
#pragma hdrstop
#include <ddeml.h>
// #include <alloc.h>
#include "unsetup.h"


// -------- Global variables -----------------------------
DWORD    idInst = 0L;


/* DDECallback()------------------------------------------------*
 *								*
 *--------------------------------------------------------------*/
 #pragma argsused
HDDEDATA EXPENTRY DDECallback(WORD Type, WORD Fmt, HCONV ConvX, HSZ hsz1,
     HSZ hsz2, HDDEDATA Data, DWORD Data1, DWORD Data2)
{
  switch(Type)
    {
      case XTYP_DISCONNECT:
//	Conv = NULL;
      break;

      case XTYP_ERROR:
	break;

      case XTYP_XACT_COMPLETE:
	break;

   }
  return ((HDDEDATA)NULL);
}

/* ExecuteDDEMacro() -------------------------------------------*
 *								*
 *--------------------------------------------------------------*/
#define MAX_DDELEN  0x1000
#define MAX_DDETIMEOUT 100000L

HDDEDATA _cdecl ExecuteDDEMacro(HCONV hConv, LPSTR szCmd, ...)
{ BOOL	   bErr;
  HDDEDATA hszCmd;
  NPSTR    pMem  = (NPSTR) LocalAlloc(LPTR, MAX_DDELEN);
    if (NULL==pMem) return FALSE;
    //---- Komando Atom zusammen basteln -----
    wvsprintf(pMem, szCmd, ...);
    hszCmd = DdeCreateDataHandle( idInst, pMem, lstrlen(pMem)+1, 0, NULL, CF_TEXT, 0);
    //---- zum Server senden -----------------
    bErr= (BOOL) DdeClientTransaction((void FAR *) hszCmd, (DWORD)-1, hConv, NULL,
                                       CF_TEXT, XTYP_EXECUTE, MAX_DDETIMEOUT, NULL);
    //---- Error Checck ----------------------
    if (bErr==FALSE) {
      WORD i= DdeGetLastError(idInst);
      wsprintf(pMem, "ExecuteDDEMacro Fehler: %d", i);
      MessageBox(NULL, "Fehler bei DDE-Ausfhrung" ,pMem, MB_OK);
    }
    LocalFree((HLOCAL)pMem);
    return bErr;
}





/* InitDDESubsys() ---------------------------------------------*
 *								*
 *--------------------------------------------------------------*/
HCONV InitDDESubsys(LPSTR pService, LPSTR pTopic)
{
  HSZ  Service;
  HSZ  Topic;
  HCONV hret;

    //---- only one channel  ----------------------
    if (idInst!=0)
    {
      return NULL;
    }

    //---- open DDE- Channel ----------------------
    if (DMLERR_NO_ERROR!=DdeInitialize((LPDWORD)&idInst, (PFNCALLBACK)DDECallback, APPCMD_CLIENTONLY, 0L))
      return 0;

    Service = DdeCreateStringHandle(idInst, pService ,CP_WINANSI);
    Topic   = DdeCreateStringHandle(idInst, pTopic,   CP_WINANSI);

    hret= DdeConnect(idInst, Service, Topic, (PCONVCONTEXT) NULL);

    DdeFreeStringHandle(idInst, Service);
    DdeFreeStringHandle(idInst, Topic);

    return hret;
}

/* CloseDDESubsys() --------------------------------------------*
 *								*
 *--------------------------------------------------------------*/
int CloseDDESubsys(HCONV hConv )
{
  DdeDisconnect(hConv);
  DdeUninitialize(idInst);
  idInst= 0;
  return 0;
}


/* DeleteProgmanGroup ------------------------------------------*
 * High-Level Funktion lscht Progframm-Manager-Gruppe
 *--------------------------------------------------------------*/
void DeleteProgmanGroup(LPSTR GroupName)
{ HCONV hConv = InitDDESubsys("PROGMAN", "PROGMAN");
  if (hConv)
  {

    ExecuteDDEMacro(hConv, "[DeleteGroup(%s)]", GroupName);

    CloseDDESubsys(hConv);
  }
}



#ifdef TESTONLY
/*----------------------------------------------------------------------------*\
|   WinMain( hInst, hPrev, lpszCmdLine, cmdShow )                              |
|                                                                              |
|   Description:                                                               |
|                                                                              |
|   Arguments:                                                                 |
|  	hInst	    instance handle of this instance of the application            |
|  	hPrev	    instance handle of previous instance. NULL if this is the      |
|                   instance of the application                                |
|  szCmdLine    null-terminated command line                                   |
|  cmdShow      specifies how the application's window is initially displayed  |
|                                                                              |
|   Returns:                                                                   |
|       The exit code as specified in the WM_QUIT message.                     |
|                                                                              |
\*----------------------------------------------------------------------------*/
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrev, LPSTR szCmdLine, int sw)
#pragma argsused
{
    DeleteProgmanGroup("Testgroup");    

    return FALSE;
}

#endif

