/*----------------------------------------------------------------------------*\
|   unsetup.c - A Program to delete Many files including itself 	       |
|               and it's Directory					       |
|   Pubpose:    As the last Part of Uninstall-Programs			       |
|		This Program opens the File UNSETUP.LST	and		       |
|		Deletes all Files that are stored in it Line by Line	       |
|		It may also delete itself and It's Directory		       |
\*----------------------------------------------------------------------------*/

#include <windows.h>
#pragma hdrstop

#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <string.h>
#include <alloc.h>
#include "unsetup.h"

#define MXFILES 2000
#define MXDIR   100



LPSTR *szFName,
      *szDName;
        
int   nCnt=0,
      dCnt=0;  

HWND hwMain;

typedef const char near * PCSTR;

BOOL InitApplication(HINSTANCE hInst);
BOOL InitInstance(HINSTANCE hInst);

char szPaint[1000];

char szCurDir[100];




/* -Msg---------------------------------------------------------*
 * Dispatch Messages						*
 *--------------------------------------------------------------*/
void Msg(void)
{ MSG ms;
  while (PeekMessage(&ms, NULL, NULL, NULL, PM_REMOVE)) {
      TranslateMessage(&ms);	
      DispatchMessage(&ms);
  }
  return;
}


/* NowDelete----------------------------------------------------*
 * Now Delete One File or SubDir				*
 *--------------------------------------------------------------*/
void NowDelete(LPSTR szName)
{ struct ffblk ff;
  int nRtn;
  char szMyName[120];
  nRtn = findfirst( szName, &ff, FA_DIREC | FA_HIDDEN);

  while (!nRtn)
  {
     strcpy(szMyName, szName);
     if (strrchr(szMyName, '\\'))
	    *(strrchr(szMyName, '\\')+1)=0;
	else if (szMyName[1]==':')
		      szMyName[2]=0;
		 else szMyName[0]=0;
     strcat(szMyName, ff.ff_name);

     if (ff.ff_attrib & FA_DIREC) {
	if (ff.ff_name[0] != '.') {
	   strcat(szMyName, "\\*.*");
	   NowDelete(szMyName);
	   *strrchr(szMyName, '\\')=0;
	   rmdir(szMyName);
        }
     }
     else {
/*	{ char szBuf[500];
	  wsprintf(szBuf, "Lsche %s", szMyName);
	  SetWindowText(hwMain, szBuf);
	} */

//	GlobalCompact(-1);
//	Msg();
//	MessageBox(GetFocus(), "Hi", "Hi", MB_ICONHAND);
	if (strlen(szPaint)>800)
	    if (strchr(szPaint, '\n'))
		strcpy(szPaint, strchr(szPaint, '\n')+1);
	    else szPaint[0]=0;

	if (remove(szMyName)) {
	     MessageBeep(0);
	     wsprintf(szPaint+strlen(szPaint), "Lschen von %s FEHLGESCHLAGEN\r\n", (LPSTR) szMyName);
	}
	else wsprintf(szPaint+strlen(szPaint), "Lschen von %s gelungen\r\n", (LPSTR) szMyName);
	InvalidateRect(hwMain, NULL, TRUE);
        UpdateWindow(hwMain);
     }

     nRtn = findnext(&ff);
  }  
}




/* DeleteThem---------------------------------------------------*
 * Delete the Files listed in szFName				*
 *--------------------------------------------------------------*/
void DeleteThem(LPSTR *szFName, int nCnt, HINSTANCE hInst, int sw)
{ LPSTR *Nxt;
  BOOL bEnd;
  MSG ms;
  SetErrorMode(TRUE);		// Keine Fehlermeldungen ausgeben

  { HFILE x[50];
    OFSTRUCT d;
    int i;
    for (i=0; i<50; ++i)
	x[i]=OpenFile("UNSETUP.LST", &d, OF_READ | OF_SHARE_DENY_NONE);
  GlobalCompact((LONG) -1);
  InitInstance(hInst);
  ShowWindow(hwMain, sw);
  GlobalCompact(-1);


      chdir("\\");
  SetTimer(hwMain, 1, 4000, NULL);
  Msg();
  do {
     GetMessage(&ms, NULL, NULL, NULL);
     bEnd = ms.message == WM_TIMER;
     TranslateMessage(&ms);
     DispatchMessage(&ms);
  }
  while (!bEnd); 
//  remove("SELFDEL.EXE");

    for (i=0; i<50; ++i)
     if (x[i]!=-1) _lclose(x[i]);
  }


  for (Nxt = szFName; *Nxt; ++Nxt)
  {
      NowDelete(*Nxt);
  }

  for (Nxt = szDName; *Nxt; ++Nxt)
  {
      rmdir(*Nxt);
  }

}




void DeleteIni(LPSTR String)
{ LPSTR File    = String,
        Section =           strchr(File, ','),
        Key     = Section ? strchr(Section+1, ',') : NULL;
  OFSTRUCT dummy;
  char szWinDir[144];

  GetWindowsDirectory(szWinDir  , sizeof(szWinDir));

  if (Section)
  { *Section++=0;


    if (Key)
    { *Key++=0;
    }
    WritePrivateProfileString(Section, Key, NULL, File);
  } else
  {
    lstrcat(szWinDir, "\\");
    lstrcat(szWinDir, File);
    OpenFile(szWinDir, &dummy, OF_DELETE);
  }
}



/*----------------------------------------------------------------------------*\
|   WinMain( hInst, hPrev, lpszCmdLine, cmdShow )                              |
|                                                                              |
|   Description:                                                               |
|                                                                              |
|   Arguments:                                                                 |
|  	hInst	    instance handle of this instance of the application            |
|  	hPrev	    instance handle of previous instance. NULL if this is the      |
|                   instance of the application                                |
|  szCmdLine    null-terminated command line                                   |
|  cmdShow      specifies how the application's window is initially displayed  |
|                                                                              |
|   Returns:                                                                   |
|       The exit code as specified in the WM_QUIT message.                     |
|                                                                              |
\*----------------------------------------------------------------------------*/
int PASCAL WinMain(HANDLE hInst, HANDLE hPrev, LPSTR szCmdLine, int sw)
{
    FILE *fIn = fopen("UNSETUP.LST", "rt");
    char szBuf[144],
         szBuf2[144],
         szWinDir[144],
         szSystemDir[144];

    if (IDYES!=MessageBox(NULL, "Sind Sie sicher, das Sie diese Applikation vollstndig von Ihrem System entfernen mchten?", "WARNUNG", MB_YESNO | MB_ICONSTOP))
        return TRUE;

    GetSystemDirectory(szSystemDir, sizeof(szSystemDir));
    GetWindowsDirectory(szWinDir  , sizeof(szWinDir));

    if (hPrev) return FALSE;

    getcurdir(0, szCurDir+3);
    szCurDir[2]='\\';
    szCurDir[1]=':';
    szCurDir[0]=getdisk()+'A';

    szFName=(LPSTR *) calloc(MXFILES, sizeof(LPSTR));
    szDName=(LPSTR *) calloc(MXDIR  , sizeof(LPSTR));
    szPaint[0]=0;

    InitApplication(hInst);

    Msg();

    if (fIn)
    {
       while (!feof(fIn)) {
	  fgets(szBuf, sizeof(szBuf), fIn);
	  if (!feof(fIn))
          {
	      if (strchr(szBuf, '\n'))
		 *strchr(szBuf, '\n')=0;

              if (*szBuf)
                 if (!memicmp(szBuf, "GROUP:", 6))
                      DeleteProgmanGroup(szBuf+6);
                 else
                 if (!memicmp(szBuf, "INI:", 4))
                      DeleteIni(szBuf+4);
                 else
                 {
                    if (!memicmp(szBuf, "WINDOWS\\", 8))
                         wsprintf(szBuf2, "%s%s", (LPSTR) szWinDir, (LPSTR) szBuf+7);
                    else
                    if (!memicmp(szBuf, "SYSTEM\\", 7))
                         wsprintf(szBuf2, "%s%s", (LPSTR) szWinDir, (LPSTR) szBuf+6);
                    else
                    if (szBuf[0]=='.')
                         wsprintf(szBuf2, "%s%s", (LPSTR) szCurDir, (LPSTR) szBuf+1);
                         else if (szBuf[0]!='\\' && szBuf[1]!=':')
                                   wsprintf(szBuf2, "%s\\%s", (LPSTR) szCurDir, (LPSTR) szBuf);
                              else lstrcpy(szBuf2, szBuf);

                    if (!chdir(szBuf2))
                            szDName[dCnt++]=strdup(szBuf2);
                       else
                            szFName[nCnt++]=strdup(szBuf2);
                 }
	  }
       }

      fclose(fIn);

      DeleteThem(szFName, nCnt, hInst, sw);
    }
    else
      MessageBox(GetFocus(), "Kann Datei UNSETUP.LST nicht ffnen", "UnSetup...", MB_ICONSTOP | MB_OK);

    chdir("\\");

    return FALSE;
}



void SelfDelPaint(HWND hWnd)
{ PAINTSTRUCT ps;
  RECT rc;
  GetClientRect(hWnd, &rc);
  BeginPaint(hWnd, &ps);
//  TextOut(ps.hdc, 0, 0, szPaint, strlen(szPaint));
  DrawText(ps.hdc, szPaint, -1, &rc, DT_CENTER);

  EndPaint(hWnd, &ps);
}


DWORD FAR PASCAL _export SelfDelProc(HWND hWnd, WPARAM msg, WPARAM wParam, LPARAM lParam)
{ switch (msg) {
    case WM_PAINT : SelfDelPaint(hWnd); break;
  }
  return DefWindowProc(hWnd, msg, wParam, lParam);
}


BOOL InitApplication(HINSTANCE hInst)
{       WNDCLASS cls;
       /* Register a class for the main application window */

        cls.hCursor        = LoadCursor(NULL,IDC_ARROW);
        cls.hIcon          = NULL; //LoadIcon(hInst,MAKEINTATOM(ID_APP));
        cls.lpszMenuName   = NULL;
	cls.lpszClassName  = MAKEINTATOM(815);
	cls.hbrBackground  = (HBRUSH)COLOR_WINDOW + 1;
        cls.hInstance      = hInst;
        cls.style          = CS_BYTEALIGNCLIENT | CS_VREDRAW | CS_HREDRAW | CS_DBLCLKS;
	cls.lpfnWndProc    = (WNDPROC) SelfDelProc;
        cls.cbWndExtra     = 0;
        cls.cbClsExtra     = 0;

	return !RegisterClass(&cls);
}


BOOL InitInstance(HINSTANCE hInst)
{     hwMain = CreateWindow(MAKEINTATOM(815), "Entfernen der Komponenten luft",
			    WS_OVERLAPPED | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_THICKFRAME/* | WS_VISIBLE | WS_MAXIMIZE*/,    // Style bits
			    0,0,500,500,            // Position, size
                            (HWND)NULL,             // Parent window (no parent)
                            (HMENU)NULL,            // use class menu
			    hInst, 		    // handle to window instance
                            (LPSTR)NULL             // no params to pass on
			    );
      UpdateWindow(hwMain);

      return TRUE;
}


