/*
 *  copy.c - Copy routine for wInstall
 *
 *  notes:
 *	we now use the LZCopy stuff so COMPRESS is NOT defined
 *	we now set the crit error handler ourselves so CHECKFLOPPY is
 *	NOT defined
 */

#include <windows.h>
#include <dos.h>
#include <string.h>
#include <stdlib.h>
#ifdef __BORLANDC__
#  include <dir.h>	  // Borlandc Directory-Support
#else
#  include <direct.h>
#endif
#ifdef VER
#  include <ver.h>
#endif

#include "lobotomy.h"

// ...and lets even remove some more brain cells...

#define NOWINSTYLES       //- WS_*, CS_*, ES_*, LBS_*, SBS_*, CBS_*
#define NOSHOWWINDOW      //- SW_*
#define NOATOM            //- Atom Manager routines
#define NOCOLOR           //- Screen colors
#define NOGDI             //- All GDI defines and routines
#define NOMINMAX          //- Macros min(a,b) and max(a,b)
#define NOOPENFILE        //- OpenFile(), OemToAnsi, AnsiToOem, and OF_*
#define NOTEXTMETRIC      //- typedef TEXTMETRIC and associated routines
#define NOWINOFFSETS      //- GWL_*, GCL_*, associated routines


#include "sulib.h"
#include "install.h"
#include "ws.h"
#include "progdde.h"
#include "gauge.h"
#include "lhadec.h"		// LHALIB-Interface
#ifndef NOZIP
# include "zipdec.h"
#endif


char szDisks[] = "disks";

BOOL PUBLIC GetDiskPath(char cDisk, PSTR szPath);
WORD PUBLIC wsCopyStatus(int msg, int n, LPSTR szFile);

/*
 *  global vars used by DosCopy
 */
static LPSTR    lpBuf = NULL;   // copy buffer
static int      iBuf = 0;       // usage count
static WORD     nBufSize;
static char	cDisk;
       char	cOverwrite;	// Overwrite-Flag: S,A,N,I
static LPSTR	szEdit;
extern PSTR	pErrMsg;
extern char     szCaption[];

int		ProPosition,		// Position at start of Copy...
		ProRangeForFile;


#define MAXBUF  (30 * 1024)     // size of default copy buffer

void NEAR PASCAL AllocCopyBuf(void);
void NEAR PASCAL FreeCopyBuf(void);

void NEAR PASCAL LoadTheDiskBitmap(int nNo);
int  NEAR DosWildCopy(PSTR szSrc, PSTR szPath, FPFNCOPY fpfnCopy);

/*void PUBLIC fartonear(LPSTR dst, LPSTR src)
{
	while (*src)
		*dst++ = *src++;

	*dst = 0;
}*/







/* mkdirext ----------------------------------------------------*
 * Create a sub\sub\sub-Directory....				*
 *--------------------------------------------------------------*/
int PUBLIC mkdirext(char *szPath)
{	int err,
            retry=0;    


	// Ergnzung 29.7.94 Werner Braun. Jetzt auch Anlegen verschachtelter
	//   Pfade.

		char p1[256], *p2;

		err = ~ERROR_OK;    // err auf einen sinnvollen Wert setzen
			    // fr die folgende Schleife
	strcpy(p1,szPath);
	while ((err = mkdir(szPath)) != ERROR_OK && retry++<50)
        {

	    // strlen(p1) == 3 bedeutet zwangslufig RootDir. Das geht nicht.

	    while (strlen(p1) > 3 && (err = mkdir(p1)) != ERROR_OK)
            {
		// Letzten Pfad-Bestandtteil von p1 wegkrzen bis zur
				// Ebene unmittelbar unter dem Rootdir.

		p2 = strrchr(p1,'\\');
		*p2 = 0;

	    }
			// Damit wre die oberste Ebene angelegt, jetzt auf ein Neues.

			strcpy(p1,szPath);
	}

        return err;
}



/*  WORD FileCopy (szSource, szDir, fpfnCopy, WORD f)
 *
 *  This function will copy a group of files to a single destination
 *
 *  ENTRY:
 *
 *  szSource     : pointer to a SETUP.INF section
 *  szDir        : pointer to a string containing the target DIR
 *  fpfnCopy     : CALLBCK function used to notify called of copy status
 *  fCopy        : flags
 *
 *      FC_SECTION      - szSource is a section name
 *      FC_LIST         - szSource is a pointer to a list, each item \0
 *                        terminated and the whole list \0\0 terminated
 *      FC_FILE         - szSource is a file name.
 *      FC_QUALIFIED    - szSource is a fully qualified file name.
 *      FC_DEST_QUALIFIED - szDir is fully qualified. Don't expand this.
 *
 *  NOTES:
 *      if szSource points to a string of the form '#name' the section
 *      named by 'name' will be used as the source files
 *
 *      the first field of each line in the secion is used as the name of the
 *      source file.  A file name has the following form:
 *
 *          #:name
 *
 *          #       - Disk number containing file 1-9,A-Z
 *          name    - name of the file, may be a wild card expression
 *
 *  Format for copy status function
 *
 *  BOOL FAR PASCAL CopyStatus(int msg, int n, PSTR szFile)
 *
 *      msg:
 *          COPY_ERROR          error occured while copying file(s)
 *                              n      is the DOS error number
 *                              szFile is the file that got the error
 *                              return: TRUE ok, FALSE abort copy
 *
 *          COPY_STATUS         Called each time a new file is copied
 *                              n      is the percent done
 *                              szFile is the file being copied
 *                              return: TRUE ok, FALSE abort copy
 *
 *          COPY_INSERTDISK     Please tell the user to insert a disk
 *                              n      is the disk needed ('1' - '9')
 *                              return: TRUE try again, FALSE abort copy
 *
 *          COPY_QUERYCOPY      Should this file be copied?
 *                              n      line index in SETUP.INF section (0 based)
 *                              szFile is the line from section
 *                              return: TRUE copy it, FALSE dont copy
 *
 *          COPY_START          Sent before any files are copied
 *
 *          COPY_END            Sent after all files have been copied
 *                              n   is dos error if copy failed
 *
 *
 *  EXIT: returns TRUE if successful, FALSE if failure.
 *
 */

WORD PUBLIC FileCopy (LPSTR szSource, PSTR szDir, FPFNCOPY fpfnCopy, WORD fCopy, char cDisk)
{
    int       err = ERROR_OK;
    char      szPath[MAXPATHLEN];	// Vollstndiger Pfadname der Zieldatei
    char      szLogSrc[MAXPATHLEN];
    char      szSrcBase[15];
    char      szSrc[MAXPATHLEN];
    char      szErrFile[MAXPATHLEN],
    	      szOverwrite[MAXSTR];
    LPSTR far *pFileList;
    LPSTR far *pFileListBegin;
    LPSTR     pFile;
    LPSTR     pFileBegin;
    BOOL      fDoCopy;
    int       n = 0;
//    int       nDisk;
//    char      cDisk;
    int       cntFiles = 0;

    #define CALLBCK(msg,n,pFile) \
        (fpfnCopy ? ((*fpfnCopy)((WORD)(msg),(int)(n),(LPSTR)(pFile))) : FC_IGNORE)

    if (!szSource || !*szSource || !szDir || !*szDir)
        return FALSE;

#ifndef COMPRESS
    AllocCopyBuf();
#endif

    //------------- Zielverzeichnis bearbeiten : ist Windows-Verzeichnis ? ---
    lstrcpy(szPath, szDir);
#   ifndef __WIN32__
    AnsiUpper(szPath);
#   endif
    /*  fix up the drive in the destination
     */

         if ( fCopy & FC_DEST_QUALIFIED )
              lstrcpy(szPath,szDir);
	 else ExpandFileName(szDir,szPath);

    fCopy &= ~FC_DEST_QUALIFIED;

    //----------- Ergnzung 6.6.93 : Bedingte Installation --------------
    if (szSource[0] == '?') {
       char szQuest[200];
       int  nAnswer;
       wsprintf((LPSTR) szQuest, (LPSTR) wsLoadSz(IDS_QUEST,NULL), szSource+1);
       nAnswer=MessageBox(NULL, szQuest, szCaption, MB_YESNO | MB_TASKMODAL);
       if (nAnswer==IDYES) szSource[0]='#';
	     else          return FALSE;
    }

    //----------- Falls Dateiname eine Section ist: Section kopieren! ---
    if (szSource[0] == '#' && fCopy == FC_FILE)
    {
        fCopy = FC_SECTION;
        ++szSource;
    }

    //----------- Parameter abhngig vom zu kopierenden Objekktyp (Section, File)...
    switch (fCopy)
    {
        case FC_LSTPTR:
            pFileList = pFileListBegin = (LPSTR far *)szSource;
            pFileBegin = *pFileList;

            while ( pFileList[n] ) {
	       if ( *pFileList[n] )
		  ++cntFiles;
               ++n;
            }

            break;

        case FC_SECTION:
	    {
	    char buf[40];

	    lstrcpy(buf, szSource);
	    szSource = infFindSection(NULL,buf);
            if (szSource == NULL)
		goto exit;

	    fCopy = FC_LIST;
	    }
            // fall through to FC_LIST

        case FC_LIST:
            pFileBegin = szSource;
            cntFiles = infLineCount(szSource);
            break;

        case FC_FILE:
        case FC_QUALIFIED:
        default:
            pFileBegin = szSource;
	    cntFiles = 1;
    }

    /*
     * Does the destination directory exist? if not create it.
     */
    if (!DosValidDir(szPath))
    {   char szPathOem[MAXPATHLEN];
        AnsiToOem(szPath, szPathOem);

	err = mkdirext(szPathOem);

	// oh no! this is bad

	if (err != ERROR_OK) {
	    CALLBCK(COPY_ERROR,err,szPath);
	    goto exit;
	}
    }

    /*
     *  walk all files in the list and call DosWildCopy ....
     *
     *  NOTES:
     *      we must walk file list sorted by disk number.
     *      we should use the disk that is currently inserted.
     *      we should do a find first/find next on the files????
     *      we need to check for errors.
     *      we need to ask the user to insert disk in drive.
     *
     */
    CALLBCK(COPY_START,0,NULL);

//    for (nDisk = 1; cntFiles > 0 && !bCancel; nDisk++) {

//	cDisk      = CHDISK(nDisk);
	pFileList  = pFileListBegin;
	pFile      = pFileBegin;
	n          = 0;

	while (pFile) {

	    /*
	     *  should we copy this file?
	     *  copy the files in disk order.
	     */
	    AnsiUpperBuff(pFile,1);
	    fDoCopy = pFile[1] == ':' && cDisk == pFile[0] ||
		      pFile[1] != ':' && cDisk == '1' && *pFile ||
		      fCopy == FC_QUALIFIED;

	    if (fDoCopy)
		cntFiles--;         // done with a file. decrement count.

	    if (fDoCopy && CALLBCK(COPY_QUERYCOPY,n,pFile)) {

		if (CALLBCK(COPY_STATUS, 0, pFile) == FC_ABORT) {
		    err = ERROR_NOFILES;
		    goto exit;
		}

                // Get File Overwrite Flag 
		cOverwrite = infParseField(pFile, 4, szOverwrite) ? szOverwrite[0] : 'S';

		// now we convert logical dest into a physical (unless FC_QUALIFIED)

                infParseField(pFile, 1, szLogSrc);	 // logical source
                if ( fCopy != FC_QUALIFIED )
                   ExpandFileName(szLogSrc, szSrc); // full physical source
                else
                   lstrcpy(szSrc,szLogSrc);

tryagain:   
		// Show User something beautyfull

		LoadTheDiskBitmap(szLogSrc[0]);

                // Call low level copy command

                err = DosWildCopy(szSrc, szPath, fpfnCopy);
      
                if (err != ERROR_OK) {

		    lstrcpy(szSrcBase, FileName(szSrc)); // save base name

                    if (err == ERROR_FILENOTFOUND || err == ERROR_PATHNOTFOUND) {

                        // isolate the path

                        StripPathName(szSrc);

		   	// now try to get a new path in szSrc

			switch (CALLBCK(COPY_INSERTDISK, szLogSrc[0], szSrc)) {
	           	case FC_RETRY:
		   		catpath(szSrc, szSrcBase);	// add the file back on
		   		goto tryagain;			// and try again...

                   	case FC_ABORT:
                   		goto exit;

	           	case FC_IGNORE:
        	        	break;
                   	}

                    }

		    // ERROR situation
		    //
		    // this may be a real error or something like
		    // a share violation on a network.

		    ExpandFileName(szLogSrc, szSrc);	// full physical source

		    // if it is a write error report the destination file
		    // otherwise report with the source file

		    switch (err) {
		    case ERROR_WRITE:
		    	lstrcpy(szErrFile, szPath);
			catpath(szErrFile, szSrcBase);
		    	break;

		    default:
		    	lstrcpy(szErrFile, szSrc);
		    }

		    switch (CALLBCK(COPY_ERROR, err, szErrFile)) {

                    case FC_RETRY:
                            goto tryagain;
    
                    case FC_ABORT:
                            goto exit;

                    case FC_IGNORE:
                            break;
                    }
                }

		if (CALLBCK(COPY_STATUS,100,pFile) == FC_ABORT) {
                    err = !ERROR_OK;
                    goto exit;
                }
            }

            /*
             * Move on to next file in the list
             */
            n++;
            if (fCopy == FC_LSTPTR)
                pFile = *(++pFileList);
	         else if (fCopy == FC_LIST)
                pFile = infNextLine(pFile);
            else
                pFile = NULL;
        }
//    }

    err = ERROR_OK;

exit:
    CALLBCK(COPY_END,err,NULL);
#ifndef COMPRESS
    FreeCopyBuf();
#endif
    return err;

    #undef CALLBCK
}

#ifndef COMPRESS

/*  AllocCopyBuf()
 *
 *  allocate a buffer for DosWildCopy to use
 *
 */
void NEAR PASCAL AllocCopyBuf()
{
    if (iBuf++ == 0)
    {
        nBufSize = MAXBUF;
        for(;;)
        {
            lpBuf = FALLOC(nBufSize);
            if (lpBuf || nBufSize == 1)
                break;
            nBufSize /= 2;
        }
        if (lpBuf == NULL)
            iBuf--;
    }
}

/*  FreeCopyBuf()
 *
 *  free copy buffer, if its use count is zero
 *
 */
void NEAR PASCAL FreeCopyBuf()
{
    if (iBuf > 0 && --iBuf == 0 && lpBuf)
    {
	FFREE(lpBuf);
    }
}
#endif

PSTR GetExtension(PSTR szFile)
{
	PSTR ptr;

	for (ptr = szFile; *ptr && *ptr != '.'; ptr++);

	if (*ptr != '.')
		return NULL;
	else
		return ptr+1;

}


#ifdef __WIN32__
/* TestOverwriteCondition32 ------------------------------------*
 * Fragt, ob der neu zu installierende File den vorhandenen	*
 * File ersetzen soll...					*
 * Rckgabe: IDYES  : File ersetzen				*
 *	     IDNO   : File nicht ersetzen			*
 *	     ICANCEL: Verarbeitung abbrechen			*
 *--------------------------------------------------------------*/

int TestOverwriteCondition32(LPCSTR FileName, LPFILETIME ntime)
{
     FILETIME time;
     BOOL     NewFileIsOlder;
     HANDLE   fh;			// File handle of opened File

     char     MsgText[200],
	      StrBuf[200];
     int      nAnswer=IDYES; 		// MessageBox-Answer

     SYSTEMTIME stime,
                sntime;



     fh = CreateFile( FileName, 0, 0, NULL, OPEN_EXISTING, 0, NULL);

     if (fh != NULL)
     {			// If File already exists
        GetFileTime(fh, NULL, NULL, &time);
        CloseHandle(fh);

	if (cOverwrite == 'I')		// Ignore all existing Files?
	   return IDCANCEL;

	if (cOverwrite == 'O')		// Overwarite all Files ?
	   return 0;

			 // File to install < File already There?
        NewFileIsOlder = CompareFileTime(ntime, &time) < 0;

	if (cOverwrite == 'N' || NewFileIsOlder) { // ASk only, if installed File is newer

	   // --------- Ask user if he/she wishes to overwrite it. ------
           FileTimeToSystemTime(ntime, &sntime);
           FileTimeToSystemTime(&time, &stime);

	   LoadString(hiRes, NewFileIsOlder ? IDS_OVERWRITENEWER : IDS_OVERWRITE, StrBuf, sizeof(StrBuf));
	   wsprintf(MsgText, StrBuf, FileName, sntime.wDay, sntime.wMonth, sntime.wYear, sntime.wHour, sntime.wMinute,
                                               stime.wDay , stime.wMonth , stime.wYear , stime.wHour , stime.wMinute);

	   nAnswer = MessageBox(hwndWS, MsgText, "Setup...", MB_YESNOCANCEL | MB_ICONQUESTION);
	}
    }

   return nAnswer;
}
#endif


/* -------------------------------------------------------------*
 *  DosCopy(PSTR szSrc, PSTR szPath)
 *
 *  Copy the file specifed by szSrc to the drive and directory
 *  specifed by szPath
 *
 *  ENTRY:
 *      szSrc   - Fully qualified File name to copy from
 *      szPath  - directory to copy to
 *	fpfnCopy- Callback-Function for File-Changes etc.
 *
 *  RETURNS:
 *      0 - no error, else dos error code
 *
 */
int NEAR DosCopy(PSTR szSrc, PSTR szPath, FPFNCOPY fpfnCopy)
{
    int          f = ERROR_OK;
#   ifdef __WIN32__
    HANDLE       fh;    
    FILETIME     otime , ntime;
    SYSTEMTIME   sotime, sntime;
#   else
    int          fhDst;
    unsigned     odate, otime, ndate, ntime;
#   endif

#   ifdef VER
    char	 szDstFileName[MAXPATHLEN],
		 szSrcDir[MAXPATHLEN],
		 szSrcLz [MAXPATHLEN],
		 szCurDir [_MAX_PATH],
		 szDstDir [_MAX_PATH],
		 szTmpFile[_MAX_PATH],
		 szBuffer[MAXSTR],
		 szUserQuestion[1000];
    WORD 	 wRet;
    DWORD 	 dwRet;
    UINT 	 wCurDirLen = sizeof(szCurDir);
    UINT 	 wDstDirLen = sizeof(szDstDir);
    UINT 	 wTmpFileLen = sizeof(szTmpFile);
    OFSTRUCT	 dummy;
    BOOL	 IgnoreProblem = TRUE;
#   endif
    int		 nAnswer;

      /*
       * create the source file name from the source path and the file
       * name that DosFindFirst/Next found
       */

      /*
       * Test for the Source-File Type:
       * .ARJ -> ARJ-Archiv
       * .LZH -> LZH-Archiv
       * else -> Normal or LZEXPAND-File.
      */

#     ifndef NOZIP
      if (fnMystrstr(szSrc, ".ZIP"))
	  f = CopyZip(szSrc, szPath, fpfnCopy);	// Bei ZIP32-Komprimierten Archiven
      else
#     endif

#     ifndef NOARJ
      if (fnMystrstr(szSrc, ".ARJ"))
	  f = CopyArj(szSrc, szPath);	// Bei ARJ-Komprimierten Archiven
      else
#     endif

#     ifndef NOLHA  
      if (fnMystrstr(szSrc, ".LZH"))
	  f = CopyLha(szSrc, szPath, fpfnCopy);// Bei LHA-Komprimierten Archiven
      else
#     endif
      {
	/*
	 * Do a normal DOS- or LZEXPAND-Type Copy process.
	 */

#	ifdef VER
	/*
	 * Overwrite-File decision...
	 */

	/*
	 * create the destination file name from the dest path and the file
	 * name that DosFindFirst/Next found
	 */
	lstrcpy(szDstFileName,szPath);

	catpath(szDstFileName,FileName(szSrc));

	lstrcpy(szSrcDir,szSrc);
	StripPathName(szSrcDir);


#       ifdef __WIN32__
        if (NULL!=(fh = CreateFile( szDstFileName, 0, 0, NULL, OPEN_EXISTING, 0, NULL)))
        {
           GetFileTime(fh, NULL, NULL, &otime);
           CloseHandle(fh);
        }

	/* ------ Hat Quelldatei ein _ am Ende ?------------------ */
	lstrcpy(szSrcLz, szSrc);
	if (NULL == (fh = CreateFile( szSrcLz, 0, 0, NULL, OPEN_EXISTING, 0, NULL)))
	   if (szSrcLz[0])
           {
	      szSrcLz[lstrlen(szSrcLz)-1]='_';
	      fh = CreateFile( szSrcLz, 0, 0, NULL, OPEN_EXISTING, 0, NULL);
	   }

	if (fh!=NULL)
        {
           GetFileTime(fh, NULL, NULL, &ntime);
           CloseHandle(fh);
	}
	  else return f = ERROR_FILENOTFOUND;

        FileTimeToSystemTime(&ntime, &sntime);
        FileTimeToSystemTime(&otime, &sotime);
#       else
	fhDst = OpenFile( szDstFileName, &dummy, OF_READ | OF_SHARE_DENY_NONE);
	if (fhDst!=HFILE_ERROR)
        {
	      _dos_getftime(fhDst,&odate,&otime);
	      _lclose(fhDst);
	}

	/* ------ Hat Quelldatei ein _ am Ende ?------------------ */
	lstrcpy(szSrcLz, szSrc);
	if (HFILE_ERROR == (fhDst = OpenFile( szSrcLz, &dummy, OF_READ | OF_SHARE_DENY_NONE)))
	   if (szSrcLz[0]) {
	      szSrcLz[lstrlen(szSrcLz)-1]='_';
	      fhDst = OpenFile( szSrcLz, &dummy, OF_READ | OF_SHARE_DENY_NONE);
	}

	if (fhDst!=HFILE_ERROR) {
	      _dos_getftime(fhDst,&ndate,&ntime);
	      _lclose(fhDst);
	}
	  else return f = ERROR_FILENOTFOUND;

#       endif
	/*----  */
	  fpfnCopy(COPY_STATUS, 0, NULL);
//	  UpdateWindow(hwndWS);

	/*----  */

#       ifdef __WIN32__
	do {
	   if (IDCANCEL == (nAnswer = TestOverwriteCondition32(szDstFileName, &ntime)))
		if (fnErrorMsg(IDS_EXITMSG) )
		return bCancel = TRUE;
	} while(nAnswer==IDCANCEL);
#       else
	do {
	   if (IDCANCEL == (nAnswer = TestOverwriteCondition(szDstFileName, ndate, ntime)))
		if (fnErrorMsg(IDS_EXITMSG) )
		return bCancel = TRUE;
	} while(nAnswer==IDCANCEL);
#       endif

	if (nAnswer == IDYES) {

	 wRet = VerFindFile (
			  0,//VFFF_ISSHAREDFILE,
			  FileName(szSrc),	// Name of File to be installed
			  szPath,		// Windows-Path (ignored)
			  szPath,		// Applications-Directory
			  szCurDir,
			  &wCurDirLen,
			  szDstDir,
			  &wDstDirLen);

	 /*
	  * The LZ-routine called by VerInstallFile looks for a renamed file
	  * (i.e with the "_" in it's extension if the actual file is not
	  * found in the source directory).
	  */
	 dwRet = VerInstallFile (
			     VIFF_DONTDELETEOLD | (cOverwrite == 'A' ? VIFF_FORCEINSTALL : 0),	// flags
			     FileName(szSrc),	// Name of File to be installed (Source)
			     FileName(szSrc),	// Name of File to be installed (Destination)
			     szSrcDir,		// Directory containing the Source-File.
			     szPath,		// Directory for the Destination-File
			     szCurDir,		// Directory containing the currently installed File.
			     szTmpFile,		// Filename used to compare File-Dates etc.
			     &wTmpFileLen);	// Length of szTmpFile-Buffer


	 /*
	  * Ask User for special Cases like Language-Mismatch etc...
	  */

	 /* Compare return value against all defined bit values and take
	  * appropriate action on each.
	  */
	 if (dwRet & (VIF_MISMATCH|VIF_SRCOLD|VIF_DIFFLANG|VIF_DIFFCODEPG|\
		      VIF_DIFFTYPE | VIF_CANNOTREADDST))
	 {
	   wsLoadSz(IDS_VIF, szBuffer);

#          ifdef __WIN32__
	   wsprintf(szUserQuestion, szBuffer,
			(LPSTR) szSrc,
			sntime.wDay, sntime.wMonth, sntime.wYear, sntime.wHour, sntime.wMinute,
			(LPSTR) szDstFileName,
			sotime.wDay, sotime.wMonth, sotime.wYear, sotime.wHour, sotime.wMinute);
#          else
	   wsprintf(szUserQuestion, szBuffer,
			(LPSTR) szSrc,
			ndate & 0x1f, (ndate>>5) & 0xf, (ndate>>9)+80, ntime >> 11, (ntime >> 5) & 0x3f,
			(LPSTR) szDstFileName,
			odate & 0x1f, (odate >>5) & 0xf, (odate>>9)+80,otime >> 11, (otime >> 5) & 0x3f);
#          endif


	   if (dwRet & VIF_MISMATCH)     lstrcat(szUserQuestion, wsLoadSz(IDS_VIF_MISMATCH, NULL));
	   if (dwRet & VIF_SRCOLD)       lstrcat(szUserQuestion, wsLoadSz(IDS_VIF_SRCOLD, NULL));
	   if (dwRet & VIF_DIFFLANG)     lstrcat(szUserQuestion, wsLoadSz(IDS_VIF_DIFFLANG, NULL));
	   if (dwRet & VIF_DIFFCODEPG)   lstrcat(szUserQuestion, wsLoadSz(IDS_VIF_DIFFCODEPG, NULL));
	   if (dwRet & VIF_DIFFTYPE)     lstrcat(szUserQuestion, wsLoadSz(IDS_VIF_DIFFTYPE, NULL));
	   if (dwRet & VIF_CANNOTREADDST)lstrcat(szUserQuestion, wsLoadSz(IDS_VIF_CANNOTREADDST, NULL));

	   lstrcat(szUserQuestion, wsLoadSz(IDS_VIF2, NULL));


	   if (cOverwrite!='I' &&
			       (cOverwrite == 'O' ||
				IDYES == MessageBox(NULL, szUserQuestion, wsLoadSz(IDS_PROBLEM, NULL), MB_ICONQUESTION | MB_YESNO)
			       )
	      )
		 dwRet = VerInstallFile (
			     VIFF_DONTDELETEOLD | VIFF_FORCEINSTALL,	// flags
			     szTmpFile,		// Name of File to be installed (Source) -> Temporary File
			     FileName(szSrc),	// Name of File to be installed (Destination)
			     szPath,		// Directory containing the Source-File.
			     szPath,		// Directory for the Destination-File
			     szCurDir,		// Directory containing the currently installed File.
			     szTmpFile,		// Filename used to compare File-Dates etc.
			     &wTmpFileLen);	// Lengtrh of szTmpFile-Buffer
	 }


	 /* Compare return value against all defined bit values and take
	  * appropriate action on each.
	  */
	  if (dwRet & (VIF_MISMATCH|VIF_SRCOLD|VIF_DIFFLANG|VIF_DIFFCODEPG|\
		       VIF_DIFFTYPE | VIF_CANNOTREADDST))
	      f = ERROR_OK; 	     /* a mismatch , don't copy */

	 /* The remaining flags (if any) represent errors. Depending on broad
	  * classification of these, return a suitable INSTVER error code
	  */
	 else if (dwRet & (VIF_WRITEPROT | VIF_FILEINUSE | VIF_ACCESSVIOLATION|
			  VIF_SHARINGVIOLATION | VIF_CANNOTDELETE |\
			  VIF_CANNOTREADSRC))

	  f = ERROR_SHARE;

	 else if (dwRet & VIF_OUTOFSPACE)

	  f = ERROR_WRITE;

	 else if (dwRet & VIF_OUTOFMEMORY)

	  f =  ERROR_NOMEMORY;

	 else if (dwRet & (VIF_CANNOTCREATE | VIF_CANNOTRENAME | VIF_TEMPFILE))

	  f =  ERROR_WRITE;


	 /*
	  * Check if we need to delete a Temporary File.
	  */
	 if (dwRet & VIF_TEMPFILE) {
	     if (!SLASH(szDstDir[_fstrlen (szDstDir) - 1]))
		 _fstrcat (szDstDir, "\\");
	     lstrcat (szDstDir, szTmpFile);
	     OpenFile((LPSTR)szDstDir, &dummy, OF_DELETE);
	 }
	}
#	else

	fhSrc = FOPEN(szFile);

	if (fhSrc < 0)
	{
	    f = FERROR();
	    goto errfree;
	}

	/* Save date of opened file */
#       ifndef __WIN32__            // Not supportet by now
	if (_dos_getftime(fhSrc,&date,&time))
	   goto errclose1;
#	endif

#ifdef LZEXPAND
	fhSrc = LZInit(fhSrc);
#endif
	/*
	 * create the destination file name from the dest path and the file
	 * name that DosFindFirst/Next found
	 */
	lstrcpy(szFile,szPath);

#       ifdef __WIN32__
	catpath(szFile,ff.cFileName);
#	else
	catpath(szFile,fcb.ff_name);
#	endif

	fhDst = FCREATE(szFile);

	if (fhDst == -1)
	{
	    f = FERROR();
	    goto errclose1;
	}
	/*---- Kopieren der Daten von Src->Dst ---------*/
#ifdef LZEXPAND
	while ( (size = LZRead(fhSrc,lpBuf,nBufSize)) > 0)
#else
	while ( (size = FREAD(fhSrc,lpBuf,nBufSize)) != 0)
#endif
	{
	    /*---- ----*/
	    if (FWRITE(fhDst,lpBuf,size) != size)
	    {
		/*---- write error? ----*/
		f = FERROR();
		if (f == ERROR_OK)
		    f = ERROR_WRITE;
		goto errclose;
	    }
	}
#       ifndef __WIN32__		// Not supportet by now
	/* Restore date of written file */
	_dos_setftime(fhDst,date,time);
#       endif

	/*----  Aufrumen: Datei schlieen -------------*/
errclose:
	FCLOSE(fhDst);
errclose1:
#ifdef LZEXPAND
	LZClose(fhSrc);
#else
	FCLOSE(fhSrc);
#endif
#	endif// VER
      } // else (Not ARJ or LZH)


      return f;
}



/*  DosWildCopy(PSTR szSrc, PSTR szPath)
 *
 *  Copy the file specifed by szSrc to the drive and directory
 *  specifed by szPath
 *
 *  ENTRY:
 *      szSrc   - File name to copy from
 *		  May contain Wildcard-Characters like *.EXE etc.
 *      szPath  - directory to copy to
 *	fpfnCopy- Callback-Function for File-Changes etc.
 *
 *  RETURNS:
 *      0 - no error, else dos error code
 *
 */
int NEAR DosWildCopy(PSTR szSrc, PSTR szPath, FPFNCOPY fpfnCopy)
{
#   ifdef __WIN32__
    WIN32_FIND_DATA ff;

    HANDLE	    hFind = INVALID_HANDLE_VALUE;
#   else
    struct ffblk fcb;
#   endif
    char         szSrcFile[MAXPATHLEN];
    int          f = ERROR_OK;

    //----------------- Falls ein Komrpimiertes Archiv vorliegt ------------------

//    strupr(szSrc);
    AnsiUpper(szSrc);


    ProPrintf(ID_STATUS3, wsLoadSz(IDS_SOURCE, NULL), (LPSTR) szSrc);

/*
#   ifndef NOARJ
    if (fnMystrstr(szSrc, ".ARJ")) return CopyArj(szSrc, szPath);	// Bei ARJ-Komprimierten Archiven
#   endif

    if (fnMystrstr(szSrc, ".LZH")) return CopyLha(szSrc, szPath, fpfnCopy);// Bei LHA-Komprimierten Archiven
*/

#ifdef DEBUG
    if (fDontCopy)
	return ERROR_OK;

    if (infGetProfileString(NULL,"setup","copy",szFile) && szFile[0] == 'f')
	return ERROR_OK;
#endif

    AllocCopyBuf();

    if (!lpBuf)
	return ERROR_NOMEMORY;

#ifdef CHECK_FLOPPY
    if (!IsDiskInDrive(szSrc[0]))
    {
	f = ERROR_FILENOTFOUND;
	goto errfree;
    }
#endif


    /* Are there any Wildcards used ? */
    if (strchr(szSrc, '?') != NULL ||
	strchr(szSrc, '*') != NULL) {


       /* Test, if a File exists that matches Specifications */
#      ifdef __WIN32__
       if (INVALID_HANDLE_VALUE == (hFind = FindFirstFile(szSrc, &ff)) ) {
		f = ERROR_FILENOTFOUND;
		goto errfree;
       }
#      else
       if (findfirst(szSrc, &fcb, ATTR_FILES)) {
		f = ERROR_FILENOTFOUND;
		goto errfree;
       }
#      endif

       /*
	* copy every file that matches the file pattern passed in.
	*/
       do
       {
	lstrcpy(szSrcFile,szSrc);
	StripPathName(szSrcFile);
#       ifdef __WIN32__
	catpath(szSrcFile, ff.cFileName);
#       else
	catpath(szSrcFile, fcb.ff_name);
#       endif
	f = DosCopy(szSrcFile, szPath, fpfnCopy);

#      ifdef __WIN32__
       }   while (f == ERROR_OK && FindNextFile(hFind, &ff));
#      else
       }   while (f == ERROR_OK && !findnext(&fcb));
#      endif
    } else
       f = DosCopy(szSrc, szPath, fpfnCopy);

errfree:

    FreeCopyBuf();
#   ifdef __WIN32__
    if (hFind != INVALID_HANDLE_VALUE)
       FindClose(hFind);
#   endif

    return f;
}


/* BOOL fnMystrstr(char *szSrcStr, char *szSearchStr);
 *
 * Function will return BOOL value as to weather the Search string exists
 * any where within the source string. The difference between this func
 * the C run time func is that this one is simpler and is also not case
 * sensitive.
 *
 * ENTRY: szSrcStr    - Char buffer to be searched.
 *
 *        szSearchStr - String that will be searched for.
 *
 * EXIT:  BOOL value as to weather or not string was found.
 *
 *
 * WARNING: Source and search strings MUST be null terminated.
 *          
 *
 */
BOOL fnMystrstr(szSrcStr, szSearchStr)
char       *szSrcStr;
char       *szSearchStr;
{
   unsigned      len;             // Get length of search string.

   while (szSearchStr[0] == '.' && SLASH(szSearchStr[1]))
      szSearchStr+=2;

   len = lstrlen(szSearchStr);

   while ( !ISEOL(*szSrcStr) ) {
      if ( ! strnicmp(szSrcStr,szSearchStr,len))
         return TRUE;
      ++szSrcStr;
   }
   return FALSE;

}

/*  BOOL GetDiskPath(char cDisk, szPath)
 *
 *  This function will retrive the full path name for a logical disk
 *  the code reads the [disks] section of SETUP.INF and looks for
 *  n = path where n is the disk char.  NOTE the disk '0' defaults to
 *  the root windows directory.
 *
 *  ENTRY:
 *
 *  cDisk        : what disk to find 0-9,A-Z
 *  szPath       : buffer to hold disk path
 *
 */
BOOL PUBLIC GetDiskPath(char cDisk, PSTR szPath)
{
    char    ach[2];
    char    szBuf[MAXPATHLEN];

    if (cDisk == '0')
    {
	/*
	 * return the windows setup directory
	 */
	lstrcpy(szPath,szSetupPath);
	return TRUE;
    }

    /*
     * now look in the [disks] section for a full path name
     */
    ach[0] = cDisk;
    ach[1] = 0;
    if ( !infGetProfileString(NULL,szDisks,ach,szPath) )
       return FALSE;
    infParseField(szPath,1,szPath);
    /*
     *  is the path relative? is so prepend the szDiskPath
     */
    if (szPath[0] == '.' || szPath[0] == 0)
    {
        lstrcpy(szBuf,szDiskPath);
	if (! fnMystrstr(szDiskPath,szPath) )
           catpath(szBuf,szPath);
        lstrcpy(szPath,szBuf);
    }
    return TRUE;
}


/*  BOOL FAR PASCAL ExpandFileName(PSTR szFile, PSTR szPath)
 *
 *  This function will retrive the full path name for a file
 *  it will expand, logical disk letters to pyshical ones
 *  will use current disk and directory if non specifed.
 *
 *  if the drive specifed is 0-9, it will expand the drive into a
 *  full pathname using GetDiskPath()
 *
 *  IE  0:system ==>  c:windows\system
 *      1:foo.txt     a:\foo.txt
 *
 *  ENTRY:
 *
 *  szFile       : File name to expand what disk to find
 *  szPath       : buffer to hold full file name
 *
 */
BOOL PUBLIC ExpandFileName(PSTR szFile, PSTR szPath)
{
    char    szBuf[MAXPATHLEN*2];

	 if (!memicmp(szFile, "0:WINDOWS", 9))
         {
	    GetWindowsDirectory(szPath, MAXPATHLEN-2);
            if (szFile[9])
                lstrcat(szPath,szFile + 9);
         }
    else if (!memicmp(szFile, "0:SYSTEM32", 10))
    {
#        ifdef __WIN32__
         GetSystemDirectory(szPath, MAXPATHLEN-2);
#        else
         if (GetWinFlags()&0x4000) // Windows NT has a SYSTEM32-Directory
         {
            GetWindowsDirectory(szPath, MAXPATHLEN-15);
            lstrcat(szPath, "\\SYSTEM32");
         }
         else                      // Windows 95 just uses SYSTEM-Directory
	    GetSystemDirectory(szPath, MAXPATHLEN-2);
#        endif
         if (szFile[10])
                lstrcat(szPath,szFile + 10);
    }
    else if (!memicmp(szFile, "0:SYSTEM", 8))
         {
	    GetSystemDirectory(szPath, MAXPATHLEN-2);
            if (szFile[8])
                lstrcat(szPath,szFile + 8);
         }
    else

    if (szFile[1] == ':' && GetDiskPath(szFile[0],szBuf))
    {
        lstrcpy(szPath,szBuf);
        if (szFile[2])
            catpath(szPath,szFile + 2);
    }
    else
    {
        lstrcpy(szPath,szFile);
    }
    return TRUE;
}

/*-----------------------------------------------------------------------------

    wsCount() : Anzahl der zur Installation ausgewhlten Dateien summieren

  -----------------------------------------------------------------------------*/
static  int     nFiles;


int PUBLIC wsCount(PSTR szSection)
{
    PINF    pinf,			// Section List
	    pinfLine;			// Lines in the Section
    char    szSource[MAXSTR],		// Copy Source: Section Name of File-List
	    szLine  [MAXSTR];		// Line Buffer


    if (szSection) {

       ProPrintf(ID_STATUS1, wsLoadSz(IDS_WAITCOPY,NULL));

       for (pinf = infFindSection(NULL,szSection); pinf; pinf = infNextLine(pinf))
       {

	   dprintf("inf line:%ls\n", (LPSTR)pinf);

	   infParseField(pinf,1,szSource);

	   if (szSource[0] == '#' ||
	       szSource[0] == '?') {

	       // count these, and copy below
	       for (pinfLine=infFindSection(NULL,szSource+1); pinfLine; pinfLine = infNextLine(pinfLine)) {
		   nFiles += infParseField(pinfLine,3,szLine)		// Get 3. Parameter: Relative File Size
				? atoi(szLine)
				: 10;
	       }

//	       nFiles += infLineCount(infFindSection(NULL, szSource + 1));
	       dprintf("nFiles:%d\n", nFiles);

	   } else
	       nFiles++;
       }
/*
       for (pinf = infFindSection(NULL,szSection); pinf; pinf = infNextLine(pinf))
       {

	   dprintf("inf line:%ls\n", (LPSTR)pinf);

	   infParseField(pinf,1,szSource);

	   if (szSource[0] == '#' ||
	       szSource[0] == '?') {

	       // count these, and copy below

	       nFiles += infLineCount(infFindSection(NULL, szSource + 1));
	       dprintf("nFiles:%d\n", nFiles);

	   } else
	       nFiles++;
       }*/
    }
       else nFiles =0;

    return nFiles;
}




/*----------------------------------------------------------------------------*\
|   wsCopy()                                                                   |
|                                                                              |
\*----------------------------------------------------------------------------*/
BOOL PUBLIC wsCopy(PSTR szSection, char cDisk)
{
    PINF    pinf;
    char    szSource[MAXSTR];
    char    szDest[MAXSTR];
    int	    err = ERROR_OK;

    // we use different sections for net and win386 setup.  net setup
    // overrides win386.

    dprintf("wsCopy %s\n",szSection);

    dprintf("nFiles:%d\n", nFiles);

    ProSetBarRange(nFiles);

    for (pinf = infFindSection(NULL,szSection);
	 pinf && !bCancel;
	 pinf = infNextLine(pinf))
    {
	infParseField(pinf,1,szSource);
	infParseField(pinf,2,szDest);
	if ((err = FileCopy(szSource,szDest,(FPFNCOPY)wsCopyStatus,FC_FILE,cDisk)) != ERROR_OK)
	   break;
    }

    return err == ERROR_OK;
}

/*----------------------------------------------------------------------------*\
|   define the call back function used by the FileCopy() function.	       |
|                                                                              |
\*----------------------------------------------------------------------------*/

WORD PUBLIC wsCopyStatus(int msg, int n, LPSTR szFile)
{
    char buf[80];

    switch (msg)
    {
	case COPY_INSERTDISK:
	    return wsInsertDisk(n,szFile);

	case COPY_ERROR:
	    ProSetBarPos(ProPosition);
	    return wsCopyError(n,szFile);

	case COPY_QUERYCOPY:

/*	    // special case hack for .386 files built into win386.exe

	    infParseField(szFile, 1, buf);

	    if (*FileName(buf) == '*')
		return FALSE;		// don't copy
*/
	    return TRUE;

	case COPY_END:
	case COPY_START:
	    SetErrorMode(msg == COPY_START);	// don't crit error on us
	    break;

        case COPY_STATUS:
	    if (n == 0)
	    {
		dprintf("%ls\n", (LPSTR)szFile);

                ProPosition = ProGetBarPos();

		// if there is a title, update it.  this allows shared titles

		if (infParseField(szFile,2,buf))
			ProPrintf(ID_STATUS2, wsLoadSz(IDS_COPYING,NULL), (LPSTR)buf);

		ProRangeForFile = infParseField(szFile,3,buf)
					? atoi(buf)
					: 10;

	    } else

	    if (n == 100)
	    {
		ProSetBarPos(ProPosition + ProRangeForFile);

/*		ProDeltaPos(infParseField(szFile,3,buf)	// Get relative File Size
			     ? atoi(buf)
			     : 10);*/
//		ProDeltaPos(1);
	    } else
		ProSetBarPos(ProPosition + MulDiv(n, ProRangeForFile, 100) );

	    if (! wsYield() )
                return FC_ABORT;

	    break;
    }
    return FC_IGNORE;
}

/*----------------------------------------------------------------------------*\
|                                                                              |
| wsCopyError()                                                                |
|                                                                              |
|   Handles errors, as the result of copying files.                            |
|                                                                              |
|   this may include net contention errors, in witch case the user must	       |
|   retry the operation.						       |
|                                                                              |
\*----------------------------------------------------------------------------*/
WORD PUBLIC wsCopyError(int n, LPSTR sz)
{
    char buf[200];
    char file[MAXSTR];
    int  res;

    lstrcpy(file, sz);		// in case our DS moves durring wsLoadSz()

    if (!wsLoadSz(IDS_ERROR + n, buf)) {

    	// error string doesn't exist.  if it is a net error use
	// net string, if not that use generic error string

    	if (n > ERROR_SHARE)
		wsLoadSz(IDS_ERROR + ERROR_SHARE, buf);
	else
	        wsprintf(buf, wsLoadSz(IDS_ERROR,NULL), n);
    }

    lstrcat(buf,"\n");

    // check for the out of disk space case

    if (n == ERROR_WRITE) {		// check for out of disk space

    	dprintf("free space on disk %ld\n", DosDiskFreeSpace(0));

	if (DosDiskFreeSpace(0) < 50000L)
    		lstrcat(buf, wsLoadSz(IDS_OUTOFDISK, NULL));
    }

    lstrcat(buf, file);		// add the file name

    // pass these through globals

    pErrMsg = buf;
    res = DialogBox(hiRes, MAKEINTRESOURCE(DLG_COPYERROR), GetActiveWindow(), wsErrorDlg);

    return res;
}


/*----------------------------------------------------------------------------*\
|                                                                              |
| wsInsertDisk()                                                               |
|                                                                              |
|   Handles errors, as the result of copying files.                            |
|                                                                              |
\*----------------------------------------------------------------------------*/
WORD PUBLIC wsInsertDisk(int n, LPSTR szSrcPath)
{
    cDisk  = (char)n;

    szEdit = szSrcPath;

    return (WORD)DialogBox(hiRes, MAKEINTRESOURCE(DLG_INSERTDISK), GetActiveWindow(), wsDiskDlg);
}

/*----------------------------------------------------------------------------*\
|   wsDiskDlg( hDlg, uiMessage, wParam, lParam )                               |
|                                                                              |
|   Arguments:                                                                 |
|       hDlg            window handle of about dialog window                   |
|       uiMessage       message number                                         |
|       wParam          message-dependent                                      |
|       lParam          message-dependent                                      |
|                                                                              |
|   Returns:                                                                   |
|       TRUE if message has been processed, else FALSE                         |
|                                                                              |
\*----------------------------------------------------------------------------*/

BOOL CALLBACK _export static wsDiskDlg(HWND hDlg, unsigned uiMessage, WPARAM wParam, LPARAM lParam)
{

    switch (uiMessage)
    {
	case WM_COMMAND:
	    switch (wParam)
	    {
		case ID_OK:

		    // szEdit points to the path that will be retried

		    GetDlgItemText(hDlg, ID_EDIT, szEdit, MAXSTR);
		    lstrcpy(szDiskPath, szEdit);	// and make this the default

                    EndDialog(hDlg, FC_RETRY);
		    break;

		case ID_CANCEL:

		    EndDialog(hDlg, FC_IGNORE);
		    break;
	    }
	    return TRUE;

        case WM_INITDIALOG:
	    {
            /*
             *  now look in the [disks] section for the disk name
             *  the disk name is the second field.
             */
	    char ach[2];
	    char buf[MAXSTR];
	    char buf2[MAXSTR];

            ach[0] = cDisk;
            ach[1] = 0;

            infGetProfileString(NULL,wsLoadSz(IDS_DISKS,NULL),ach,buf);

	    infParseField(buf,2,buf2);

            SetDlgItemText(hDlg,ID_TEXT,buf2);
	    SetDlgItemText(hDlg,ID_EDIT,szEdit);

	    wsDlgInit(hDlg);

	    MessageBeep(0);

            return TRUE;
	    }
    }
    return FALSE;
}

/*----------------------------------------------------------------------------*\
|   wsYield()                                                                  |
|                                                                              |
|   Description:                                                               |
|       Handle any messages in our Que, return when the Que is empty           |
|                                                                              |
|   Returns:                                                                   |
|       FALSE if a WM_QUIT message was encountered, TRUE otherwise             |
|                                                                              |
\*----------------------------------------------------------------------------*/
BOOL PUBLIC wsYield()
{
    MSG     msg;
    BOOL    retval = TRUE;

    while (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE)) {

        if ( msg.message == WM_QUIT )
           retval = FALSE;

    	if (CheckSpecialKeys(&msg))
		continue;

        TranslateMessage(&msg);
        DispatchMessage(&msg);

    }
    return retval;
}


/***************************************************************************
 * BOOL PUBLIC CheckSpecialKeys(PMSG pmsg)
 * 
 * returns:
 *	TRUE	it was special and I delt with it
 *	FALSE	it wasn't special so pass it on
 *
 **************************************************************************/
BOOL PUBLIC CheckSpecialKeys(LPMSG lpmsg)
{
	if (lpmsg->message != WM_KEYDOWN)
		return FALSE;

        switch(lpmsg->wParam) {

	// exit keys

        case VK_F3:
		PostMessage(hwndWS,WM_COMMAND,ID_EXITSETUP,0L);
		break;

	default:
		return FALSE;
        }
	return TRUE;		// yes, this was a special key
}

#ifdef CHECK_FLOPPY

#define CBSECTORSIZE	512
#define INT13_READ	2



/*--------------------------------------------------------------------------

  IsValidDiskette() -
									    
--------------------------------------------------------------------------*/


/****************************************************************************
*
*    FUNCTION: CheckRM(LPTSTR)
*
*    PURPOSE: Verifies that a removeable media drive contains a disk
*
*    COMMENTS:
*
*        This function is called each time a drive type is determined to be
*        removeable (DRIVE_REMOVEABLE).  An attempt is made to open a
*        file in the root directory of the drive.  If the attempt succeeds,
*        then media is present in the drive and subsequent calls to the
*        drive can be safely made.  If the call fails, then there is no media
*        present in the drive and no attempts should be made to access this
*        drive.  The Error Mode is temporarily set to 1 to allow failures
*        to immediately return to the calling program.  This eliminates
*        unwanted dialog boxes that prompt for disks to be placed in the
*        drive.
*
*    INPUT: lpszDriveName - removeable media drive name (ex - "a:")
*
*    OUTPUT: Returns TRUE if media present
*                    FALSE if media is not present
*
****************************************************************************/

#ifdef __WIN32__
BOOL NEAR IsValidDiskette(int iDrive)
{
  HFILE    iRC;
  char     lpszFileName[30];
  OFSTRUCT ofstruct;
  WORD     wStyle=OF_EXIST;
  UINT     uiOldMode;

  uiOldMode = SetErrorMode(SEM_NOOPENFILEERRORBOX);
  wsprintf(lpszFileName, "%c:\.", iDrive);
  iRC=OpenFile(lpszFileName,&ofstruct,wStyle);
  SetErrorMode(uiOldMode);
  if (iRC==HFILE_ERROR)
    return (FALSE);
//  _lclose(iRC);
  return (TRUE);
}


#else

BOOL NEAR IsValidDiskette(int iDrive)
{
  char	    buf[CBSECTORSIZE];

  iDrive |= 0x0020;	// make lower case

  iDrive -= 'a';	// A = 0, B = 1, etc. for BIOS stuff

  return MyReadWriteSector(buf, INT13_READ, iDrive, 0, 0, 1);
}

#endif

#endif

#ifdef CHECK_FLOPPY

/*  BOOL IsDiskInDrive(char cDisk)
 *
 *  Is the specifed disk in the drive
 *
 *  ENTRY:
 *
 *  cDisk        : what disk required to be in the drive (logical)
 *
 *  return TRUE if the specifed disk is in the drive
 *         FALSE if the wrong disk is in the drive or disk error
 *
 */
BOOL NEAR IsDiskInDrive(int iDisk)
{

    if ((iDisk  >= 'A' && iDisk <= 'Z') || 
    	(iDisk  >= 'a' && iDisk <= 'z')) {

	    if (DosRemoveable(iDisk)) {

	        if (!IsValidDiskette(iDisk))
        		return FALSE;
	    }


	    return TRUE;
    }

    return TRUE;	// for non drive letters assume a path
    			// and thus always in.
}

#endif 

void PUBLIC catpath(PSTR path, PSTR sz)
{
    //
    // Remove any drive letters from the directory to append
    //
    if ( sz[1] == ':' )
       sz+=2;

    //
    // Remove any current directories ".\" from directory to append
    //
    while (sz[0] == '.' && SLASH(sz[1]))
        sz+=2;

    //
    // Dont append a NULL string or a single "."
    //
    if (*sz && !(sz[0] == '.' && sz[1] == 0))
    {
       if ( (!SLASH(path[lstrlen(path)-1])) && ((path[lstrlen(path)-1]) != ':') )
          lstrcat(path,CHSEPSTR);
       lstrcat(path,sz);
    }
}


PSTR PUBLIC FileName(PSTR szPath)
{
    PSTR   sz;

    for (sz=szPath; *sz; sz++)
	;
    for (; sz>=szPath && !SLASH(*sz) && *sz!=':'; sz--)
	;
    return ++sz;
}

PSTR PUBLIC StripPathName(PSTR szPath)
{
    PSTR   sz;

    sz = FileName(szPath);

    if (sz > szPath+1 && SLASH(sz[-1]) && sz[-2] != ':')
        sz--;

    *sz = 0;
    return szPath;
}

/* LoadTheDiskBitmap -------------------------------------------*
 * Load the next bitmap connected with a Disk-Number		*
 *--------------------------------------------------------------*/
static int nOldNo = -1;

void NEAR PASCAL LoadTheDiskBitmap(int nNo)
{
  char ach[2];
  char buf[MAXSTR];

  ach[0] = nNo;
  ach[1] = 0;


  if (nNo != nOldNo) {
     nOldNo = nNo;
     infGetProfileString(NULL,wsLoadSz(IDS_DISKS,NULL),ach,buf);

     if (infParseField(buf,3,szBitmap))
	 LoadTheBitmap(szBitmap);
  }
}
