/*------------------------------------------------------------------

	A S T E P I X : Bibliothek mit Sammlung von Routinen zur
			Handhabung von DIBs (Device-Independend-Bitmaps)

			Bernd Herd
			Rudolf-Virchow-Str. 8
			6842 Brstadt

			Basierend : DIB.C des SDK 3.0

	DibInfo:	Bitmap-Headerdaten (BITMAPINFOHEADER) extrahieren
			Entspricht etwa GetObject( bitmap,... )
        	
  ------------------------------------------------------------------*/

#include <windows.h>
#include "leonardo.h"			// Headerfile fr Anwndungsprogramme
#include "leonardi.h"			// Bibliotheksinterner Headerfile
#pragma hdrstop

/****************************************************************************
 *									    *
 *  FUNCTION   : DibInfo(HANDLE hbi,LPBITMAPINFOHEADER lpbi)		    *
 *									    *
 *  PURPOSE    : Retrieves the DIB info associated with a CF_DIB	    *
 *		 format memory block.					    *
 *									    *
 *  RETURNS    : TRUE  - if successful. 				    *
 *		 FALSE - otherwise					    *
 *									    *
 ****************************************************************************/
BOOL API DibInfo (HDIB hbi, LPBITMAPINFOHEADER lpbi)
{   int WidthBytes;
    if (hbi){
	*lpbi = *(LPBITMAPINFOHEADER)GlobalLock (hbi);

	/* fill in the default fields */
	if (lpbi->biSize != sizeof (BITMAPCOREHEADER)){
	    if (lpbi->biSizeImage == 0L) {
	        WidthBytes = WIDTHBYTES((int) lpbi->biWidth*(int) lpbi->biBitCount);
		lpbi->biSizeImage = WidthBytes * lpbi->biHeight;
	    }


	    if (lpbi->biClrUsed == 0L)
		lpbi->biClrUsed = DibNumColors (lpbi);
	}
	GlobalUnlock (hbi);
	return TRUE;
    }
    return FALSE;
}
