/*----------------------------------------------------------------------------*
|   install.c - A template for a Windows application installer 		       |
|                                                                              |
|		MIt umfangreichen Modifikationen von Bernd Herd		       |
\*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*\
|                                                                              |
|   i n c l u d e   f i l e s                                                  |
|                                                                              |
\*----------------------------------------------------------------------------*/

//#include "lobotomy.h"
#include <windows.h>
#pragma hdrstop
#include <string.h>
#ifdef __BORLANDC__
#  include <dir.h>
#else
#  include <direct.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <shellapi.h>
#include <commdlg.h>

#include "sulib.h"
#include "ws.h"
#include "progdde.h"
#include "gauge.h"
#include "install.h"
#include "helpids.h"
#include "leonardo.h"


/*#ifdef WIN32
# define NOCTL3D TRUE
#endif*/

#ifndef NOCTL3D
// #include "..\..\psupp\ctl3d\ctl3d.h"
typedef   BOOL (WINAPI *CTL3DPROC)(HINSTANCE);
HINSTANCE hCtl3DLib = NULL;
#endif

#define MAXTMP 256

#if defined(__BORLANDC__) && !defined(__WIN32__)
void _cdecl _setupio(void){}		// Diese Zeile spart 2KByte Speicher, weil Dateien direkt verwaltet werden!

int _RTLENTRY _sys_nerr = 50;		// Diese Variable wird vom Laufzeit-system Angesprochen bei chdrive...,
					// und fhrt dann zum Linken von PERROR, was wiederum... unntig Platz verbrt

size_t      _RTLENTRYF _EXPFUNC strlen(const char _FAR *__s) { return lstrlen(__s); }
#endif


#if defined(__BORLANDC__) && defined(__WIN32__)
// --------- Omit General Protection Handler Stuff--------
void _InitDefaultHander(void) {};
void _fpreset(void) {};
void _initmatherr(int (*matherr)(void *), int (*matherrl)(void *)) {};
void _initfmode(int *fmodeptr){};
void _cdecl _setupio(void){}		// Diese Zeile spart 2KByte Speicher, weil Dateien direkt verwaltet werden!

int _RTLENTRY _sys_nerr = 50;		// Diese Variable wird vom Laufzeit-system Angesprochen bei chdrive...,
					// und fhrt dann zum Linken von PERROR, was wiederum... unntig Platz verbrt

size_t      _RTLENTRYF _EXPFUNC strlen(const char _FAR *__s) { return lstrlen(__s); }

void * _RTLENTRY malloc(size_t lSize)
{ HGLOBAL h;
  h=GlobalAlloc(GMEM_MOVEABLE, lSize);
  return (void *) GlobalLock(h);
}

void * _RTLENTRY calloc(size_t lSize, size_t nCnt)
{ HGLOBAL h;

  h=GlobalAlloc(GMEM_ZEROINIT | GMEM_MOVEABLE, lSize * nCnt);
  return (void *) GlobalLock(h);
}



void _RTLENTRY free(void *p)
{ HGLOBAL h;
#    ifdef WIN32
     if (NULL!=(h=GlobalHandle(p)))
#    else
     if (NULL!=(h=LOWORD(GlobalHandle(HIWORD(p)))))
#    endif
     {
	      GlobalUnlock(h);
	      GlobalFree(h);
     }
}



char * _RTLENTRY strdup (const char *pi)
{ int l = lstrlen(pi)+1;
  char *p = malloc( l );

  memcpy( p, pi , l);

  return p;
}



void  _FAR *_RTLENTRY realloc(void _FAR *__block, size_t __size)
{ HGLOBAL h;

#  ifdef WIN32
   h=GlobalHandle(__block);
#  else
   h=LOWORD(GlobalHandle(HIWORD(__block)));
#  endif
//   h=(HGLOBAL) LOWORD((DWORD) GlobalHandle(HIWORD((DWORD) __block)));
   GlobalUnlock(h);
   h=GlobalReAlloc(h, __size, GMEM_MOVEABLE);
  return (void *) GlobalLock(h);
}
#endif


       char DiskNames[] = "123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

/*----------------------------------------------------------------------------*\
|                                                                              |
|   g l o b a l   v a r i a b l e s                                            |
|                                                                              |
\*----------------------------------------------------------------------------*/

char      szCaption[] = "Setup...";
char      szNull[]    = "";
char      szSetupInf[MAXPATHLEN];
char      szSetupPath[MAXPATHLEN];
char      szDiskPath[MAXPATHLEN];
HWND      hwndWS;		// Fensterhandle des blauen Hintergrundfensters
HPALETTE  hpalWS = NULL;	// Wer schn sein will muss leiden ...
BOOL	  fMono;
PSTR      szText;
char      szString[MAXSTR];
int	  dyChar;
int	  dxChar;
WORD	  capsScreen;
WORD	  fExit;
char      bufTmp[MAXTMP];
PSTR      pErrMsg;

BOOL      bCfgWarn=FALSE,	// TRUE, wenn nderungen in Konfiguration ausgefhrt wurden
	  bCancel =FALSE;	// TRUE, wenn Kopiervorgang vom Benutzer abgebrochen

char      szLang[7];		// Gewhlte SETUP-Sprache (DEU, ENG ...)
HINSTANCE hiRes=NULL,		// Instanzenhandle der Ressourcen-DLL
	  hiWS;			// Instanzenhandle des SETUP-Programmes
static char szBkBig[80],	// "Grosser" Hintergrundtext
	    szBkSmall[180];	// "Kleiner" Hintergrundtext
LPSTR	  pszModules = NULL;
BOOL	  bHelp;		// Je nachdem, of "SETUxxx.HLP" - Datei gefunden wurde.
char	  szHelp[60];		// FileName of .HLP-File

#define STDLANG	 "ENG"		// Standard-Installationssprache, wenn keine DLL der "Richtigen" Sprache verfgbar
#define DEULANG  "DEU"		// Reserve-Name
#define ENGLANG  "ENG"		// Englisch....
#define FRALANG  "FRA"		// Franzsich....

/*----------------------------------------------------------------------------*\
|                                                                              |
|   f u n c t i o n   d e f i n i t i o n s                                    |
|                                                                              |
\*----------------------------------------------------------------------------*/

LONG FAR PASCAL  AppWndProc (HWND hwnd, unsigned uiMessage, WORD wParam, LONG lParam);
void PRIVATE     infDlgFixup(HWND hwnd);
void PRIVATE     infDlgDetails(HWND hwnd);
LONG NEAR PASCAL AppCommand(HWND hwnd, unsigned msg, WORD wParam, LONG lParam);
BOOL FAR PASCAL  AppExit(HWND hDlg, unsigned uiMessage, WORD wParam, LONG lParam);
int  PRIVATE     fnCheckDiskSpace(void);
void DeleteTempDir(void);
BOOL PRIVATE	 AskModules(void);
BOOL PRIVATE	 AskRegistration(void);



void CopyWithPathName(LPSTR lpdst, LPSTR lpname);

// ------------- Data for actually-Defined Bitmap -----------------------------

char      szBitmap[80],			// Bitmap-Filename
	  szLastBitmap[80];		// zur Erkennung auf Gleichheit dre Anforderung
HBITMAP   hBitmap = NULL;		// Bitmap-Handle
HMETAFILE hMetaFile;			// Metafile-Handle
BITMAP    Bitmap;			// Bitmap-Size-Info
int	  nXBmp, nYBmp,			// Bitmap-Position
	  nCXBmp, nCYBmp;		// Metafile-Gre

void LoadTheBitmap(PSTR szName);	// Load the Bitmap with the given Name
void DrawBitmapTransparent(HDC hdcDest, HBITMAP hBitmap, int nXDest, int nYDest);

#ifdef __WIN32__
# define DLL_NAME "SET32"
#else
# define DLL_NAME "SETU"
#endif


/*----------------------------------------------------------------------------*\
|   LanguageInfo()                                                             |
|                                                                              |
|   Description:                                                               |
|	Bestimmt aktuelle Sprache aus WIN.INI und ldt passene SETUxxx.DLL     |
|                                                                              |
|   Arguments:                                                                 |
|                                                                              |
|   Returns:                                                                   |
|	TRUE if successful, FALSE if not                                       |
|                                                                              |
\*----------------------------------------------------------------------------*/

BOOL LanguageInfo(HINSTANCE hInst)
{
    OFSTRUCT dummy;
    char     szRes[60],
	     szFile[100],
	    *p;
    struct ffblk ff;

    //------------- WIN.INI-Eintrag holen ---------------------------
    GetProfileString("Intl", "sLanguage", STDLANG, szLang, sizeof(szLang)-1);
    AnsiUpper(szLang);
    if (!lstrcmpi(szLang, "ENU"))	// Amerikanisches Englisch gleichbehandeln
	 lstrcpy (szLang, "ENG");

    GetModuleFileName(hInst, szFile, sizeof(szFile));
    OemToAnsi(szFile, szFile);
    p=strrchr(szFile, '\\');
    if (!p) p=szFile-1;
    lstrcpy(p+1, DLL_NAME "%s.DLL");

    //------------- Versuch, auf DLL zuzugreifen --------------------
    wsprintf((LPSTR) szRes, (LPSTR) szFile, (LPSTR) szLang);

    if (OpenFile(szRes, &dummy, OF_EXIST) != HFILE_ERROR)			// "Windows-Selected Language" Driver DLL
	 hiRes = LoadLibrary( szRes );						// Load Library
    else if (OpenFile(DLL_NAME STDLANG ".DLL", &dummy, OF_EXIST) != HFILE_ERROR)  // Try English one.
	      hiRes = LoadLibrary( DLL_NAME STDLANG ".DLL" );			// Lade SetuEng.DLl
	 else if (!findfirst(DLL_NAME "*.DLL", &ff, 0))				// Search for any other Language Driver DLL
		  hiRes = LoadLibrary( ff.ff_name );				// Lade SetuDeu.DLl

    if (hiRes < HINSTANCE_ERROR)
	MessageBox(NULL, "Can't load " DLL_NAME STDLANG ".DLL or any other proper Language Driver Library for ASETUP", "Handling Error", MB_OK);

/*    if (OpenFile("SETU" DEULANG ".DLL", &dummy, OF_EXIST) != HFILE_ERROR)	// Prfe SetuEng.Dll
	hiRes = LoadLibrary( "SETU" DEULANG ".DLL" );			// Lade reserve : SetuDeu.Dll ...
    else
	if (OpenFile("SETU" FRALANG ".DLL", &dummy, OF_EXIST) != HFILE_ERROR)	// Prfe SetuFRA.Dll
	   hiRes = LoadLibrary( "SETU" FRALANG ".DLL" );			        // Lade reserve : SetuFra.Dll ...
	else
	   if (OpenFile(szRes, &dummy, OF_EXIST) != HFILE_ERROR)   // Prfex existenz Setuxxx.dll
	       hiRes = LoadLibrary( szRes );
	   else
	       hiRes = LoadLibrary( "SETU" STDLANG ".DLL" );			// Lade SezuDeu.DLl */

    //------------- Versuche, ob eine Hilfetextdatei verfgbar ist --
    lstrcpy(        szHelp,         szRes);
    lstrcpy(strrchr(szHelp, '.')+1, "HLP");

    bHelp = OpenFile(szHelp, &dummy, OF_EXIST) != HFILE_ERROR;

    return (int) hiRes >= 32;
}





// NOTE: running multiple instances, Windows takes care of maintaining
// multiple pwd within each instance
int do_chdrive(char *s)
{
#   ifdef __BORLANDC__ 
    return (s[1] == ':') ? setdisk(s[0] - 'A') : 0;
#   else
    return (s[1] == ':') ? (_chdrive(1 + s[0] - 'A') == 0) : 0;
#   endif
}

int do_chdir(char *s)
{
    if (s[1] == ':')
    {
        // allow drives in here too
        if (! do_chdrive(s)) return 0;
        s += 2;
    }
    return (chdir(s) == 0);
}





/*----------------------------------------------------------------------------*\
|   AppInit( hInst, hPrev)                                                     |
|                                                                              |
|   Description:                                                               |
|	This procedure is called when the application is first loaded into         |
|	memory.  It performs any initialization tasks that need to be done only     |
|  for the first instance of the application.                                  |
|                                                                              |
|   Arguments:                                                                 |
|	hInstance	instance handle of current instance                             |
|	hPrev		instance handle of previous instance                               |
|                                                                              |
|   Returns:                                                                   |
|	TRUE if successful, FALSE if not                                            |
|                                                                              |
\*----------------------------------------------------------------------------*/
#pragma argsused
BOOL AppInit(HINSTANCE hInst,HINSTANCE hPrev,int sw,LPSTR szCmdLine)
{
    WNDCLASS    cls;
    char        *pach;
    HDC         hdc;
    OFSTRUCT	os;
    char        szCaption[MAXSTR],
		szInfName[MAXSTR];
    TEXTMETRIC  tm;
    PINF	pinf;
    UINT	uOldErrMode;		// Privious Value of ErrorMode Flag
    DWORD	dwMainStyle;

#ifdef DEBUG
    dprintf("%C");
#endif

    // ----------- Aktuelles Verzeichnis fr DLLs setzen --------------- 12.1.95
    GetModuleFileName(hInst, szDiskPath, sizeof(szDiskPath));
    OemToAnsi(szDiskPath, szDiskPath);

    if (NULL!=(pach = strrchr(szDiskPath, '\\')))
	      *pach = 0;

    do_chdir(szDiskPath);					// Verzeichnis setzen
		// Hinweis: Die DLL-und Bitmap-Dateien werden normalerweise aus STP0000.TMP gelesen

    /* Sprachabhngige Resourcen-DLL starten --------------------------- */
    if (!LanguageInfo(hInst))
       return FALSE;

#   ifndef NOCTL3D
    // ----------- Versuche, Ctl3d zu laden ---------------------------
    uOldErrMode = SetErrorMode( SEM_NOOPENFILEERRORBOX );	// Keine Fehlermeldungen, falls CTL3D fehlt.

#   ifdef WIN32
    if (NULL !=           (hCtl3DLib = LoadLibrary("CTL3D32.DLL") ) ) {
	CTL3DPROC fnReg = (CTL3DPROC) GetProcAddress( hCtl3DLib, "Ctl3dRegister"     ),
		  fnAuto= (CTL3DPROC) GetProcAddress( hCtl3DLib, "Ctl3dAutoSubclass" );
#   else
    if (HINSTANCE_ERROR < (hCtl3DLib = LoadLibrary("CTL3D.DLL"  ) ) ||
	HINSTANCE_ERROR < (hCtl3DLib = LoadLibrary("CTL3DV2.DLL") ) ) {
	CTL3DPROC fnReg = (CTL3DPROC) GetProcAddress( hCtl3DLib, "CTL3DREGISTER"     ),
		  fnAuto= (CTL3DPROC) GetProcAddress( hCtl3DLib, "CTL3DAUTOSUBCLASS" );
#   endif

        if (fnReg && fnAuto) {
	    fnReg(hInst);
            fnAuto(hInst);
	}
	else { FreeLibrary(hCtl3DLib); hCtl3DLib=NULL; }
    }   else hCtl3DLib = NULL;

    SetErrorMode( uOldErrMode );
#   endif

    //------------ bergabeparameter gibt Quell-Laufwerk an -----------
/*    if (*szCmdLine >= 'A')
#   ifdef WIN32
       _chdrive(*szCmdLine-'A'+1);
#   else
//       setdisk(*szCmdLine-'A');
#   endif
*/

    /* Save the instance handle for the DialogBox */
    hiWS = hInst;

    /* Display the hourglass cursor */
    wsStartWait();

    // ----------- Dateiname der APPSETUP.INF-Datei bestimmen ---------- 12.1.95
    if (*szCmdLine >= 'A') 				// bergabeparameter vorhanden ?
	lstrcpy(szDiskPath, szCmdLine);			// bergabeparameter als Pfadangabe annehmen

    wsprintf(szInfName, "%s\\%s", (LPSTR) szDiskPath, (LPSTR) wsLoadSz(IDS_INFNAME,NULL)); // "APPSETUP.INF"

    if (OpenFile(szInfName, &os, OF_EXIST) == -1) {
        wsEndWait();
	MessageBox(NULL, wsLoadSz(IDS_NOINF, NULL), szCaption, MB_OK | MB_ICONEXCLAMATION);
	return FALSE;
    }
#   ifndef WIN32
    GlobalCompact((LONG)(-1));		// help infOpen() succeed
						// 5 MByte freischaufeln, um 5KB zu laden ....
#   endif

    pinf = infOpen(szInfName);
//    pinf = infOpen(os.szPathName);

    wsEndWait();

    WinAssert(pinf);
    if (!pinf) {
	MessageBox(NULL, wsLoadSz(IDS_NOINFMEM, NULL), szCaption, MB_OK | MB_ICONEXCLAMATION);
	return FALSE;
    }
    
    hdc  = GetDC(NULL);
    fMono = GetDeviceCaps(hdc, NUMCOLORS) == 2;
    capsScreen = GetDeviceCaps(hdc, RASTERCAPS);
    GetTextMetrics(hdc,&tm);
    dyChar = tm.tmHeight;
    dxChar = tm.tmAveCharWidth;
    ReleaseDC(NULL,hdc);



    //------------ Hintergrundtexte laden -----------------------------
    if (!infLookup(wsLoadSz(IDS_INFBIG,NULL)  ,szBkBig))
	wsLoadSz(IDS_BKBIG  , szBkBig  );
    if (!infLookup(wsLoadSz(IDS_INFSMALL,NULL),szBkSmall))
        wsLoadSz(IDS_BKSMALL, szBkSmall);



    if (!hPrev) {

       /* Register a class for the main application window */

        cls.hCursor        = LoadCursor(NULL,IDC_ARROW);
        cls.hIcon          = LoadIcon(hInst,MAKEINTRESOURCE(ID_APP));
        cls.lpszMenuName   = NULL;
        cls.lpszClassName  = MAKEINTATOM(ID_APP);
	cls.hbrBackground  = GetStockObject(NULL_BRUSH); //(HBRUSH)COLOR_WINDOW + 1;
        cls.hInstance      = hInst;
        cls.style          = CS_BYTEALIGNCLIENT | CS_VREDRAW | CS_HREDRAW | CS_DBLCLKS;
	cls.lpfnWndProc    = (WNDPROC) AppWndProc;
        cls.cbWndExtra     = 0;
        cls.cbClsExtra     = 0;

        if (!RegisterClass(&cls))
	    return FALSE;
    }

    if (!infLookup(wsLoadSz(IDS_INFCAPTION, NULL),szCaption))
	wsLoadSz(IDS_MCAPTION, szCaption);

    dwMainStyle = infLookupInt("ASetup.HasCaption", TRUE)
		     ? WS_OVERLAPPED | WS_CAPTION | WS_MAXIMIZE
		     : WS_POPUP | WS_MAXIMIZE;

    if (infLookupInt("ASetup.NoMaximize", FALSE)) dwMainStyle &= ~WS_MAXIMIZE;


    hwndWS = CreateWindow (MAKEINTATOM(ID_APP),     // Class name
			    szCaption,		    // Caption
//			    wsLoadSz(IDS_MCAPTION, NULL), // Caption
			    dwMainStyle, 	    // Style bits
			     40, 10,600,420,        // Position, size
                            (HWND)NULL,             // Parent window (no parent)
                            (HMENU)NULL,            // use class menu
                            (HANDLE)hInst,          // handle to window instance
                            (LPSTR)NULL             // no params to pass on
                            );

    //------------ Load the initial Bitmap ----------------------------
    if (infLookup(wsLoadSz(IDS_INFBITMAP,NULL),szBitmap))
	 LoadTheBitmap(szBitmap);

    ShowWindow( hwndWS, SW_SHOW );

    /* Create the "stext" class used in progress dialogs */
    if (!ControlInit(hPrev,hInst))
    	return FALSE;

    if (!ProInit(hInst))
    	return FALSE;

    if (!ddeInit(hInst, hPrev))
    	return FALSE;

    fExit = 0;

/*
 *  szSetupInf   is the directory or file name where SETUP.INF can be found
 *
 *  szSetupPath  is the directory to which application files will be copied        
 *
 *  szDiskPath   is the directory where the root of the setup disks are
 *
 */
/*
#   ifdef WIN32
    GetCurrentDirectory(sizeof(szDiskPath), szDiskPath);
#   else
    DosCwd(szDiskPath);
#   endif
*/
    lstrcpy(szSetupInf,szDiskPath);
    
    return TRUE;
}


/*-----------------------------------------------------------------------------

     wsExec : Eigene Routine zum Start der Programme im [Exec]-Abschnitt
	      Bernd Herd 25.6.93 ---- Die auszufhrenden Programme knnen jetzt
				      einen bergabeparameter erhalten. Beispiel:
				      [Exec]
				      write.exe,"readme.wri"	
  -----------------------------------------------------------------------------*/
#pragma argsused
void PRIVATE wsExec( HWND hwndWS, PSTR SectionHeader, BOOL WaitForExit)
{
  PINF	pExecSection;			// Zeiger auf Daten im [Exec]-Abschnitt
  char  szExec[MAXSTR*2],		// Buffer fr WinExec-Anweisung
	szFile[MAXSTR*2]; 		// Dateiname (0: / 1:... wird ersetzt)
  HINSTANCE hExecInst;

  //---------------- Sind Anweisungen im [Exec]-Abschnitt vorhanden ? ----------
  do_chdir(szSetupPath);

  for ( pExecSection = infFindSection(NULL, SectionHeader);
	pExecSection;
	pExecSection = infNextLine(pExecSection) ) {

    //-------------- Zeile in Dateiname und Parameter zerlegen -----------------
    *szExec=0;
    infParseField(pExecSection, 1, szFile);
    ExpandFileName(szFile, szExec);
    lstrcat(szExec, " ");
    infParseField(pExecSection, 2, szFile);
    CopyWithPathName(szExec+lstrlen(szExec), szFile);
//    infParseField(pExecSection, 2, szExec+lstrlen(szExec));

    //-------------- Programm aufrufen -----------------------------------------
#   ifdef WIN32
		WinExec(szExec, SW_NORMAL);
#   else
    hExecInst = WinExec(szExec, SW_NORMAL);
    while (  WaitForExit && 
	     (int) hExecInst >= 32 &&
	     GetModuleUsage(hExecInst) )
	     wsYield();
#   endif

  }
}




/* CopyWithPathName---------------------------------------------*
 * Kopiert von Quellpuffer nach Zielpuffer und ersetzt dabei	*
 * jedes Auftreten von "0:" durch das Installationsverzeichnis  *
 *--------------------------------------------------------------*/
void CopyWithPathName(LPSTR lpdst, LPSTR lpname)
{
   BOOL fQuote = FALSE;				// 17.8.94: Bernd Herd: Texte in " " nicht bearbeiten
   char ch;
   char szDiskPath[MAXPATHLEN];

	while ( (ch=*lpname++) != 0) {

	  if (ch == '"') fQuote ^= TRUE;
	    else
	      if (!fQuote &&
//	          ch       =='0' &&		// 0:-Ersatzstring suchen
		  IsCharAlphaNumeric(ch) &&
		  lpname[0]==':' &&
		  GetDiskPath(ch, szDiskPath)
		  ) {
		       wsprintf(lpdst, "%s\\", (LPSTR) szDiskPath /* szSetupPath*/); // Ersetzung ausfhren
		       lpdst += lstrlen(lpdst);
		       lpname++;
		  }
		  else
		  if (!fQuote && ch=='%') {	// 18.8.94: Bernd Herd: Zugirff auf Environment-Variablen
		     char szBuf[20], *p=szBuf;
		     LPSTR pq = lpname;
		     while (*pq && *pq>='A' && *pq<='Z')
			 *p++=*pq++;
		     *p=0;
#ifndef NOGETENV
		     if (*pq=='%' && getenv(szBuf)) {
			lstrcpy(lpdst, getenv(szBuf));
			lpdst += lstrlen(lpdst);
			lpname=pq+1;
		     }  else
#endif
		     *lpdst++=ch;
		  }
			else *lpdst++= ((BYTE) ch)==0xff ? '"' : ch;
	}
	*lpdst=0;
}



/*-------------------------------------------------------------------------------------

     wsConfig : Routine schreibt Konfigurationseintrge in CONFIG.SYS und AUTOEXEC.BAT

  -------------------------------------------------------------------------------------*/
#define MAXSIZE 0x4000
void wsConfig(PSTR pszAbschn, PSTR pszFile)
{
  PINF    pAbschn;
  HFILE   hFile = HFILE_ERROR;

  HGLOBAL hMem, hDst;			// Platz fr gesamte Datei
  LPSTR   pMem, pDst;
  int     nLen = 0;

  char    szKey[40];		// Platz fr Schlsselwort (z.B. "FILES")
  int     nVal=0;		// Platz fr Wert (z.B. = 50)

  OFSTRUCT dummy;
  PSTR    pNext, pDest;
  LPSTR   pFile, pDFile;	// Zeiger auf Puffer fr Dateidaten und Genderte Dateidaten
  char    szZeile[800],
	  szBefore[800];	// @xxxxx - Eintragungen mit Schlsselworten
  PSTR    pBefore;
  BOOL    bBefore = FALSE;

  BOOL    bFound =FALSE,	// Flag zeigt an, ob Zeile in Datei gefunden wurde.
	  bChange=FALSE;	// Flag zeigt an, ob Datei geschrieben werden mu

  //------------ Prfe, ob Abschnitt vorhanden ----------------------
  pAbschn = infFindSection(NULL, pszAbschn);

  //------------ Eingabedatei ffnen --------------------------------
  hFile   = _lopen(pszFile, OF_READ);

  //------------ Speicher zuordnen ----------------------------------
  hMem = GlobalAlloc(GHND, MAXSIZE);  hDst=GlobalAlloc(GHND, MAXSIZE);
  pMem = GlobalLock(hMem);            pDst=GlobalLock(hDst);

  //------------ Reihenfolge-Schlsselwrter lschen ----------------
  szBefore[0]=0;

  if (pAbschn) {

     //-------------- Dateidaten in Speicher lesen ------------------
     if (hFile != HFILE_ERROR) {
        nLen = _lread(hFile, pMem, MAXSIZE-1);
	if (nLen && pMem[nLen-1]==26) nLen--;
	_lclose(hFile);
	hFile = HFILE_ERROR;
     }
     pMem[nLen]=0;

     //-------------- Eingabedaten bearbeiten: Je Zeile im Abschnitt-
     while (*pAbschn) {
      //------------- Reihenfolge-Schlsselwort ? -------------------
      if (*pAbschn=='@')
	lstrcpy(szBefore, pAbschn+1);
      else {

	//----------- Schlsselwert bearbeiten ----------------------
	if (*pAbschn=='"') {
	    LPSTR pv = pAbschn+1, pn=szKey;
	    while (*pv && *pv!='"') *pn++=*pv++;
	    *pn=0;
	} else {
	    lstrcpy(szKey, pAbschn );

   	    pNext = strpbrk(szKey, "=-, ");
            if (pNext) {
	       if (*pNext == '=') nVal=atoi(pNext+1);
	       /* if (nVal!=0)      */ *pNext=0;
	    }
	}

	//----------- Schlsselwert in der Datei suchen -------------
	bFound = FALSE;
	pFile  = pMem;
	pDFile = pDst;
	*pDFile= 0;
	while (*pFile) {
	   pDest = szZeile;
	   while (*pFile==' ') ++pFile;
	   while (*pFile && *pFile!='\r') *pDest++ = *pFile++;
	   *pDest=0; pFile+=2;

	   //----------- Prfung auf Reihenfolge -----------------------
	   for (pBefore = szBefore; *pBefore && !bBefore && !bFound; ) {
	       char szTest[50], *p;
	       for (p=szTest; *pBefore && *pBefore!=','; )
		    *p++=*pBefore++;
	       *p=0; if (*pBefore) ++pBefore;

	       if (fnMystrstr(szZeile, szTest)) {
//	       if (!strnicmp(szZeile, szTest, lstrlen(szTest))) {
		  bBefore = FALSE;
		  CopyWithPathName(pDFile, pAbschn);		// 17.8.94: B.Herd "0:" zulassen
		  lstrcat(pDFile, "\r\n");
//		  wsprintf(pDFile, "%s\r\n", pAbschn);
		  pDFile+=lstrlen(pDFile);
		  bFound =
		  bChange=TRUE;
	       }
	   }

	   //------------ Prfe, ob Schlsselwort gefunden wurde -------------
	   if (!strnicmp(szZeile, szKey, lstrlen(szKey))) {
	      // ---- Schlsselwert in Datei gefunden -> Wert prfen -
	      bFound = TRUE;
/*	      if (!nVal || (strchr(szZeile, '=') && atoi(strchr(szZeile, '=')+1) >= nVal))
		 bChange=FALSE;
	      else {
		 bChange=TRUE;
		 CopyWithPathName(szZeile, pAbschn);		// 17.8.94: B.Herd "0:" zulassen
//		 lstrcpy(szZeile, pAbschn);
              } */
	      if (/*nVal && */!(strchr(szZeile, '=') && atoi(strchr(szZeile, '=')+1) > nVal)) {
		 bChange=TRUE;
		 CopyWithPathName(szZeile, pAbschn);		// 17.8.94: B.Herd "0:" zulassen
//		 lstrcpy(szZeile, pAbschn);
              } 
	   }

	   lstrcpy(pDFile, szZeile);
	   lstrcat(pDFile, "\r\n");
	   pDFile += lstrlen(pDFile);
	}

	//----------- Falls Zeile bislang fehlt -> ergnzen ---------
        if (!bFound) {
	   CopyWithPathName(pDFile, pAbschn);		// 17.8.94: B.Herd "0:" zulassen
//	   lstrcpy(pDFile, pAbschn);
	   lstrcat(pDFile, "\r\n");
	   pDFile += lstrlen(pDFile);
	   bChange = TRUE;
	}

	*pDFile=0;

	lstrcpy(pMem, pDst);
      }

      //----------- Nchste Zeile im INF-Abschnitt ------------------
      pAbschn += lstrlen(pAbschn)+1;
     }

     //-------------- Genderte Dateidaten speichern ----------------
     if (bChange) {
        hFile = OpenFile(pszFile, &dummy, OF_WRITE | OF_CREATE);
        if (hFile != HFILE_ERROR)
           _lwrite(hFile, pMem, lstrlen(pMem));
        else MessageBox(NULL, "Fehler beim Schreiben in die Datei. Vielleicht ist die Datei Schreibgeschtzt?",
			      pszFile,
			      MB_ICONSTOP | MB_OK);
	bCfgWarn=TRUE;
     }

     //-------------- Speicher freigeben ----------------------------
     GlobalUnlock(hMem);  GlobalUnlock(hDst);
     GlobalFree(hMem);	  GlobalFree(hDst);
  }

  //------------ Dateien schlieen ----------------------------------
  if (hFile != HFILE_ERROR) _lclose(hFile);
}






/* wsIni--------------------------------------------------------*
 * Eintragungen in INI-Dateien hinzufgen oder ndern		*
 *--------------------------------------------------------------*/
void wsIni(void)
{ PINF pAbschn;		// Zeiger auf nchsten zu bearbeitenden Abschnitt
  char szBuf[200],	// Puffer fr INF-Daten vor der Namensersetzung
       szIniFile[100],	// Dateiname der INI-Datei
       szSection[100],	// szSection.name von WritePrivateProfileString
       szEntry[150],	// szEntry-Parameter von WritePrivateProfileString
       szString[220];	// szString-Parameter von WritePrivateProfileString	

  //------------ Prfe, ob Abschnitt vorhanden ----------------------
  for (pAbschn = infFindSection(NULL, "INI");
       pAbschn && *pAbschn;
       pAbschn = infNextLine(pAbschn)
      ) {	

      //-------- Abschnitt zeilenweise durcharbeiten ----------------
      infParseField(pAbschn, 1, szBuf);		// INI-Dateiname in 1. Spalte
      CopyWithPathName(szIniFile, szBuf);
      lstrcat(szIniFile, ".INI");

      infParseField(pAbschn, 2, szBuf);		// Section-Name in 2. Spalte
      CopyWithPathName(szSection, szBuf); 

      infParseField(pAbschn, 3, szBuf);		// Entry-Name in 3. Spalte
      CopyWithPathName(szEntry, szBuf); 

      infParseField(pAbschn, 4, szBuf);		// Eigentliche Daten in 4. Spalte
      CopyWithPathName(szString, szBuf);

      WritePrivateProfileString(szSection, szEntry, szString, szIniFile);
  }
}




/*----------------------------------------------------------------------------*\
|   WinMain( hInst, hPrev, lpszCmdLine, cmdShow )                              |
|                                                                              |
|   Description:                                                               |
|                                                                              |
|   Arguments:                                                                 |
|  	hInst	    instance handle of this instance of the application            |
|  	hPrev	    instance handle of previous instance. NULL if this is the      |
|                   instance of the application                                |
|  szCmdLine    null-terminated command line                                   |
|  cmdShow      specifies how the application's window is initially displayed  |
|                                                                              |
|   Returns:                                                                   |
|       The exit code as specified in the WM_QUIT message.                     |
|                                                                              |
\*----------------------------------------------------------------------------*/
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrev, LPSTR szCmdLine, int sw)
{   char    szLocalTmp[MAXSTR],
	    szModule  [50];
    LPSTR   pModule;

    char   *pnDisk;	
//    int     nFiles;

    /* Call the initialization procedure */

    if (!AppInit(hInst,hPrev,sw,szCmdLine))
    {   MessageBox(NULL, "SETUP2.EXE could not be propperly initialized. Please close some other programs and try again.",
                         "Handling Error",
                         MB_ICONSTOP | MB_OK);
	return FALSE;
    }

    /* Loop until the user specifies a destination with sufficent disk space */
    while(TRUE) {
       if (!DialogBox(hiRes, MAKEINTRESOURCE(DLG_WINSETUP), hwndWS, wsInstallDlg) )
       {
	  DestroyWindow(hwndWS);         // Kill the appllication, right now!
	  FreeLibrary(hiRes);
	  DeleteTempDir();
	  return TRUE;
       }
       if ( !fnCheckDiskSpace() ) /*
	  fnOkMsgBox(CheckFree == 1 ? IDS_NEEDROOM : IDS_NEEDROOMWINDOWS, );
       else
       */   break;
    }

    UpdateWindow(hwndWS);		// Sieht besser aus ....


    // ------------ Ask for Modules that shall be installed --
    if (!AskModules() ||
	!AskRegistration()) {
	  DestroyWindow(hwndWS);         // Kill the appllication, right now!
	  FreeLibrary(hiRes);
	  DeleteTempDir();
	  return TRUE;
    }

    UpdateWindow(hwndWS);		// Sieht besser aus ....
    ProOpen(hwndWS, 0);

    //-------------- Gesamtanzahl zu kopierende Dateien bestimmen (100%)-
    wsCount(NULL);
    wsCount(wsLoadSz(IDS_WINCOPY,szLocalTmp));
    wsCount(wsLoadSz(IDS_LANCOPY,szLocalTmp));
    { for ( pModule = pszModules;				// Modulauswahlabhngige Abschnitte zhlen
	    pModule;
	    pModule = infNextLine(pModule) ) {
	 lstrcpy(szModule, pModule);
	 wsCount(szModule);
      }
    }

    // ------------- Diskettenweise vorgehen -----------------------------
    for (pnDisk=DiskNames; *pnDisk && !bCancel; pnDisk++)
    {
      //-------------- Standardmodul-Kopien ------------------------------
      if ( !wsCopy(wsLoadSz(IDS_WINCOPY,szLocalTmp), *pnDisk) ||	// Kopieren Haupteintragungen
	   !wsCopy(wsLoadSz(IDS_LANCOPY,szLocalTmp), *pnDisk) 	// Kopieren sprachabhngige Eintragungen
	 ) bCancel = TRUE;

      //-------------- Modulauswahlabhngige Kopien ----------------------
      for ( pModule = pszModules;				// Modulauswahlabhngige Abschnitte zhlen
            pModule && !bCancel;
	    pModule = infNextLine(pModule)  ) {
	   lstrcpy(szModule, pModule);
	   bCancel |= !wsCopy(szModule, *pnDisk);
      }
    }

    /* Build groups only if all the copy tasks are successful. */

    if ( !bCancel ) {
       wsProgman(hwndWS);

       /* Config.Sys und AutoExec.Bat ndern */
       wsConfig("Config"  , "C:\\CONFIG.SYS");
       wsConfig("AutoExec", "C:\\AUTOEXEC.BAT");

       /* 8.3.94: INI-Eintragungen hinzufgen oder ndern */
       wsIni();

       if (bCfgWarn)
	  MessageBox(NULL,wsLoadSz(IDS_CFGWARN,NULL),szCaption,MB_OK | MB_ICONHAND);

       /* Ausfhren der Programme im [Exec]-Abschnitt der INF-Datei */
       wsExec(hwndWS, "Exec", TRUE);

       /* Inform user that the copy process is complete. */
       MessageBox(NULL,wsLoadSz(IDS_FINISHED,NULL),szCaption,MB_OK);

       /* Ausfhren der Programme im [Exec]-Abschnitt der INF-Datei */
       wsExec(hwndWS, "ExecAfterMessage", FALSE);

       //----------- Ressourcen-DLL freigeben -----------------------
       DestroyWindow(hwndWS);         // Kill the application, right now!
       FreeLibrary(hiRes);
       DeleteTempDir();

       return TRUE;
    }

    //----------- Ressourcen-DLL freigeben -----------------------
    DestroyWindow(hwndWS);         // Kill the appllication, right now!
    FreeLibrary(hiRes);
    DeleteTempDir();

    return FALSE;
}

/* BOOL PRIVATE fnCheckDiskSpace(void);
 *
 * This function checks disk space on the specified destination drive
 * against the minimum disk space requirement specified in the .INF file.
 *
 * Arguments: None.
 *
 * Returns:
 *
 *   Integer Value:
 *     0: 		    current destination provides sufficent disk space.
 *     IDS_NEEDROOM: 	    current destination does not provide sufficient disk space.
 *     IDS_NEEDROOMWINDOWS: Windows drive does not provide sufficiont disk Space.
 *
 */
BOOL PRIVATE fnCheckDiskSpace(void)
{  char    szLocalTmp[MAXSTR];
   DWORD   TestApplication,
   	   TestWindows,

	   NeededApplication = 1000000L,	// default Values
	   NeededWindows     =  100000L;
   int     err;					// error Value : 0/1/2


   // ---------- Get Minimum Size Values from INF-File ------
   if (infLookup(wsLoadSz(IDS_DISKSPACE,NULL),szLocalTmp))
       NeededApplication = atol(szLocalTmp);

   if (infLookup(wsLoadSz(IDS_DISKWINDOWS,NULL),szLocalTmp))
       NeededWindows = atol(szLocalTmp);

   // ---------- Test if Windows and App on the same Drive --
   GetWindowsDirectory(szLocalTmp, sizeof(szLocalTmp)-1);

   if (!strnicmp(szSetupPath, szLocalTmp, 2)) {
       TestApplication  = NeededApplication + NeededWindows;
       TestWindows      = 0L;
   } else {
       TestApplication  = NeededApplication;
       TestWindows      = NeededWindows;
   }

   err = DosDiskFreeSpace(szSetupPath[0] - '@') < TestApplication ? IDS_NEEDROOM :
	 (TestWindows &&
	  DosDiskFreeSpace(szLocalTmp[0] - '@') < TestWindows) ? IDS_NEEDROOMWINDOWS : 0;

   if (err)
      fnOkMsgBox(err, (DWORD) (NeededApplication+1023)/1024, (DWORD) (NeededWindows+1023)/1024);

   return err;
}

/*-----------------------------------------------------------------------------

	AppWndPaint : Paint-Routine fr das Hauptfenster

		      Zeichnet blauen Hintergrund und weie Schrift

  -----------------------------------------------------------------------------*/


#define CNT     128		// Anzahl der Farben
#define BLUE(i) ((CNT-((i)+1))*150/CNT+20)	// Zuordnung Farnummer -> Farbe


void AppWndPaint(HWND hWnd)
{  PAINTSTRUCT ps;
   HDC         hDC;
   RECT        rcClient;
   int         i,    nX , nY,
		     nX2=0, nY2=0;
   HFONT       hfo, hfn;
   HBRUSH      hbn;
   HPALETTE    hpalo;			// Ursprngliche Palette des Device-Contextes
   RECT	       rc;

   hDC=BeginPaint(hWnd, &ps);

   //-------------- Fenster aufteilen -----------------------------
   GetClientRect(hWnd, &rcClient);

   //-------------- Farbpalette steuern ---------------------------
   if (infLookupInt("ASetup.Background", TRUE)) {

      if (hpalWS) {
	 hpalo = SelectPalette(hDC, hpalWS, FALSE);
	 RealizePalette(hDC);
      }

      for (i=1; i<CNT; ++i) {
	 nX = MulDiv(i, rcClient.right , CNT-1)+1;
	 nY = MulDiv(i, rcClient.bottom, CNT-1)+1;
	 hbn = CreateSolidBrush(hpalWS ? PALETTEINDEX(i) : (LONG) BLUE(i-1)<<16);
	 SetRect(&rc, 0  , nY2, nX, nY); FillRect(hDC, &rc, hbn);
	 SetRect(&rc, nX2, 0  , nX, nY); FillRect(hDC, &rc, hbn);
	 DeleteObject(hbn);

	 nX2 = nX-1;
	 nY2 = nY-1;
      }

      //-------------- Farbpalette steuern ---------------------------
      if (hpalWS)
	 SelectPalette(hDC, hpalo, FALSE);
   }

   //-------------- Hinterlegter Text -----------------------------
   hfn = CreateFont(MulDiv(80, GetSystemMetrics(SM_CYSCREEN), 768),
			0,0,0,FW_BOLD,TRUE,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
			DEFAULT_QUALITY, VARIABLE_PITCH | FF_SWISS,"Arial");
   hfo = SelectObject(hDC, hfn);

   SetBkMode(hDC, TRANSPARENT);
   SetTextColor(hDC, 0L);
   TextOut(hDC, 40, 35, szBkBig  , lstrlen(szBkBig));
   SetTextColor(hDC, 0xffffffL);
   TextOut(hDC, 35, 30, szBkBig  , lstrlen(szBkBig));

   SelectObject(hDC, hfo);
   DeleteObject(hfn);

   //-------------- Kleinerer hinterl. Text -----------------------
   hfn = CreateFont(MulDiv(24, GetSystemMetrics(SM_CYSCREEN), 768),
			0,0,0,FW_BOLD,FALSE,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,
			DEFAULT_QUALITY, VARIABLE_PITCH | FF_SWISS,"Arial");
   hfo = SelectObject(hDC, hfn);

   SetTextColor(hDC, 0L);
   TextOut(hDC, 37, rcClient.bottom-52, szBkSmall  , lstrlen(szBkSmall));
   SetTextColor(hDC, 0xffffffL);
   TextOut(hDC, 35, rcClient.bottom-50, szBkSmall  , lstrlen(szBkSmall));

   SelectObject(hDC, hfo);
   DeleteObject(hfn);

   SetBkMode(hDC, OPAQUE);

   //-------------- Show the Bitmap, if any Bitmap has been loaded ----

   if (hBitmap)
      DrawBitmapTransparent(hDC, hBitmap, nXBmp, nYBmp);

   if (hMetaFile) {
      SetMapMode(hDC, MM_ANISOTROPIC);
#     ifdef WIN32
      SetViewportExtEx(hDC, nCXBmp, nCYBmp, NULL);
      SetViewportOrgEx(hDC, nXBmp, nYBmp, NULL);
#     else
      SetViewportExt(hDC, nCXBmp, nCYBmp);
      SetViewportOrg(hDC, nXBmp, nYBmp);
#     endif
      PlayMetaFile(hDC, hMetaFile);
      SetMapMode(hDC, MM_TEXT);
#     ifdef WIN32
      SetViewportOrgEx(hDC, 0, 0, NULL);
#     else
      SetViewportOrg(hDC, 0, 0);
#     endif
   }

   //-------------- Zeichnen vollstndig --------------------------
   EndPaint(hWnd, &ps);
}


/*----------------------------------------------------------------------------

     	BluePalette : Blaue Farbpalette fr Fensterhintergrund definieren

  ----------------------------------------------------------------------------*/
HPALETTE BluePalette(void)
{ HPALETTE	hpBlue;
  int		i;
  PLOGPALETTE 	Pal = (PLOGPALETTE) LocalAlloc(LMEM_FIXED | LMEM_ZEROINIT, sizeof(LOGPALETTE) + (CNT+1) * sizeof(PALETTEENTRY));
  PALETTEENTRY *p;

  Pal -> palVersion    = 0x300;
  Pal -> palNumEntries = CNT+1;
  for (i=0, p=Pal->palPalEntry;i<=CNT;++i) {
      p  ->peBlue  = BLUE(i);
      p++->peFlags = PC_NOCOLLAPSE;		// 9.3.94: PC_RESERVED Gab rger, wenn Palette bereits benutzt wurde
//      Pal -> palPalEntry[i] . peFlags = 0;			// 9.3.94: PC_RESERVED Gab rger, wenn Palette bereits benutzt wurde
  }
  hpBlue = CreatePalette(Pal);
  LocalFree((HLOCAL) Pal);
  return hpBlue;
}






/*----------------------------------------------------------------------------*\
|   AppWndProc( hwnd, uiMessage, wParam, lParam )                              |
|                                                                              |
|   Description:                                                               |
|       The window proc for the application's main window.  This processes all |
|       of the parent window's messages.                                       |
|                                                                              |
|   Arguments:                                                                 |
|       hwnd            window handle for the window			       |
|       uiMessage       message number                                         |
|       wParam          message-dependent                                      |
|       lParam          message-dependent                                      |
|                                                                              |
|   Returns:                                                                   |
|       0 if processed, nonzero if ignored                                     |
|                                                                              |
\*----------------------------------------------------------------------------*/
#pragma argsused
LONG FAR PASCAL AppWndProc(hwnd, msg, wParam, lParam)
    HWND     hwnd;
    unsigned msg;
    WORD     wParam;
    long     lParam;
{
    PAINTSTRUCT ps;
    char	szDummy[5];

    switch (msg) {
        case WM_COMMAND: return AppCommand(hwnd,msg,wParam,lParam);

	case WM_PAINT:   AppWndPaint(hwnd);
        		 return FALSE;

	case WM_CREATE:  ps.hdc = GetDC( hwnd );		// Falls Farbpaletten untersttzt werden, eine erzeigen
			 if ( (GetDeviceCaps(ps.hdc, RASTERCAPS) & RC_PALETTE )!=0 	// Farbpaletten untersttzt
			      && !infLookup("ASetup.NoPalette", szDummy) )
			     hpalWS = BluePalette();
			 ReleaseDC( hwnd, ps.hdc );
			 break;

	case WM_DESTROY: PostQuitMessage(0);
			 bCancel=TRUE;
                         if (hpalWS)
			    DeleteObject(hpalWS);
			 if (bHelp)
			     WinHelp( hwndWS, szHelp, HELP_QUIT, 0L);
			 break;

	case WM_PALETTEISCHANGING:
		/* if ASETUP was not responsible for palette change and if
		 * ok to hide changes, paint app. window black.
		 */
		if ((HWND) wParam != hwnd) {
		    RECT Rect;
                    HDC  hDC;
		    GetClientRect(hwnd, &Rect);

		    hDC = GetDC(hwnd);
		    FillRect( hDC, &Rect, GetStockObject(BLACK_BRUSH));
		    ReleaseDC(hwnd, hDC);
		}
		break;



	case WM_QUERYNEWPALETTE:
		/* If palette realization causes a palette change,
		 * we need to do a full redraw.
		 */

		if (hpalWS) {
		    HDC      hDC     = GetDC (hwnd);
		    HPALETTE hOldPal = SelectPalette (hDC, hpalWS, 0);
		    int      i       = RealizePalette(hDC);

		    SelectPalette (hDC, hOldPal, 0);
		    ReleaseDC (hwnd, hDC);
		    if (i) {
			InvalidateRect (hwnd, (LPRECT) (NULL), TRUE);
			return TRUE;
		    } else
			return FALSE;
		}
		else
		    return FALSE;

	case WM_PALETTECHANGED:
		/* if GRBOX was not responsible for palette change and if
		 * palette realization causes a palette change, do a redraw.
		 */

		 if ((HWND) wParam != hwnd){
		    if (hpalWS){

			HDC      hDC     = GetDC (hwnd);
			HPALETTE hOldPal = SelectPalette (hDC, hpalWS, 0);
			int      i       = RealizePalette(hDC);

			if (i)
				UpdateColors (hDC);
			else    InvalidateRect (hwnd, (LPRECT) (NULL), 1);

			SelectPalette (hDC, hOldPal, 0);
			ReleaseDC (hwnd, hDC);
		    }
		}
		break;

    }
    return DefWindowProc(hwnd,msg,wParam,lParam);
}

/* AppCommand (hwnd, msg, wParam, lParam)
 *
 * This function handles commands passed to main application windows.
 *
 */
#pragma argsused
LONG NEAR PASCAL AppCommand (hwnd, msg, wParam, lParam)
    HWND     hwnd;
    unsigned msg;
    WORD     wParam;
    long     lParam;
{
    switch(LOWORD(wParam))
    {
	case ID_EXITSETUP:
            if ( fnErrorMsg(IDS_EXITMSG) ) {
               ProClose();
               DestroyWindow(hwndWS);
            }
            break;
    }
    return 0L;
}

/* fnErrorMsg(int ID_Error_Message);
 *
 * This function displays a system-modal message box and
 * lets user choose yes or no in response to the message box.
 *
 * Arguments:
 *
 *    ID_Error_Message       Resource ID of message to be displayed in the
 *                           message box.
 * Returns:
 *
 *    TRUE if the user chooses the Yes button.
 *    FALSE if the user chooses the No button.
 *
 */
BOOL PUBLIC fnErrorMsg(ID_Error_Message)
int    ID_Error_Message;
{
   char   szTmpStr[256];

   wsLoadSz(ID_Error_Message,szTmpStr);

   return IDYES == MessageBox(NULL,szTmpStr,wsLoadSz(IDS_EXITCAPTION,NULL),STD_EXIT_MSGBOX);
}

/* fnOkMsgBox(int ID_Error_Message);
 *
 * This function displays a system-modal message box and
 * lets user choose yes or no in response to the message box.
 *
 * Arguments:
 *
 *    ID_Error_Message       Resource ID of message to be displayed in the
 *                           message box.
 * Returns:
 *
 *    Nothing.
 *
 */
VOID PUBLIC fnOkMsgBox(int ID_Error_Message, ...)
{
   char   szTmpStr[256],		// String loaded from INF-File.
   	  szParStr[300];		// string after wvsprintf

   wsLoadSz(ID_Error_Message,szTmpStr);

   wvsprintf(szParStr, szTmpStr, (&ID_Error_Message)+1);

   MessageBox(NULL,szParStr,wsLoadSz(IDS_EXITCAPTION,NULL),STD_OK_MSGBOX);
}


/*----------------------------------------------------------------------------*\
|   wsDlgInit(hDlg)                                                            |
|                                                                              |
|   Handle the init message for a dialog box.                                  |
|                                                                              |
\*----------------------------------------------------------------------------*/
void PUBLIC wsDlgInit(HWND hDlg)
{
    RECT rc;

    // ------------ Look for "xxx.yyy" -----------------------
    infDlgFixup(hDlg);

    // ------------ Look for Dialog-Details ------------------
    infDlgDetails(hDlg);

    /*
     *   Center the dialog.
     */
    GetWindowRect(hDlg,&rc);
    SetWindowPos(hDlg,NULL,
	(GetSystemMetrics(SM_CXSCREEN) - (rc.right - rc.left)) / 2,
	(GetSystemMetrics(SM_CYSCREEN) - (rc.bottom - rc.top)) / 2,
	0, 0, SWP_NOSIZE | SWP_NOACTIVATE);


    // enable hwndWS to allow keyboard input

/*    if (hwndWS == GetParent(hDlg))
	EnableWindow(hwndWS,TRUE); */
}

/*----------------------------------------------------------------------------*\
|   infDlgFixup()                                                              |
|                                                                              |
|   If the dialog caption text or the text of any control has the form         |
|                                                                              |
|	                     section.text                                           |
|                                                                              |
|   then this function changes the text to the text found in APPSETUP.INF.	    |
|                                                                              |
\*----------------------------------------------------------------------------*/
void PRIVATE infDlgFixup(HWND hwnd)
{

    if (GetWindowText(hwnd,bufTmp,sizeof(bufTmp)))
    {
	if (infLookup(bufTmp,bufTmp))
	    SetWindowText(hwnd,bufTmp);
    }

    hwnd = GetWindow(hwnd,GW_CHILD);
    while (hwnd)
    {
	infDlgFixup(hwnd);
	hwnd = GetWindow(hwnd,GW_HWNDNEXT);
    }
}





int infParseInt(PINF pinfGroup, int Column, int defaultvalue)
{ char buf[50];
  if (infParseField(pinfGroup, Column, buf))
	return (int) atol(buf);
   else return defaultvalue;
}



/* FindControlByText -------------------------------------------*
 *								*
 *--------------------------------------------------------------*/
HWND static near pascal FindControlByText(HWND hwnd, PSTR txt)
{ HWND hw;
  char szBuf[50];

  for (hw = GetWindow(hwnd, GW_CHILD);
       hw;
       hw = GetWindow(hw, GW_HWNDNEXT)) {

       GetWindowText(hw, szBuf, sizeof(szBuf));
       if (!lstrcmpi(szBuf, txt))
	   return hw;
  }

  return NULL;
}



/* infDlgDetails -----------------------------------------------*
 * Look for Details on Size, Positions and additional Controls	*
 *--------------------------------------------------------------*/
void PRIVATE infDlgDetails(HWND hwnd)
{   PINF pinfGroup;
    RECT rcd;
    HWND Control;
    char ControlClass[15];


    // ---------- Get Text of first Control ------------------
    if (NULL != (Control = GetWindow(hwnd, GW_CHILD)) &&
	0    !=  GetWindowText(Control,bufTmp,sizeof(bufTmp)))

    for (pinfGroup = infFindSection(NULL, bufTmp);
	 pinfGroup;
	 pinfGroup = infNextLine(pinfGroup)) {

	 *bufTmp = 0;

	 rcd.left  = infParseInt(pinfGroup, 5, 0);
	 rcd.top   = infParseInt(pinfGroup, 6, 0);
	 rcd.right = infParseInt(pinfGroup, 7, 30);
	 rcd.bottom= infParseInt(pinfGroup, 8, 30);

	 MapDialogRect(hwnd, &rcd);

	 if (infParseField(pinfGroup, 0, bufTmp)) {	// Get Key-Item (SIZE=...)

	    if (!lstrcmpi(bufTmp, "SIZE"))
	       SetWindowPos(hwnd, NULL, 0, 0, rcd.left, rcd.top, SWP_NOMOVE);
/*	    else {
	    } */
	 } else {

	    if (infParseField(pinfGroup, 1, bufTmp) &&
		0    == strnicmp(bufTmp, "CONTROL", 7)) {


		Control = FindControlByText(hwnd, bufTmp+7);

		if (!Control) {
		   infParseField(pinfGroup, 3, ControlClass);

		   Control = CreateWindow(ControlClass,
					  bufTmp+7,
					  WS_VISIBLE | WS_CHILD | WS_TABSTOP,
					  0,0,0,0,
					  hwnd,
					  (HMENU) -1,
					  hiWS,
					  NULL);
		}

		SetWindowPos(Control, NULL, rcd.left, rcd.top, rcd.right, rcd.bottom, SWP_NOZORDER);

		switch ((int) infParseInt(pinfGroup, 2, 0)) {
		  case -3: SendMessage(Control, WM_SETFONT, (WPARAM) GetStockObject(ANSI_VAR_FONT), 0L);
		  	   break;      
		  case -2: SendMessage(Control, WM_SETFONT, (WPARAM) SendMessage(hwnd, WM_GETFONT, 0, 0L), TRUE);
			   break;
		}

	    }
	 }

/*	 infParseField(pinfGroup, 3, bufTmp);	// Name of Icon Exe-File
	 if (*buf) */
    }
}








/*----------------------------------------------------------------------------*\
|   wsStartWait()                                                              |
|                                                                              |
|   Displays an hourglass cursor.                                              |
|                                                                              |
\*----------------------------------------------------------------------------*/
void PUBLIC wsStartWait()
{
        SetCursor(LoadCursor(NULL,MAKEINTATOM(IDC_WAIT)));
}

/*----------------------------------------------------------------------------*\
|   wsEndWait()                                                                |
|                                                                              |
|   Restores the cursor to its original shape.                                 |
|                                                                              |
\*----------------------------------------------------------------------------*/
void PUBLIC wsEndWait()
{

        SetCursor(LoadCursor(NULL,MAKEINTATOM(IDC_ARROW)));
}

/*---------------------------------------------------------------------------*/
/*                                                                           */
/*  PRIV text control that uses ExtTextOut(), thus avoiding flicker.         */
/*                                                                           */
/*---------------------------------------------------------------------------*/
LRESULT EXPORT fnText( HWND hwnd, unsigned msg, WPARAM wParam, LPARAM lParam )
{
    PAINTSTRUCT ps;
    RECT rc;
    char        ach[128];
    int  len;

    switch (msg)
    {
    case WM_SETTEXT:
        DefWindowProc(hwnd, msg, wParam, lParam);
        InvalidateRect(hwnd,NULL,FALSE);
        UpdateWindow(hwnd);
        return 0L;

    case WM_ERASEBKGND:
        return 0L;

    case WM_PAINT:
        BeginPaint(hwnd, &ps);
        GetClientRect(hwnd,&rc);

        len = GetWindowText(hwnd,ach,sizeof(ach));
        SetBkColor(ps.hdc,GetSysColor(COLOR_WINDOW));
        SetTextColor(ps.hdc,GetSysColor(COLOR_WINDOWTEXT));
        ExtTextOut(ps.hdc,0,0,ETO_OPAQUE,&rc,ach,len,NULL);

        EndPaint(hwnd, &ps);
        return 0L;
    }
    return DefWindowProc(hwnd, msg, wParam, lParam);
}

/*----------------------------------------------------------------------------*\
|   wsLoadSz()                                                                 |
|                                                                              |
|   Description:                                                               |
|       Loads a string from our resource file                                  |
|                                                                              |
|       ids     ID of string to load                                           |
|       pch     buffer in which to place the string. If pch is NULL, the       |
|               string will be placed in a global buffer.                      |
|                                                                              |
|   Returns:                                                                   |
|       near pointer to the loaded string                                      |
|                                                                              |
\*----------------------------------------------------------------------------*/
PSTR PUBLIC wsLoadSz(int ids, PSTR pch)
{
    if (pch == NULL)
	pch = bufTmp;

    pch[0]=0;
    LoadString(hiRes,ids,pch,MAXTMP);

    return pch;
}










/* SelectDirectory ---------------------------------------------*
 * Show Directory Browse Dialog
 *
 * Uses the common Dialogs to show a File Open Dialog Box
 * Scrolls it to the Left, so the file-Name List gets invisible.
 *
 *--------------------------------------------------------------*/
#define ID_NAMELISTBOX 1120
#define ID_DIRLISTBOX  1121
#define ID_DIRSTATIC   1088

BOOL FirstTime;

UINT CALLBACK _export static DirSltHook(HWND hDir, UINT msg, WPARAM wParam, LPARAM lParam)
#pragma argsused
{
  switch (msg)
  { case WM_INITDIALOG: FirstTime=TRUE;
                        break;

    case WM_PAINT:
    if (FirstTime)
    { HWND hwListbox = GetDlgItem(hDir, ID_NAMELISTBOX);
      RECT rcListbox,
           rcWindow;
      FirstTime=FALSE;
      GetWindowRect(hwListbox, &rcListbox);
      GetWindowRect(hDir     , &rcWindow);
      ScreenToClient(hDir, (LPPOINT) &rcListbox.right);
      ScrollWindowEx(hDir, -rcListbox.right-1, 0, NULL, NULL, NULL, NULL, SW_SCROLLCHILDREN);
      SetWindowPos(hDir, NULL, 0, 0, rcWindow.right-rcWindow.left-rcListbox.right, rcWindow.bottom-rcWindow.top, SWP_NOMOVE);
      SetFocus(GetDlgItem(hDir, ID_DIRLISTBOX));
    }
    break;

    case WM_COMMAND:
      if (LOWORD(wParam)==IDOK)
         GetDlgItemText(hDir, ID_DIRSTATIC, szSetupPath, sizeof(szSetupPath));
  }


  return 0;
}


void SelectDirectory(HWND hDlg)
{ OPENFILENAME ofn;
  char szFile[50];
  lstrcpy(szFile, "*.*");
  memset(&ofn, 0, sizeof(ofn));
  ofn.lStructSize = sizeof(ofn);
  ofn.hwndOwner=hDlg;
  ofn.lpstrFilter="*.*\0*.*";
  ofn.lpstrFile  =szFile;
  ofn.nMaxFile   =50;
  ofn.lpfnHook   =DirSltHook;
  ofn.Flags      =OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_NOVALIDATE | OFN_ENABLEHOOK | OFN_NOCHANGEDIR;
  if (GetOpenFileName(&ofn))
        SetDlgItemText(hDlg,ID_EDIT1,szSetupPath);

  SetFocus(GetDlgItem(hDlg, ID_EDIT1));
}








/*----------------------------------------------------------------------------*\
|   wsInstallDlg( hDlg, uiMessage, wParam, lParam )                            |
|                                                                              |
|   Returns:                                                                   |
|       TRUE if message has been processed, else FALSE                         |
|                                                                              |
\*----------------------------------------------------------------------------*/
#pragma argsused
BOOL CALLBACK _export static wsInstallDlg( HWND hDlg, UINT uiMessage, WPARAM wParam, LPARAM lParam )
{
    HWND    hEditFld;
    char    szTmpBuf[MAXSTR];
    int	    l;
    OFSTRUCT dummy;

    switch (uiMessage)
    {
/*	case WM_SYSCOMMAND:		// suppress taskman
	    if (wParam == SC_TASKLIST)
		return TRUE;
	    break;*/

	case WM_COMMAND:
	    switch (LOWORD(wParam))
	    {
		case ID_OK:
		    l=GetDlgItemText(hDlg,ID_EDIT1,szSetupPath,MAXPATHLEN);

		    // ---------- No trailing Backslashes please... ----------
		    if (szSetupPath[0] &&
			szSetupPath[l-1]=='\\')
			szSetupPath[l-1]=0;

		    // ---------- Test if Directory already exists -----------
		    if (infLookupInt("data.dirwarnexist", FALSE) &&
			DosValidDir(szSetupPath) &&	// Directory does not exist
			IDNO == MessageBox(hDlg, wsLoadSz(IDS_DIREXIST, NULL), szCaption, MB_ICONQUESTION | MB_YESNO)
		       )
		       return TRUE;			// Do not close Dialog.

                    // ---------- Test if Program Version not updateable -----
                    lstrcpy(szTmpBuf, szSetupPath);
                    lstrcat(szTmpBuf, "\\");
                    if (infLookup("data.noupdate", szTmpBuf+lstrlen(szTmpBuf)) &&
                        OpenFile(szTmpBuf, &dummy, OF_EXIST)!=HFILE_ERROR
                       )
                    { MessageBox(hDlg, wsLoadSz(IDS_CANNOTUPDATE, NULL), szCaption, MB_ICONEXCLAMATION | MB_OK);
                      return TRUE;
                    }

		    EndDialog(hDlg, TRUE);
		    break;

		case ID_CANCEL:
		    // make this the same as pressing F3
		    if ( fnErrorMsg(IDS_EXITMSG) )
		       EndDialog(hDlg, FALSE);
		    break;
		case ID_HELP:
		    WinHelp( hwndWS, szHelp, HELP_CONTEXT, (DWORD) IDH_WINSETUP);
		    break;

                case ID_BROWSE:
                    SelectDirectory(hDlg);
                    break;

	    }
	    return TRUE;

	/*  On init we need to:
	 *     - Put default text in edit field.
	 *     - Set focus to edit field.
	 *     - Place cursor at end of edit field text.
	 *     - Destroy the Help-Button if there isn't a Help File available
	 */

	case WM_INITDIALOG:
	    wsDlgInit(hDlg);
	    if (!bHelp) SendDlgItemMessage(hDlg, ID_HELP, WM_CLOSE, 0, 0L);
	    hEditFld = GetDlgItem(hDlg,ID_EDIT1);
	    infLookup(wsLoadSz(IDS_DEFAULT_DIR,NULL),szTmpBuf);
	    SetDlgItemText(hDlg,ID_EDIT1,szTmpBuf);
	    SetFocus(hEditFld);
	    SendMessage(hEditFld,EM_SETSEL,0,MAKELONG(lstrlen(szTmpBuf),lstrlen(szTmpBuf)));
	    SetTimer(hDlg, 1001, 1000, NULL);

	    return FALSE;

	case WM_TIMER:
	    wsExec(hwndWS, "ExecAtStart", FALSE);
	//  ---->
	case WM_DESTROY:
	    KillTimer(hDlg, 1001);
    }
    return FALSE;
}

/*----------------------------------------------------------------------------*\
|   wsErrorDlg( hDlg, uiMessage, wParam, lParam )			       |
|                                                                              |
|   Arguments:                                                                 |
|       hDlg            window handle of About dialog's window                   |
|       uiMessage       message number                                         |
|       wParam          message-dependent                                      |
|       lParam          message-dependent                                      |
|                                                                              |
|   Returns:                                                                   |
|       TRUE if message has been processed, else FALSE                         |
|                                                                              |
\*----------------------------------------------------------------------------*/
#pragma argsused
BOOL CALLBACK _export wsErrorDlg(HWND hDlg, unsigned uiMessage, WPARAM wParam, LPARAM lParam)
{
    switch (uiMessage)
    {
	case WM_COMMAND:
	    switch (LOWORD(wParam))
	    {
		case ID_RETRY:
                    EndDialog(hDlg,FC_RETRY);
		    break;

		case ID_ABORT:
		    EndDialog(hDlg,FC_ABORT);
		    break;

		case ID_IGNORE:
		    EndDialog(hDlg,FC_IGNORE);
		    break;
	    }
	    return TRUE;

        case WM_INITDIALOG:
	    SetDlgItemText(hDlg, ID_STATUS1, pErrMsg);
	    wsDlgInit(hDlg);
            return TRUE;
    }
    return FALSE;
}

#ifdef DEBUG
/* FAR _Assert(char*,int);
 *
 * Called as a result of an assertion failure. Will print out an error
 * dialog containing the file and line number at which the assertion failure
 * occured.
 *
 * ENTRY: Only from an assertion failure.
 * EXIT : Fatal Error (exit to MS-DOS).
 *
 */
int FAR _Assert(PSTR szFile, int iLine)
{
    int     id;
    char    buf[128];

    fsprintf(buf,"%s : %d",szFile,iLine);
    id = MessageBox(NULL,buf,"WinAssert",MB_ABORTRETRYIGNORE|MB_ICONEXCLAMATION|MB_DEFBUTTON3|MB_SYSTEMMODAL);
    switch (id)
    {
        case IDABORT:
	    exit(-1);  /* Terminate application immediately. */
        case IDIGNORE:
            break;
    }
    return 0;
}
#endif


/*----------------------------------------------------------------------

	Temporres STP00000.TMP-Verzeichnis lschen

  ----------------------------------------------------------------------*/
void DeleteTempDir(void)
{ char 		szFileName[100];
  int   	nRtn;
# ifdef WIN32
  WIN32_FIND_DATA ff;
  BOOL		  bMore;
  HANDLE	  hFind;
# else
  struct ffblk 	  ff;
# endif
  PSTR          pr;
# ifndef NOCTL3D
  CTL3DPROC	fnUnReg;


  //--------------- Free the Bitmap, if loaded -------------------
  if (hBitmap) {
      DeleteObject(hBitmap);
      hBitmap = NULL;
  }

  if (hMetaFile) {
      DeleteMetaFile(hMetaFile);
      hMetaFile=NULL;
  }

  //--------------- Schlieen DDE-Hilfsfenster -------------------
  ddeDestroy();


    // -------------- Ctl3D-Subclassing beenden, falls gestartet ---
  if (hCtl3DLib) {
#    ifdef WIN32
     fnUnReg = (CTL3DPROC) GetProcAddress( hCtl3DLib, "Ctl3dUnregister" );
#    else	
     fnUnReg = (CTL3DPROC) GetProcAddress( hCtl3DLib, "CTL3DUNREGISTER" );
#    endif
     if (fnUnReg)
	 fnUnReg(hiWS);

     FreeLibrary(hCtl3DLib);
     hCtl3DLib=NULL;
  }
# endif

  SetErrorMode(TRUE);		// Keine Fehlermeldungen ausgeben
# ifndef WIN32
  GlobalCompact((LONG) -1);
# endif
  GetModuleFileName(hiWS, szFileName, sizeof(szFileName));
  if (fnMystrstr(szFileName, "STP00000.TMP")) {
     pr   = strrchr(szFileName, '\\');
     lstrcpy(pr, "\\*.*");
     pr++;
#    ifdef WIN32
     hFind = FindFirstFile(szFileName, &ff);
     if (hFind != INVALID_HANDLE_VALUE) {
        do {
          lstrcpy(pr, ff.cFileName);
          DeleteFile(szFileName);
          bMore = FindNextFile(hFind, &ff);
        } while (bMore);
	FindClose(hFind);
     }
#    else
     nRtn = findfirst(szFileName, &ff, 0);
     while (!nRtn) {
       lstrcpy(pr, ff.ff_name);
       remove(szFileName);
       nRtn = findnext(&ff);
     }
#    endif
     pr--;
     *pr=0;
     chdir("\\");		// Das zu lschende Verzeichnis freigeben
     rmdir(szFileName);		// Verzeichnis lschen
  }
  SetErrorMode(FALSE);

}


/*----------------------------------------------------------------------

	Frage nach den zu kopierenden Modulen

  ----------------------------------------------------------------------*/
#define IDFIRST 2000
#pragma argsused
BOOL CALLBACK _export static AskModulesProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  switch (msg) {
     case WM_INITDIALOG: {
	 LPSTR p     = pszModules;
	 LPSTR pList = infFindSection(NULL, wsLoadSz(IDS_MODULES, NULL));
	 int   i = 0,
               nY;
	 HWND  hwTemp;
	 char  szTitle[100],
               szFlags[30];	
	 RECT  rc;
	 HDC   hDC;
	 int   XS;
	 DWORD dwBase = GetDialogBaseUnits();		// Schriftgren holen
	 int   yBase  = HIWORD( dwBase ),
	       xBase  = LOWORD( dwBase );

	 //-------------- Help-Button lschen, falls kein Hilfetext ----
	 if (!bHelp) SendDlgItemMessage(hWnd, ID_HELP, WM_CLOSE, 0, 0L);

	 //-------------- Fenster- und Bildschirmgre -----------------
	 GetClientRect(hWnd, &rc);
	 hDC  = CreateCompatibleDC(NULL);
         XS  = GetDeviceCaps(hDC, HORZRES);
	 DeleteDC(hDC);

	 //-------------- Schaltfelder einfgen ------------------------
	 while (pList && *pList) {
	      *szFlags=0;
	       infParseField(pList, 2, szTitle);
	       infParseField(pList, 3, szFlags);		// Flags : 1 = Aktivieren, 0 = Deaktivieren
	       hwTemp = CreateWindow( "BUTTON",			// Fensterklasse
				      szTitle,			// Fenstertitel
				      BS_AUTOCHECKBOX | WS_CHILD | WS_VISIBLE | WS_TABSTOP, // Fensterstile
				      xBase, i*yBase*14/10 + yBase*2,	// X,Y-Koordinate
				      rc.right - 2 * xBase, yBase,	// Gre
				      hWnd,			// Parent
				      (HMENU) (i + IDFIRST),	// DIalogelement-Id
				      hiWS,			// Instanz
				      NULL);			// Nicht bentigt
	       SendMessage(hwTemp, WM_SETFONT,  (WPARAM) SendMessage(hWnd, WM_GETFONT, 0, 0L), TRUE);
	       SendMessage(hwTemp, BM_SETCHECK, szFlags[0]!='0', 0L);

	       infParseField(pList, 1, p);		// Section-Name speichern

	       p     += lstrlen(p)     +1;
               pList  = infNextLine(pList);
	       ++i;			       
	 }

	 nY = (i+2) * yBase*14/10;

	 SetWindowPos( GetDlgItem(hWnd, IDCANCEL+1) , HWND_BOTTOM, 0		     , nY-yBase, XS, 2, SWP_NOACTIVATE);
	 SetWindowPos( GetDlgItem(hWnd, IDOK      ) , HWND_BOTTOM, xBase * 5/2         , nY   , 0, 0, SWP_NOACTIVATE | SWP_NOSIZE);
	 SetWindowPos( GetDlgItem(hWnd, IDCANCEL  ) , HWND_BOTTOM, rc.right  -xBase *10, nY   , 0, 0, SWP_NOACTIVATE | SWP_NOSIZE);
	 if (bHelp)
	 SetWindowPos( GetDlgItem(hWnd, ID_HELP   ) , HWND_BOTTOM, rc.right/2-xBase * 4, nY   , 0, 0, SWP_NOACTIVATE | SWP_NOSIZE);


//	 MoveWindow( GetDlgItem(hWnd, IDOK)    ,  20, nY, 70, 20, TRUE);
//	 MoveWindow( GetDlgItem(hWnd, IDCANCEL), 150, nY, 70, 20, TRUE);

	 GetWindowRect(hWnd, &rc);
	 SetWindowPos( hWnd, 0, 0, 0, rc.right, nY+4*yBase, SWP_NOMOVE | SWP_NOZORDER);

	 wsDlgInit(hWnd);

	 ShowWindow( hWnd, SW_NORMAL);

     }	 return TRUE;

     case WM_COMMAND: {
	 switch (LOWORD(wParam)) {
	     case IDOK:  {
		  LPSTR q =pszModules,
			d =pszModules;
		  int  i=0;

		  while (*q) {
		      if (IsDlgButtonChecked(hWnd, i+IDFIRST)) {
			 lstrcpy(d, q);
			 d += lstrlen(d)+1;
		      }
		      q += lstrlen(q)+1;
		      ++i;
		  }
		  *d++=0;
		  *d++=0;

	     }		   EndDialog(hWnd, TRUE);  break;

//	     case IDCANCEL:EndDialog(hWnd, FALSE); break;

		case ID_CANCEL:
		    // make this the same as pressing F3
		    if ( fnErrorMsg(IDS_EXITMSG) )
		       EndDialog(hWnd, FALSE);
		    break;


	     case ID_HELP: WinHelp( hwndWS, szHelp, HELP_CONTEXT, (DWORD) IDH_SELECT);
			   break;
	 }
     }
  }

  return FALSE;
}


BOOL PRIVATE AskModules(void)
{
  LPSTR   pList = infFindSection(NULL, wsLoadSz(IDS_MODULES, NULL));
  BOOL    bOk   = TRUE;

  pszModules = GlobalLock( GlobalAlloc( GHND, 4000 ) );

  if (pList) {
     // --------- Load the 2.nd Bitmap -------------------------------
     if (infLookup(wsLoadSz(IDS_INFBITMAPMOD,NULL),szBitmap))
	 LoadTheBitmap(szBitmap);

     bOk = DialogBox(hiRes, MAKEINTRESOURCE(DLG_SELECT), hwndWS, AskModulesProc);
  }

  return bOk;
}





/* LoadTheBitmap -------------------------------------------------------*
 * Load the Bitmap with the given Name					*
 *----------------------------------------------------------------------*/

void LoadTheBitmap(PSTR szName)		// Load the Bitmap with the given Name
{ int    nRelX, nRelY,			// Relative x, y-Koordinaten
	 nRelCX, nRelCY;		// Relative x, y-Gren
  char   szFName[100];
  HDIB   hDib;
  RECT   rc;
  RECT	 rcWS;

  GetClientRect( hwndWS, &rcWS );

  if (!lstrcmp(szLastBitmap, szName)) return;		// Prfung auf unvernderte Darstellung
       lstrcpy(szLastBitmap, szName);

  infParseField(szName, 2, szFName); nRelX  = atoi(szFName);
  infParseField(szName, 3, szFName); nRelY  = atoi(szFName);
  infParseField(szName, 4, szFName); nRelCX = atoi(szFName);
  infParseField(szName, 5, szFName); nRelCY = atoi(szFName);

  infParseField(szName, 1, szFName);

  if (hBitmap) {
	DeleteObject(hBitmap);
	SetRect(&rc, nXBmp, nYBmp, nXBmp+Bitmap.bmWidth, nYBmp+Bitmap.bmHeight);
	InvalidateRect(hwndWS, &rc, TRUE);
  }

  if (hMetaFile) {
	DeleteMetaFile(hMetaFile);
	hMetaFile = NULL;
	SetRect(&rc, nXBmp, nYBmp, nXBmp+nCXBmp, nYBmp+nCYBmp);
	InvalidateRect(hwndWS, &rc, TRUE);
  }

  if (fnMystrstr(szName, ".WMF")) {
        SetErrorMode(TRUE);
	hMetaFile = GetMetaFile(szFName);		// Load Non-Placeable Metafile
	SetErrorMode(FALSE);
	nCXBmp = MulDiv( rcWS.right , nRelCX, 100);
	nCYBmp = MulDiv( rcWS.bottom, nRelCY, 100);
  }
  else {

     hDib = OpenDIB(szFName);

     if (hDib) {
	hBitmap = BitmapFromDib(hDib, NULL);
        GlobalFree(hDib);

        if (hBitmap) {
	   GetObject(hBitmap, sizeof(BITMAP), &Bitmap);

	   nCXBmp = Bitmap.bmWidth;
	   nCYBmp = Bitmap.bmHeight;
	}
     }
  }

  nXBmp = MulDiv( rcWS.right  - nCXBmp, nRelX, 100);
  nYBmp = MulDiv( rcWS.bottom - nCYBmp, nRelY, 100);
           
  SetRect(&rc, nXBmp, nYBmp, nXBmp+nCXBmp, nYBmp+nCYBmp);
  if (hwndWS)
     InvalidateRect(hwndWS, &rc, hMetaFile!=0);
}


/* DrawBitmapTransparent -------------------------------------------------*
 * Draws the Bitmap into the given HDC and masking Black as a transparent *
 * Color								  *
 * hdcDest	- Ziel-Device-Kontext (Bildschirm oder Memory, keine Drucker *
 * hBitmap      - Auszugebende Bitmap, Schwarz fr Transparent		  *
 * nXDest       - X-Offset im Ziel-Device-Kontext			  *
 * nYDest	- Y-Offset im Ziel-Device-Kontext			  *
 * In dieser Form nur fr MM_TEXT (default) geeignet			  *
 * -----------------------------------------------------------------------*/
void DrawBitmapTransparent(HDC hdcDest, HBITMAP hBitmap, int nXDest, int nYDest)
{
  BITMAP        Bitmap; 
  HBITMAP	hbmMask,	// Masken-Bitmap (Sw/Wei)
		hbmOld,		// Alte Bitmap zum restaurieren Masken-HDC
		hbmOldSrc;
  HDC		hdcMask,	// DC fr die Masken-Bitmap
		hdcSrc;

  GetObject(hBitmap, sizeof(BITMAP), &Bitmap);

  hdcSrc    = CreateCompatibleDC(hdcDest);
  hbmOldSrc = (HBITMAP) SelectObject(hdcSrc, hBitmap);

  hbmMask = CreateBitmap(Bitmap.bmWidth, Bitmap.bmHeight, 1, 1, NULL);
  hdcMask = CreateCompatibleDC(hdcDest);

  hbmOld  = (HBITMAP) SelectObject(hdcMask, hbmMask);

  SetBkColor(hdcSrc, 0);

  BitBlt(hdcMask, 0, 0, Bitmap.bmWidth, Bitmap.bmHeight, hdcSrc, 0, 0, SRCCOPY);

  SetTextColor(hdcDest, 0L);
  SetBkColor(hdcDest, 0xffffffL);

  BitBlt(hdcDest, nXDest, nYDest, Bitmap.bmWidth, Bitmap.bmHeight, hdcMask, 0, 0, SRCAND);
  BitBlt(hdcDest, nXDest, nYDest, Bitmap.bmWidth, Bitmap.bmHeight, hdcSrc , 0, 0, SRCPAINT);
  SetBkColor(hdcSrc, 0xffffffL);

  SelectObject(hdcSrc, hbmOldSrc);
  DeleteDC(hdcSrc);

  SelectObject(hdcMask, hbmOld);
  DeleteDC(hdcMask);
  DeleteObject(hbmMask);
}




#ifdef WIN32

/* DosDiskFreeSpace --------------------------------------------*
 * WIN32-Hack zur Source-Kompatibilitt				*
 *--------------------------------------------------------------*/
LONG PUBLIC DosDiskFreeSpace(int iDrive)
{ DWORD SectorsPerCluster,
	BytesPerSector,
	FreeClusters,
	Clusters;
  LONG lFree;

  char szRoot[20];

  wsprintf(szRoot, "%c:\\", iDrive+'@');

  if (GetDiskFreeSpace(	szRoot,
			&SectorsPerCluster,
			&BytesPerSector,
			&FreeClusters,
			&Clusters) )
			{
     if (FreeClusters > 0xfffff)
	  lFree = 0x7000000;
     else lFree = SectorsPerCluster * BytesPerSector * FreeClusters;
  }
  else {
    MessageBeep(0);
    MessageBeep(0);
    lFree = 1000000L;
  }

  return lFree;
}

/* DosValidDir -------------------------------------------------*
 * WIN32-Hack zur Source-Kompatibilitt				*
 * Prfung Directory-Existenz					*
 *--------------------------------------------------------------*/
int   PUBLIC DosValidDir (LPSTR szDir)
{ char szCurrentDir[200];
  BOOL bRtn;

  GetCurrentDirectory( sizeof(szCurrentDir), szCurrentDir);
//  getcurdir(szCurrentDir);

  bRtn = !chdir( szDir);

  chdir(szCurrentDir);

  return bRtn;
}
#endif









/* TestChecksum ------------------------------------------------*
 * Tests, if the given String results in a Zero-Checksum over 	*
 * the least 4 Bits						*
 * Returns 0 when OK						*
 *--------------------------------------------------------------*/
BOOL PRIVATE TestChecksum(PSTR Checksum)
{ int s;
  for (s=0; *Checksum; )
       s+=(*Checksum++);
  return s & 0xf;
}


/*----------------------------------------------------------------------

   Ask for Registration Infos (NAME, SERIAL Number...)

  ----------------------------------------------------------------------*/
#pragma argsused
BOOL CALLBACK _export static AskRegistrationProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
  PINF  pList;
  int   i;
  HWND  hwTemp;
  char  szTitle[100],
        szFieldTitle[100],
	szKeyValue[100];
  PSTR  pl;
  BOOL  error;
  HKEY  hky;
  LONG  cb;

  switch (msg) {
     case WM_INITDIALOG: {
	 RECT  rc,
	       rcDlg;
	 HFONT hfnt = (HFONT) SendMessage(hWnd, WM_GETFONT, 0, 0L);

	 //-------------- Datenfelder einfgen -------------------------
	 for (i=1, pList  = infFindSection(NULL, wsLoadSz(IDS_REGISTRATION, NULL));
		   pList;
		   pList  = infNextLine(pList))
	      if (!infParseField(pList, 0, szTitle)) {		// Lines with '=' handled seperately

	       infParseField(pList, 2, szTitle);

	       SetRect(&rc, 5, i*20, 50, 13);
	       MapDialogRect(hWnd, &rc);
	       lstrcat(szTitle, ":");

	       hwTemp = CreateWindow( "static",			// Fensterklasse
				      szTitle,			// Fenstertitel
				      SS_RIGHT | WS_CHILD | WS_VISIBLE, // Fensterstile
				      rc.left, rc.top,		// X,Y-Koordinate
				      rc.right, rc.bottom,	// Gre
				      hWnd,			// Parent
				      (HMENU) -1,		// DIalogelement-Id
				      hiWS,			// Instanz
				      NULL);			// Nicht bentigt
	       SendMessage(hwTemp, WM_SETFONT, (WPARAM)hfnt , TRUE);


               *szTitle=0;
	       if (infParseField(pList, 1, bufTmp) &&				// Get Field Name
		   NULL != (pl = strrchr(bufTmp, '\\'))) {
		   *pl++=0;
		   if (ERROR_SUCCESS == RegOpenKey(HKEY_CLASSES_ROOT, bufTmp, &hky)) {

                      cb = sizeof(szTitle);
		      RegQueryValue(hky, pl, szTitle, &cb);

		      RegCloseKey(hky);
		   }
	       }

	       pl=strchr(szTitle, ',');

	       hwTemp = CreateWindow( "edit",			// Fensterklasse
				      pl ? pl+1 : "",		// Fenstertitel
                                      (szTitle[0] ? WS_DISABLED : 0) |
				      WS_BORDER | WS_CHILD | WS_VISIBLE | WS_TABSTOP, // Fensterstile
				      rc.left+rc.right+5, rc.top,		// X,Y-Koordinate
				      rc.right*3, rc.bottom,	// Gre
				      hWnd,			// Parent
				      (HMENU) (i + IDFIRST),	// DIalogelement-Id
				      hiWS,			// Instanz
				      NULL);			// Nicht bentigt
	       SendMessage(hwTemp, WM_SETFONT, (WPARAM)hfnt , TRUE);

	       ++i;

	 }

	 SetRect(&rc, 10, (i)*20, 21, 20);
	 MapDialogRect(hWnd, &rc);

	 GetClientRect(hWnd, &rcDlg);


	 SetWindowPos( GetDlgItem(hWnd, IDCANCEL+1) , HWND_BOTTOM, 0		           , rc.top-5 , rcDlg.right, 2, SWP_NOACTIVATE);
	 SetWindowPos( GetDlgItem(hWnd, IDOK      ) , HWND_BOTTOM, rcDlg.right  /3-rc.right, rc.top+4 , 0 , 0, SWP_NOACTIVATE | SWP_NOSIZE);
	 SetWindowPos( GetDlgItem(hWnd, IDCANCEL  ) , HWND_BOTTOM, rcDlg.right*2/3-rc.right, rc.top+4 , 0 , 0, SWP_NOACTIVATE | SWP_NOSIZE);

	 SetWindowPos(            hWnd              , NULL       , 0, 0, rcDlg.right               , rc.top+rcDlg.bottom, SWP_NOACTIVATE);

	 wsDlgInit(hWnd);

	 ShowWindow( hWnd, SW_NORMAL);

     }	 return TRUE;

#    ifndef __WIN32__
     case WM_CTLCOLOR:
	if (HIWORD(lParam)==CTLCOLOR_EDIT &&
	    !IsWindowEnabled((HWND) LOWORD(lParam))) {
	    SetBkColor((HDC) wParam, 0xc0c0c0L);
	    return GetStockObject(LTGRAY_BRUSH);
	}
        break;
#    endif

     case WM_COMMAND: {
	 switch (LOWORD(wParam)) {
	     case IDOK:  {
	 //-------------- Gltigkeitsprfung fr Eingabedaten ----------
	 error = 0;
	 for (i=1, pList  = infFindSection(NULL, wsLoadSz(IDS_REGISTRATION, NULL));
		   pList && !error;
		   pList  = infNextLine(pList))
	      if (!infParseField(pList, 0, szTitle) &&
		   NULL != (hwTemp = GetDlgItem(hWnd, i+IDFIRST))) {		// Lines with '=' handled seperately

		   GetWindowText(hwTemp, szTitle, sizeof(szTitle));
                   AnsiUpper(szTitle);
		   if (!szTitle[0])			// Is Data Field empty?
			error = (infParseInt(pList, 3, 0) & 2) ? 0 : IDS_REGEMPTY;
		   else error = (infParseInt(pList, 3, 0) & 1) && TestChecksum(szTitle) ? IDS_REGCHECKSUM : 0;

		   if (error)
		     infParseField(pList, 2, szTitle);	// Get Field Name

	      ++i;
	      }
	 if (!error) {
	    // ---------- No error occured, write Data ---------------

	    for (i=1, pList  = infFindSection(NULL, wsLoadSz(IDS_REGISTRATION, NULL));
		   pList && !error;
		   pList  = infNextLine(pList))

	      if (!infParseField(pList, 0, szTitle) &&
		   NULL != (hwTemp = GetDlgItem(hWnd, i+IDFIRST)) && 		// Lines with '=' handled seperately
		   GetWindowText(hwTemp, szTitle, sizeof(szTitle)) && 		// Do not write empty Fields
		   infParseField(pList, 1, bufTmp) &&				// Get Field Name "SNR"
		   infParseField(pList, 2, szFieldTitle) &&			// Get Field Title "Serial Number"
		   NULL != (pl = strrchr(bufTmp, '\\'))) {
		   *pl++=0;
		   if (ERROR_SUCCESS == RegCreateKey(HKEY_CLASSES_ROOT, bufTmp, &hky)) {

		      // --------- Write Data Field Contents -------------------
		      wsprintf(szKeyValue, "%s,%s", (LPSTR) szFieldTitle, (LPSTR) szTitle);
		      RegSetValue(hky, pl, REG_SZ, szKeyValue, lstrlen(szKeyValue) );

		      RegCloseKey(hky);
		   }
		   ++i;
	    }

	    EndDialog(hWnd, TRUE);
	 }
	 else
            // ---------- An Error Occured: Show Error Message -------
	    fnOkMsgBox(error, (LPSTR) szTitle);

	 }   break;

	     case ID_CANCEL:
		    // make this the same as pressing F3
		    if ( fnErrorMsg(IDS_EXITMSG) )
		       EndDialog(hWnd, FALSE);
		    break;


//	     case ID_HELP: WinHelp( hwndWS, szHelp, HELP_CONTEXT, (DWORD) IDH_SELECT);
//			   break;
	 }
     }
  }

  return FALSE;
}


BOOL PRIVATE AskRegistration(void)
{
  LPSTR   pList = infFindSection(NULL, wsLoadSz(IDS_REGISTRATION, NULL));
  BOOL    bOk   = TRUE;

  if (pList) {
     // --------- Load the 2.nd Bitmap -------------------------------
/*     if (infLookup(wsLoadSz(IDS_INFBITMAPMOD,NULL),szBitmap))
	 LoadTheBitmap(szBitmap); */

     bOk = DialogBox(hiRes, MAKEINTRESOURCE(DLG_REGISTER), hwndWS, AskRegistrationProc);
  }

  return bOk;
}
