/* FontInst.C --------------------------------------------------*
 * Zusatz zu ASetup zum Einrichten von Schriftarten		*
 * Syntax: Wird im [Exec]-Abschnitt von ASetup eingesetzt	*
 *								*
 * [Exec]							*
 * AFont,"OCRB,OCR-B (TrueType)"				*
 *								*
 * Veranlat die Installation der Schriftartdatei OCRB.FOT,	*
 * die sich im Windows-System-Ordner befinden mu.		*
 * der 2. Parameter gibt den Namen der Schrift fr die		*
 * Systemsteuerung an.						*
 *--------------------------------------------------------------*/

#include <windows.h>
#include <string.h>


#if defined(__BORLANDC__) && !defined(__WIN32__)
void _cdecl _setupio(void){}		// Diese Zeile spart 2KByte Speicher, weil Dateien direkt verwaltet werden!

int _RTLENTRY _sys_nerr = 50;		// Diese Variable wird vom Laufzeit-system Angesprochen bei chdrive...,
					// und fhrt dann zum Linken von PERROR, was wiederum... unntig Platz verbrt

size_t      _RTLENTRYF _EXPFUNC strlen(const char _FAR *__s) { return lstrlen(__s); }




#endif

#pragma argsused
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
  char szSysDir[144],
       szResFile[144],
       szTtfFile[144],
       szCmdLine[144];

  BOOL bErr = FALSE;

  OFSTRUCT dummy;

  char *pFile, *pName;

  lstrcpy(szCmdLine, lpCmdLine);

  pFile = strtok(szCmdLine, ","),
  pName = strtok(NULL,	  "");

  if (!pFile || !pName) bErr=TRUE;

  // --------------- Windows Systemverzeichnis -------------
  GetSystemDirectory( szSysDir, sizeof(szSysDir) );

  // --------------- Filenamen zusammensetzen --------------
  wsprintf( szResFile, "%s\\%s.FOT", (LPSTR) szSysDir, (LPSTR) pFile);
  wsprintf( szTtfFile, "%s\\%s.TTF", (LPSTR) szSysDir, (LPSTR) pFile);


  // --------------- Kontrolle auf existierende Schriftart -
  if ( OpenFile( szResFile, &dummy, OF_EXIST) != HFILE_ERROR) {
//     wsprintf(szSysDir, "Das Hinzufgen der Schriftart %s schlug fehl, da sie schon eingerichtet war.", (LPSTR) pName);
//     MessageBox( NULL, szSysDir, "AFont...", MB_OK | MB_ICONINFORMATION);
     return TRUE;		// Vorzeitiger Abbruch
  }

  // --------------- Falls Schriftart nicht existiert ------
  if ( OpenFile( szTtfFile, &dummy, OF_EXIST) == HFILE_ERROR)
      return TRUE;		// Schrift wurde beim Kopieren nicht ausgewhlt

  // --------------- Font-Resource-File erzeugen -----------
  if (!bErr)
     bErr = !CreateScalableFontResource(
				FALSE,		// Not Hidden
				szResFile,	// Name of File to Create
				szTtfFile,	// Name of True Type Font File
				NULL );

  // --------------- Dateiname ohne Pfad -------------------
  wsprintf( szResFile, "%s.FOT"    ,                   (LPSTR) pFile);

  // --------------- INI-verzeichnis ergnzen --------------
  if (!bErr)
     WriteProfileString("fonts", pName, szResFile);

  // --------------- Schriftart sofort verfgbar machen ----
  if (!bErr)
       bErr = !AddFontResource( szResFile );

  // --------------- Applikationen benachrichtigen ---------
  if (!bErr)
       SendMessage(HWND_BROADCAST, WM_FONTCHANGE, 0, 0L); 

  // --------------- Fehlermeldung wenn ntig --------------
  if (bErr)
     MessageBox( NULL, "Das Hinzufgen der Schiftart ist fehlgeschlagen", "AFont...", MB_OK | MB_ICONEXCLAMATION);

  return TRUE;
}
