page	, 128
	TITLE   "LHA - Decompressor 32 Bit Version"

        WIN32 = 1
.386p
;---------------------------------------------------------------------
; L H A L I B . L I B
; Library to be used in Microsoft windows Programs
; makes it possible to extract LHA-Archives.
;
; (C) Bernd Herd / Heidelberger Landstr. 316 / 64297 Darmstadt
;     Tel u. Fax 0049-6151/591216 FIDO 2:244/7202.10
;
; Version 1.1 with temporary Data Segment
; Version 1.2 fixed problem with Files containing attributes
; Version 1.3 Allows for Extraction of a given File-Handle and Position
;	      by using MAKEINTRESOURCE( hFile ) as the Archiv Filename
;---------------------------------------------------------------------
; Usage:
; int FAR PASCAL _LHAExpand@16(const char far *ArchivName, const char far *FileName, int Options,
;			   FARPROC PeekProc)
;
; with:
; ArchivName : FileName of LHA-Archivfile. Extension is recommended.
; DestPath   : Directory Pathname for Destination File
; PeekProc   : Application-supplied callback-Routine to enable Multitasking
;
; Options may be:
; LHA_OVERWRITE		Overwrite existing Files without warning
; LHA_ATTRIB		Set File attributes
;
include c:\borlandc\include\windows.inc

	.xlist
include f:\mstools\h\callconv.inc            ; calling convention macros
        .list


;------------- Stack usage ---------------------
; Ebp+16 4 char *  ArchivNAme
; Ebp+12 4 char *  DestPath
; Ebp+10 2 int     Options
; Ebp+6  4 FARPROC PeekProc
; Ebp+2	4 	  return  Adress
; Ebp+0	2 	  old Ebp  Value
; 14 Bytes for Parameters at all

;------------- Windows Procedures used ---------
EXTRNP	__lopen,2
EXTRNP  __lread,3
EXTRNP  __lwrite,3
EXTRNP  __lclose,1
EXTRNP  __llseek,3
EXTRNP  _OpenFile,3
EXTRNP  _MessageBoxA,4
EXTRNP  _GetFocus,0
EXTRNP  _lstrcpy,2
EXTRNP  _lstrcat,2

;------------- Codes for Options-Parameter -----
LHA_OVERWRITE		= 0001H		; Do not Ask before overwriting File
LHA_ATTRIB		= 0010H		; Set File Attributes

;------------- Error Codes ---------------------
; The Errorcode are selected to be between 2000 and 2100, so it's easyer
; to store the error text in an Resource File
LHAE_ARCHIVNOTFOUND	= 2020		; Archiv File not Found
LHAE_BROKEN		= 2021		; Broken Archiv
LHAE_METHOD		= 2022		; Compression Method not supported
LHAE_WRITE		= 2023		; Error creating/writing File
LHAE_CRC		= 2024		; CRC error
LHAE_CALLBACK		= 2025		; Callbackroutine returned LHAN_STOP
LHAE_NOTANARCHIV        = 2026		; Not an LHA-Archiv


;------------- Callback-Notification-Codes -----
LHAN_OK			= 0		; Nothing special
LHAN_IGNOREFILE		= 1		; Used with LHAM_NEXTFILE : Irgnore this File
LHAN_STOP		= 2		; Used with LHAM_PEEK     : Stop Decompression of Archive immediatly

;------------- Callback Messages ---------------
LHAM_PEEK		= 1		; Nothing special
LHAM_NEXTFILE		= 2		; Start processing next File

;------------- __llseek-Flags -------------------
SEEK_SET		= 0
SEEK_CUR		= 1
SEEK_END		= 2


_TEXT   SEGMENT DWORD USE32 PUBLIC 'CODE'
        ASSUME  CS:FLAT, DS:FLAT, ES:FLAT, SS:NOTHING, FS:NOTHING, GS:NOTHING


;_TEXT	segment byte public 'CODE'
;_TEXT	ends

;		assume	cs:_TEXT, ds:Nothing

CRC16			equ		0a001h
BufSiz			equ		04000h

NC			=		(200h - 2)
NP			=		14
NT			=		19
NPT			=		080h

CBIT		=		9
PBIT		=		4
TBIT		=		5

DSIZ		=		2000h
DSIZ2		=		DSIZ * 2

LzHead	struc
		HeadSiz  db		?
		HeadChk  db		?
		HeadID	 db		3 dup (?)
		Method	 db		?
			 db		?
		PacSiz	 dd		?
		OrgSiz	 dd		?
		FTime	 dw		?
		FDate	 dw		?
		FAttr	 dw		?
		FnLen	 db		?
		Fname	 db		80h dup (?)
		FileSize dd		?		; File Size when Ready
LzHead	ends

;_BSS	segment public
_BSS	segment at 0h

text_			db		DSIZ2 dup (?)
inpbuf			db		BufSiz dup (?)
crctbl			dw		100h dup (?)
cpyhdr			LzHead	1 dup (<?>)
FullName		db		100h dup (?)		; Full Pathname of dest. File
dummy			db 		256 dup (?)		; OFSTRUCT fr OpenFile
inpptr			dd		1 dup (?)
infile			dd		1 dup (?)		; File Handle of input File
outfile			dd		1 dup (?)
orgcrc			dw		1 dup (?)
curcrc			dw		1 dup (?)
blocksize_		dd		1 dup (?)

len_cnt			dd		17 dup (?)
start			dd		17 dup (?)
weight			dd		17 dup (?)

cmethod			db		?			; Compression Method
PeekP			dd		?			; Callback-Procedure of Application
PeekDS			dd		?			; Data Segment of Application
PeekResult		dd		?			; Result of Callback-Routine

attrlen			dw 		?			; Attribute Header Size

public	len_cnt
public	start
public	weight


left_			dw		2 * NC - 1 dup (?)
right_			dw		2 * NC - 1 dup (?)

c_table_		dw		4096 dup (?)
pt_table_		dw		256 dup (?)
c_len_			db		NC dup (?)
pt_len_			db		NPT dup (?)

public	left_
public	right_
public	c_table_
public	pt_table_
public	c_len_
public	pt_len_

bitbuf_			dw		1 dup (?)
subbitbuf_		db		1 dup (?)
bitcount_		db		1 dup (?)

myname			db		80h dup (?)
fnnext			dw		1 dup (?)
fnptr			dd		1 dup (?)
swchar			db		1 dup (?)

_BSS			ends

;_TEXT	segment byte public 'CODE'

;		assume	cs:_TEXT

PeekProc   equ DWORD PTR ss:[EBP+20]
Options    equ  WORD PTR ss:[EBP+16]
DestPath   equ DWORD PTR ss:[EBP+12]
ArchivName equ DWORD PTR ss:[EBP+8]




OverWtText	db "Diese Datei existiert bereits. Soll sie ueberschrieben werden", 0
broken		db 'Archiv zerstoert ', 0

		public _LHAExpand@16
		stdProc _LHAExpand,4

;_LHAExpand@16	Proc

		cld			; Clear Direction Flag once
 		Push Ebp			; Save old Ebp-Value
 		Mov  Ebp,ESp            ; Make Procedure Parameters Adressable

		Push ESi
		Push EDi
		Push EBx

		Mov EAx, PeekProc	; Store Applications Callback Routine
                Mov PeekP, EAx

		Call OpenInput		; Try to open Input File
		Jc ReturnError		; -> Input File not found

		Call GetHeader		; Read Archiv Header
		Jc ReturnError		; -> Broken File

		Call MakeCRC		; Prepare CRC-Table

FilesLoop:		Call GetFHeader		; Read in File Header
			Jc ReturnError
			Je EndArchiv		; -> End of Archiv reached

			Call Extract		; Extract File Data
			Jc ReturnError

		Jmp short FilesLoop	; -> MainLoop, next File

;------ Regular End of Archiv reached, No Error -----------------
EndArchiv:      Mov EAx, Word Ptr ArchivName+2	; Get HIghByte to Test for Zero
		or EAx, EAx
		je NoClose			; Version 1.3 : don't close Files automatically

		   stdCall __lclose , InFile	; Close output File

   NoClose:	Xor EAx,EAx		; Return Value

;------ Jump here, if Error occured during Decompression --------
ReturnError:	Pop EBx
		Pop EDi
		Pop ESi

		Pop Ebp
		StdRet _LHAExpand

_LHAExpand@16	EndP


;/- OpenInput -------------------------------\
;| Try to open the Archive Input File        |
;| returns Errorcode and Carry set on Error  |
;\-------------------------------------------/
OpenInput	Proc Near

		; Version 1.3: If HIWORD of Pointer to the Filename equals zero, the LOWORD is the File-Handle itself!

;		Mov EAx, ArchivName		; Get HIghByte to Test for Zero
;		or EAx, EAx
;		Mov EAx, Word Ptr ArchivName	; Get LoByte to use as Handle
;		je UseAsHandle

		   Xor EAx,EAx			; Mov EAx, OF_READ
;		   Call __lopen PASCAL , ArchivName, EAx
		   stdCall _OpenFile ,<ArchivName , offset dummy , OF_READ>

   UseAsHandle:	Mov  InFile, EAx			; return File Handle

		Inc EAx
		Jne OpenInOk			; -> No Error Occured

			Stc				; Set Carry Flag
			Mov EAx,LHAE_ARCHIVNOTFOUND	; Errorcode : Archiv not found

OpenInOk:	Ret

OpenInput	EndP



;/- GetHeader -------------------------------\
;| Read Archive File Header                  |
;| 1. Find start of Archiv                   |
;| 2. Position File to Archiv Header         |
;\-------------------------------------------/
GetHeader	Proc near

		stdCall __lread, <InFile, offset inpbuf , BufSiz>

		Mov ECx, EAx		; Count of Bytes read

		Inc EAx
		Je GetHdErr		; -> Error in __lread

;		Search for start of Archive Header, so EXE-Archives may be
;		decompressed
		mov		esi, offset inpbuf

GetHdSearch:		Cmp  word ptr [esi],'l-'
			Jne  GetHdNxt
			Cmp  Byte ptr [esi+4],'-'
			Je   GetHdFnd

GetHdNxt:		Inc  esi
			Loop GetHdSearch
		Jmp  GetHdErr			; -> Broken Archiv Error

GetHdFnd:       ; Sub  esi, (offset inpbuf + 2)
		; Call __llseek PASCAL , InFile, 0 esi , 0   ; DOS-Function: Seek in File to Position ECx:Edx Handle EBx

		; Changed in Version 1.3: Use relative File-Adressing
		Mov EAx, -2
		Sub EAx, ECx
		stdCall __llseek , <InFile, EAx , SEEK_CUR>   ; DOS-Function: Seek in File to Relative Position ECx:Edx Handle EBx

		Clc
		Inc EAx
		Jne GetHdEnd			; -> if File is OK

GetHdErr:       Stc
		Mov EAx, LHAE_NOTANARCHIV	; Not an LHA-Archiv
;		Mov EAx, LHAE_BROKEN		; Broken Archiv

GetHdEnd:	Ret

GetHeader	EndP


;/- MakeCRC ---------------------------------\
;| Prepare CRC Table                         |
;\-------------------------------------------/
MakeCRC		Proc Near

		mov		EDi, offset crctbl
		xor		Edx, Edx
MakeCRCOuter:
			mov		EAx, Edx
			mov		ECx, 8
MakeCRCInner:
				shr		EAx, 1
				jnc		MakeCRCXor
					xor		EAx, CRC16
MakeCRCXor:
			Loop MakeCrcInner

			stosw
			inc dl
		jne MakeCRCOuter

		Ret

MakeCrc		EndP


;/- GetFHeader ------------------------------\
;| Read Archive File Header                  |
;| 1. Read Header Length Byte		     |
;| 2. Read rest of File Header               |
;| 3. Test Header Checksum		     |
;\-------------------------------------------/
GetFHeader	Proc near

; Get Header ---------------------------
		stdCall __lread , <InFile, offset cpyhdr.HeadSiz, 1>
		Dec Al                  ; Had to read exactly one Byte
		Jne GetFEnd		; -> if error or End of File

		Mov Al, cpyhdr.HeadSiz
		Xor Ah, Ah
		Or  Al, al
		Je  GetFEnd		; -> End of File

		Inc Al
		stdCall __lread , <InFile, offset cpyhdr.HeadSiz+1, EAx>
		Inc EAx
		Je  GetFErr		; -> if error

; Test Header Sum ----------------------
			Mov		esi, offset cpyhdr.HeadSiz
                        Xor		ECx, ECx
			Mov		Cl, Byte Ptr [esi]
			Inc		esi
			LodsB					; Load Header Checksum
			Inc		Cl
;			Dec		Cl
;			Dec		Cl

			Dec		esi
TestHead:               Inc		esi
			sub		al, [esi]
			Loop		TestHead

			Jne		GetFErr

		Mov EAx, CpyHdr.OrgSiz		; Get Size of Original File
		Mov CpyHdr.FileSize, EAx
		Inc EAx
		Jmp short GetFEnd

GetFErr:	Stc
		Mov EAx,LHAE_BROKEN
		Or EAx,EAx

GetFEnd:	Ret

GetFHeader	EndP


;/- MakeFullName ----------------------------\
;| Combine Pathname and Filename             |
;\-------------------------------------------/
MakeFullName	Proc Near

		stdCall _lstrcpy, <offset FullName , DestPath>
		stdCall _lstrcat, <offset FullName , offset cpyhdr.FName>

		ret

MakeFullName	EndP



;/- Extract ---------------------------------\
;| Extract File from Archive                 |
;| 1. Test Header ID         		     |
;| 2. Get original CRC                       |
;| 3. Test for existing File		     |
;\-------------------------------------------/
Extract		Proc


		Mov	esi, offset CpyHdr.HeadId	; Prepare Header Adress in esi ----------

		Call	TestHeader			; Test Header
		Jc	ExtractEnd			; -> if Errornous Header or Method not supported

		Call	GetOrgCrc			; Get Original CRC

		Call MakeFullName			; Make Full Filename from PathName and Header

; Test Special File ? ------------------
;			cmp		ECx, 2101h				; 01h, '!'

;			Jne		NotMn7

;				mov		EAx, 1
;				jmp		StartDecode

;NotMn7:
; Display File name --------------------
;			mov		word ptr [EBx], 0 * 256 + ' '
;			mov		EBx, Edx
;			call	disp					; output file name
;			mov		byte ptr [EBx - 1], 0

;			jcxz	mn9						; !.BAT ?

; Check Existence of File --------------
			Call 		CheckOverwrite			; Test if File exists, Overwrite if neccessarry
			Je		ExtractEnd

; Overwrite ? --------------------------
;			mov		EBx, offset overwt	; prompt
;			call	mesout
;			call	getyn
;			je		CreateNewFile

;mn9:
;			mov		cs:autoflg, 0dh

; Create a New File --------------------
			Call CreateTheFile			; Create New Output File
			Jc   ExtractErr				; -> if Error

;			mov		ECx, 0020h
;			mov		ah, 3ch
;			int		21h					; Create a File
;			Jc		ExtractErrWrite

; Decode -------------------------------
			xor		EAx, EAx
			mov		curcrc, Ax
			dec		EAx
			mov		inpptr, EAx

			push	Edx
;			or Ebp,Ebp
			test cMethod, 0ffh
			Push Ebp
			jz Method0

				call	decode
			Jmp	Short AfterDecode

Method0:			call	copyall		; File only stored, Copy all

AfterDecode:            pop		Ebp
			pop		esi
			Jc	ExtractErrWrite		; Jump if Error mark set

			Call TimeStamp			; Set File Time and Date

			stdCall __lclose , OutFile	; Close output File
;			call	close

; Check CRC ----------------------------
			mov		Ax, curcrc
			cmp		Ax, orgcrc
			Mov		EAx, LHAE_CRC
			jne		ExtractErr

			call	setattr			; Set File attributes
			Or Al,Al			; Reset Carry
			Jmp ExtractEnd


;			jmp		mn6
;mn8:
;			call	getyn
;			jne		exit1
;mn6:
;		Jmp	MainLoop		; -> Process next File of Archive

;		mov		EBx, infile	; ???????????????????
;		call	close

;		public	exit
;exit:
;		call	@autoexec

;		public	_autoexec
;_autoexec:
;exit1:
;		xor		al, al
;exit2:
;		mov		ah, 4ch
;		int		21h

ExtractErrWrite:        Push EAx			; Save Error Code
				stdCall __lclose  , outfile
				stdCall _OpenFile ,<offset FullName , offset dummy , OF_DELETE>
			Pop  EAx			; Retrieve Error Code
			Jmp  Short ExtractEnd
ExtractErrCreate:      	Mov EAx, LHAE_WRITE
ExtractErr:		Stc
ExtractEnd:		Ret

Extract		EndP



;/- TestHeader ------------------------------\
;| Test Header and extract ID                |
;\-------------------------------------------/
TestHeader	Proc near

		lodsw
		cmp EAx, 'l-'
		Jne TestHdErr		; -> Broken File

			lodsw		; Get Compression Method
			xchg	al, ah
			sub		EAx, 'h0'
			mov		cMethod, al	; Store Compression Method
			je		NoErrMth	; -> if Method is OK
			sub		EAx, 4
			je		NoErrMth	; -> if Method is OK
			dec		EAx
			jne		ErrMth		; -> if Method is not OK

NoErrMth:		lodsb
			sub al, '-'
			je		TestHdEnd

; Error in Header
TestHdErr:	Stc
		Mov EAx, LHAE_BROKEN
		Jmp short TestHdEnd

; Compression Method not supported -----
ErrMth:		Stc
		Mov EAx, LHAE_METHOD

TestHdEnd:	ret

TestHeader	EndP


;/- GetOrgCrc -------------------------------\
;| Get Original CRC -> ORGCRC                |
;\-------------------------------------------/
GetOrgCrc		Proc near

			mov		EBx, offset cpyhdr.Fname
			mov		EDx, EBx
			Sub		ECx, ECx		; Upper 24 Bit = Zero
			mov		 Cl, [EBx - 1]		; Lower  8 Bit = Length
			add		EBx, ECx		; Compute Address of Original CRC

			Sub		Ax, Ax
			xchg	Ax, [EBx]			; EAx = 0, [EBx] = CRC
			mov		orgcrc, Ax
			mov		fnptr, Edx		; Pointer to the FileName

			Mov     Ax, [EBx+3]			; Get Attribute Header Size
			Mov	AttrLen, Ax			; Store attribute Header Size

			Ret

GetOrgCrc		EndP

;/- CheckOverwrite --------------------------\
;| Check, if file should be Overwritten,     |
;| ask User if neccessary    		     |
;\-------------------------------------------/
CheckOverwrite		Proc near

			Mov   EAx, LHAM_NEXTFILE				; Ask Applications Callback Routine
			Call  AppCallBack
			Mov   EAx, PeekResult
			Cmp   EAx, LHAN_IGNOREFILE			; Skip This File ?
			Je    SkipThisFile				; -> if File not wanted
			Cmp   EAx, LHAN_STOP				; End Decompression immediatly
			Mov   EAx, LHAE_CALLBACK
			Stc
			Je    CheckOverEnd

			Test		Options, LHA_OVERWRITE		; If this Flag not set, ask before overwriting
			Jne		CreateNewFile			; -> Create File, do not Ask

				stdCall _OpenFile , <Edx , offset dummy , OF_EXIST>
				Inc EAx					; Test File existence
				Je	CreateNewFile			; -> Create File, do not Ask

					Call OverWtMessage		; Ask User, if File should be overwritten

					je	CreateNewFile		; -> Create New FIle

SkipThisFile:				Call SkipThis			; Skip File Data
					Xor EAx, EAx			; Give Return Code
					Jmp Short CheckOverEnd

CreateNewFile:		Inc EAx

CheckOverEnd:		Ret

CheckOverwrite		EndP

;			mov		EAx, 4300h				; get file attr
;			int		21h						;	(for MS-DOS 3.3)
;			jc		CreateNewFile
;			Jmp CreateNewFile


;/- OverWtMessage ---------------------------\
;| Ask User, if File should be overwritten   |
;\-------------------------------------------/
OverWtMessage		Proc near

			StdCall _GetFocus

			stdCall _MessageBoxA , <EAx , offset OverWtText , offset FullName , MB_YESNO OR MB_ICONQUESTION>
			Cmp  EAx, IDYES

			Ret

OverWtMessage		EndP



;/- SkipThis --------------------------------\
;| Skip File Data to next File               |
;\-------------------------------------------/
SkipThis		Proc near

			stdCall __llseek ,< InFile , CpyHdr.PacSiz , SEEK_CUR>

			Ret

;			mov		Edx, cpyhdr.PacSiz		; skip file
;			mov		ECx, cpyhdr.PacSiz + 2

;			mov		EBx, infile
;			mov		EAx, 4201h 			; seek to relative position
;			int		21h					; Move a File Pointer
;			jmp		mn6

SkipThis		EndP


;/- TimeStamp -------------------------------\
;| 1. Set output File Time and Date          |
;\-------------------------------------------/
TimeStamp		Proc Near

			mov		EBx, outfile			; Currently nt supported
;			cmp		EBx, 1					; file '!' ?
;			je		mn8

;		mov		Edx, cpyhdr.FDate
;		mov		ECx, cpyhdr.FTime
;		mov		EAx, 5701h				; set date
;		int		21h

			ret

TimeStamp		EndP

;/- CreateTheFile ---------------------------\
;| Create a new File and Store Handle	     |
;\-------------------------------------------/
CreateTheFile		Proc Near

			stdCall _OpenFile , <offset FullName , offset dummy , OF_CREATE OR OF_WRITE>
			Inc EAx
			Jne NewFileOk		; If File Creation successfull
			  Mov EAx,LHAE_WRITE
			  Stc
                          Jmp short NewFileEnd	
NewFileOk:		Dec EAx
			mov		outfile, EAx		; Store new file handle
newFileEnd:		Ret


CreateTheFile		EndP


;/- SetAttr ---------------------------------\
;| 2. Set File attributes		     |
;\-------------------------------------------/
SetAttr		Proc near

; Set File Attributes ------------------
		Test Options, LHA_ATTRIB		; Set File attributes ?
		Je  NoSetAttr

			mov		Edx, offset FullName
			mov		cl, byte ptr cpyhdr.FAttr
			xor		ch, ch
			mov		EAx, 4301h
			int		21h				; Set File Attributes

NoSetAttr:	ret

SetAttr		EndP


;/- AppCallback ------------------------------\
;| Execute Applications Callback-Function Once|
;\--------------------------------------------/
AppCallback	Proc near

		Push EBx

		Mov  PeekResult, 0

		Mov  EBx, PeekP
		Or   EBx, EBx
		Je   AppCallEnd

		PushA
		Call PeekP

		Mov  PeekResult, EAx	; Result of Callback-Routine

		PopA

AppCallEnd:     Pop EBx
		ret


AppCallback	EndP



;-----------------------------------------------
;		Output Error Text
;-----------------------------------------------

brokenerr:      stdCall _GetFocus

		stdCall _MessageBoxA  , <EAx , offset broken, offset FullName , MB_OK OR MB_ICONHAND>
		mov		al, 1
		mov		ah, 4ch	; Immediatly exit Program via DOS
		int		21h

;-----------------------------------------------
;		obt@̏o
;-----------------------------------------------
putbuf	proc	near
	xor		Edx, Edx	;	mov		Edx, offset text_
	mov		ECx, EDi
	sub		ECx, Edx
putbuf2:
;	jcxz	return
	jcxz	Egal		;>
	Jmp Egal2               ;>
Egal:	Jmp return              ;>
Egal2:                          ;>

	stdCall __lwrite  , <outfile , Edx , ECx>
	Sub  EAx, ECx			; Test successfull write
	Jne  PutErr			; -> Error in PutBuf
;	mov		EBx, outfile
;	mov		ah, 40h
;	int		21h
;	$_if <sub EAx, ECx>, NE
;SUB EAx, ECx
;jNE $_133
;jmp $_132
;$_133:
;		cmp		EBx, 1
;		jne		errwrite
;	$_endif
;$_132:
calccrc:
	mov		esi, Edx
        Sub		EBx, EBx
	mov		Bx, curcrc
;	xor		ah, ah						; ah = 0
;	cld
$_134:
		lodsb
		xor		bl, al
		mov		al, bh
		mov		bh, ah
		shl		EBx, 1
		mov		Bx, crctbl[EBx]				; Kritisch...
		and		EBx, 00000FFFFH
		xor		EBx, EAx
;	$_until <LOOP>
;	$_until <LOOP>
LOOP $_134
	mov		curcrc, Bx
	mov		EDi, Edx

;	cmp		outfile, 1
;	je		return
;	mov		ah, 02h
;	mov		dl, '.'
;	jmp		short int21_ret					; int	21h
	ret

PutErr:	Stc
	Mov EAx, LHAE_WRITE
	ret

putbuf	endp

;-----------------------------------------------
;		Copy File Data, no compression
;-----------------------------------------------
		public	copyall
copyall proc	near
		xor		EDi, EDi

CopyLoop:			mov		EBx, offset cpyhdr.OrgSiz
				sub		[EBx], EDi
				sbb		word ptr 2[EBx], 0
				mov		ECx, DSIZ2

				Jnz		$_136
						mov		EAx, [EBx]
						or		EAx, EAx
						jz		cpyend
				cmp EAx,ECx
				jnb		$_136

						mov		ECx, EAx
$_136:

				mov		Edx, offset text_
				mov		EBx, infile
				mov		ah, 3fh
				int		21h
				push	ECx
				call	putbuf2
				pop		EDi
				Jc	cpyend		;-> if Error writing output File
		Jmp CopyLoop
cpyend:
		ret
copyall endp


;-----------------------------------------------
;		Delete incomplete Files
;-----------------------------------------------
		public	unlink
unlink	proc	near

		mov		Edx, fnptr
		mov		ah, 41h							; unlink
		int		21h
return:
		ret
unlink	endp




;-----------------------------------------------
;		getc
;			EAx: 1 byte (return)
;-----------------------------------------------
		public	getc
getc	proc	near
		mov		EBx, inpptr
		cmp 		EBx, offset inpbuf + BufSiz
		jnae		NoBufEmpty		; -> if buffer not empty now

	;-----------------------------------------------
	;		buffer 
	;-----------------------------------------------
			public	getbuf
	getbuf	proc	near
			push	ECx
			push	Edx
			mov		Edx, offset inpbuf
			mov		ECx, BufSiz
			mov		EBx, offset cpyhdr.PacSiz
			sub		[EBx], ECx
			sbb		word ptr 2[EBx], 0
			Jnc   MoreThanOneBlock
				add		ECx, [EBx]	; If there is only one Data Block left
MoreThanOneBlock:
			stdCall __lread , <InFile, offset inpbuf , ECx>

			mov		EBx, offset inpbuf
			pop		Edx
			pop		ECx
	getbuf	endp
	;-----------------------------------------------
NoBufEmpty:
		mov		al, [EBx]
		inc		EBx
		mov		inpptr, EBx
		ret
getc	endp


;-----------------------------------------------
;		extract routines
;-----------------------------------------------
		public	decode
decode proc	near
	xor		EAx, EAx
	mov		blocksize_, EAx
	mov		bitbuf_   , Ax
	mov		subbitbuf_, al
	mov		bitcount_ , al


	Sub   Cx, Cx
	Mov   Cx,AttrLen
	Add   ECx, ECx

	;------------ Ignore Bytes that are added depending on attributes (Don't know why ...)
attrlp:	  jcxz  attrend
	  Mov Al,16
          Call getc
	  Loop attrlp
attrend:


	mov		al,16
	call	fillbuf_			; Make 16 Bit available in bitbuf

	mov		EDi, offset text_	; Destination Data Adress
	jmp		$entry

$loop:
		Mov	EAx,LHAM_PEEK		; Command : Nothing special
		Call	AppCallback		; Execute Applications Callback-Routine
		Cmp	PeekResult, LHAN_STOP	; Test: Callback-Routine wants to stop Immediatly?
		Je	StopDecomp

		call	decode_c_st1_
		or	ah, ah
		Jnz	ElseDecode

			stosb
			cmp EDi, offset text_[DSIZ2]
			Jne $entry
				call	putbuf	; Store Buffer in Output File
				Jc	DecodeEndErr	; -> If Error 
$entry:
			sub		word ptr cpyhdr.OrgSiz, 1
			jnc		$loop
		Jmp $_144
ElseDecode:
			mov		ECx, EAx
			sub		ECx, 100h - 3
			call	decode_p_st1_
			mov		esi, EDi
			stc
			sbb		esi, EAx
			push	ECx
$_148:
				and		esi, DSIZ2 - 1
				movsb
				test	EDi, DSIZ2
				Jz      $_150

					push	ECx
					push	esi
					call	putbuf
					pop		esi
					pop		ECx
					Jc	DecodeEndPop
$_150:
			Loop $_148

			pop		ECx
			sub		word ptr cpyhdr.OrgSiz, Cx
			jnc		$loop
;		$_endif
$_144:
		sbb		word ptr cpyhdr.OrgSiz + 2, 0
		jnc		$loop
	$endloop:
	call		putbuf
	Jmp short DecodeEnd

StopDecomp:	Stc		;Mark Error
		Mov EAx, LHAE_CALLBACK
		Jmp short DecodeEnd

DecodeEndPop:	pop ECx
DecodeEndErr:	Mov EAx,LHAE_WRITE
DecodeEnd:	ret

decode endp


;	static void read_pt_len(short nn, short nbit, short i_special)
;public	read_pt_len_
read_pt_len_	proc	near
	push	esi
	mov		al, dl
	call	getbits_
;	$_if <cmp EAx, esi>, A
CMP EAx, esi
jA $_153
jmp $_152
$_153:
		jmp		brokenerr
;	$_endif
$_152:
	mov		EDi, offset pt_len_
;	$_if <or EAx, EAx>, Z
OR EAx, EAx
jZ $_155
jmp ElseRead
$_155:
		pop		ECx
		rep		stosb
		mov		al, dl
		call	getbits_
		mov		ECx, 256
		mov		EDi, offset pt_table_
		rep		stosw
		ret
;	$_else
ElseRead:	mov		Edx, ECx			; dl = i_special
		add		Edx, EDi
		mov		esi, EDi
		add		esi, EAx			; EAx = n
$_156:
			mov		al, 3
			call	getbits_
;			$_if <cmp al, 7>, E
CMP AL, 7
jE $_159
jmp $_158
$_159:
				mov		Bx, bitbuf_
				And		EBx, 0ffffH
WhileRead:			shl EBx,1
				jnc EndWhileRead
					inc		EAx
					Jmp short WhileRead
EndWhileRead:			push	EAx
				sub		al, 6
				call	fillbuf_
				pop		EAx
;			$_endif
$_158:
			stosb
;			$_if <cmp EDi, Edx>, E
CMP EDi, Edx
jE $_161
jmp $_160
$_161:
				mov		al, 2
				call	getbits_
				mov		ECx, EAx
				xor		al, al
				rep		stosb
;			$_endif
$_160:
;		$_until <cmp EDi, esi>, AE
;		$_until <cmp EDi, esi>, AE
CMP EDi, esi
jAE $_157
jmp $_156
$_157:
		pop		esi						; nn
		mov		Ebp, offset pt_len_
		lea		ECx, [Ebp + esi]	;	lea		ECx, pt_len_[esi]
		sub		ECx, EDi
		xor		al, al
		rep		stosb
		mov		EAx, esi
		mov		ECx, 8
		mov		EDi, offset pt_table_
		jmp		make_table_
;	$_endif
$_154:
read_pt_len_	endp

;	static void read_c_len(void)
;public	read_c_len_
read_c_len_	proc	near
	mov		al, CBIT
	call	getbits_
;	$_if <cmp EAx, NC>, A
CMP EAx, NC
jA $_163
jmp $_162
$_163:
		jmp		brokenerr
;	$_endif
$_162:
	mov		EDi, offset c_len_
;	$_if <or EAx, EAx>, Z
OR EAx, EAx
jZ $_165
jmp ElseLen
$_165:
		mov		ECx, NC
		rep		stosb
		mov		al, CBIT
		call	getbits_
		mov		ECx, 4096
		mov		EDi, offset c_table_
		rep		stosw
		ret
;	$_else
ElseLen:	mov		Edx, EDi
		add		Edx, EAx			; EAx = n
		push	EDi
$_166:
			mov		Ax, bitbuf_
			And		EAx, 0ffffh
			mov		bl, ah
			xor		bh, bh
			shl		EBx, 1
			mov		Bx, pt_table_[EBx]
			And		EBx, 0ffffh

			mov		esi, offset read_c_len_1
			mov		ECx, NT
			jmp		tree1

if 0
			$_while <cmp EBx, NT>, AE
;				$_if <shl al, 1>, C
SHL AL, 1
jC $_169
jmp $_168
$_169:
					mov		EBx, right_[EBx]
				$_else
					mov		EBx, left_[EBx]
;				$_endif
$_168:
			$_enddo
endif

read_c_len_1:
			push	EBx
			mov		al, pt_len_[EBx]
			call	fillbuf_
			pop		EAx
;			$_if <sub EAx, 2>, BE
SUB EAx, 2
jBE $_171
jmp ElseLen4
$_171:
;				$_if , Z

jZ $_173
jmp ElseLen2
$_173:
					mov		al, CBIT
					call	getbits_
					add		EAx, 20
					mov		ECx, EAx
					Jmp		$_172
;				$_else
ElseLen2:
;					$_if <inc EAx>, Z
INC EAx
jZ $_175
jmp ElseLen3
$_175:
						mov		al, 4
						call	getbits_
						add		EAx, 3
						mov		ECx, EAx
						Jmp		$_174
;					$_else
ElseLen3:						mov		ECx, 1
;					$_endif
$_174:
;				$_endif
$_172:
				xor		al, al
				rep		stosb
				Jmp		$_170
;			$_else
ElseLen4:				stosb
;			$_endif
$_170:
;		$_until <cmp EDi, Edx>, AE
;		$_until <cmp EDi, Edx>, AE
CMP EDi, Edx
jAE $_167
jmp $_166
$_167:
		mov		ECx, offset c_len_ + NC
		sub		ECx, EDi
		xor		al, al
		rep		stosb
		mov		EAx, NC
		pop		Ebp
		mov		ECx, 12
		mov		EDi, offset c_table_
		jmp		make_table_
;	$_endif
$_164:
read_c_len_	endp

;	ushort decode_c_st1(void)
decode_c	proc	near
;	not entry here
decode_c_st1_2:
	push	EDi
	mov		al, 16
	call	getbits_
	dec		EAx
	mov		blocksize_, EAx
	mov		esi, NT
	mov		dl, TBIT
	mov		ECx, 3
	call	read_pt_len_
	call	read_c_len_
	mov		esi, NP
	mov		dl, PBIT
	mov		ECx, -1
	call	read_pt_len_
	pop		EDi
	jmp		decode_c_st1_3
;
;	entry here
;
public	decode_c_st1_
decode_c_st1_:
	sub		blocksize_, 1
	jc		decode_c_st1_2
decode_c_st1_3:
	mov		Bx, bitbuf_
	And		EBx, 0ffffh
	mov		cl, 4
	shr		EBx, cl
	shl		EBx, 1
	mov		Bx, c_table_[EBx]
	And		EBx, 0ffffh
;	$_if	<cmp EBx, NC>, B
CMP EBx, NC
jB $_177
jmp $_176
$_177:
decode_c_st1_1:
		push	EBx
		mov		al, c_len_[EBx]
		call	fillbuf_
		pop		EAx
		ret
;	$_endif
$_176:
	mov		Ax, bitbuf_
	And		Eax, 0ffffh
	shl		al, cl
	mov		esi, offset decode_c_st1_1
	mov		ECx, NC
tree0:
$_178:
;		$_if <shl al, 1>, C
SHL AL, 1
jC $_181
jmp ElseDec1
$_181:
			mov		Bx, right_[EBx]
			Jmp $_180
;		$_else
ElseDec1:		mov		Bx, left_[EBx]
;		$_endif
$_180:
			And		EBx, 0ffffh
tree1:
;	$_until <cmp EBx, ECx>, B
;	$_until <cmp EBx, ECx>, B
CMP EBx, ECx
jB $_179
jmp $_178
$_179:
	jmp		esi
decode_c	endp

;	ushort decode_p_st1(void)
public	decode_p_st1_
decode_p_st1_	proc	near
;---------------------------------------------------------------
;	ushort decode_p_st1(void)
;---------------------------------------------------------------
	push	ECx
	xor		bh, bh
	mov		bl, byte ptr bitbuf_ + 1
	shl		EBx, 1
	mov		Bx, pt_table_[EBx]
	And		EBx, 0ffffh
;	$_if	<cmp EBx, NP>, B
CMP EBx, NP
jB $_183
jmp $_182
$_183:
decode_p_st1_1:
		push	EBx
		mov		al, pt_len_[EBx]
		call	fillbuf_
		pop		EAx
;		$_if <cmp al, 1>, A
CMP AL, 1
jA $_185
jmp $_184
$_185:
			dec		EAx
			mov		ECx, EAx
			call	getbits_
			mov		EBx, 1
			shl		EBx, cl
			or		EAx, EBx
;		$_endif
$_184:
		pop		ECx
		ret
;	$_endif
$_182:
	mov		al, byte ptr bitbuf_
	mov		esi, offset decode_p_st1_1
	mov		ECx, NP
	jmp		tree0

if 0
$_186:
;		$_if <shl al, 1>, C
SHL AL, 1
jC $_189
jmp $_188
$_189:
			mov		EBx, right_[EBx]
		$_else
			mov		EBx, left_[EBx]
;		$_endif
$_188:
;	$_until <cmp EBx, NP>, B
;	$_until <cmp EBx, NP>, B
CMP EBx, NP
jB $_187
jmp $_186
$_187:
	jmp		decode_p_st1_1
endif
decode_p_st1_	endp


;---------------------------------------------------------------
;	void make_table(short nchar, uchar bitlen[],
;	                         EAx            Ebp
;					short tablebits, ushort _table[])
;	                             ECx            EDi
;---------------------------------------------------------------
_BSS	segment ;at 000h ; para public 'BSS'
;	org 0h
;_BSS	segment para public 'BSS'
avail_mt		dw		1 dup (?)
nchar			dw		1 dup (?)
bitlen			dw		1 dup (?)
tablebits		dw		1 dup (?)
_table			dd		1 dup (?)
restbits		db		1 dup (?)

public	avail_mt
public	nchar
public	bitlen
public	tablebits
public	_table
public	restbits
_BSS	ends

	public	make_table_
make_table_	proc	near
	mov		nchar, Ax
	shl		EAx, 1
	mov		avail_mt, Ax
	mov		tablebits, Cx
	mov		_table, EDi
	mov		al, 16
	sub		al, cl
	mov		restbits, al

	mov		EAx, 1
	shl		EAx, cl
	mov		ECx, EAx
	xor		EAx, EAx
	rep		stosw

	xor		esi, esi
	mov		EBx, 8000h
	mov		Edx, 1
$_190:
		mov		EDi, Ebp
		mov		Cx, nchar
		And		ECx, 0ffffh
$_192:
			mov		al, dl
			repne	scasb
			jne		mt1
			mov		EAx, EDi
			sub		EAx, Ebp
			dec		EAx
			push	ECx
			push	EDi
;			; EBx = weight
;			; esi = code
;			; Edx = len
			mov		cl, restbits
			mov		EDi, esi
			shr		EDi, cl
			shl		EDi, 1
			add		EDi, _table
			push	EBx
;			$_if <cmp Edx, tablebits>, BE
CMP dx, TABLEBITS
jBE $_195
jmp ElseTab1
$_195:
				shr		EBx, cl
				mov		ECx, EBx
				rep		stosw
				Jmp		$_194
;			$_else
;		/*  n  tree  */
;				; EDi = taddr
;				; esi =
;				; ECx =
;				; EAx = char
ElseTab1:			push	esi
				mov		Cx, tablebits
				shl		esi, cl
				neg		ECx
				add		ECx, Edx
$_196:
;					$_if <cmp word ptr [EDi], 0>, E
CMP WORD PTR [EDi], 0
jE $_199
jmp $_198
$_199:
;				/* }܂тĂȂ΍ */
						mov		Bx, avail_mt
						And		EBx, 0ffffh
						mov		right_[EBx], 0
						mov		left_[EBx], 0
						mov		[EDi], EBx
						add		avail_mt, 2
;					$_endif
$_198:
					mov		EDi, [EDi]
;					$_if <shl esi, 1>, C
SHL esi, 1
jC $_201
jmp ElseTab2
$_201:
						add		EDi, offset right_
;					$_else
						Jmp $_200
ElseTab2:					add		EDi, offset left_
;					$_endif
$_200:
;				$_until <LOOP>
;				$_until <LOOP>
LOOP $_196
				mov		[EDi], EAx
				pop		esi
;			$_endif
$_194:
			pop		EBx
			pop		EDi
			pop		ECx
			add		esi, EBx
			jc		mt2
;		$_until <or ECx, ECx>, Z
;		$_until <or ECx, ECx>, Z
OR ECx, ECx
jZ $_193
jmp $_192
$_193:
mt1:
		inc		Edx
		shr		EBx, 1
;	$_until , C
;	$_until , C

jC $_191
jmp $_190
$_191:
public mt2
mt2:
	ret
make_table_	endp

;-----------------------------------------------
;		͂炎rbg𓾂
;-----------------------------------------------
;
;ushort getbits(uchar n)
;{
	public	getbits_
getbits_:		
	push	ECx
	mov		cl, 16
	sub		cl, al
	push	bitbuf_
	call	fillbuf_
	pop		EAx
	shr		EAx, cl
	pop		ECx
	ret

;
;void fillbuf(uchar n)  /* Shift bitbuf n bits left, read n bits */
;{

;/- Fillbuf --------------------------------------------------------------\
;| read in AL Bits from input File into BitBuf and SubBitBuf		  |
;\------------------------------------------------------------------------/
fillbuf_	proc near

	push	ECx
	push	Edx
	mov		ch, al
	mov		cl, bitcount_
	mov		dx, bitbuf_
	And		EDx, 0ffffh
	mov		al, subbitbuf_

	cmp		ch, cl		; Count of Bits wantet > Count of Bits stored ?
	Jna		NoFillNew	; -> If enough Bits available in bitbuf
	
		sub		ch, cl	; Compute count of bits to load
		shl		Edx, cl	; Rotate available Data to the left ??
		rol		al, cl	;                                   ??
		add		dl, al  ; Combine LSB/MSB                   ??
		mov		cl, 8	;
fb1:
		call	getc		; Get one Byte -> AL
		cmp	ch, cl		; Are there enough Bits available now ?
                Jna	EndFillLoop	; -> Enough bits available, don't add more

			sub		ch, cl	; Subtract count of bits read
			mov		dh, dl	; Shift in new Data Byte to DH:DL:AL
			mov		dl, al
	jmp		fb1			; -> Read in next Byte

EndFillLoop:
NoFillNew:                              ; DH:DL:AL contains Data Bits, CL=Bit position in DH, CH=Rest of bits read
	sub		cl, ch		; CL=New Bit Position in DH 
	mov		bitcount_, cl	; Store new bit position
	mov		cl, ch		; Count of Bits to shift away
	xor		ah, ah		
	shl		Edx, cl		; Shift Bits and combine them
	shl		EAx, cl
	add		dl, ah
	mov		bitbuf_, dx     ; Store new Bits
	mov		subbitbuf_, al	; Store LSB
	pop		Edx		; Restore Register Data
	pop		ECx
	ret

fillbuf_	endp


_TEXT	ends

_Bss	Segment
endBSS			label	byte
_Bss	EndS

		end
