with Text_IO,
     Text_Handler;

package Scanner is

  --
  --  provides the char-by-char file scanning to find
  --  each reserved word, keyword, or identifier
  --
  --         by John H. Heidema  (December, 1985)
  --
  --        ( with minor changes in October 1990 )

  procedure Get_Word
     ( F        : in     Text_IO.File_Type;  -- the file being searched
       ThisWord :    out Text_Handler.Text;  -- the word found, if any
       EOL      :    out Boolean;            -- reports jump to next line
       EOF      :    out Boolean );          -- signals end_of_file reached
    --
    -- does a char-by-char scan of the Ada source code file
    -- from the current file position until a reserved word,
    -- keyword, or Ada identifier is found.  Returns to caller
    -- at that point (or at EOL or EOF) with the word found (if any)
    --

end Scanner;

