package TEXT_HANDLER is

  --
  --  version of a string (text) processing package
  --  like that outlined in the Ada LRM (Section 7.6)
  --
  --    coding details by Michael B. Feldman
  --          with modifications by
  --     Steven Gutknecht and John Heidema
  --
  --
  --           Status:  Public Domain
  --


  MAXIMUM : constant INTEGER := 64;
  subtype INDEX is INTEGER range 0..MAXIMUM;

  type TEXT is private;    -- major usability problems when also "limited"

  STRING_OVERFLOW    : exception;
  INVALID_ARGUMENTS  : exception;


  -- Field Selection Routines:
  function LENGTH (T : in TEXT) return INDEX;
  function VALUE  (T : in TEXT) return STRING;
  function EMPTY  (T : in TEXT) return BOOLEAN;


  -- Conversion and Assignment Routines:
  function MAKETEXT(S : in STRING) return TEXT;
  function MAKETEXT(C : in CHARACTER) return TEXT;
  procedure CLEAR(T : in out TEXT);
  procedure COPY(DESTINATION : out TEXT;  SOURCE : in TEXT);


  -- Concatenation Routines:
  function "&" (T1, T2 : in TEXT) return TEXT;
  function "&" (T1 : in TEXT;  C : in CHARACTER) return TEXT;
  function "&" (C : in CHARACTER;  T1 : in TEXT) return TEXT;
  function "&" (T1 : in TEXT;  S : in STRING) return TEXT;
  function "&" (S : in STRING;  T1 : in TEXT) return TEXT;


  -- Boolean Comparison Routines:
  function Equal(T1, T2 : in TEXT) return BOOLEAN;  -- "=" not permitted
  function "<"  (T1, T2 : in TEXT) return BOOLEAN;
  function "<=" (T1, T2 : in TEXT) return BOOLEAN;
  function ">"  (T1, T2 : in TEXT) return BOOLEAN;
  function ">=" (T1, T2 : in TEXT) return BOOLEAN;


  function LOCATE(SUB: in TEXT; WITHIN: in TEXT) return INDEX;
  function LOCATE(SUB: in STRING; WITHIN: in TEXT) return INDEX;
  function LOCATE(SUB: in CHARACTER; WITHIN: in TEXT) return INDEX;
  -- Find Sub in text; Return 0 if not there.

  function SUBSTR(T : in TEXT; START, SIZE : in INDEX) return TEXT;
  -- Return substring; truncate if overflow.

  procedure PUT(T : in TEXT);


  private
    type TEXT is
      record
        POS : INDEX := 0;
        VALUE : STRING(1..MAXIMUM);
      end record;

end TEXT_HANDLER;
