
with Text_Handler,
     Xref_Types;

package Tree_Handler is

  --
  --  contains the binary search tree management/processing
  --  facilities needed for this cross-referencer
  --
  --      built by John H. Heidema  (December, 1985)
  --
  --        [ with minor changes in October 1990]
  --

  procedure Update(
          T : in out Xref_Types.BTree;           -- binary tree pointer
          K : in     Text_Handler.Text;          -- new word to insert
          V : in     Xref_Types.Line_Number );   -- its line number
  --
  --  This procedure adds one word node (with data of type Text)
  --  to the binary tree indicated by access variable T
  --  If a node for this word already exists, then just the
  --  new line number V is added to the tree data structure
  --  (which has a linked list of line numbers attached to
  --  each tree node).  New words get attached to existing
  --  tree leaves, moving left if earlier in the alphabet and
  --  right if later.
  --

  procedure Report( T : in     Xref_Types.Btree );
  --
  --  This is the output routine called at the end of file
  --  processing to print the collected results in alphabetical
  --  order and by increasing line number.  An "inorder"
  --  traversal of the binary search tree (accessed via
  --  its rootnode T) achieves this.
  --

end Tree_Handler;

