
with Text_Handler;

package Xref_Types is
  --
  -- type declarations for Ada Cross-Referencer program
  --
  --     built by:  John H. Heidema - December, 1985
  --
  --       with minor updates and modifications
  --               in October, 1990
  --

  type Line_Number is
    new Integer range 1..32767;       -- for word locations in file


  type OneWayListNode;                --
  type List is access OneWayListNode; -- dynamically allocated nodes
  type OneWayListNode is              -- for linked list of line numbers
    record                            -- associated with each identifier
      Value : Line_Number;                  -- the  data
      Next  : List := null;                 -- pointer to next list node
    end record;

  type ListHeader is                -- method for accessing line_number
    record                          -- list associated with BST word node
      Head : List := null;    -- pointers to
      Tail : List := null;    -- line number lists
    end record;


  type TreeNode;                      -- defining structure
  type BTree is access TreeNode;      -- for a binary tree
  type TreeNode is                    -- to store incoming identifiers
    record                        -- the node structure:
      Key   : Text_Handler.Text;  --   the identifier
      Value : ListHeader;         --   its list of line numbers
      Left  : BTree := null;      --   the left child tree
      Right : BTree := null;      --   the right child tree
    end record;


      -- setting up the structure for a finite state machine (FSM)
      -- to help pick identifiers out of the source code:

  type State      is (Start, Build, Finish);         -- for FSM states
  type InputClass is (Letter, Di_git, CR, Junk);     -- for each character
  type Action     is
    (Nothing, StartWord, BumpLine, AddLetter);       -- for the word finder

  type Transitions is                 --
    record                            -- Get_Word scanner will work like an
      NewState   : State  := Start;   -- FSM with transition-assigned output
      ThisAction : Action := Nothing; --
    end record;

  type FSM_Table is
    array (State, InputClass) of Transitions;    -- for Get_Word usage

end Xref_Types;
