{********************************************************}
{ Program Generator for Borland Pascal 7.0
{
{ Created by Jamie Unden
{ History:
{ 10/13/95  Initial Release                 - Progen10.Zip
{ 10/18/95  Added Help                      - Progen20.Zip
{ 10/25/95  Added SAVE                      - Progen30.Zip
{ 05/21/96  Restructured, fixed bugs        - Progen40.Zip
{ 07/03/96  Added SetupWindow and Paint to
{           MainWindow                      - Progen40.Zip
{********************************************************}
Program Progen;

{$M 16384, 32768}

Uses WinTypes, WinProcs, OWindows, ODialogs, BWCC, Strings, Objects, Global;

{$R Progen.RES}

{********************************************************}
{ Type Definitions                                       }
{********************************************************}
Type
  Main_File_Type = (Path_Name, RC_Name, Const_Name, Icon_Name);
  Search_Type = (Dialog, Menuitem, Pushbutton, Control, EditText);
  Link_Type = (DialogType, MenuType);
  FileType = (One, Split);
{********************************************************}
{ Define a TApplication descendant                       }
{********************************************************}
  PProgen = Object (TApplication)
    Procedure InitMainWindow; Virtual;
  End;

{********************************************************}
{ Define the main window                                 }
{********************************************************}
  PProgenWindow = ^ProgenWindow;
  ProgenWindow = Object (TWindow)
    DragDC: HDC;
    Constructor Init (AParent: PWindowsObject; ATitle: PChar);
    Procedure One_File (Var Msg: TMessage); Virtual cm_First + cm_one_file;
    Procedure Split_File (Var Msg: TMessage); Virtual cm_First + cm_split_file;
    Procedure GetWindowClass (Var AWndClass: TWndClass); Virtual;
    Procedure Exit (Var Msg: TMessage); Virtual cm_First + cm_Exit;
    Procedure Do_cm_help_index (Var Msg: TMessage); Virtual cm_First + cm_help_index;
    Procedure Do_cm_help_about (Var Msg: TMessage); Virtual cm_First + cm_help_about;
    Procedure Do_cm_load_file (Var Msg: TMessage); Virtual cm_First + cm_load_file;
    Procedure Do_cm_save_file (Var Msg: TMessage); Virtual cm_First + cm_save_file;
  End;

{********************************************************}
{ Define the Dialog Box for Combined Files               }
{********************************************************}
  POne_File = ^TOne_File;
  TOne_File = Object (TDialog)
    DragDC: HDC;
    Procedure WMInitDialog (Var Msg: TMessage); Virtual wm_First + wm_InitDialog;
    Procedure Get_Main_Filenames (Var Msg: TMessage); Virtual ID_First + dlg_om_main_files_butt;
    Procedure Get_Dialog_Links (Var Msg: TMessage); Virtual ID_First + dlg_om_dialog_links;
    Procedure Get_Collection (Var Msg: TMessage); Virtual ID_First + dlg_om_coll;
    Procedure Get_Idle_Process_Name (Var Msg: TMessage); Virtual ID_First + dlg_om_idle;
    Procedure Build_Source (Var Msg: TMessage); Virtual ID_First + dlg_om_build_source;
    Procedure OmCancel (Var Msg: TMessage); Virtual ID_First + dlg_om_cancel;
    Procedure Do_dlg_om_help (Var Msg: TMessage); Virtual id_First + dlg_om_help;
    Procedure Do_dlg_om_save (Var Msg: TMessage); Virtual id_First + dlg_om_save;
  End;

{********************************************************}
{ Define the Dialog Box for Split Files                  }
{********************************************************}
  PSplit_File = ^TSplit_File;
  TSplit_File = Object (TDialog)
    DragDC: HDC;
    Procedure WMInitDialog (Var Msg: TMessage); Virtual wm_First + wm_InitDialog;
    Procedure Get_Main_Filenames (Var Msg: TMessage); Virtual ID_First + dlg_sm_main_files_butt;
    Procedure Get_Dialog_Unit_Names (Var Msg: TMessage); Virtual ID_First + dlg_sm_dialog_names;
    Procedure Get_Dialog_Links (Var Msg: TMessage); Virtual ID_First + dlg_sm_dialog_links;
    Procedure Get_Collection (Var Msg: TMessage); Virtual ID_First + dlg_sm_coll;
    Procedure Get_Idle_Process_Name (Var Msg: TMessage); Virtual ID_First + dlg_sm_idle;
    Procedure Build_Source (Var Msg: TMessage); Virtual ID_First + dlg_sm_build_source;
    Procedure SmCancel (Var Msg: TMessage); Virtual ID_First + dlg_sm_cancel;
    Procedure Do_dlg_sm_help (Var Msg: TMessage); Virtual id_First + dlg_sm_help;
    Procedure Do_dlg_sm_save (Var Msg: TMessage); Virtual id_First + dlg_sm_save;
  End;

{********************************************************}
{ Define the Dialog Box for Main File List               }
{********************************************************}
  PMain_Files = ^TMain_Files;
  TMain_Files = Object (TDialog)
    DragDC: HDC;
    Procedure WMInitDialog (Var Msg: TMessage); Virtual wm_First + wm_InitDialog;
    Procedure Get_Base_Dir (Var Msg: TMessage); Virtual id_First + dlg_mf_base_dir;
    Procedure Get_RC_Name (Var Msg: TMessage); Virtual id_First + dlg_mf_rc_name;
    Procedure Get_Const_Name (Var Msg: TMessage); Virtual id_First + dlg_mf_const_name;
    Procedure Get_Menu_Name (Var Msg: TMessage); Virtual id_First + dlg_mf_menu_name;
    Procedure Get_Icon_Name (Var Msg: TMessage); Virtual id_First + dlg_mf_icon_name;
    Procedure Get_List_Data (Var Msg: TMessage); Virtual id_First + dlg_mf_combo_box;
    Procedure MfCancel (Var Msg: TMessage); Virtual ID_First + dlg_mf_cancel;
    Procedure MfDone (Var Msg: TMessage); Virtual ID_First + dlg_mf_done;
    Procedure Do_dlg_mf_help (Var Msg: TMessage); Virtual id_First + dlg_mf_help;
  End;

{********************************************************}
{ Define the Dialog Box for Dialog/Unit Cross Reference  }
{********************************************************}
  PDialog_Unit = ^TDialog_Unit;
  TDialog_Unit = Object (TDialog)
    DragDC: HDC;
    Procedure WMInitDialog (Var Msg: TMessage); Virtual wm_First + wm_InitDialog;
    Procedure DUEnter (Var Msg: TMessage); Virtual ID_First + dlg_dialog_enter;
    Procedure DUClear (Var Msg: TMessage); Virtual ID_First + dlg_dialog_clear;
    Procedure DULoad (Var Msg: TMessage);Virtual;
    Procedure DUFocus (Var Msg: TMessage);Virtual ID_First + dlg_dialog_dlg;
    Procedure DUDone (Var Msg: TMessage); Virtual ID_First + dlg_dialog_done;
    Procedure DUCancel (Var Msg: TMessage); Virtual ID_First + dlg_dialog_cancel;
    Procedure Do_dlg_dialog_help (Var Msg: TMessage); Virtual id_First + dlg_dialog_help;
  End;

{********************************************************}
{ Define the Dialog Box for Link Selector  }
{********************************************************}
  PLink_Selector = ^TLink_Selector;
  TLink_Selector = Object (TDialog)
    DragDC: HDC;
    Procedure WMInitDialog (Var Msg: TMessage); Virtual wm_First + wm_InitDialog;
    Procedure LSDialog (Var Msg: TMessage); Virtual id_First + dlg_link_sel_Dialog;
    Procedure LSMenu (Var Msg: TMessage); Virtual id_First + dlg_link_sel_Menu;
    Procedure LSBox (Var Msg: TMessage); Virtual id_First + dlg_link_sel_Box;
    Procedure LSOK (Var Msg: TMessage); Virtual ID_First + dlg_link_sel_OK;
    Procedure LSDone (Var Msg: TMessage); Virtual ID_First + dlg_link_sel_Done;
    Procedure LSHelp (Var Msg: TMessage); Virtual id_First + dlg_link_sel_Help;
  End;

{********************************************************}
{ Define the Dialog Box for Control Links Cross Reference}
{********************************************************}
  PControl_Links = ^TControl_Links;
  TControl_Links = Object (TDialog)
    DragDC: HDC;
    Procedure WMInitDialog (Var Msg: TMessage); Virtual wm_First + wm_InitDialog;
    Procedure CLEnter (Var Msg: TMessage); Virtual ID_First + dlg_ctrl_links_enter;
    Procedure CLClear (Var Msg: TMessage); Virtual ID_First + dlg_ctrl_links_clear;
    Procedure LoadDisp (Var Msg: TMessage); Virtual;
    Procedure CLFocus (Var Msg: TMessage); Virtual ID_First + dlg_ctrl_links_controls;
    Procedure CLDone (Var Msg: TMessage); Virtual ID_First + dlg_ctrl_links_done;
    Procedure Do_dlg_ctrl_links_help (Var Msg: TMessage); Virtual id_First + dlg_ctrl_links_help;
  End;

{********************************************************}
{ Define the Dialog Box for Idle Process Name            }
{********************************************************}
  PIdle_Name = ^TIdle_Name;
  TIdle_Name = Object (TDialog)
    DragDC: HDC;
    Procedure WMInitDialog (Var Msg: TMessage); Virtual wm_First + wm_InitDialog;
    Procedure INCancel (Var Msg: TMessage); Virtual ID_First + dlg_idle_name_cancel;
    Procedure INDone (Var Msg: TMessage); Virtual ID_First + dlg_idle_name_done;
    Procedure Do_dlg_idle_name_help (Var Msg: TMessage); Virtual id_First + dlg_idle_name_help;
  End;

{********************************************************}
{ Define the Dialog Box for Read Data                    }
{********************************************************}
  PRead_Data = ^TRead_Data;
  TRead_Data = Object (TDialog)
    Procedure WMInitDialog (Var Msg: TMessage); Virtual wm_First + wm_InitDialog;
  End;

{********************************************************}
{ Define the Dialog Box for Read Data                    }
{********************************************************}
  PCode_Genned = ^TCode_Genned;
  TCode_Genned = Object (TDialog)
    Procedure WMInitDialog (Var Msg: TMessage); Virtual wm_First + wm_InitDialog;
    Procedure CGOk (Var Msg: TMessage); Virtual Id_First + dlg_code_gen_ok;
  End;

{********************************************************}
{ Define About
{********************************************************}
PAbout = ^TAbout;
TAbout = Object (TDialog)
  Procedure WMInitDialog (Var Msg: TMessage); Virtual wm_First + wm_InitDialog;
  Procedure Do_dlg_about_ok (Var Msg: TMessage); Virtual id_First + dlg_about_ok;
End;

{********************************************************}
{ Define Start_Directory
{********************************************************}
PStart_Directory = ^TStart_Directory;
TStart_Directory = Object (TDialog)
  Procedure WMInitDialog (Var Msg: TMessage); Virtual wm_First + wm_InitDialog;
  Procedure Do_dlg_sd_done (Var Msg: TMessage); Virtual id_First + dlg_sd_done;
  Procedure Do_dlg_sd_cancel (Var Msg: TMessage); Virtual id_First + dlg_sd_cancel;
  Procedure Do_dlg_sd_combo (Var Msg: TMessage); virtual id_First + dlg_sd_path;
  Procedure Get_Path_Data (Var Msg: TMessage); Virtual id_First + dlg_sd_combo;
End;

{**********************************************************************}
{                 Define the List Item                                 }
{**********************************************************************}
  PListItem = ^TListItem;
  TListItem = Object (TObject)
    DispItem, Link : PString;
    Constructor Init (NewItem, NewLink: String);
    Destructor Done; Virtual;
    Function GetDisp: String; Virtual;
    Function GetLink: String; Virtual;
    Constructor Load (Var S: TBufStream);
    Procedure Store (Var S: TBufStream); Virtual;
  End;

  PList = ^TList;
  TList = Object (TSortedCollection)
    Function KeyOf (Item: Pointer): Pointer; Virtual;
    Function Compare (Key1, Key2: Pointer): Integer; Virtual;
    Procedure ClearList; Virtual;
  End;

{********************************************************}
{ Global Variable Declarations                           }
{********************************************************}
Var
  Main_File_Sel       : Main_File_Type;
  Main_Path_Name      : String;
  Program_File_Name   : STRING;
  RC_File_Name        : STRING;
  RC_File_Short       : STRING;
  Const_File_Name     : STRING;
  Main_Icon_Name      : STRING;
  Main_Menu_Name      : String;
  Idle_Process_Name   : String;
  Get_ID_Second_Param : String;
  Idle_Checked        : Boolean;
  FoundItem           : PListItem;
  Infile, TypeFile    : Text;
  CodeFile, Outfile3  : Text;
  FileStarted         : BOOLEAN;
  FileLoaded          : Boolean;
  Dialog_Coll         : PList;
  MenuItem_Coll       : PList;
  Controls_Coll       : PList;
  Misc_Coll           : PList;
  Line_Count          : Integer;
  MyFile              : TBufStream;
  Main_File_Check     : Boolean;
  Dialog_Names_Check  : Boolean;
  Control_Links_Check : Boolean;
  LinkSel             : Link_Type;
  SelectedDialog      : String;
  BuildStyle          : FileType;

{********************************************************}
{ Code Area                                              }
{********************************************************}
{**********************************************************************}
{                 Define the Stream Registration                       }
{**********************************************************************}
Const
  RList : TStreamRec = (
  ObjType : 140;
  VmtLink : Ofs (TypeOf (TList)^);
  Load: @TList. Load;
  Store: @TList. Store);

  RListItem : TStreamRec = (
  ObjType : 141;
  VmtLink : Ofs (TypeOf (TListItem)^);
  Load: @TListItem. Load;
  Store: @TListItem. Store);
  
  memo_line : String = '{********************************************************}';
  use_line : String = 'Uses WinTypes, WinProcs, OWindows, ODialogs, BWCC, Strings, Objects, ';

Function Get_ID(Instring: String; Item: Search_Type):String; Forward;
Procedure DoMainHeader(InType: FileType);Forward;
Procedure DoSecondHeader; Forward;
Procedure DoHelpFile; Forward;
Procedure DoDialogs(InType: FileType);Forward;
Procedure RegisterList; Forward;
Function FileExist(FileName: String):Boolean; Forward;

Function SearchList (C: PCollection; ItemToFind: String):Boolean;
Var
  Found : Boolean;
  Function ItemMatch (Item: PListItem): Boolean; Far;
  Var
    TString : String;
  Begin
    TString := Item^. GetDisp;
    Found := (TString = ItemToFind);;
    ItemMatch := Found;
  End;
Begin
  Found := False;
  if C <> nil Then
    FoundItem := C^. FirstThat (@ItemMatch);
  SearchList := Found;
End;

{********************************************************}
{ Code for Main Window                                   }
{********************************************************}
Constructor ProgenWindow. Init (AParent: PWindowsObject; ATitle: PChar);
Begin
  Inherited Init (AParent, ATitle);
  Attr. Menu := LoadMenu (HInstance, 'MENU_1');
  Main_Path_Name := 'c:';
  Program_File_Name  := '';
  RC_File_Name       := ' ';
  Const_File_Name    := ' ';
  Main_Icon_Name     := ' ';
  Main_Menu_Name     := ' ';
  Idle_Process_Name  := ' ';
  Main_File_Check    := False;
  Dialog_Names_Check := False;
  Control_Links_Check := False;
  Idle_Checked       := False;
  RegisterList;
End;

Procedure ProgenWindow. One_File (Var Msg: TMessage);
VAR
  Get_Status : Integer;
Begin
  BuildStyle := One;
  Get_Status := Application^. ExecDialog (New (POne_File, Init (Nil, 'One_Main') ) );
End;

Procedure ProgenWindow. Split_File (Var Msg: TMessage);
VAR
  Get_Status : Integer;
Begin
  BuildStyle := Split;
  Get_Status := Application^. ExecDialog (New (PSplit_File, Init (Nil, 'Split_Main') ) );
End;

Procedure ProgenWindow. GetWindowClass (Var AWndClass: TWndClass);
Begin
  Inherited GetWindowClass (AWndClass);
  AWndClass. HIcon := LoadIcon (HInstance, 'ICON_1');
End;

Procedure ProgenWindow. Exit (Var Msg: TMessage);
Begin
  if FileStarted Then
  Begin
    Dispose(Dialog_Coll, Done);
    Dispose(MenuItem_Coll, Done);
    Dispose(Controls_Coll, Done);
    Dispose(Misc_Coll, Done);
  End;
  Inherited Done;
End;

Procedure ProgenWindow. Do_cm_help_index (Var Msg: TMessage);
Begin
  DragDC := GetDC(HWindow);
  WinHelp(HWindow, 'ProGen.hlp', help_index, 0);
End;

Procedure ProgenWindow. Do_cm_help_about (Var Msg: TMessage);
Begin
  Application^. ExecDialog (New (PAbout, Init (Nil, 'About') ) );
End;

Procedure ProgenWindow. Do_cm_load_file (Var Msg: TMessage);
Var
  TChar : Array [0..20] Of Char;
  OK_To_Process : Boolean;

  procedure GetMiscStuff(Item : PListItem);FAR;
  Var
    TString1, TString2 : String;
    i : Integer;
  Begin
      TString1 := Item^. GetDisp;
      TString2 := Item^. GetLink;
      If TString1 = 'path' Then
        Main_Path_Name := TString2
      Else If TString1 = 'rc_file' Then
      Begin
        RC_File_Name := TString2;
        i := 1;
        RC_File_Short := '';
        While (RC_File_name[i] <> '.') And (i < Length(RC_File_Name)) Do
        Begin
          RC_File_Short := RC_File_Short + RC_File_Name[i];
          Inc(i);
        End;
        RC_File_Short[1] := UpCase(RC_File_Short[1]);
      End
      Else If TString1 = 'const' Then
        Const_File_Name := TString2
      Else If TString1 = 'icon' Then
        Main_Icon_Name := TString2
      Else If TString1 = 'menu' Then
        Main_Menu_Name := TString2
      Else If TString1 = 'idle' Then
        Idle_Process_Name := TString2
      Else If TString1 = 'mf_check' Then
        Main_File_Check := (TString2 = 'True')
      Else If TString1 = 'dn_check' Then
        Dialog_Names_Check := (TString2 = 'True')
      Else If TString1 = 'cl_check' Then
        Control_Links_Check := (TString2 = 'True')
      Else If TString1 = 'ip_check' Then
        Idle_Checked := (TString2 = 'True');
  End;
Begin
  Application^. ExecDialog (New (PStart_Directory, Init (Nil, 'Start_Directory') ) );
  if Not FileStarted Then
  Begin
    Dialog_Coll := New (PList, Init (10, 5) );
    Dialog_Coll^. Duplicates := False;
    MenuItem_Coll := New (PList, Init (10, 5) );
    MenuItem_Coll^. Duplicates := False;
    Controls_Coll := New (PList, Init (10, 5) );
    Controls_Coll^. Duplicates := False;
    Misc_Coll := New (PList, Init (10, 5) );
    Misc_Coll^. Duplicates := False;
    FileStarted := True;
  end
  else
  Begin
    Dialog_Coll^. Clearlist;
    MenuItem_Coll^. Clearlist;
    Controls_Coll^. Clearlist;
    Misc_Coll^. Clearlist;
  End;
{ Load collections from stream }
  OK_To_Process := True;
  If Not (FileExist('dlgs.dat')) Then
    OK_To_Process := False;
  If Not (FileExist('menus.dat')) Then
    OK_To_Process := False;
  If Not (FileExist('ctrls.dat')) Then
    OK_To_Process := False;
  If Not (FileExist('misc.dat')) Then
    OK_To_Process := False;

  If OK_To_Process Then
  Begin
    StrPCopy (@TChar, 'dlgs.dat');
    With MyFile Do
    Begin
      Init (@TChar, stOpen, 1024);
      Dialog_Coll := PList (Get);
      Done;
    End;

    StrPCopy (@TChar, 'menus.dat');
    With MyFile Do
    Begin
      Init (@TChar, stOpen, 1024);
      MenuItem_Coll := PList (Get);
      Done;
    End;

    StrPCopy (@TChar, 'ctrls.dat');
    With MyFile Do
    Begin
      Init (@TChar, stOpen, 1024);
      Controls_Coll := PList (Get);
      Done;
    End;

    StrPCopy (@TChar, 'misc.dat');
    With MyFile Do
    Begin
      Init (@TChar, stOpen, 1024);
      Misc_Coll := PList (Get);
      Done;
    End;
    If Misc_Coll <> nil Then
      Misc_Coll^. Foreach(@GetMiscStuff);
    FileStarted := True;
    FileLoaded := True;
    Application^. ExecDialog (New (PRead_Data, Init (Nil, 'Read_Data') ) );
  End
  else
    MessageBox (HWindow, 'No Setup Saved', 'OOPS!', mb_Ok);
End;

Procedure ProgenWindow. Do_cm_save_file (Var Msg: TMessage);
Var
  TChar : Array [0..20] Of Char;
  TString1, TString2, TString3, TString4 : String;
Begin
  If FileStarted Then
  Begin
    StrPCopy (@TChar, 'dlgs.dat');
    MyFile. Init (@TChar, stCreate, 1024);
    MyFile. Put (Dialog_Coll);
    MyFile. Done;

    StrPCopy (@TChar, 'menus.dat');
    MyFile. Init (@TChar, stCreate, 1024);
    MyFile. Put (MenuItem_Coll);
    MyFile. Done;

    StrPCopy (@TChar, 'ctrls.dat');
    MyFile. Init (@TChar, stCreate, 1024);
    MyFile. Put (Controls_Coll);
    MyFile. Done;

    If Main_File_Check Then
      TString1 := 'True'
    Else
      TString1 := 'False';

    If Dialog_Names_Check Then
      TString2 := 'True'
    Else
      TString2 := 'False';

    If Control_Links_Check Then
      TString3 := 'True'
    Else
      TString3 := 'False';

    If Idle_Checked Then
      TString4 := 'True'
    Else
      TString4 := 'False';

    If Misc_Coll <> nil Then
      Misc_Coll^. Clearlist;
    With Misc_Coll^ Do
    Begin
      Insert (New (PListItem, Init ('path', Main_Path_Name) ) );
      Insert (New (PListItem, Init ('rc_file', RC_File_Name) ) );
      Insert (New (PListItem, Init ('const', Const_File_Name) ) );
      Insert (New (PListItem, Init ('icon', Main_Icon_Name) ) );
      Insert (New (PListItem, Init ('menu', Main_Menu_Name) ) );
      Insert (New (PListItem, Init ('idle', Idle_Process_Name) ) );
      Insert (New (PListItem, Init ('mf_check', TString1) ) );
      Insert (New (PListItem, Init ('dn_check', TString2) ) );
      Insert (New (PListItem, Init ('cl_check', TString3) ) );
      Insert (New (PListItem, Init ('ip_check', TString4) ) );
    End;

    StrPCopy (@TChar, 'misc.dat');
    MyFile. Init (@TChar, stCreate, 1024);
    MyFile. Put (Misc_Coll);
    MyFile. Done;

  End;
End;

{********************************************************}
{ Code for Application decendent                         }
{********************************************************}
Procedure PProgen. InitMainWindow;
Begin
  MainWindow := New (PProgenWindow, Init (Nil, 'Progen') );
End;

{********************************************************}
{ Code for Combined File Dialog Box procedures           }
{********************************************************}
Procedure TOne_File. WMInitDialog (Var Msg: TMessage);
Begin
  Inherited SetupWindow;
  If Main_File_Check Then
    SendDlgItemMsg (dlg_om_main_files_ck, BM_SETCHECK, 1, 0 );
  If Control_Links_Check Then
    SendDlgItemMsg (dlg_om_dialog_links_ck, BM_SETCHECK, 1, 0 );
  If Idle_Checked Then
    SendDlgItemMsg (dlg_om_idle_ck, BM_SETCHECK, 1, 0 );
End;

Procedure TOne_File. Get_Main_Filenames (Var Msg: TMessage);
VAR
  Get_Status : Integer;
Begin
  Get_Status := Application^. ExecDialog (New (PMain_Files, Init (Nil, 'Main_Filenames') ) );
  If Get_Status = 0 Then
  Begin
    SendDlgItemMsg (dlg_om_main_files_ck, BM_SETCHECK, 1, 0 );
    Main_File_Check    := True;
    Get_Status := Application^. ExecDialog (New (PRead_Data, Init (Nil, 'Read_Data') ) );
    if Get_Status <> 0 Then
      MessageBox (HWindow, 'Error in reading files', 'OOPS!', mb_Ok);
  End;
End;

Procedure TOne_File. Get_Dialog_Links (Var Msg: TMessage);
Begin
  Application^. ExecDialog (New (PLink_Selector, Init (Nil, 'Link_Select') ) );
  SendDlgItemMsg (dlg_om_dialog_links_ck, BM_SETCHECK, 1, 0 );
  Control_Links_Check := True;
End;

Procedure TOne_File. Get_Collection (Var Msg: TMessage);
Begin
  MessageBox (HWindow, 'Feature not implemented', 'OOPS!', mb_Ok);
End;

Procedure TOne_File. Get_Idle_Process_Name (Var Msg: TMessage);
VAR
  Get_Status : Integer;
Begin
  Get_Status := Application^. ExecDialog (New (PIdle_Name, Init (Nil, 'Idle_Name') ) );
  If Get_Status = 0 Then
  Begin
    SendDlgItemMsg (dlg_om_idle_ck, BM_SETCHECK, 1, 0 );
    Idle_Checked := True;
  End;
End;

Procedure TOne_File. Build_Source (Var Msg: TMessage);
Var
  TString2 : String;
  CkStatus : Integer;
  OK_To_Process : Boolean;
Begin
  OK_To_Process := True;
  CkStatus := SendDlgItemMsg (dlg_om_main_files_ck, BM_GETCHECK, 0, 0 );
  If CkStatus = 0 Then
  Begin
    OK_To_Process := False;
    MessageBox (HWindow, 'Main Files must be setup first.', 'OOPS!', mb_Ok);
  End;
  CkStatus := SendDlgItemMsg (dlg_om_dialog_links_ck, BM_GETCHECK, 0, 0 );
  If CkStatus = 0 Then
  Begin
    OK_To_Process := False;
    MessageBox (HWindow, 'Control Links must be setup first.', 'OOPS!', mb_Ok);
  End;
  CkStatus := SendDlgItemMsg (dlg_om_idle_ck, BM_GETCHECK, 0, 0 );
  If OK_To_Process Then
  Begin
    DoMainHeader(One);
    Writeln(TypeFile, '');
    DoSecondHeader;
    DoDialogs(One);
    Close(TypeFile);
    Close(CodeFile);
    Assign(OutFile3, RC_File_Short + '.pas');
    ReWrite(OutFile3);
    Assign(TypeFile, 'Types.Tmp');
    Reset(TypeFile);
    Assign(CodeFile, 'Code.Tmp');
    Reset(CodeFile);
    While Not Eof(TypeFile) Do
    Begin
      Readln(TypeFile, TString2);
      Writeln(OutFile3, TString2);
    End;
    While Not Eof(CodeFile) Do
    Begin
      Readln(CodeFile, TString2);
      Writeln(OutFile3, TString2);
    End;
    Close(TypeFile);
    Close(CodeFile);
    Writeln(OutFile3, '');
    If Idle_Checked Then
    Begin
      Writeln(OutFile3, Memo_Line);
      Writeln(OutFile3, '{ Code for Idle Process');
      Writeln(OutFile3, Memo_Line);
      Writeln(OutFile3, 'Procedure ' + Idle_Process_Name + ';');
      Writeln(OutFile3, 'Begin');
      Writeln(OutFile3, 'End;');
      Writeln(OutFile3, '');
    End;
    Writeln(OutFile3, Memo_Line);
    Writeln(OutFile3, '{ Variable Declarations');
    Writeln(OutFile3, Memo_Line);
    Writeln(OutFile3, 'Var');
    Writeln(OutFile3, '  My' + RC_File_Short + ' : P' + RC_File_Short + ';');
    Writeln(OutFile3, '');
    Writeln(OutFile3, 'Begin');
    Writeln(OutFile3, '  My' + RC_File_Short + '. Init (''' + RC_File_Short + ''');');
    Writeln(OutFile3, '  My' + RC_File_Short + '. Run;');
    Writeln(OutFile3, '  My' + RC_File_Short + '. Done;');
    Writeln(OutFile3, 'End.');
    Close(OutFile3);
    Assign(TypeFile, 'Types.Tmp');
    Erase(TypeFile);
    Assign(CodeFile, 'Code.Tmp');
    Erase(CodeFile);
    DoHelpFile;
    Application^. ExecDialog (New (PCode_Genned, Init (Nil, 'Code_Genned') ) );
  End
  else
    MessageBox (HWindow, 'File Missing', 'OOPS!', mb_Ok);
End;

Procedure TOne_File. OmCancel (Var Msg: TMessage);
Begin
  TOne_File.EndDlg(0);
End;

Procedure TOne_File. Do_dlg_om_help (Var Msg: TMessage);
Begin
  DragDC := GetDC(HWindow);
  WinHelp(HWindow, 'ProGen.hlp', help_context, dlg_om_help);
End;

Procedure TOne_File. Do_dlg_om_save (Var Msg: TMessage);
Var
  TChar : Array [0..20] Of Char;
  TString1, TString2, TString3, TString4 : String;
Begin
  If FileStarted Then
  Begin
    StrPCopy (@TChar, 'dlgs.dat');
    MyFile. Init (@TChar, stCreate, 1024);
    MyFile. Put (Dialog_Coll);
    MyFile. Done;

    StrPCopy (@TChar, 'menus.dat');
    MyFile. Init (@TChar, stCreate, 1024);
    MyFile. Put (MenuItem_Coll);
    MyFile. Done;

    StrPCopy (@TChar, 'ctrls.dat');
    MyFile. Init (@TChar, stCreate, 1024);
    MyFile. Put (Controls_Coll);
    MyFile. Done;

    If Main_File_Check Then
      TString1 := 'True'
    Else
      TString1 := 'False';

    If Dialog_Names_Check Then
      TString2 := 'True'
    Else
      TString2 := 'False';

    If Control_Links_Check Then
      TString3 := 'True'
    Else
      TString3 := 'False';

    If Idle_Checked Then
      TString4 := 'True'
    Else
      TString4 := 'False';

    If Misc_Coll <> nil Then
      Misc_Coll^. Clearlist;
    With Misc_Coll^ Do
    Begin
      Insert (New (PListItem, Init ('path', Main_Path_Name) ) );
      Insert (New (PListItem, Init ('rc_file', RC_File_Name) ) );
      Insert (New (PListItem, Init ('const', Const_File_Name) ) );
      Insert (New (PListItem, Init ('icon', Main_Icon_Name) ) );
      Insert (New (PListItem, Init ('menu', Main_Menu_Name) ) );
      Insert (New (PListItem, Init ('idle', Idle_Process_Name) ) );
      Insert (New (PListItem, Init ('mf_check', TString1) ) );
      Insert (New (PListItem, Init ('dn_check', TString2) ) );
      Insert (New (PListItem, Init ('cl_check', TString3) ) );
      Insert (New (PListItem, Init ('ip_check', TString4) ) );
    End;

    StrPCopy (@TChar, 'misc.dat');
    MyFile. Init (@TChar, stCreate, 1024);
    MyFile. Put (Misc_Coll);
    MyFile. Done;
  End;
End;

{********************************************************}
{ Code for Split File Dialog Box procedures
{********************************************************}
Procedure TSplit_File. WMInitDialog (Var Msg: TMessage);
Begin
  Inherited SetupWindow;
  If Main_File_Check Then
    SendDlgItemMsg (dlg_sm_main_files_ck, BM_SETCHECK, 1, 0 );
  If Dialog_Names_Check Then
    SendDlgItemMsg (dlg_sm_dialog_names_ck, BM_SETCHECK, 1, 0 );
  If Control_Links_Check Then
    SendDlgItemMsg (dlg_sm_dialog_links_ck, BM_SETCHECK, 1, 0 );
  If Idle_Checked Then
    SendDlgItemMsg (dlg_sm_idle_ck, BM_SETCHECK, 1, 0 );
End;

Procedure TSplit_File. Get_Main_Filenames (Var Msg: TMessage);
VAR
  Get_Status : Integer;
Begin
  Get_Status := Application^. ExecDialog (New (PMain_Files, Init (Nil, 'Main_Filenames') ) );
  If Get_Status = 0 Then
  Begin
    SendDlgItemMsg (dlg_sm_main_files_ck, BM_SETCHECK, 1, 0 );
    Main_File_Check    := True;
    Get_Status := Application^. ExecDialog (New (PRead_Data, Init (Nil, 'Read_Data') ) );
    if Get_Status <> 0 Then
      MessageBox (HWindow, 'Error in reading files', 'OOPS!', mb_Ok);
  End;
End;

Procedure TSplit_File. Get_Dialog_Unit_Names (Var Msg: TMessage);
VAR
  Get_Status : Integer;
Begin
  Get_Status := Application^. ExecDialog (New (PDialog_Unit, Init (Nil, 'Dialog_Unit') ) );
  if Get_Status = 0 Then
  Begin
    SendDlgItemMsg (dlg_sm_dialog_names_ck, BM_SETCHECK, 1, 0 );
    Dialog_Names_Check := True;
  End
  Else
  Begin
    SendDlgItemMsg (dlg_sm_dialog_names_ck, BM_SETCHECK, 0, 0 );
    Dialog_Names_Check := False;
  End;
End;

Procedure TSplit_File. Get_Dialog_Links (Var Msg: TMessage);
Begin
  Application^. ExecDialog (New (PLink_Selector, Init (Nil, 'Link_Select') ) );
  SendDlgItemMsg (dlg_sm_dialog_links_ck, BM_SETCHECK, 1, 0 );
  Control_Links_Check := True;
End;

Procedure TSplit_File. Get_Collection (Var Msg: TMessage);
Begin
  MessageBox (HWindow, 'Feature not implemented', 'OOPS!', mb_Ok);
End;

Procedure TSplit_File. Get_Idle_Process_Name (Var Msg: TMessage);
VAR
  Get_Status : Integer;
Begin
  Get_Status := Application^. ExecDialog (New (PIdle_Name, Init (Nil, 'Idle_Name') ) );
  If Get_Status = 0 Then
  Begin
    SendDlgItemMsg (dlg_sm_idle_ck, BM_SETCHECK, 1, 0 );
    Idle_Checked := True;
  End;
End;

Procedure TSplit_File. Build_Source (Var Msg: TMessage);
Var
  i : Integer;
  TString1, TString2 : String;
  CkStatus : Integer;
  OK_To_Process : Boolean;

  Procedure CallGetDisp (P : PListItem); Far;
  Var
    TextItem : Array [0..80] Of Char;
  Begin
    TString1 := P^. GetLink;
    If TString1 <> ' ' Then
    Begin
      TString2 := TString2 + TString1 + ', ';
      if(Length(TString2) > 65) Then
      Begin
        Writeln(TypeFile, TString2);
        TString2 := ' ';
      End;
    End;
  End;
Begin
  OK_To_Process := True;
  CkStatus := SendDlgItemMsg (dlg_sm_main_files_ck, BM_GETCHECK, 0, 0 );
  If CkStatus = 0 Then
  Begin
    OK_To_Process := False;
    MessageBox (HWindow, 'Main Files must be setup first.', 'OOPS!', mb_Ok);
  End;
  CkStatus := SendDlgItemMsg (dlg_sm_dialog_names_ck, BM_GETCHECK, 0, 0 );
  If CkStatus = 0 Then
  Begin
    OK_To_Process := False;
    MessageBox (HWindow, 'Dialog Names must be setup first.', 'OOPS!', mb_Ok);
  End;
  CkStatus := SendDlgItemMsg (dlg_sm_dialog_links_ck, BM_GETCHECK, 0, 0 );
  If CkStatus = 0 Then
  Begin
    OK_To_Process := False;
    MessageBox (HWindow, 'Control Links must be setup first.', 'OOPS!', mb_Ok);
  End;
  CkStatus := SendDlgItemMsg (dlg_sm_idle_ck, BM_GETCHECK, 0, 0 );
  If OK_To_Process Then
  Begin
    DoMainHeader(Split);
    TString2 := '';
    Dialog_Coll^. ForEach (@CallGetDisp);
    TString2[Length(TString2) -1] := ';';
    Writeln(TypeFile, TString2);
    Writeln(TypeFile, '');
    DoSecondHeader;
    DoDialogs(Split);
    Assign(OutFile3, RC_File_Short + '.pas');
    ReWrite(OutFile3);
    Assign(TypeFile, 'Types.Tmp');
    Reset(TypeFile);
    Assign(CodeFile, 'Code.Tmp');
    Reset(CodeFile);
    While Not Eof(TypeFile) Do
    Begin
      Readln(TypeFile, TString2);
      Writeln(OutFile3, TString2);
    End;
    While Not Eof(CodeFile) Do
    Begin
      Readln(CodeFile, TString2);
      Writeln(OutFile3, TString2);
    End;
    Close(TypeFile);
    Close(CodeFile);
    Writeln(OutFile3, '');
    If Idle_Checked Then
    Begin
      Writeln(OutFile3, Memo_Line);
      Writeln(OutFile3, '{ Code for Idle Process');
      Writeln(OutFile3, Memo_Line);
      Writeln(OutFile3, 'Procedure ' + Idle_Process_Name + ';');
      Writeln(OutFile3, 'Begin');
      Writeln(OutFile3, 'End;');
      Writeln(OutFile3, '');
    End;
    Writeln(OutFile3, Memo_Line);
    Writeln(OutFile3, '{ Variable Declarations');
    Writeln(OutFile3, Memo_Line);
    Writeln(OutFile3, 'Var');
    Writeln(OutFile3, '  My' + RC_File_Short + ' : P' + RC_File_Short + ';');
    Writeln(OutFile3, '');
    Writeln(OutFile3, 'Begin');
    Writeln(OutFile3, '  My' + RC_File_Short + '. Init (''' + RC_File_Short + ''');');
    Writeln(OutFile3, '  My' + RC_File_Short + '. Run;');
    Writeln(OutFile3, '  My' + RC_File_Short + '. Done;');
    Writeln(OutFile3, 'End.');
    Close(OutFile3);
    Assign(TypeFile, 'Types.Tmp');
    Erase(TypeFile);
    Assign(CodeFile, 'Code.Tmp');
    Erase(CodeFile);
    DoHelpFile;
    Application^. ExecDialog (New (PCode_Genned, Init (Nil, 'Code_Genned') ) );
  End
  Else
    MessageBox (HWindow, 'File Missing', 'OOPS!', mb_Ok);
End;

Procedure TSplit_File. SmCancel (Var Msg: TMessage);
Begin
  TSplit_File.EndDlg(0);
End;

Procedure TSplit_File. Do_dlg_sm_help (Var Msg: TMessage);
Begin
  DragDC := GetDC(HWindow);
  WinHelp(HWindow, 'ProGen.hlp', help_context, dlg_sm_help);
End;

Procedure TSplit_File. Do_dlg_sm_save (Var Msg: TMessage);
Var
  TChar : Array [0..20] Of Char;
  TString1, TString2, TString3, TString4 : String;
Begin
  If FileStarted Then
  Begin
    StrPCopy (@TChar, 'dlgs.dat');
    MyFile. Init (@TChar, stCreate, 1024);
    MyFile. Put (Dialog_Coll);
    MyFile. Done;

    StrPCopy (@TChar, 'menus.dat');
    MyFile. Init (@TChar, stCreate, 1024);
    MyFile. Put (MenuItem_Coll);
    MyFile. Done;

    StrPCopy (@TChar, 'ctrls.dat');
    MyFile. Init (@TChar, stCreate, 1024);
    MyFile. Put (Controls_Coll);
    MyFile. Done;

    If Main_File_Check Then
      TString1 := 'True'
    Else
      TString1 := 'False';

    If Dialog_Names_Check Then
      TString2 := 'True'
    Else
      TString2 := 'False';

    If Control_Links_Check Then
      TString3 := 'True'
    Else
      TString3 := 'False';

    If Idle_Checked Then
      TString4 := 'True'
    Else
      TString4 := 'False';

    If Misc_Coll <> nil Then
      Misc_Coll^. Clearlist;
    With Misc_Coll^ Do
    Begin
      Insert (New (PListItem, Init ('path', Main_Path_Name) ) );
      Insert (New (PListItem, Init ('rc_file', RC_File_Name) ) );
      Insert (New (PListItem, Init ('const', Const_File_Name) ) );
      Insert (New (PListItem, Init ('icon', Main_Icon_Name) ) );
      Insert (New (PListItem, Init ('menu', Main_Menu_Name) ) );
      Insert (New (PListItem, Init ('idle', Idle_Process_Name) ) );
      Insert (New (PListItem, Init ('mf_check', TString1) ) );
      Insert (New (PListItem, Init ('dn_check', TString2) ) );
      Insert (New (PListItem, Init ('cl_check', TString3) ) );
      Insert (New (PListItem, Init ('ip_check', TString4) ) );
    End;

    StrPCopy (@TChar, 'misc.dat');
    MyFile. Init (@TChar, stCreate, 1024);
    MyFile. Put (Misc_Coll);
    MyFile. Done;
  End;
End;
{********************************************************}
{ Code for Main Files Dialog Box procedures              }
{********************************************************}
Procedure TMain_Files. WMInitDialog (Var Msg: TMessage);
Var
  SelectedText : Array[1..20] of Char;
Begin
  Inherited SetupWindow;
  StrPCopy(@SelectedText, Main_Path_Name);
  SendDlgItemMsg (dlg_mf_base_dir, wm_SetText, 0, LongInt (@SelectedText) );
  StrPCopy(@SelectedText, RC_File_Name);
  SendDlgItemMsg (dlg_mf_rc_name, wm_SetText, 0, LongInt (@SelectedText) );
  StrPCopy(@SelectedText, Const_File_Name);
  SendDlgItemMsg (dlg_mf_const_name, wm_SetText, 0, LongInt (@SelectedText) );
  StrPCopy(@SelectedText, Main_Icon_Name);
  SendDlgItemMsg (dlg_mf_icon_name, wm_SetText, 0, LongInt (@SelectedText) );
  StrPCopy(@SelectedText, Main_Menu_Name);
  SendDlgItemMsg (dlg_mf_menu_name, wm_SetText, 0, LongInt (@SelectedText) );
End;

Procedure TMain_Files. Get_Base_Dir (Var Msg: TMessage);
VAR
  SelectedText : Array [0..80] Of Char;
Begin
  If Msg. LParamHi = EN_SETFOCUS Then
  Begin
    StrPCopy(@SelectedText, Main_Path_Name + '\*.dir');
    SendDlgItemMsg (dlg_mf_combo_box, LB_RESETCONTENT, 0, 0 );
    Main_File_Sel := Path_Name;
    DlgDirList(HWindow, @SelectedText, dlg_mf_combo_box, 0, $0010);
  End;
End;

Procedure TMain_Files. Get_RC_Name (Var Msg: TMessage);
VAR
  SelectedText : Array [0..40] Of Char;
  TString : String;
Begin
  If Msg. LParamHi = EN_SETFOCUS Then
  Begin
    SendDlgItemMsg (dlg_mf_combo_box, LB_RESETCONTENT, 0, 0 );
    StrPCopy (@SelectedText, '*.RC');
    Main_File_Sel := RC_Name;
    SendDlgItemMsg (dlg_mf_combo_box, LB_DIR, 0, LongInt (@SelectedText) );
  End;
End;

Procedure TMain_Files. Get_Const_Name (Var Msg: TMessage);
VAR
  SelectedText : Array [0..40] Of Char;
Begin
  If Msg. LParamHi = EN_SETFOCUS Then
  Begin
    SendDlgItemMsg (dlg_mf_combo_box, LB_RESETCONTENT, 0, 0 );
    StrPCopy (@SelectedText, '*.pas');
    Main_File_Sel := Const_Name;
    SendDlgItemMsg (dlg_mf_combo_box, LB_DIR, 0, LongInt (@SelectedText) );
  End;
End;

Procedure TMain_Files. Get_Menu_Name (Var Msg: TMessage);
VAR
  SelectedText : Array [0..20] Of Char;
Begin
  If Msg. LParamHi = EN_SETFOCUS Then
  Begin
    SendDlgItemMsg (dlg_mf_combo_box, LB_RESETCONTENT, 0, 0 );
  End;
End;

Procedure TMain_Files. Get_Icon_Name (Var Msg: TMessage);
VAR
  SelectedText : Array [0..20] Of Char;
Begin
  If Msg. LParamHi = EN_SETFOCUS Then
  Begin
    SendDlgItemMsg (dlg_mf_combo_box, LB_RESETCONTENT, 0, 0 );
  End;
End;

Procedure TMain_Files. Get_List_Data (Var Msg: TMessage);
VAR
  Idx: Integer;
  SelectedText : Array [0..80] Of Char;
  TString1, TString2 : String;
  i, j : Integer;
Begin
  If Msg. LParamHi = LBN_DBLCLK Then
  Begin
    Idx := SendDlgItemMsg (dlg_mf_combo_box, lb_GetCurSel, 0, LongInt (0) );
    SendDlgItemMsg (dlg_mf_combo_box, lb_GetText, Idx, LongInt (@SelectedText) );
    case Main_File_Sel of
      Path_Name:
      Begin
        TString1 := StrPas (@SelectedText);
        if TString1 = '[..]' Then
        Begin
          i := Length(Main_Path_Name);
          While Main_Path_Name[i] <> '\' Do
            Dec(i);
          TString2 := '';
          For j := 1 to i - 1 Do
            TString2 := TString2 + Main_Path_Name[j];
          Main_Path_Name := TString2;
        End
        Else
        Begin
          TString2 := '\';
          for i := 2 to Length(TString1) - 1 Do
            TString2 := TString2 + TString1[i];
          Main_Path_Name := Main_Path_Name + TString2;
        End;
        TString1 := Main_Path_Name + '\*.dir';
        StrPCopy(@SelectedText, TString1);
        DlgDirList(HWindow, @SelectedText, dlg_mf_combo_box, 0, $0010);
        StrPCopy(@SelectedText, Main_Path_Name);
        SendDlgItemMsg (dlg_mf_base_dir, wm_SetText, 0, LongInt (@SelectedText) );
      End;
      RC_Name:
        SendDlgItemMsg (dlg_mf_rc_name, wm_SetText, 0, LongInt (@SelectedText) );
      Const_Name:
        SendDlgItemMsg (dlg_mf_const_name, wm_SetText, 0, LongInt (@SelectedText) );
      Icon_Name:
        SendDlgItemMsg (dlg_mf_icon_name, wm_SetText, 0, LongInt (@SelectedText) );
    End;
  End;
End;

Procedure TMain_Files. MfCancel (Var Msg: TMessage);
Begin
  TMain_Files.EndDlg(1);
End;

Procedure TMain_Files. MfDone (Var Msg: TMessage);
Var
  Idx: Integer;
  SelectedText: Array [0..61] Of Char;
  Im_Done : Boolean;
  TString : String;
Begin
  Im_Done := True;
  SendDlgItemMsg (dlg_mf_rc_name, wm_GetText, Idx, LongInt (@SelectedText) );
  RC_File_Name := StrPas (@SelectedText);
  if(RC_File_Name = '') then Im_Done := False;
  TString := '   ';
  TString[1] := RC_File_Name [Length(RC_File_Name) - 2];
  TString[2] := RC_File_Name [Length(RC_File_Name) - 1];
  TString[3] := RC_File_Name [Length(RC_File_Name)];
  if TString <> '.rc' then
    RC_File_Name := RC_File_Name + '.rc';

  SendDlgItemMsg (dlg_mf_const_name, wm_GetText, Idx, LongInt (@SelectedText) );
  Const_File_Name := StrPas (@SelectedText);
  if(Const_File_Name = '') then Im_Done := False;
  TString := '    ';
  TString[1] := Const_File_Name [Length(Const_File_Name) - 3];
  TString[2] := Const_File_Name [Length(Const_File_Name) - 2];
  TString[3] := Const_File_Name [Length(Const_File_Name) - 1];
  TString[4] := Const_File_Name [Length(Const_File_Name)];
  if TString <> '.pas' then
    Const_File_Name := Const_File_Name + '.pas';

  SendDlgItemMsg (dlg_mf_icon_name, wm_GetText, Idx, LongInt (@SelectedText) );
  Main_Icon_Name := StrPas (@SelectedText);
  if(Main_Icon_Name = '') then Im_Done := False;

  SendDlgItemMsg (dlg_mf_menu_name, wm_GetText, Idx, LongInt (@SelectedText) );
  Main_Menu_Name := StrPas (@SelectedText);
  if(Main_Menu_Name = '') then Im_Done := False;

  if Im_Done then
    TMain_Files.EndDlg(0)
  else
    MessageBox (HWindow, 'All fields must be completed', 'OOPS!', mb_Ok);
End;

Procedure TMain_Files. Do_dlg_mf_help (Var Msg: TMessage);
Begin
  DragDC := GetDC(HWindow);
  WinHelp(HWindow, 'ProGen.hlp', help_context, dlg_mf_help);
End;

{********************************************************}
{ Code for Dialog/Unit Dialog Box procedures             }
{********************************************************}
Procedure TDialog_Unit. WMInitDialog (Var Msg: TMessage);
Begin
  Inherited SetupWindow;
  TDialog_Unit. DULoad (Msg);
End;

Procedure TDialog_Unit. DUEnter (Var Msg: TMessage);
Var
  Idx: Integer;
  SelectedText: Array [0..61] Of Char;
  TString1, TString2 : String;
  TString4, TString5 : String;
  i : Integer;
Begin
  SendDlgItemMsg (dlg_dialog_dlg, wm_GetText, Idx, LongInt (@SelectedText) );
  TString1 := StrPas(@SelectedText);
  TString2 := '';
  for i := 1 to Length(TString1) -2 Do
    TString2 := TString2 + TString1[i + 2];
  SendDlgItemMsg (dlg_dialog_unit, wm_GetText, Idx, LongInt (@SelectedText) );
  TString1 := StrPas(@SelectedText);
  if(TString2 <> '') AND (TString1 <> '') AND (Length(TString1) < 9) Then
  Begin
    FoundItem := nil;
    If SearchList(Dialog_Coll, TString2) Then
    Begin
      Dialog_Coll^. Free(FoundItem); { Delete old version }

      With Dialog_Coll^ Do
      Begin
        Insert (New (PListItem, Init (TString2, TString1) ) );
      End;
    End;
    TDialog_Unit. DULoad(Msg);
  End;
  If (Length(TString1) > 8) Then
    MessageBox (HWindow, 'Unit name must be less then 8 characters.', 'OOPS!', mb_Ok);
End;

Procedure TDialog_Unit. DUClear (Var Msg: TMessage);
Var
  Idx: Integer;
  SelectedText: Array [0..61] Of Char;
  TString1, TString2 : String;
  i : Integer;
Begin
  SendDlgItemMsg (dlg_dialog_dlg, wm_GetText, Idx, LongInt (@SelectedText) );
  TString1 := StrPas(@SelectedText);
  TString2 := '';
  for i := 1 to Length(TString1) -2 Do
    TString2 := TString2 + TString1[i + 2];
  if(TString2 <> '') AND (TString1 <> '') Then
  Begin
    FoundItem := nil;
    If SearchList(Dialog_Coll, TString2) Then
    Begin
      Dialog_Coll^. Free (FoundItem); { Delete old version }
      With Dialog_Coll^ Do
      Begin
        Insert (New (PListItem, Init (TString2, ' ') ) );
      End;
    End;
    TDialog_Unit. DULoad(Msg);
  End;
End;

Procedure TDialog_Unit. DULoad (Var Msg: TMessage);
  Procedure CallGetDisp (P : PListItem); Far;
  Var
    TextItem : Array [0..80] Of Char;
    TString1, TString2 : String;
  Begin
    TString1 := P^. GetDisp;
    if (TString1 <> 'Close_Dialog*') And (TString1 <> 'End_Program*') And
       (TString1 <> 'Help_Directory*') And (TString1 <> 'Help_Topic*') AND
       (TString1 <> 'Edit_Box*') Then
    Begin
      TString2 := P^. GetLink;
      If TString2 = ' ' Then
        StrPCopy (@TextItem, '  ' + TString1)
      Else
        StrPCopy (@TextItem, '* ' + TString1);
      SendDlgItemMsg (dlg_dialog_dlg, cb_AddString, 0, LongInt (@TextItem) );
    End;
  End;
VAR
  SelectedText : Array[1..8] of Char;
Begin
  if Dialog_Coll <> nil Then
  Begin
    SendDlgItemMsg (dlg_dialog_dlg, cb_resetcontent, 0, 0);
    Dialog_Coll^. ForEach (@CallGetDisp);
    StrPCopy(@SelectedText, '');
    SendDlgItemMsg (dlg_dialog_unit, wm_SetText, 0, LongInt (@SelectedText) );
  end;
End;

Procedure TDialog_Unit. DUFocus (Var Msg: TMessage);
VAR
  Idx: Integer;
  SelectedText : Array [0..80] Of Char;
  TString1, TString2 : String;
  i : Integer;
Begin
  If Msg. LParamHi = LBN_DBLCLK Then
  Begin
    SendDlgItemMsg (dlg_dialog_dlg, wm_GetText, Idx, LongInt (@SelectedText) );
    TString1 := StrPas(@SelectedText);
    TString2 := '';
    for i := 1 to Length(TString1) -2 Do
      TString2 := TString2 + TString1[i + 2];
    if Dialog_Coll <> nil Then
    Begin
      FoundItem := nil;
      if SearchList(Dialog_Coll, TString2) Then
      Begin
        TString1 := FoundItem^. Getlink;
        StrPCopy(@SelectedText, TString1);
        SendDlgItemMsg (dlg_dialog_unit, wm_SetText, 0, LongInt (@SelectedText) );
      End;
    End;
  End;
End;

Procedure TDialog_Unit. DUDone (Var Msg: TMessage);
VAR
  SelectedText : Array[1..8] of Char;
  NamesDone : BOOLEAN;
  Dupes : PList;

  Procedure CallGetDisp (P : PListItem); Far;
  Var
    TextItem : Array [0..80] Of Char;
    TString1, TString2 : String;
  Begin
    TString1 := P^. GetDisp;
    TString2 := P^. GetLink;
    If (TString1 <> 'End_Program*') And (TString1 <> 'Close_Dialog*') And
       (TString1 <> 'Help_Directory*') And ( TString1 <> 'Help_Topic*') AND
       ( TString1 <> 'Edit_Box*') Then
      If (TString2 <> 'End_Program*') And (TString2 <> 'Close_Dialog*') And
         (TString2 <> 'Help_Directory*') And ( TString2 <> 'Help_Topic*') AND
         ( TString2 <> 'Edit_Box*') Then
        If (TString1 = ' ') OR (TString2 = ' ') Then
          NamesDone := False;
  End;
  Procedure CallGetDupes (P : PListItem); Far;
  Var
    TextItem : Array [0..80] Of Char;
    TString : String;
  Begin
    TString := P^. GetLink;
    If (TString <> ' ') Then
    Begin
      With Dupes^ Do
      Begin
        Insert (New (PListItem, Init (TString,' ') ) );
      End;
    End;
  End;
Begin
  NamesDone := False;
  if Dialog_Coll <> nil Then
  Begin
    NamesDone := True;
    Dialog_Coll^. ForEach (@CallGetDisp);
  end;
  If Not NamesDone Then
    MessageBox (HWindow, 'All Dialog Boxes must have Unit Names', 'OOPS!', mb_Ok)
  Else If Dialog_Coll <> nil Then
  Begin
    Dupes := New (PList, Init (10, 5) );
    Dupes^. Duplicates := False;
    Dialog_Coll^. Foreach(@CallGetDupes);
    If (Dialog_Coll^. Count - 5) <> Dupes^. Count Then
    Begin
      MessageBox (HWindow, 'All Unit Names must be unique', 'OOPS!', mb_Ok);
      NamesDone := False;
    End;
    Dispose(Dupes, Done);
  End;
  If NamesDone Then
    TDialog_Unit.EndDlg(0)
End;

Procedure TDialog_Unit. DUCancel (Var Msg: TMessage);
Begin
  TDialog_Unit.EndDlg(1);
End;

Procedure TDialog_Unit. Do_dlg_dialog_help (Var Msg: TMessage);
Begin
  DragDC := GetDC(HWindow);
  WinHelp(HWindow, 'ProGen.hlp', help_context, dlg_dialog_help);
End;

{********************************************************}
{ Code for Control Link Selector Box procedures           }
{********************************************************}
Procedure TLink_Selector. WMInitDialog (Var Msg: TMessage);
Begin
End;

Procedure TLink_Selector. LSDialog (Var Msg: TMessage);
Var
  TString : STRING;
  Procedure CallGetDisp (P : PListItem); Far;
  Var
    Idx: Integer;
    SelectedText : Array [0..80] Of Char;
  Begin
    TString := P^. GetDisp;
    If (TString <> ' ') AND (TString[Length(TString)] <> '*')Then
    Begin
        strpcopy(@SelectedText, TString);
        SendDlgItemMsg (dlg_link_Sel_Box, cb_AddString, 0, LongInt (@SelectedText) );
    End;
  End;
Begin
  LinkSel := DialogType;
  Dialog_Coll^. ForEach (@CallGetDisp);
End;

Procedure TLink_Selector. LSMenu (Var Msg: TMessage);
Begin
  LinkSel := MenuType;
  SendDlgItemMsg (dlg_link_sel_Box, CB_RESETCONTENT, 0, 0 );
End;

Procedure TLink_Selector. LSBox (Var Msg: TMessage);
Begin
End;

Procedure TLink_Selector. LSOK (Var Msg: TMessage);
Var
  Idx: Integer;
  SelectedText : Array [0..80] Of Char;
  TString : STRING;
Begin
  If LinkSel = DialogType Then
  Begin
    SendDlgItemMsg (dlg_link_Sel_Box, wm_GetText, Idx, LongInt (@SelectedText) );
    TString  := StrPas (@SelectedText);
    If(TString <> '') Then
    Begin
      SelectedDialog := 'DLG: ' + TString;
      Application^. ExecDialog (New (PControl_Links, Init (Nil, 'Control_Links') ) );
    End;
  End
  Else
  Begin
      SelectedDialog := 'Menu Items';
      Application^. ExecDialog (New (PControl_Links, Init (Nil, 'Control_Links') ) );
  End;
End;

Procedure TLink_Selector. LSDone (Var Msg: TMessage);
Begin
  EndDlg(0);
End;

Procedure TLink_Selector. LSHelp (Var Msg: TMessage);
Begin
  DragDC := GetDC(HWindow);
  WinHelp(HWindow, 'ProGen.hlp', help_context, dlg_ctrl_links_help);
End;

{********************************************************}
{ Code for Control Links Dialog Box procedures           }
{********************************************************}
Procedure TControl_Links. WMInitDialog (Var Msg: TMessage);
Var
  SelectedText : Array[1..20] of Char;
Begin
  Inherited SetupWindow;
  StrPCopy(@SelectedText, SelectedDialog);
  SendDlgItemMsg (dlg_ctrl_links_SelectedDialog, wm_SetText, 0, LongInt (@SelectedText) );
  TControl_Links. LoadDisp(Msg);
End;

Procedure TControl_Links. CLEnter (Var Msg: TMessage);
Var
  Idx: Integer;
  SelectedText: Array [0..61] Of Char;
  TString1, TString2, TString3 : String;
  TString4, TString5 : String;
  i : Integer;
Begin
  SendDlgItemMsg (dlg_ctrl_links_controls, wm_GetText, Idx, LongInt (@SelectedText) );
  TString1 := StrPas(@SelectedText);
  TString2 := '';
  for i := 1 to Length(TString1) -2 Do
    TString2 := TString2 + TString1[i + 2];
  SendDlgItemMsg (dlg_ctrl_links_link, wm_GetText, Idx, LongInt (@SelectedText) );
  TString1 := StrPas(@SelectedText);
  TString3 := '';
  for i := 1 to Length(TString1) -2 Do
    TString3 := TString3 + TString1[i + 2];
  if(TString2 <> '') AND (TString3 <> '') Then
  Begin
    FoundItem := nil;
    If SearchList(Controls_Coll, TString2) Then
    Begin
      Repeat
        Controls_Coll^. Free(FoundItem); { Delete old version }
        FoundItem := nil;
      Until Not (SearchList(Controls_Coll, TString2));
      With Controls_Coll^ Do
      Begin
        Insert (New (PListItem, Init (TString2, TString3) ) );
      End;
    End;
    If SearchList(MenuItem_Coll, TString2) Then
    Begin
      Repeat
        MenuItem_Coll^. Free(FoundItem); { Delete old version }
        FoundItem := nil;
      Until Not (SearchList(MenuItem_Coll, TString2));
      With MenuItem_Coll^ Do
      Begin
        Insert (New (PListItem, Init (TString2, TString3) ) );
      End;
    End;
    TControl_Links. LoadDisp(Msg);
  End
  Else
    TString1 := TString1;
End;

Procedure TControl_Links. LoadDisp (Var Msg: TMessage);
Var
  Temp_ID : Integer;
  Temp_Coll : PList;
  TString : String;
  Temp_SID : String;
  Found : Boolean;
  TempLink : String;

  Procedure CallGetDisp (P : PListItem); Far;
  Var
    TextItem : Array [0..80] Of Char;
    TString, TString1 : String;
  Begin
    TString := P^. GetDisp;
    TString1 := P^. GetLink;
    if TString1 = ' ' Then
      StrPCopy (@TextItem, '  ' + TString)
    Else
      StrPCopy (@TextItem, '* ' + TString);
    SendDlgItemMsg (Temp_ID, cb_AddString, 0, LongInt (@TextItem) );
  End;
Begin
  if(Dialog_Coll <> nil) AND (Controls_Coll <> nil) Then
  Begin
    SendDlgItemMsg (dlg_ctrl_links_controls, CB_RESETCONTENT, 0, 0 );
    SendDlgItemMsg (dlg_ctrl_links_link, CB_RESETCONTENT, 0, 0 );
    If LinkSel = DialogType Then
    Begin
      Temp_Coll := New (PList, Init (10, 5) );
      Temp_Coll^. Duplicates := False;
      Temp_ID := dlg_ctrl_links_controls;

      Assign(Infile, RC_File_Name);
      Reset(Infile);
      While Not EOF(Infile) Do
      Begin
        ReadLn(Infile, TString);
        Temp_SID := Get_Id(TString, DIALOG);
        if (Temp_SID <> '') AND ('DLG: ' + Temp_SID = SelectedDialog) Then
        Begin
          TString := '';
          While (TString <> 'BEGIN') AND Not EOF(Infile) Do
            ReadLn(Infile, TString);
          While (TString <> 'END') AND Not EOF(Infile) Do
          Begin
            ReadLn(Infile, TString);
            Temp_SID := Get_Id(TString, CONTROL);
            If Get_ID_Second_Param <> '-1' Then
            Begin
              Found := SearchList(Controls_Coll, Get_ID_Second_Param);
              if (Found) And (FoundItem^. GetLink <> ' ') Then
              Begin
                TempLink := FoundItem^. GetLink;
                With Temp_Coll^ Do
                Begin
                  Insert (New (PListItem, Init (Get_ID_Second_Param, TempLink) ) );
                End;
              End
              Else
              With Temp_Coll^ Do
              Begin
                Insert (New (PListItem, Init (Get_ID_Second_Param, ' ') ) );
              End
            End;
            Temp_SID := Get_Id(TString, PUSHBUTTON);
            If Get_ID_Second_Param <> '-1' Then
            Begin
              Found := SearchList(Controls_Coll, Get_ID_Second_Param);
              if (Found) And (FoundItem^. GetLink <> ' ') Then
              Begin
                TempLink := FoundItem^. GetLink;
                With Temp_Coll^ Do
                Begin
                  Insert (New (PListItem, Init (Get_ID_Second_Param, TempLink) ) );
                End;
              End
              Else
              With Temp_Coll^ Do
              Begin
                Insert (New (PListItem, Init (Get_ID_Second_Param, ' ') ) );
              End;
            End;
            Temp_SID := Get_Id(TString, EDITTEXT);
            If (Temp_SID <> '-1') AND (Temp_SID <> '') Then
            Begin
              Found := SearchList(Controls_Coll, Temp_SID);
              if (Found) And (FoundItem^. GetLink <> ' ') Then
              Begin
                TempLink := FoundItem^. GetLink;
                With Temp_Coll^ Do
                Begin
                  Insert (New (PListItem, Init (Temp_SID, TempLink) ) );
                End;
              End
              Else
              With Temp_Coll^ Do
              Begin
                Insert (New (PListItem, Init (Temp_SID, ' ') ) );
              End;
            End;
          End;
        End;
      End;
      Close(Infile);
      Temp_Coll^. ForEach (@CallGetDisp);
      Dispose(Temp_Coll, Done);
      Temp_ID := dlg_ctrl_links_link;
      Dialog_Coll^. ForEach (@CallGetDisp);
    End
    Else
    Begin
      Temp_ID := dlg_ctrl_links_controls;
      MenuItem_Coll^. ForEach (@CallGetDisp);
      Temp_ID := dlg_ctrl_links_link;
      Dialog_Coll^. ForEach (@CallGetDisp);
    End;
  End;
End;

Procedure TControl_Links. CLClear (Var Msg: TMessage);
Var
  Idx: Integer;
  SelectedText: Array [0..61] Of Char;
  TString1, TString2 : String;
  i : Integer;
Begin
  SendDlgItemMsg (dlg_ctrl_links_controls, wm_GetText, Idx, LongInt (@SelectedText) );
  TString1 := StrPas(@SelectedText);
  TString2 := '';
  for i := 1 to Length(TString1) -2 Do
    TString2 := TString2 + TString1[i + 2];
  SendDlgItemMsg (dlg_ctrl_links_link, wm_GetText, Idx, LongInt (@SelectedText) );
  TString1 := StrPas(@SelectedText);
  FoundItem := nil;
  If SearchList(Controls_Coll, TString2) Then
  Begin
    Repeat
      Controls_Coll^. Free(FoundItem); { Delete old version }
      FoundItem := nil;
    Until Not (SearchList(Controls_Coll, TString2));
    With Controls_Coll^ Do
    Begin
      Insert (New (PListItem, Init (TString2, ' ') ) );
    End;
  End;
  TControl_Links. LoadDisp(Msg);
End;

Procedure TControl_Links. CLFocus (Var Msg: TMessage);
VAR
  Idx: Integer;
  SelectedText : Array [0..80] Of Char;
  TString1, TString2 : String;
  i : Integer;
Begin
  If Msg. LParamHi = LBN_DBLCLK Then
  Begin
    SendDlgItemMsg (dlg_ctrl_links_controls, wm_GetText, Idx, LongInt (@SelectedText) );
    TString1 := StrPas(@SelectedText);
    TString2 := '';
    for i := 1 to Length(TString1) -2 Do
      TString2 := TString2 + TString1[i + 2];
    if Controls_Coll <> nil Then
    Begin
      FoundItem := nil;
      if SearchList(Controls_Coll, TString2) Then
      Begin
        TString1 := FoundItem^. Getlink;
        StrPCopy(@SelectedText, TString1);
        SendDlgItemMsg (dlg_ctrl_links_link, wm_SetText, 0, LongInt (@SelectedText) );
      End;
    End;
  End;
End;

Procedure TControl_Links. CLDone (Var Msg: TMessage);
Begin
  TControl_Links.EndDlg(0);
End;

Procedure TControl_Links. Do_dlg_ctrl_links_help (Var Msg: TMessage);
Begin
  DragDC := GetDC(HWindow);
  WinHelp(HWindow, 'ProGen.hlp', help_context, dlg_ctrl_links_help);
End;

{********************************************************}
{ Code for Idle Process Name                             }
{********************************************************}
Procedure TIdle_Name. WMInitDialog (Var Msg: TMessage);
Var
  Idx: Integer;
  SelectedText: Array [0..61] Of Char;
Begin
  Inherited SetupWindow;
  StrPCopy(@SelectedText, Idle_Process_Name);
  SendDlgItemMsg (dlg_idle_name_box, wm_SetText, Idx, LongInt (@SelectedText) );
End;

Procedure TIdle_Name. INCancel (Var Msg: TMessage);
Begin
  TIdle_Name.EndDlg(1);
End;

Procedure TIdle_Name. INDone (Var Msg: TMessage);
Var
  Idx: Integer;
  SelectedText: Array [0..61] Of Char;
  TString : String;
Begin
  SendDlgItemMsg (dlg_idle_name_box, wm_GetText, Idx, LongInt (@SelectedText) );
  TString := StrPas (@SelectedText);
  If TString <> '' then
  Begin
    Idle_Process_Name := TString;
    TIdle_Name.EndDlg(0)
  End
  else
    MessageBox (HWindow, 'Name Box not filled', 'OOPS!', mb_Ok);
End;

Procedure TIdle_Name. Do_dlg_idle_name_help (Var Msg: TMessage);
Begin
  DragDC := GetDC(HWindow);
  WinHelp(HWindow, 'ProGen.hlp', help_context, dlg_idle_name_help);
End;

{********************************************************}
{ Code for Read Data Dialog Box procedures               }
{********************************************************}
Procedure TRead_Data. WMInitDialog (Var Msg: TMessage);
VAR
 i : Integer;
 TString : String;
 Temp_ID : String;
 NewString : String;
 OK_To_Process : Boolean;
Begin
  Inherited SetupWindow;
  if Not (FileStarted Or FileLoaded) Then
  Begin
    Dialog_Coll := New (PList, Init (10, 5) );
    Dialog_Coll^. Duplicates := False;
    MenuItem_Coll := New (PList, Init (10, 5) );
    MenuItem_Coll^. Duplicates := False;
    Controls_Coll := New (PList, Init (10, 5) );
    Controls_Coll^. Duplicates := False;
    Misc_Coll := New (PList, Init (10, 5) );
    Misc_Coll^. Duplicates := False;
    FileStarted := True;
  end
  else If Not FileLoaded Then
  Begin
    Dialog_Coll^. Clearlist;
    MenuItem_Coll^. Clearlist;
    Controls_Coll^. Clearlist;
    Misc_Coll^. Clearlist;
  End;
  OK_To_Process := True;
  If Not (FileExist(RC_File_Name)) Then
    OK_To_Process := False;
  If Not (FileExist(Const_File_Name)) Then
    OK_To_Process := False;

  If OK_To_Process Then
  Begin
    Assign(Infile, RC_File_Name);
    Reset(Infile);
    While Not EOF(Infile) Do
    Begin
      ReadLn(Infile, TString);
      Temp_ID := Get_Id(TString, MENUITEM);
      if Temp_Id <> '' Then
      Begin
        If Not (SearchList(MenuItem_Coll, Temp_ID)) Then
        Begin
          With MenuItem_Coll^ Do
          Begin
            Insert (New (PListItem, Init (Temp_ID, ' ') ) );
          End;
        End;
      End;
      Temp_ID := Get_Id(TString, DIALOG);
      if Temp_Id <> '' Then
      Begin
        If Not (SearchList(Dialog_Coll, Temp_ID)) Then
        Begin
          With Dialog_Coll^ Do
          Begin
            Insert (New (PListItem, Init (Temp_ID, ' ') ) );
          End;
        End;
      End;
    End;
    If Not (SearchList(Dialog_Coll, 'Close_Dialog*')) Then
    Begin
      With Dialog_Coll^ Do
      Begin
        Insert (New (PListItem, Init ('Close_Dialog*', ' ') ) );
        Insert (New (PListItem, Init ('End_Program*', ' ') ) );
        Insert (New (PListItem, Init ('Help_Directory*', ' ') ) );
        Insert (New (PListItem, Init ('Help_Topic*', ' ') ) );
        Insert (New (PListItem, Init ('Edit_Box*', ' ') ) );
      End;
    End;
    Close(InFile);
    Assign(Infile, Const_File_Name);
    Reset(Infile);
    TString := '';
    While (Not EOF(Infile)) AND (TString <> 'const') Do
      ReadLn(Infile, TString);
    ReadLn(Infile, TString);
    While Not EOF(Infile) Do
    Begin
      ReadLn(Infile, TString);
      i := 2;
      NewString := '';
      while (i < Length(TString)) AND (Ord(TString[i]) <> 9) and (TString[i] <> ' ')Do
      Begin
        NewString := NewString + TString[i];
        Inc(i)
      End;
      if (NewString <> 'mplementatio') AND (NewString <> '') AND (NewString <> 'nd') Then
      Begin
        If Not (SearchList(Controls_Coll, NewString)) Then
        Begin
          With Controls_Coll^ Do
          Begin
            Insert (New (PListItem, Init (NewString, ' ') ) );
          End;
        End;
      End;
    End;
    Close(InFile);
  End
  Else
    MessageBox (HWindow, 'File Missing', 'OOPS!', mb_Ok);
  TRead_Data.EndDlg(0);
End;

{********************************************************}
{ Code for Code Genned Dialog Box procedures             }
{********************************************************}
Procedure TCode_Genned. WMInitDialog (Var Msg: TMessage);
Var
  TString : String;
  SelectedText : Array[1..10] of Char;
  Infile : TEXT;
  Procedure CallLineGen (P : PListItem); Far;
  Var
    TextItem : Array [0..80] Of Char;
    FileName, TString : String;
    InFile : Text;
  Begin
    FileName := P^. GetLink;
    If FileName <> ' ' Then
    Begin
      FileName := FileName +  + '.pas';
      TString := P^. GetDisp;
      Assign(InFile, FileName);
      Reset(Infile);
      While NOT EOF(Infile) DO
      Begin
        Readln(Infile, TString);
        Inc(Line_Count);
      End;
      Close(Infile);
    End;
  End;
Begin
  Inherited SetupWindow;
  Line_Count := 0;
  Assign(Infile, RC_File_Short + '.pas');
  Reset(Infile);
  While NOT EOF(Infile) Do
  Begin
    Readln(Infile, TString);
    Inc(Line_Count);
  End;
  Close(Infile);
  If BuildStyle = Split Then
  Begin
    Dialog_Coll^. Foreach(@CallLineGen);
  End;
  Str(Line_Count, TString);
  StrPCopy(@SelectedText, TString);
  SendDlgItemMsg (dlg_code_gen_lines, wm_SetText, 0, LongInt (@SelectedText) );
End;

Procedure TCode_Genned. CGOk (Var Msg: TMessage);
Begin
  TCode_Genned. EndDlg(0);
End;

{**********************************************************************}
{                 Define the List Item Procedures                      }
{**********************************************************************}
Constructor TListItem. Init (NewItem, NewLink: String);
Begin
  DispItem := NewStr (NewItem);
  Link := NewStr (NewLink);
End;

Destructor TListItem. Done;
Begin
  DisposeStr (DispItem);
  DisposeStr (Link);
End;

Function TListItem. GetDisp: String;
Begin
  GetDisp := DispItem^;
End;

Function TListItem. GetLink: String;
Begin
  GetLink := Link^;
End;

Constructor TListItem. Load (Var S: TBufStream);
Var
  DString : String [80];
  LString: String [80];
Begin
  S. Read (DString, SizeOf (DString) );
  DispItem := NewStr (DString);
  S. Read (LString, SizeOf (LString) );
  Link := NewStr (LString);
End;

Procedure TListItem. Store (Var S: TBufStream);
Var
  DString : String [80];
  LString : String [80];
Begin
  DString := DispItem^;
  LString := Link^;
  S. Write (DString, SizeOf (DString) );
  S. Write (LString, SizeOf (LString) );
End;
{**********************************************************************}
{                 Define the List Procedures                           }
{**********************************************************************}
Procedure TList. ClearList;
Begin
  Inherited FreeAll;
End;

Function TList. KeyOf (Item: Pointer): Pointer;
Begin
  KeyOf := PListItem (Item)^. Dispitem;
End;

Function TList. Compare (Key1, Key2: Pointer): Integer;
Begin
  If PString (Key1)^ = PString (Key2)^ Then
    Compare := 0
  Else If PString (Key1)^ < PString (Key2)^ Then
    Compare := -1
  Else
    Compare := 1;
End;

{********************************************************}
{ Misc. Procedures/Functions                             }
{********************************************************}
Function Get_ID(Instring: String; Item: Search_Type):String;
VAR
  i : Integer;
  p : PChar;
  TString1 : String;
  InPChar, FoundPChar : Array [0..61] Of Char;
Begin
  StrPCopy (@InPChar, InString);
  TString1 := '';
  Get_ID_Second_Param := '-1';
  Case Item of
    Dialog: StrPCopy (@FoundPChar, 'DIALOG');
    Menuitem: StrPCopy (@FoundPChar, 'MENUITEM');
    Control: StrPCopy (@FoundPChar, 'CONTROL');
    Pushbutton: StrPCopy (@FoundPChar, 'BUTTON');
    EditText: StrPCopy (@FoundPChar, 'EDITTEXT');
  End;
  p := StrPos (@InPChar, @FoundPChar);
  if p <> nil Then
  Begin
    case Item of
    Menuitem:
      Begin
        i := 1;
        while (Instring[i] <> '"') AND (i < Length(Instring)) Do Inc(i);
        Inc(i);
        While (Instring[i] <> '"') AND (i < Length(Instring)) Do
        Begin
          TString1 := TString1 + Instring[i];
          Inc(i);
        End;
        While (Instring[i] <> ' ') And (i <= Length(Instring)) Do
          Inc(i);
        Inc(i);
        Get_ID_Second_Param := '';
        While (Instring[i] <> ' ') And (i <= Length(Instring)) Do
        Begin
          Get_ID_Second_Param := Get_ID_Second_Param + Instring[i];
          Inc(i);
        End;
        TString1 := Get_ID_Second_Param;
      End;
    Control, PushButton:
      Begin
        i := 1;
        while (Instring[i] <> '"') AND (i < Length(Instring)) Do Inc(i);
        Inc(i);
        While (Instring[i] <> '"') AND (i < Length(Instring)) Do
        Begin
          TString1 := TString1 + Instring[i];
          Inc(i);
        End;
        While (Instring[i] <> ' ') And (i <= Length(Instring)) Do
          Inc(i);
        Inc(i);
        Get_ID_Second_Param := '';
        While (Instring[i + 1] <> ' ') And (i <= Length(Instring) + 1) Do
        Begin
          Get_ID_Second_Param := Get_ID_Second_Param + Instring[i];
          Inc(i);
        End;
      End;
    Dialog:
      Begin
        StrPCopy (@FoundPChar, '"');
        p := StrPos (@InPChar, @FoundPChar);
        if p = nil Then
        Begin
          i := 1;
          While Instring[i] <> ' ' Do
          Begin
            TString1 := TString1 + Instring[i];
            Inc(i);
          End;
        End;
      End;
    EditText:
      Begin
        i := 2;
        While InString[i] <> ' ' Do
          Inc(i);
        Inc(i);
        While InString[i] <> ',' Do
        Begin
          TString1 := TString1 + InString[i];
          Inc(i);
        End;
      End;
    End; {Case}
  End;
  Get_ID := TString1;
End;

Procedure DoMainHeader(InType: FileType);
Var
  TString1, TString2,String3 : String;
  i : Integer;
Begin
  Assign(TypeFile, 'types.tmp');
  Rewrite(TypeFile);
  Writeln(TypeFile, Memo_Line);
  Writeln(TypeFile, '{ Source code generated by Pro-Gen for ' + RC_File_Name);
  Writeln(TypeFile, '{');
  Writeln(TypeFile, '{ Just think how much time you just saved!!!');
  Writeln(TypeFile, Memo_Line);
  Writeln(TypeFile, '');
  i := 1;
  RC_File_Short := '';
  While (RC_File_name[i] <> '.') And (i < Length(RC_File_Name)) Do
  Begin
    RC_File_Short := RC_File_Short + RC_File_Name[i];
    Inc(i);
  End;
  RC_File_Short[1] := UpCase(RC_File_Short[1]);
  TString2 := 'Program ' + RC_File_Short + ';';
  Writeln(TypeFile, TString2);
  Writeln(TypeFile, '');
  i := 1;
  TString2 := '';
  While (Const_File_Name[i] <> '.') And (i < Length(Const_File_Name)) Do
  Begin
    TString2 := TString2 + Const_File_Name[i];
    Inc(i);
  End;
  Const_File_Name := TString2;
  If InType = Split Then
    TString2 := Use_Line + TString2 + ','
  Else
    TString2 := Use_Line + TString2 + ';';
  Writeln(TypeFile, TString2);
End;

Procedure DoSecondHeader;
Var
  TString1, TString2, TString3, TString4 : String;

  Procedure CallGetDisp (P : PListItem); Far;
  Var
    TextItem : Array [0..80] Of Char;
    Found : Boolean;
  Begin
    TString1 := P^. GetDisp;
    FoundItem := nil;
    Found := SearchList(Controls_Coll, TString1);
    if (Found) And (FoundItem^. GetLink <> ' ') Then
    Begin
    TString2 := '    Procedure Do_' + TString1;
    TString2 := TString2 + ' (Var Msg: TMessage); Virtual cm_First + ' + TString1 + ';';
    Writeln(TypeFile, TString2);
      TString3 := FoundItem^. GetLink;
      TString4 := 'Procedure ' + RC_File_Short + 'Window. Do_' + TString1;
      TString4 := TString4 + ' (Var Msg: TMessage);';
      Writeln(CodeFile, TString4);
      Writeln(CodeFile, 'Begin');
      If TString3 = 'End_Program*' Then
        TString4 := '  Inherited Done;'
      Else If TString3 = 'Help_Directory*' Then
        TString4 := '  WinHelp(HWindow, ''' + RC_File_Short + '.hlp'', help_index, 0);'
      Else
        TString4 := '  Application^. ExecDialog (New (P'+ TString3 + ', Init (Nil, ''' + TString3 + ''') ) );';
      Writeln(CodeFile, TString4);
      Writeln(CodeFile, 'End;');
      Writeln(CodeFile, '');
    End;
  End;
Begin;
  TString1 := '{$R ' + RC_File_Short + '.res}';
  Writeln(TypeFile, TString1);
  Writeln(TypeFile, '');
  Writeln(TypeFile, Memo_Line);
  Writeln(TypeFile, '{ Type Definitions');
  Writeln(TypeFile, Memo_Line);
  Writeln(TypeFile, 'Type');
  Writeln(TypeFile, Memo_Line);
  Writeln(TypeFile, '{ Define a TApplication descendant');
  Writeln(TypeFile, Memo_Line);
  Writeln(TypeFile, '  P' + RC_File_Short + ' = Object (TApplication)');
  Writeln(TypeFile, '    Procedure InitMainWindow; Virtual;');
  If Idle_Checked Then
    Writeln(TypeFile, '    Procedure MessageLoop; Virtual;');
  Writeln(TypeFile, '  End;');
  Writeln(TypeFile, '');
  Writeln(TypeFile, Memo_Line);
  Writeln(TypeFile, '{ Define the main window');
  Writeln(TypeFile, Memo_Line);
  Writeln(TypeFile, '  P' + RC_File_Short + 'Window = ^' + RC_File_Short + 'Window;');
  Writeln(TypeFile, '  ' + RC_File_Short + 'Window = Object (TWindow)');
  Writeln(TypeFile, '    DragDC: HDC;');
  Writeln(TypeFile, '    Constructor Init (AParent: PWindowsObject; ATitle: PChar);');
  Writeln(TypeFile, '    Procedure SetupWindow; Virtual;');
  Writeln(TypeFile, '    Procedure GetWindowClass (Var AWndClass: TWndClass); Virtual;');
  Writeln(TypeFile, '    Procedure Paint(PaintDC: HDC; var PaintInfo: TPaintStruct); virtual;');
  Assign(CodeFile, 'Code.tmp');
  Rewrite(CodeFile);
  Writeln(CodeFile, Memo_Line);
  Writeln(CodeFile, '{ Code Section');
  Writeln(CodeFile, Memo_Line);
  Writeln(CodeFile, '');
  If Idle_Checked Then
    Writeln(CodeFile, 'Procedure ' + Idle_Process_Name + '; Forward;');
  Writeln(CodeFile, Memo_Line);
  Writeln(CodeFile, '{ Code for Main Window');
  Writeln(CodeFile, Memo_Line);
  Writeln(CodeFile, 'Constructor ' + RC_File_Short + 'Window. Init (AParent: PWindowsObject; ATitle: PChar);');
  Writeln(CodeFile, 'Begin');
  Writeln(CodeFile, '  Inherited Init (AParent, ATitle);');
  Writeln(CodeFile, '  Attr. Menu := LoadMenu (HInstance, ''' + Main_Menu_Name + ''');');
  Writeln(CodeFile, 'End;');
  Writeln(CodeFile, '');
  Writeln(CodeFile, 'Procedure ' + RC_File_Short + 'Window. GetWindowClass (Var AWndClass: TWndClass);');
  Writeln(CodeFile, 'Begin');
  Writeln(CodeFile, '  Inherited GetWindowClass (AWndClass);');
  Writeln(CodeFile, '  AWndClass. HIcon := LoadIcon (HInstance, ''' + Main_Icon_Name + ''');');
  Writeln(CodeFile, 'End;');
  Writeln(CodeFile, '');
  Writeln(CodeFile, 'Procedure ' + RC_File_Short + 'Window. SetupWindow;');
  Writeln(CodeFile, 'Begin');
  Writeln(CodeFile, '  Inherited SetupWindow;');
  Writeln(CodeFile, 'End;');
  Writeln(CodeFile, '');
  Writeln(CodeFile, 'Procedure ' + RC_File_Short + 'Window. Paint(PaintDC: HDC; var PaintInfo: TPaintStruct);');
  Writeln(CodeFile, 'Begin');
  Writeln(CodeFile, '  DragDC := GetDC(HWindow);');
  Writeln(CodeFile, '  ReleaseDC(HWindow,DragDC);');
  Writeln(CodeFile, 'End;');
  Writeln(CodeFile, '');
  MenuItem_Coll^. ForEach(@CallGetDisp);
  Writeln(TypeFile, '  End;');
  Writeln(TypeFile, '');
  Writeln(CodeFile, Memo_Line);
  Writeln(CodeFile, '{ Code for Application decendent');
  Writeln(CodeFile, Memo_Line);
  Writeln(CodeFile, 'Procedure P' + RC_File_Short + '. InitMainWindow;');
  Writeln(CodeFile, 'Begin');
  TString4 := '  MainWindow := New (P' + RC_File_Short + 'Window, Init (Nil, ''' + RC_File_Short + ''') );';
  Writeln(CodeFile, TString4);
  Writeln(CodeFile, 'End;');
  Writeln(CodeFile, '');
  If Idle_Checked Then
  Begin
    Writeln(CodeFile, 'Procedure P' + RC_File_Short + '. MessageLoop;');
    Writeln(CodeFile, 'Var');
    Writeln(CodeFile, '  Message: TMsg;');
    Writeln(CodeFile, 'Begin');
    Writeln(CodeFile, '  While True Do');
    Writeln(CodeFile, '  Begin');
    Writeln(CodeFile, '    If PeekMessage (Message, 0, 0, 0, pm_Remove) Then');
    Writeln(CodeFile, '    Begin');
    Writeln(CodeFile, '      If Message. Message = wm_Quit Then');
    Writeln(CodeFile, '      Begin');
    Writeln(CodeFile, '        Status := Message. WParam;');
    Writeln(CodeFile, '        Exit;');
    Writeln(CodeFile, '      End;');
    Writeln(CodeFile, '      If Not ProcessAppMsg (Message) Then');
    Writeln(CodeFile, '      Begin');
    Writeln(CodeFile, '        TranslateMessage (Message);');
    Writeln(CodeFile, '        DispatchMessage (Message);');
    Writeln(CodeFile, '      End;');
    Writeln(CodeFile, '    End');
    Writeln(CodeFile, '    Else');
    Writeln(CodeFile, '     ' + Idle_Process_Name + ';');
    Writeln(CodeFile, '  End;');
    Writeln(CodeFile, 'End;');
    Writeln(CodeFile, '');
  End;
End;

Procedure DoHelpFile;
Var
  TString1, TString2 : String;
  TString, NewString : String;
  i : Integer;
  HelpFile, TempFile : Text;

  Procedure GetHelpItem(HelpItem: PListitem);FAR;
  Var
    ImDone : Boolean;
    OK_To_Process : Boolean;
    HWindow: HWnd;
  Begin
    ImDone := False;
    TString1 := HelpItem^. GetDisp;
    TString2 := HelpItem^. GetLink;
    OK_To_Process := True;
    If Not (FileExist(Const_File_Name + '.pas')) Then
      OK_To_Process := False;
    If (TString2 = 'Help_Topic*') And OK_To_Process Then
    Begin
      Assign(Infile, Const_File_Name + '.pas');
      Reset(Infile);
      TString := '';
      While (Not EOF(Infile)) AND (TString <> 'const') Do
        ReadLn(Infile, TString);
      ReadLn(Infile, TString);
      While (Not EOF(Infile)) Or (Not ImDone) Do
      Begin
        ReadLn(Infile, TString);
        i := 2;
        NewString := '';
        while (i < Length(TString)) AND (Ord(TString[i]) <> 9) and (TString[i] <> ' ')Do
        Begin
          NewString := NewString + TString[i];
          Inc(i)
        End;
        if (NewString <> 'mplementatio') AND (NewString <> '') AND (NewString <> 'nd') Then
        Begin
          If TString1 = NewString Then
          Begin
            i := 2;
            While TString[i] <> '=' Do
              Inc(i);
            Inc(i, 2);
            NewString := '.map ' + TString1 + ' ';
            While TString[i] <> ';' Do
            Begin
              NewString := NewString + TString[i];
              Inc(i);
            End;
            ImDone := True;
            Writeln(HelpFile, NewString);
            Writeln(TempFile, '.topic ' + TString1+ ',' + TString1);
            Writeln(TempFile, TString1);
            Writeln(TempFile, '.color 1');
            Writeln(TempFile, '.fontsize 20');
            Writeln(TempFile, '  This is the topic for ' + TString1);
            Writeln(TempFile, '');
            Writeln(TempFile, '{.jump main_index, "Contents"}');
            Writeln(TempFile, '');
          End;
        End;
      End;
      Close(InFile);
    End
    Else IF Not OK_To_Process Then
      MessageBox (HWindow, 'File Does Not Exist', 'OOPS!', mb_Ok);
  End;

Begin
  Assign(HelpFile, RC_File_Short + '.hgn');
  Rewrite(HelpFile);
  Assign(TempFile, 'temp.tmp');
  Rewrite(TempFile);
  Writeln(HelpFile, '.rem Help File for ' + RC_File_Short);
  Writeln(HelpFile, '.fontadd fswiss, "Arial"');
  Writeln(HelpFile, '.fontend');
  Controls_Coll^. Foreach(@GetHelpItem);
  Writeln(HelpFile, '.colortable');
  Writeln(HelpFile, '\red0\green0\blue0;');
  Writeln(HelpFile, '\red60\green0\blue128;');
  Writeln(HelpFile, '\red0\green100\blue90;');
  Writeln(HelpFile, '.endcolortable');
  Writeln(HelpFile, '.fontsel 1');
  Writeln(HelpFile, '..This is the TOP Level definition');
  Writeln(HelpFile, '.topic main_index, Contents');
  Writeln(HelpFile, '.fontsize 30');
  Writeln(HelpFile, '.color 0');
  Writeln(HelpFile, RC_File_Short + ' Help');
  Writeln(HelpFile, '');
  Writeln(HelpFile, '.color 1');
  Writeln(HelpFile, '.fontsize 20');
  Writeln(HelpFile, 'This is the ''Table of Contents'' screen.');
  Writeln(HelpFile, '');
  Writeln(HelpFile, '');
  Close(TempFile);
  Reset(TempFile);
  While Not EOF(TempFile) Do
  Begin
    Readln(TempFile, TString);
    Writeln(HelpFile, TString);
  End;
  Close(HelpFile);
  Erase(TempFile);
End;

Procedure GetAllDlgItems(InDlg, InName : String; InType: FileType);
Var
  TString1, TString2, TString3 : String;
  Temp_ID, Control_ID : String;
  GetAllDone : Boolean;
  OK_To_Process : Boolean;
  HWindow : HWnd;

  Procedure MakeEntry(Ctrlr_ID: String);
  Var
    TString1, TString2, TString3 : String;
    Found : Boolean;
  Begin
    If (InDlg <> 'Close_Dialog*') And (InDlg <> 'End_Program*') And
       (InDlg <> 'Help_Directory*') And (InDlg <> 'Help_Topic*') AND
       (InDlg <> 'Edit_Box*') Then
    Begin
      Writeln(TypeFile, '  Procedure Do_' + Ctrlr_Id + ' (Var Msg: TMessage); Virtual id_First + ' + Ctrlr_ID + ';');
      Writeln(CodeFile, 'Procedure T' + InDlg + '. Do_' + CTrlr_Id + ' (Var Msg: TMessage);');
      Writeln(CodeFile, 'Begin');
      FoundItem := nil;
      Found := Searchlist(Controls_Coll, Ctrlr_ID);
      If (Found) And (FoundItem^. GetLink <> ' ') Then
      Begin
        TString2 := FoundItem^. GetLink;
        If TString2 = 'Close_Dialog*' Then
          TString1 := '  T' + InDlg + '. EndDlg(0);'
        else if TString2 = 'Help_Topic*' Then
          TString1 := '  WinHelp(HWindow, ''' + RC_File_Short + '.hlp'', help_context, ' + Ctrlr_ID + ');'
        Else If TString2 = 'Edit_Box*' Then
        Begin
          TString1 := '  If Msg. LParamHi = LBN_DBLCLK Then';
          Writeln(CodeFile, TString1);
          TString1 := '  Begin';
          Writeln(CodeFile, TString1);
          TString1 := '  End;';
        End
        Else
          TString1 := '  Application^. ExecDialog (New (P'+ TString2 + ', Init (Nil, ''' + TString2 + ''') ) );';
      End
      Else
        TString1 := '';
      Writeln(CodeFile, TString1);
      Writeln(CodeFile, 'End;');
      Writeln(CodeFile, '');
    End;
  End;
Begin
  If (InDlg <> 'Close_Dialog*') And (InDlg <> 'End_Program*') And
     (InDlg <> 'Help_Directory*') And (InDlg <> 'Help_Topic*') And
     (InDlg <> 'Edit_Box*') Then
  Begin
    GetAllDone := False;
    OK_To_Process := True;
    If Not (FileExist(RC_File_Name)) Then
      OK_To_Process := False;
    if OK_To_Process Then
    Begin
      Assign(Infile, RC_File_Name);
      Reset(Infile);
      While Not EOF(Infile) and Not GetAllDone Do
      Begin
        Readln(Infile, TString1);
        Temp_ID := Get_Id(TString1, DIALOG);
        if (Temp_ID <> '') And (Temp_ID = InDlg) Then
        Begin
          While TString1 <> 'BEGIN' Do
            Readln(Infile, TString1);
          If InType = Split Then
          Begin
            Assign(TypeFile, InName + '.tt');
            Rewrite(TypeFile);
            Assign(CodeFile, InName + '.tc');
            Rewrite(CodeFile);
            Writeln(TypeFile, Memo_Line);
            Writeln(TypeFile, '{ Source code generated by Progen for ' + Temp_ID);
            Writeln(TypeFile, Memo_Line);
            Writeln(TypeFile, '');
            Writeln(TypeFile, 'Unit ' + InName + ';');
            Writeln(TypeFile, '');
            Writeln(TypeFile, 'Interface');
            Writeln(TypeFile, '');
            Writeln(TypeFile, Use_Line + Const_File_Name + ';');
            Writeln(TypeFile, '');
            Writeln(TypeFile, 'Type');
          End;
          Writeln(TypeFile, Memo_Line);
          Writeln(TypeFile, '{ Define ' + InDlg);
          Writeln(TypeFile, Memo_Line);
          Writeln(TypeFile, 'P' + InDlg + ' = ^T' + InDlg + ';');
          Writeln(TypeFile, 'T' + InDlg + ' = Object (TDialog)');
          Writeln(TypeFile, '  Procedure WMInitDialog (Var Msg: TMessage); Virtual wm_First + wm_InitDialog;');
          Writeln(CodeFile, Memo_Line);
          Writeln(CodeFile, '{ Code for ' + InDlg);
          Writeln(CodeFile, Memo_Line);
          Writeln(CodeFile, 'Procedure T' + InDlg + '. WMInitDialog (Var Msg: TMessage);');
          Writeln(CodeFile, 'Begin');
          Writeln(CodeFile, '  Inherited SetupWindow;');
          Writeln(CodeFile, 'End;');
          Writeln(CodeFile, '');
          While TString1 <> 'END' Do
          Begin
            GetAllDone := False;
            Readln(Infile, TString1);
            Control_ID := Get_Id(TString1, CONTROL);
            If Get_ID_Second_Param <> '' Then
            Begin
              If Get_ID_Second_Param <> '-1' Then
              Begin
                MakeEntry(Get_ID_Second_Param);
                GetAllDone := True;
              End;
            End;
            Control_ID := Get_Id(TString1, PUSHBUTTON);
            If (Control_ID <> '') And (Not GetAllDone) Then
            Begin
              If Get_ID_Second_Param <> '-1' Then
              Begin
                MakeEntry(Get_ID_Second_Param);
                GetAllDone := True;
              End;
            End;
            Control_ID := Get_Id(TString1, EDITTEXT);
            If (Control_ID <> '') And (Not GetAllDone) Then
              MakeEntry(Control_ID);
          End;
          Writeln(TypeFile, 'End;');
          Writeln(TypeFile, '');
          If InType = Split Then
          Begin
            Writeln(TypeFile, '');
            Writeln(TypeFile, 'Implementation');
            Writeln(TypeFile, '');
            Writeln(CodeFile, '');
            Writeln(CodeFile, 'Begin');
            Writeln(CodeFile, 'End.');
            Close(TypeFile);
            Close(CodeFile);
            Assign(TypeFile, InName + '.tt');
            Reset(TypeFile);
            Assign(CodeFile, InName + '.tc');
            Reset(CodeFile);
            Assign(OutFile3, InName + '.pas');
            Rewrite(OutFile3);
            While Not Eof(TypeFile) Do
            Begin
              Readln(TypeFile, TString1);
              Writeln(OutFile3, TString1);
            End;
            While Not Eof(CodeFile) Do
            Begin
              Readln(CodeFile, TString1);
              Writeln(OutFile3, TString1);
            End;
            Close(OutFile3);
            Erase(TypeFile);
            Erase(CodeFile);
          End;
        End;
      End;
      Close(Infile);
    End
    Else IF Not OK_To_Process Then
      MessageBox (HWindow, 'File Does Not Exist', 'OOPS!', mb_Ok);
  End;
End;

Procedure DoDialogs(InType: FileType);
Var
  TString1, TString2, TString3, TString4 : String;

  Procedure CallGetNext (P : PListItem); Far;
  Var
    TextItem : Array [0..80] Of Char;
  Begin
    TString1 := P^. GetDisp;
    TString2 := P^. GetLink;
    GetAllDlgItems(TString1, TString2, InType);
  End;
Begin
  If InType = Split Then
  Begin
    Close(TypeFile);
    Close(CodeFile);
  End;
  Dialog_Coll^. Foreach(@CallGetNext);
End;

{********************************************************}
{ Code for About
{********************************************************}
Procedure TAbout. WMInitDialog (Var Msg: TMessage);
Begin
  Inherited SetupWindow;
End;

Procedure TAbout. Do_dlg_about_ok (Var Msg: TMessage);
Begin
  TAbout. EndDlg(0);
End;

{********************************************************}
{ Code for Start_Directory
{********************************************************}
Procedure TStart_Directory. WMInitDialog (Var Msg: TMessage);
Var
  SelectedText : Array[1..80] of Char;
Begin
  Inherited SetupWindow;
  StrPCopy(@SelectedText, Main_Path_Name);
  SendDlgItemMsg (dlg_sd_path, wm_SetText, 0, LongInt (@SelectedText) );
End;

Procedure TStart_Directory. Do_dlg_sd_done (Var Msg: TMessage);
Begin
  TStart_Directory. EndDlg(0);
End;

Procedure TStart_Directory. Do_dlg_sd_cancel (Var Msg: TMessage);
Begin
  TStart_Directory. EndDlg(0);
End;

Procedure TStart_Directory. Do_dlg_sd_combo (Var Msg: TMessage);
VAR
  SelectedText : Array [0..80] Of Char;
Begin
  If Msg. LParamHi = EN_SETFOCUS Then
  Begin
    StrPCopy(@SelectedText, Main_Path_Name + '\*.dir');
    SendDlgItemMsg (dlg_sd_combo, LB_RESETCONTENT, 0, 0 );
    Main_File_Sel := Path_Name;
    DlgDirList(HWindow, @SelectedText, dlg_sd_combo, 0, $0010);
  End;
End;

Procedure TStart_Directory. Get_Path_Data  (Var Msg: TMessage);
VAR
  Idx: Integer;
  SelectedText : Array [0..80] Of Char;
  TString1, TString2 : String;
  i, j : Integer;
Begin
  If Msg. LParamHi = LBN_DBLCLK Then
  Begin
    Idx := SendDlgItemMsg (dlg_sd_combo, lb_GetCurSel, 0, LongInt (0) );
    SendDlgItemMsg (dlg_sd_combo, lb_GetText, Idx, LongInt (@SelectedText) );
    TString1 := StrPas (@SelectedText);
    if TString1 = '[..]' Then
    Begin
      i := Length(Main_Path_Name);
      While Main_Path_Name[i] <> '\' Do
        Dec(i);
      TString2 := '';
      For j := 1 to i - 1 Do
        TString2 := TString2 + Main_Path_Name[j];
      Main_Path_Name := TString2;
    End
    Else
    Begin
      TString2 := '\';
      for i := 2 to Length(TString1) - 1 Do
        TString2 := TString2 + TString1[i];
      Main_Path_Name := Main_Path_Name + TString2;
    End;
    TString1 := Main_Path_Name + '\*.dir';
    StrPCopy(@SelectedText, TString1);
    DlgDirList(HWindow, @SelectedText, dlg_sd_combo, 0, $0010);
    StrPCopy(@SelectedText, Main_Path_Name);
    SendDlgItemMsg (dlg_sd_path, wm_SetText, 0, LongInt (@SelectedText) );
  End;
End;
{********************************************************}
{ Code for RegisterList
{********************************************************}
Procedure RegisterList;
Begin
  RegisterType (RCollection);
  RegisterType (RList);
  RegisterType (RListItem);
End;

{********************************************************}
{ Code for FileExist
{********************************************************}
Function FileExist(FileName: String):Boolean;
Var
  TestFile : Text;
  FileStatus : Boolean;
Begin
  Assign(TestFile, FileName);
  {$I-}
  Reset(TestFile);
  {$I+}
  If IOResult = 0 Then
  Begin
    FileStatus := True;
    Close(TestFile);
  End
  Else
  Begin
    FileStatus := False;
  End;
  FileExist := FileStatus;
End;

{********************************************************}
{ Variable Declarations                                  }
{********************************************************}
Var
  Do_Progen : PProgen;
Begin
  Do_Progen. Init ('Progen');
  Do_Progen. Run;
  Do_Progen. Done;
End.