
/********** nsnvbitf.cpp: implement a dll to use netscape.network.1 from vb *****
 *
 *	20 April 1995	shc@cfg.com    initial version
 *
 *
 *
 *	Version 0.2, 4 May 1995
 *	
 * NOTICE: This software and its associated documentation ("the
 * software") was written by Steve Caine (shc@cfg.com) of
 * Caine, Farber & Gordon, Inc., 1010 East Union Street, Ste 205, Pasadena,
 * CA 91106 and is hereby placed in the public domain.  You may do
 * anything at all with the software. There are no restrictions.  The
 * software is provided AS IS and WITH ALL FAULTS.  Neither the author nor
 * Caine, Farber & Gordon, Inc. nor any other party assumes any
 * responsibility for the software or for any modification thereto.
 *	
 * See the accompanying README.TXT file for information on building,
 * installing and using this dll.
 *
 *******************************************************************************/

#include <windows.h>
#include <ole2.h>
#include <dispatch.h>
#include <variant.h> 
#include <olenls.h>
#include <stdio.h>                          
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

#include "xvbapi.h"

#define DLLENTRY	FAR PASCAL __export


/*
 ***** Error Message Codes *****
 *
 */
 
#define DEFAULT_ERROR_BASE 21000    // may be modified by NsNetSetErrorBase

#define ERROR_HR_FAILED			1   // a failure HRESULT was returned by a
									//      function.  Use NsNetGetSCode to
									//		 get the corresponding SCode.
#define ERROR_ALLOC_BSTR		2	// failure allocating a bstr
#define ERROR_NO_NETSCAPE		3	// netscape not yet instantiated.


/*
 ***** NsNet Option Flags *****
 *
 */
 
#define OPT_HOURGLASS		 0x0001	// show hourglass while instantiating,
 									//	opening, and reading
#define OPT_FOCUS			 0x0002	// warp focus back to the active VB window
									//	after instantiating Netscape. If
									//	not, focus is left on Netscape.
#define OPT_AUTOCONNECT		 0x0004	// automatically instantiate netscape on
									//	first use of a function that needs it
#define OPT_RELEASE_ON_ERROR 0x0008 // release netscape on signalling an error									
									
#define DEFAULT_OPTIONS		OPT_FOCUS	// change this define to establish new
										//  defaults																	 									

/*
 ***** Dispatch Paramater Setup Macros *****
 *
 */
 
#define SETDISPPARAMS(dp, numArgs, pvArgs, numNamed, pNamed) \
	{\
		(dp).cArgs = numArgs; \
		(dp).rgvarg = pvArgs; \
		(dp).cNamedArgs = numNamed; \
		(dp).rgdispidNamedArgs = pNamed; \
	}
	
#define SETNOPARAMS(dp) SETDISPPARAMS(dp, 0, NULL, 0, NULL);

/*
 ***** Forward Declarations of Exported Routines *****
 *
 */
 
extern "C" {
	void DLLENTRY NsNetCreate(void);
}


/*
 * Forward Declarations of Local Routines
 *
 */

void CheckNetscape(void);
BSTR GetBstr(LPSTR str);
BSTR GetBstrFromHlstr(HLSTR str);
BSTR GetBstrLen(LPSTR str, USHORT len);
DISPID GetID(char *name);
void HrFail(void);
void RestoreCursor(void);
void SetHourGlass(void);
void SignalError(USHORT err, LPSTR msg);

/*
 ***** Static Data *****
 *
 */
 
HRESULT hr;                            	// HRESULT of the last call

LPDISPATCH pdisp;                       // pointer to the netscape.network.1
										//		 object

HCURSOR hHourGlass;						// the hourglass cursor

HCURSOR hOldCursor;						// the previous cursor

USHORT errbase = DEFAULT_ERROR_BASE;    // error message numbers are added to 
										//		this to get the real number to
										//		give to vb

long options = DEFAULT_OPTIONS;			// processing options										

static DISPID idnamed = DISPID_PROPERTYPUT;  // dispid for doing a property put

int initialized;						// on if OLE has been initialized


/*
 ***** LibMain: Initialize the DLL *****
 *
 */

int FAR PASCAL LibMain(HINSTANCE hInst, WORD wDataSeg, WORD wHeapSize,
		LPSTR lpszCmdLine)
{
	if (wHeapSize != 0) UnlockData(0);
	return 1;
}

/*
 ********** Routines Exported from the DLL **********
 *
 */
		
extern "C" {

/*
 ***** Routines to Control the Interface *****
 *
 */
 
/*
 * NsNetCreate: Instantiate the Netscape.Network.1 automation object
 *
 */

void DLLENTRY NsNetCreate(void)
{
	CLSID clsid;
	HWND hwnd;
	
	if (!pdisp) {
		if (options & OPT_FOCUS) hwnd = GetActiveWindow();
		SetHourGlass();					// restored below or by SignalError
		OleInitialize(NULL);
		initialized++;
		hr = CLSIDFromProgID("Netscape.Network.1", &clsid);
		if (FAILED(hr)) HrFail();
		hr = CoCreateInstance(clsid, NULL, CLSCTX_SERVER, IID_IDispatch,
				(LPVOID FAR*) &pdisp);
		if (FAILED(hr)) HrFail();
		RestoreCursor();
		if (options & OPT_FOCUS) SetFocus(hwnd);
	}
}


/*
 * NsNetGetSCode: converts the last HRESULT to an SCode and returns it.  This
 *					can be used after a failure hresult error is signaled.
 *
 */

long DLLENTRY NsNetGetSCode(void)
{
	return GetScode(hr);
}


/*
 * NsNetRelease: release the netscape.network.1 automation object
 *
 */

void DLLENTRY NsNetRelease(void)
{
	if (pdisp) {
		pdisp->Release();
		OleUninitialize();
		pdisp = NULL;
	}
}


/*
 * NsNetSetErrorBase: set the base amount to be added to each NsNet
 *						error message
 *
 */

void DLLENTRY NsNetSetErrorBase(short base)
{
	errbase = base;
}


/*
 * NsSetOptions: set options
 *
 */
 
void NsSetOptions(long opt)
{
	options = opt;
}


/*
 ***** The actual NSAPI Routines *****
 *
 */


/*
 * NsBytesReady: NSAPI BytesReady function
 *
 */

short DLLENTRY NsNetBytesReady()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	
	CheckNetscape();
	if (!id) id = GetID("BytesReady");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	return V_I2(&vr);
}


/*
 * NsNetClose: NSAPI Close function
 *
 */

void DLLENTRY NsNetClose()
{
	static DISPID id;
	DISPPARAMS dp;
	
	CheckNetscape();
	if (!id) id = GetID("Close");
	SETNOPARAMS(dp);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, NULL, NULL, NULL);
	if (FAILED(hr)) HrFail();
}


/*
 * NsNetGetContentEncoding: NSAPI GetContentEncoding function
 *
 */
 
HLSTR DLLENTRY NsNetGetContentEncoding()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	HLSTR rs;
	
	CheckNetscape();
	if (!id) id = GetID("GetContentEncoding");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	rs = VBCreateTempHlstr(V_BSTR(&vr), SysStringLen(V_BSTR(&vr)));
	VariantClear(&vr);
	return rs;
}


/*
 * NsNetGetContentLength: NSAPI GetContentLength function
 *
 */
 
long DLLENTRY NsNetGetContentLength()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	
	CheckNetscape();
	if (!id) id = GetID("GetContentLength");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	return V_I4(&vr);
}


/*
 * NsNetGetContentType: NSAPI GetContentType function
 *
 */

HLSTR DLLENTRY NsNetGetContentType()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	HLSTR rs;
	
	CheckNetscape();
	if (!id) id = GetID("GetContentType");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	rs = VBCreateTempHlstr(V_BSTR(&vr), SysStringLen(V_BSTR(&vr)));
	VariantClear(&vr);
	return rs;
}


/*
 * NsNetGetErrorMessage: NSAPI GetErrorMessage function
 *
 */
 
HLSTR DLLENTRY NsNetGetErrorMessage()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	HLSTR rs;
	
	CheckNetscape();
	if (!id) id = GetID("GetErrorMessage");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	rs = VBCreateTempHlstr(V_BSTR(&vr), SysStringLen(V_BSTR(&vr)));
	VariantClear(&vr);
	return rs;
}


/*
 * NsNetGetExpires: NSAPI GetExpires function
 *
 */

HLSTR DLLENTRY NsNetGetExpires()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	HLSTR rs;
	
	CheckNetscape();
	if (!id) id = GetID("GetExpires");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	rs = VBCreateTempHlstr(V_BSTR(&vr), SysStringLen(V_BSTR(&vr)));
	VariantClear(&vr);
	return rs;
}


/*
 * NsNetGetFlagFancyFTP: NSAPI GetFlagFancyFTP function
 *
 */

BOOL DLLENTRY NsNetGetFlagFancyFTP()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	
	CheckNetscape();
	if (!id) id = GetID("FlagFancyFTP");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYGET, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	return V_BOOL(&vr);
}


/*
 * NsNetGetFlagFancyNews: NSAPI GetFlagFancyNews function
 *
 */

BOOL DLLENTRY NsNetGetFlagFancyNews()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	
	CheckNetscape();
	if (!id) id = GetID("FlagFancyNews");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYGET, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	return V_BOOL(&vr);
}


/*
 * NsNetGetFlagShowAllNews: NSAPI GetFlagShowAllNews function
 *
 */

BOOL DLLENTRY NsNetGetFlagShowAllNews()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	
	CheckNetscape();
	if (!id) id = GetID("FlagShowAllNews");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYGET, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	return V_BOOL(&vr);
}


/*
 * NsNetGetLastModified: NSAPI GetLastModified function
 *
 */

HLSTR DLLENTRY NsNetGetLastModified()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	HLSTR rs;
	
	CheckNetscape();
	if (!id) id = GetID("GetLastModified");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	rs = VBCreateTempHlstr(V_BSTR(&vr), SysStringLen(V_BSTR(&vr)));
	VariantClear(&vr);
	return rs;
}


/*
 * NsNetGetPassword: NSAPI GetPassword function
 *
 */

HLSTR DLLENTRY NsNetGetPassword()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	HLSTR rs;
	
	CheckNetscape();
	if (!id) id = GetID("Password");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYGET, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	rs = VBCreateTempHlstr(V_BSTR(&vr), SysStringLen(V_BSTR(&vr)));
	VariantClear(&vr);
	return rs;
}


/*
 * NsNetGetServerStatus: NSAPI GetServerStatus function
 *
 */

short DLLENTRY NsNetGetServerStatus()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	
	CheckNetscape();
	if (!id) id = GetID("GetServerStatus");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	return V_I2(&vr);
}


/*
 * NsNetGetStatus: NSAPI GetStatus function
 *
 */

long DLLENTRY NsNetGetStatus()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	
	CheckNetscape();
	if (!id) id = GetID("GetStatus");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	return V_I4(&vr);
}


/*
 * NsNetGetUsername: NSAPI GetUsername function
 *
 */

HLSTR DLLENTRY NsNetGetUsername()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	HLSTR rs;
	
	CheckNetscape();
	if (!id) id = GetID("Username");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYGET, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	rs = VBCreateTempHlstr(V_BSTR(&vr), SysStringLen(V_BSTR(&vr)));
	VariantClear(&vr);
	return rs;
}


/*
 * NsNetIsFinished: NSAPI IsFinished function
 *
 */

BOOL DLLENTRY NsNetIsFinished()
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANT vr;
	
	CheckNetscape();
	if (!id) id = GetID("IsFinished");
	SETNOPARAMS(dp);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	return V_BOOL(&vr);
}


/*
 * NsNetOpen: NSAPI Open function
 *
 */

BOOL DLLENTRY NsNetOpen(HLSTR url, short method, HLSTR postdata,
						long postdatasize, HLSTR postheaders)
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANTARG va[5];
	VARIANT vr;
	
	CheckNetscape();
	SetHourGlass();
	if (!id) id = GetID("Open");
	VariantInit(&va[0]);		// pPostHeaders
	va[0].vt = VT_BSTR;
	va[0].bstrVal = GetBstrFromHlstr(postheaders);
	VariantInit(&va[1]);		// lPostDataSize
	va[1].vt = VT_I4;
	va[1].lVal = postdatasize;
	VariantInit(&va[2]);		// pPostData
	va[2].vt = VT_BSTR;
	va[2].bstrVal = GetBstrFromHlstr(postdata);
	VariantInit(&va[3]);		// iMethod
	va[3].vt = VT_I2;
	va[3].iVal = method;
	VariantInit(&va[4]);		// pURL
	va[4].vt = VT_BSTR;
	va[4].bstrVal = GetBstrFromHlstr(url);
	SETDISPPARAMS(dp, 5, va, 0, NULL);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, &vr, NULL, NULL);
	VariantClear(&va[0]);
	VariantClear(&va[2]);
	VariantClear(&va[4]);
	if (FAILED(hr)) HrFail();
	RestoreCursor();
	return V_BOOL(&vr);
}


/*
 * NsNetRead: NSAPI Read function.  rbuf is a normal vb string whose size will
 *				be properly allocated.
 *
 */

short DLLENTRY NsNetRead(HLSTR rbuf, short amount)
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANTARG va[2];
	VARIANT vr;
	short rlen;
	short n;
	BSTR bf;
	
	CheckNetscape();
	SetHourGlass();
	if (!id) id = GetID("Read");
	bf = SysAllocStringLen(NULL, amount);
	VariantInit(&va[0]);		// iAmount
	va[0].vt = VT_I2;
	va[0].iVal = amount;
	VariantInit(&va[1]);		// pBuffer
	va[1].vt = VT_BSTR|VT_BYREF;
	va[1].pbstrVal = &bf;
	SETDISPPARAMS(dp, 2, va, 0, NULL);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
	rlen = V_I2(&vr);
	n = (rlen >= 0) ? rlen : 0;
	VBSetHlstr(&rbuf, bf, n);	
	VariantClear(&va[1]);              
	SysFreeString(bf);
	RestoreCursor();
	return rlen;
}


/*
 * NsNetResolve: NSAPI Resolve function
 *
 */

HLSTR DLLENTRY NsNetResolve(HLSTR base, HLSTR relative)
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANTARG va[2];
	VARIANT vr;
	LPSTR surl;
	USHORT nurl;
	HLSTR rs;
	
	CheckNetscape();
	if (!id) id = GetID("Resolve");
	VariantInit(&va[0]);		// pRelative
	va[0].vt = VT_BSTR;
	surl = VBDerefHlstrLen(relative, &nurl);
	va[0].bstrVal = GetBstrLen(surl, nurl);
	VariantInit(&va[1]);		// pBase
	va[1].vt = VT_BSTR;
	surl = VBDerefHlstrLen(base, &nurl);
	va[1].bstrVal = GetBstrLen(surl, nurl);
	SETDISPPARAMS(dp, 2, va, 0, NULL);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, 
			&dp, &vr, NULL, NULL);
	VariantClear(&va[0]);
	VariantClear(&va[1]);
	if (FAILED(hr)) HrFail();
	rs = VBCreateTempHlstr(V_BSTR(&vr), SysStringLen(V_BSTR(&vr)));
	VariantClear(&vr);
	return rs;
}


/*
 * NsNetSetFlagFancyFTP: NSAPI SetFlagFancyFTP function
 *
 */

void DLLENTRY NsNetSetFlagFancyFTP(BOOL flag)
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANTARG va;
	VARIANT vr;
	
	CheckNetscape();
	if (!id) id = GetID("FlagFancyFTP");
	VariantInit(&va);
	va.vt = VT_BOOL;
	va.bool = flag;
	SETDISPPARAMS(dp, 1, &va, 1, &idnamed);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYPUT, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
}


/*
 * NsNetSetFlagFancyNews: NSAPI SetFlagFancyNews function
 *
 */

void DLLENTRY NsNetSetFlagFancyNews(BOOL flag)
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANTARG va;
	VARIANT vr;
	
	CheckNetscape();
	if (!id) id = GetID("FlagFancyNews");
	VariantInit(&va);
	va.vt = VT_BOOL;
	va.bool = flag;
	SETDISPPARAMS(dp, 1, &va, 1, &idnamed);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYPUT, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
}


/*
 * NsNetSetFlagShowAllNews: NSAPI SetFlagShowAllNews function
 *
 */

void DLLENTRY NsNetSetFlagShowAllNews(BOOL flag)
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANTARG va;
	VARIANT vr;
	
	CheckNetscape();
	if (!id) id = GetID("FlagShowAllNews");
	VariantInit(&va);
	va.vt = VT_BOOL;
	va.bool = flag;
	SETDISPPARAMS(dp, 1, &va, 1, &idnamed);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYPUT, 
			&dp, &vr, NULL, NULL);
	if (FAILED(hr)) HrFail();
}


/*
 * NsNetSetPassword: NSAPI SetPassword function
 *
 */

void DLLENTRY NsNetSetPassword(HLSTR password)
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANTARG va;
	VARIANT vr;
	LPSTR pwd;
	USHORT npwd;
	
	CheckNetscape();
	if (!id) id = GetID("Password");
	VariantInit(&va);
	va.vt = VT_BSTR;
	pwd = VBDerefHlstrLen(password, &npwd);
	va.bstrVal = GetBstrLen(pwd, npwd);
	SETDISPPARAMS(dp, 1, &va, 1, &idnamed);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYPUT, 
			&dp, &vr, NULL, NULL);
	VariantClear(&va);
	if (FAILED(hr)) HrFail();
}


/*
 * NsNetSetUsername: NSAPI SetUsername function
 *
 */

void DLLENTRY NsNetSetUsername(HLSTR name)
{
	static DISPID id;
	DISPPARAMS dp;
	VARIANTARG va;
	VARIANT vr;
	LPSTR nme;
	USHORT nnme;
	
	CheckNetscape();
	if (!id) id = GetID("Username");
	VariantInit(&va);
	va.vt = VT_BSTR;
	nme = VBDerefHlstrLen(name, &nnme);
	va.bstrVal = GetBstrLen(nme, nnme);
	SETDISPPARAMS(dp, 1, &va, 1, &idnamed);
	VariantInit(&vr);
	hr = pdisp->Invoke(id, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_PROPERTYPUT, 
			&dp, &vr, NULL, NULL);
	VariantClear(&va);
	if (FAILED(hr)) HrFail();
}

}


/*
 ********** Internal Support Routines **********
 *
 */

/*
 * CheckNetscape: see if netscape has beein instantiated and either complain or
 * 					instantiate it depending on the current option set
 *
 */

void CheckNetscape(void)
{
	if (!pdisp) {
		if (options & OPT_AUTOCONNECT) NsNetCreate();
		else SignalError(ERROR_NO_NETSCAPE,
					     "Netscape.Network.1 not yet instantiated.");
	}
}


/*
 * GetBstr: allocate a BSTR initialized to C string str and field errors
 *
 */

BSTR GetBstr(LPSTR str)
{
	BSTR s;
	
	if ((s = SysAllocString(str)) == NULL)
		SignalError(ERROR_ALLOC_BSTR, "Can't allocate a BSTR.");
	return s;
}


/*
 * GetBstrFromHlstr: create a bstr from a vb hstr
 *
 */

BSTR GetBstrFromHlstr(HLSTR str)
{
	LPSTR s;
	USHORT n;
	
	s = VBDerefHlstrLen(str, &n);
	return GetBstrLen(s, n);
}


/*
 * GetBstrLen: allocate a BSTR of length len initialized to str and field
 *					errors
 *
 */

BSTR GetBstrLen(LPSTR str, USHORT len)
{
	BSTR s;
	
	if ((s = SysAllocStringLen(str, len)) == NULL)
		SignalError(ERROR_ALLOC_BSTR, "Can't allocate a BSTR.");
	return s;
}
	

/*
 * GetID: get dispatch id of a given name and field an error
 *
 */

DISPID GetID(char *name)
{
	DISPID id;
	
	hr = pdisp->GetIDsOfNames(IID_NULL,  &name, 1, LOCALE_USER_DEFAULT,
			&id);
	if (FAILED(hr)) HrFail();
	return id;
}


/*
 * HrFail: signal the "failed hresult" error
 *
 */
 
void HrFail(void)
{
	SignalError(ERROR_HR_FAILED, "A Failure HRESULT was returned by OLE");
}


/*
 * RestoreCursor: restore the cursor to its old value
 *
 */

void RestoreCursor(void)
{
	if (hOldCursor) {
		SetCursor(hOldCursor);
		hOldCursor = NULL;
	}
}


/*
 * SetHourGlass: set the cursor to the hourglass symbol
 *
 */

void SetHourGlass(void)
{
	if ((options & OPT_HOURGLASS) && !hHourGlass) {
		hHourGlass = LoadCursor(NULL, IDC_WAIT);
		hOldCursor = SetCursor(hHourGlass);
	}
}


/*
 * SignalError: Signal a VB runtime error with error number err and message msg
 *
 */
 
void SignalError(USHORT err, LPSTR msg)
{
	if (options & OPT_RELEASE_ON_ERROR) {
		NsNetRelease();
		if (initialized) OleUninitialize();
	}
	RestoreCursor();
	VBSetErrorMessage(errbase + err, msg);
	VBRuntimeError(errbase + err); 				// does not return
}


/***************/
