Attribute VB_Name = "T2WIN_16_DEF"
Option Explicit

' Version : 9.52

' definition for win.ini section
Public Const GET_TIME_SEPARATOR = 1
Public Const GET_DATE_SEPARATOR = 2
Public Const GET_TIME_FORMAT = 3
Public Const GET_DATE_FORMAT = 4
Public Const GET_CURRENCY = 5
Public Const GET_LANGUAGE = 6
Public Const GET_COUNTRY = 7
Public Const GET_COUNTRY_CODE = 8
Public Const GET_LIST_SEPARATOR = 9
Public Const GET_DEFAULT_PRINTER = 10

' definition for drive type
Public Const DRIVE_UNKNOW = 0
Public Const DRIVE_REMOVABLE = 2
Public Const DRIVE_FIXED = 3
Public Const DRIVE_REMOTE = 4
Public Const DRIVE_CDROM = 20

' definition for file attributes
Public Const A_NORMAL = &H0             'Normal file - No read/write restrictions
Public Const A_RDONLY = &H1             'Read only file
Public Const A_HIDDEN = &H2             'Hidden file
Public Const A_SYSTEM = &H4             'System file
Public Const A_VOLID = &H8              'Volume ID file
Public Const A_SUBDIR = &H10            'Subdirectory
Public Const A_ARCH = &H20              'Archive file
Public Const A_ARCHIVE = &H20           'Archive file
Public Const A_NORMAL_ARCHIVE = &HFE    'Normal, Archive
Public Const A_ALL = &HFF               'Normal, Archive, Read-Only, Hidden, System

' definition for encrypt/decrypt
Public Const ENCRYPT_LEVEL_0 = 0
Public Const ENCRYPT_LEVEL_1 = 1
Public Const ENCRYPT_LEVEL_2 = 2
Public Const ENCRYPT_LEVEL_3 = 3
Public Const ENCRYPT_LEVEL_4 = 4

Public Const CRYPTO_KEY_TOO_SMALL = -1
Public Const CRYPTO_CANT_INIT_KEY = -2
Public Const CRYPTO_CANT_INIT_BUFFER = -11
Public Const CRYPTO_CANT_OPEN_FILEIN = -21
Public Const CRYPTO_CANT_CREATE_FILEOUT = -22
Public Const CRYPTO_ERROR_READING_FILEIN = -31
Public Const CRYPTO_ERROR1_WRITING_FILEOUT = -41
Public Const CRYPTO_ERROR2_WRITING_FILEOUT = -42
Public Const CRYPTO_ERROR1_WRITING_LASTBYTE = -51
Public Const CRYPTO_ERROR2_WRITING_LASTBYTE = -52
Public Const CRYPTO_BAD_LASTBYTE = -61

Public Const RUBY_MODE_MINIMUM = 1           ' speed is of the essence, security secondary.
Public Const RUBY_MODE_DESK_LOCK = 2         ' reasonable compromise of speed vs security.
Public Const RUBY_MODE_DEAD_BOLT = 4         ' default = probably good enough for most things.
Public Const RUBY_MODE_PORTABLE_SAFE = 5     ' security is more important than speed.
Public Const RUBY_MODE_ANCHORED_SAFE = 8     ' speed isn't much of a concern.
Public Const RUBY_MODE_BANK_VAULT = 10       ' your pentium has nothing better to do, anyway.
Public Const RUBY_MODE_FORT_KNOX = 16        ' be cool.

' definition for FILECRC32
Public Const OPEN_MODE_BINARY = 0
Public Const OPEN_MODE_TEXT = 1

' definition for FILEUUCP
Public Const MODE_UUENCODE = 0
Public Const MODE_UUDECODE = 1

' definition for ARRAYONDISK
Public Const PUT_ARRAY_ON_DISK = 0
Public Const GET_ARRAY_ON_DISK = 1

' definition for big numbers
Public Const BIG_ADD = 0
Public Const BIG_SUB = 1
Public Const BIG_MUL = 2

' definition for file version information
Public Const VER_VERSION_PRODUCT = -1
Public Const VER_VERSION_FILE = 0
Public Const VER_COMPANY_NAME = 1
Public Const VER_FILE_DESCRIPTION = 2
Public Const VER_FILE_VERSION = 3
Public Const VER_INTERNAL_NAME = 4
Public Const VER_LEGAL_COPYRIGHT = 5
Public Const VER_LEGAL_TRADEMARKS = 6
Public Const VER_PRODUCT_NAME = 7
Public Const VER_PRODUCT_VERSION = 8

' definition for language in multi-language management
Public Const LNG_FRENCH = 1
Public Const LNG_DUTCH = 2
Public Const LNG_GERMAN = 3
Public Const LNG_ENGLISH = 4
Public Const LNG_ITALIAN = 5
Public Const LNG_SPANISH = 6
Public Const LNG_CATALAN = 7
Public Const LNG_POLISH = 8
Public Const LNG_NORVEGIAN = 9

' definition for message position in multi-language message box
Public Const MB_MESSAGE_LEFT = 0
Public Const MB_MESSAGE_CENTER = 8192
Public Const MB_MESSAGE_RIGHT = 16384

' definition for timeout management in multi-language message box
Public Const MB_TIMEOUT_2 = 32768
Public Const MB_TIMEOUT_4 = 2 * MB_TIMEOUT_2
Public Const MB_TIMEOUT_8 = 2 * MB_TIMEOUT_4
Public Const MB_TIMEOUT_16 = 2 * MB_TIMEOUT_8

Public Const MB_TIMEOUT_6 = MB_TIMEOUT_2 Or MB_TIMEOUT_4
Public Const MB_TIMEOUT_10 = MB_TIMEOUT_2 Or MB_TIMEOUT_8
Public Const MB_TIMEOUT_12 = MB_TIMEOUT_4 Or MB_TIMEOUT_8
Public Const MB_TIMEOUT_14 = MB_TIMEOUT_2 Or MB_TIMEOUT_4 Or MB_TIMEOUT_8
Public Const MB_TIMEOUT_18 = MB_TIMEOUT_2 Or MB_TIMEOUT_16
Public Const MB_TIMEOUT_20 = MB_TIMEOUT_4 Or MB_TIMEOUT_16
Public Const MB_TIMEOUT_22 = MB_TIMEOUT_2 Or MB_TIMEOUT_4 Or MB_TIMEOUT_16
Public Const MB_TIMEOUT_24 = MB_TIMEOUT_8 Or MB_TIMEOUT_16
Public Const MB_TIMEOUT_26 = MB_TIMEOUT_2 Or MB_TIMEOUT_8 Or MB_TIMEOUT_16
Public Const MB_TIMEOUT_28 = MB_TIMEOUT_4 Or MB_TIMEOUT_8 Or MB_TIMEOUT_16
Public Const MB_TIMEOUT_30 = MB_TIMEOUT_2 Or MB_TIMEOUT_4 Or MB_TIMEOUT_8 Or MB_TIMEOUT_16

Public Const MB_DISPLAY_TIMEOUT = 524288

' definition for properties for language management
Public Const RS_CAPTION = 1
Public Const RS_TEXT = 2
Public Const RS_DATAFIELD = 4
Public Const RS_DATASOURCE = 8
Public Const RS_TAG = 16
Public Const RS_MENU = 32
Public Const RS_ALL = 255

' definition for accessing methods in OBJECT controls (ocx)
Public Const OBJ_MTD_CLEAR = 0

' definition for accessing properties in OBJECT controls (ocx or vbx)
Public Const OBJ_CAPTION = 0
Public Const OBJ_CLASS = 1
Public Const OBJ_CONTAINER = 2
Public Const OBJ_DATAFIELD = 3
Public Const OBJ_FORM = 4
Public Const OBJ_INDEX = 5
Public Const OBJ_NAME = 6
Public Const OBJ_NAMEINDEX = 7
Public Const OBJ_TAG = 8
Public Const OBJ_TEXT = 9

' definition for error type for PATTERNMATCHEXT
Public Const MATCH_HEXA = 17
Public Const MATCH_INTERNAL_ERROR = 16
Public Const MATCH_PATTERN = 15
Public Const MATCH_LITERAL = 14
Public Const MATCH_RANGE = 13
Public Const MATCH_ABORT = 12
Public Const MATCH_END = 11
Public Const MATCH_VALID = -1

Public Const PATTERN_VALID = 0
Public Const PATTERN_INVALID = 1
Public Const PATTERN_ESC = 2
Public Const PATTERN_RANGE = 3
Public Const PATTERN_CLOSE = 4
Public Const PATTERN_EMPTY = 5
Public Const PATTERN_INTERNAL_ERROR = 6
Public Const PATTERN_HEXA = 7

' definition for error type for ISFILENAMEVALID
Public Const IFV_ERROR = 0
Public Const IFV_NAME_TOO_LONG = 1
Public Const IFV_EXT_TOO_LONG = 2
Public Const IFV_TOO_MANY_BACKSLASH = 3
Public Const IFV_BAD_DRIVE_LETTER = 4
Public Const IFV_BAD_COLON_POS = 5
Public Const IFV_EXT_WITHOUT_NAME = 6

' definition for variable type in DISK ARRAY
Public Const DA_BYTE = 1
Public Const DA_TYPE = 0
Public Const DA_INTEGER = -2
Public Const DA_LONG = -3
Public Const DA_SINGLE = -4
Public Const DA_DOUBLE = -5
Public Const DA_CURRENCY = -6

' definition for error type in DISK ARRAY
Public Const DA_NO_ERROR = True
Public Const DA_EMPTY_FILENAME = 1
Public Const DA_BAD_FILENAME = 2
Public Const DA_CAN_KILL_FILE = 3
Public Const DA_CAN_NOT_OPEN_FILE = 4
Public Const DA_FILE_NOT_FOUND = 5
Public Const DA_BAD_TYPE = 6
Public Const DA_BAD_ROWS = 7
Public Const DA_BAD_COLS = 8
Public Const DA_BAD_SHEETS = 9
Public Const DA_CAN_NOT_WRITE_HEADER = 10
Public Const DA_CAN_NOT_WRITE_PART = 11
Public Const DA_CAN_NOT_WRITE_REMAIN = 12
Public Const DA_CAN_NOT_READ_HEADER = 13
Public Const DA_HEADER_SIZE = 14
Public Const DA_BAD_SIGNATURE = 15
Public Const DA_FILE_SIZE_MISMATCH = 16
Public Const DA_CAN_NOT_SEEK = 17
Public Const DA_INVALID_HANDLE = 18
Public Const DA_CAN_NOT_READ_PART = 19
Public Const DA_CAN_NOT_READ_REMAIN = 20

' definition for error type in HUGE MEMORY ARRAY
Public Const HMA_NO_ERROR = True
Public Const HMA_NO_MEMORY = 1
Public Const HMA_BAD_TYPE = 2
Public Const HMA_BAD_ROWS = 3
Public Const HMA_BAD_COLS = 4
Public Const HMA_BAD_SHEETS = 5
Public Const HMA_INVALID_HANDLE = 6

' definition for error type in SERIAL DATA
Public Const SD_SERIAL_NOT_FOUND = 1
Public Const SD_CAN_NOT_OPEN_FILE = 2

' definition for File I/O
Public Const EOFILE = -1
Public Const SEEK_CUR = 1
Public Const SEEK_END = 2
Public Const SEEK_SET = 0

' definition for file sort
Public Const SORT_ASCENDING = 1
Public Const SORT_DESCENDING = 2
Public Const SORT_CASE_SENSITIVE = 4
Public Const SORT_CASE_INSENSITIVE = 8

' definition for compress/expand
Public Const LZH_ENCODE = True
Public Const LZH_DECODE = False

' definition for PROPERNAME2
Public Const PN_UPPERCASE = 1
Public Const PN_PUNCTUATION = 2
Public Const PN_KEEP_ORIGINAL = 4
Public Const PN_ONLY_LEADER_SPACE = 8

' definition for matrix fill
Public Const MATRIX_ZERO = 0
Public Const MATRIX_UNIT = 1

' definition for FX picture
Public Const FX_HORIZONTAL = 1
Public Const FX_VERTICAL = 2
Public Const FX_DIAGONAL_SQUARE = 3
Public Const FX_RECTANGLE = 4

' definition for error type for SplitFile
Public Const SPLIT_BAD_PARTSIZE = -1
Public Const SPLIT_BAD_SOURCE_FILENAME = -2
Public Const SPLIT_BAD_TARGET_FILENAME = -3
Public Const SPLIT_CANT_OPEN_SOURCE = -4
Public Const SPLIT_CANT_CREATE_TARGET = -5

' definition for error type for CutFile
Public Const CUT_BAD_POSITION = -1
Public Const CUT_BAD_SOURCE_FILENAME = -2
Public Const CUT_BAD_TARGET1_FILENAME = -3
Public Const CUT_BAD_TARGET2_FILENAME = -4
Public Const CUT_POSITION_TOO_BIG = -5
Public Const CUT_CANT_OPEN_SOURCE = -6
Public Const CUT_CANT_CREATE_TARGET1 = -7
Public Const CUT_CANT_CREATE_TARGET2 = -8

' definition for error type for FileMergeExt
Public Const FILE_MERGE_NO_ERROR = -1
Public Const FILE_MERGE_EMPTY_TARGET_FILENAME = -2
Public Const FILE_MERGE_EMPTY_BAD_TARGET_FILENAME = -3
Public Const FILE_MERGE_CANT_SET_FILE_BUFFER = -4
Public Const FILE_MERGE_CANT_CREATE_TARGET_FILE = -5
Public Const FILE_MERGE_ERROR_READING_FILE = -6
Public Const FILE_MERGE_ERROR_WRITING_FILE = -7
Public Const FILE_MERGE_ERROR_BAD_WRITE = -8
Public Const FILE_MERGE_BAD_FILE_AT_POSITION = -10

'  definition for SortTypedArray
'   success/error code
Public Const ERR_STA_NO_ERROR = -1
Public Const ERR_STA_NO_ITEMS_TO_SORT = 0

'   standard data type
Public Const STA_BOOLEAN = 1                                   ' internal size = 2
Public Const STA_BYTE = 2                                      ' internal size = 1
Public Const STA_INTEGER = 3                                   ' internal size = 2
Public Const STA_LONG = 4                                      ' internal size = 4
Public Const STA_SINGLE = 5                                    ' internal size = 4
Public Const STA_DOUBLE = 6                                    ' internal size = 8
Public Const STA_CURRENCY = 7                                  ' internal size = 8
Public Const STA_DATE = 8                                      ' internal size = 8
Public Const STA_FIXSTRING_CI = 9                              ' internal size = * : fixed string length (case insensitive)
Public Const STA_FIXSTRING_CS = 10                             ' internal size = * : fixed string length (case sensitive)
Public Const STA_VARSTRING_CI = 11                             ' internal size = 4 : variable string length (case insensitive)
Public Const STA_VARSTRING_CS = 12                             ' internal size = 4 : variable string length (case sensitive)
Public Const STA_FIXSTRING_NUMBER = 13                         ' internal size = * : fixed string length (only number)
Public Const STA_VARSTRING_NUMBER = 14                         ' internal size = 4 : variable string length (only number)

'   variant data type
Public Const STA_VT_BOOLEAN = -STA_BOOLEAN                     ' internal size = 16
Public Const STA_VT_BYTE = -STA_BYTE                           ' internal size = 16
Public Const STA_VT_INTEGER = -STA_INTEGER                     ' internal size = 16
Public Const STA_VT_LONG = -STA_LONG                           ' internal size = 16
Public Const STA_VT_SINGLE = -STA_SINGLE                       ' internal size = 16
Public Const STA_VT_DOUBLE = -STA_DOUBLE                       ' internal size = 16
Public Const STA_VT_CURRENCY = -STA_CURRENCY                   ' internal size = 16
Public Const STA_VT_DATE = -STA_DATE                           ' internal size = 16
Public Const STA_VT_FIXSTRING_CI = -STA_VARSTRING_CI           ' internal size = 16
Public Const STA_VT_FIXSTRING_CS = -STA_VARSTRING_CS           ' internal size = 16
Public Const STA_VT_VARSTRING_CI = -STA_VARSTRING_CI           ' internal size = 16
Public Const STA_VT_VARSTRING_CS = -STA_VARSTRING_CS           ' internal size = 16
Public Const STA_VT_FIXSTRING_NUMBER = -STA_VARSTRING_NUMBER   ' internal size = 16
Public Const STA_VT_VARSTRING_NUMBER = -STA_VARSTRING_NUMBER   ' internal size = 16

' definition for EXTRACTISOLATE
Public Const EXTRACT_ISOLATE_LEFT = -1
Public Const EXTRACT_ISOLATE_RIGHT = 0

' structure for splittin path
Type tagSPLITPATH
   nDrive            As String
   nDir              As String
   nName             As String
   nExt              As String
End Type

' structure for file version information
Type tagFILEVERSIONINFO
   VersionProduct    As String
   VersionFile       As String
   CompanyName       As String
   FileDescription   As String
   FileVersion       As String
   InternalName      As String
   LegalCopyright    As String
   LegalTrademarks   As String
   Comments          As String
   ProductName       As String
   ProductVersion    As String
End Type

' structure for file attributes
Type FileAttributeType
   ErrNo             As Integer
   Archive           As Integer
   Hidden            As Integer
   Normal            As Integer
   ReadOnly          As Integer
   SubDir            As Integer
   System            As Integer
   VolId             As Integer
End Type

' structure for VB array
Type ArrayType
   Bounds            As Long
   LBound            As Integer
   UBound            As Integer
   ElemSize          As Integer
   IndexCount        As Integer
   TotalElem         As Integer
End Type

' structure for modules
Type tagMODULEENTRY
   dwSize            As Long
   szModule          As String * 10
   hModule           As Integer
   wcUsage           As Integer
   szExePath         As String * 256
   wNext             As Integer
End Type

' structure for tasks
Type tagTASKENTRY
   dwSize            As Long
   hTask             As Integer
   hTaskParent       As Integer
   hInst             As Integer
   hModule           As Integer
   wSS               As Integer
   wSP               As Integer
   wStackTop         As Integer
   wStackMinimum     As Integer
   wStackBottom      As Integer
   wcEvents          As Integer
   hQueue            As Integer
   szModule          As String * 10
   wPSPOffset        As Integer
   hNext             As Integer
End Type

' structure for disk array
Type tagDISKARRAY
   daSize            As Integer           'size of the type'd
   signature         As String * 7        'signature
   nFilename         As String * 64       'name of the file
   nType             As Integer           'variable type
   nRows             As Long              'number of rows
   nCols             As Long              'number of cols
   nSheets           As Long              'number of sheets
   rHandle           As Integer           'returned handle for use with other functions
   rElementSize      As Integer           'returned size of a element
   rFileSize         As Long              'returned size of the file
   rParts            As Long              'returned total part
   rRemain           As Long              'returned size of the remain part
   rSheetSize        As Long              'size of a sheet
   rOffset1          As Long              'returned offset 1
   rOffset2          As Long              'returned offset 2
   rTime             As Long              'time for the last correct transaction
   nIsTyped          As Integer           'is nType a type'd variable
   Dummy             As String * 7        'reserved for future use
End Type

' structure for multiple disk array
Type tagMULTIPLEDISKARRAY
   daSize               As Integer        'size of the structure
   signature            As String * 7     'signature
   nFilename            As String * 64    'name of the file
   nType(1 To 20)       As Integer        'standard variable type (for 20 arrays)
   nIsTyped(1 To 20)    As Integer        'is a type'd (for 20 arrays)
   nRows(1 To 20)       As Long           'number of rows (for 20 arrays)
   nCols(1 To 20)       As Long           'number of cols (for 20 arrays)
   nSheets(1 To 20)     As Long           'number of sheets (for 20 arrays)
   rHandle              As Integer        'returned handle for use with other functions
   rFileSize            As Long           'returned size of the file
   rElementSz(1 To 20)  As Integer        'returned size of a element (for 20 arrays)
   rSheetSz(1 To 20)    As Long           'size of a sheet (for 20 arrays)
   rOffsetPos(1 To 20)  As Long           'position of each array in the file (for 20 arrays)
   rOffset1             As Long           'returned offset 1
   rOffset2             As Long           'returned offset 2
   rTime                As Long           'time for the last correct transaction
   Dummy                As String * 29    'reserved for future use
End Type

' structure for huge memory array
Type tagHMA
   daSize            As Integer           'size of the type'd
   nType             As Integer           'variable type
   nRows             As Long              'number of rows
   nCols             As Long              'number of cols
   nSheets           As Long              'number of sheets
   rHandle           As Integer           'returned handle for use with other functions
   rElementSize      As Long              'returned size of a element
   rMemorySize       As Long              'returned size of the memory used
   rParts            As Long              'returned total part
   rRemain           As Long              'returned size of the remain part
   rSheetSize        As Long              'size of a sheet
   rOffset           As Long              'returned offset
   nIsTyped          As Integer           'is nType a type'd variable
   Dummy             As String * 20       'reserved for future use
End Type

' structure for serialization
Type tagSERIALDATA
   Description1      As String * 50       'serialization description 1
   Description2      As String * 50       'serialization description 2
   Number            As Long              'serialization number
   Dummy             As String * 50       'reserved for future use
End Type

' structure for 2-D geometry types
Type tagVECTOR2
   X                 As Double
   Y                 As Double
End Type

' structure for 3-D geometry types
Type tagVECTOR3
   X                 As Double
   Y                 As Double
   z                 As Double
End Type

' structure for get/set Media ID
Type tagMEDIAID
   InfoLevel         As Integer
   SerialNumber      As Long
   VolLabel          As String * 11
   FileSysType       As String * 8
End Type

' structure for Get Control Rectangle
Type tagRECT
   Left              As Integer
   Top               As Integer
   Right             As Integer
   Bottom            As Integer
End Type

' structure for 3D-Meter
Type tag3DMeter
   CrtValue          As Long              'current value
   MaxValue          As Long              'maximum value
   BackColor         As Long
   ForeColor         As Long
   Polygon           As Integer           '0  : rectangle, 1 : triangle, 2 : trapezium, 3 : ellipse , 4 : bars
   BarSize           As Integer           'size of a bar (polygon = 4) (in pixel : min=1,max=20,default=10)
   SpaceBars         As Integer           'space between bars (polygon = 4) (in pixel : min=1,max=4,default=2)
   Direction         As Integer           '0  : horizontal, other : vertical
   ThreeD            As Integer           '-1 : indented, 1 : raised
   Thickness         As Integer
   Percent           As Integer           'internal use, do not change
   OldPolygon        As Integer           'internal use, do not change
   OldDirection      As Integer           'internal use, do not change
   OldThreeD         As Integer           'internal use, do not change
   HatchBrush        As Integer           '-1 : solid brush, 0 : hor., 1 : ver., 2 : downward diag., 3 : upward diag., 4 : cross, 5 : diag.cross
End Type

' structure for File Information
Type tagFILEINFO
   fSize             As Long              'size of the file
   fDate             As Long              'date of the file (scalar date)
   fTime             As Long              'time of the file (scalar time)
   fAttribute        As Integer           'attribute of the file
End Type
   
'  structure for SortTypedArray
Type tagCONFIGARRAY
   RecordLength         As Long     ' internal use
   ActualKey            As Integer  ' internal use
   PreviousKey          As Integer  ' internal use
   KeyOffset(1 To 7)    As Integer  ' 0 is the higher key, 1 is the lower key
   KeyLength(1 To 7)    As Integer  ' length of the key (only for fixed string)
   KeyType(1 To 7)      As Integer  ' type of the key (see standard/variant data type)
   KeyOrder(1 To 7)     As Integer  ' -1 is reverse order, 0 is not used, 1 is ascending order
End Type

Rem Don't Remove It
Declare Sub c3D Lib "t2win-16.dll" (ByVal Ctl As Control, ByVal Method As Integer, ByVal Thickness As Integer)
Declare Sub c3DMeter Lib "t2win-16.dll" (ByVal Ctl As Control, Meter As tag3DMeter)
Declare Function cAddD Lib "t2win-16.dll" (array() As Double, ByVal nValue As Double) As Integer
Declare Function cAddDigit Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cAddI Lib "t2win-16.dll" (array() As Integer, ByVal nValue As Integer) As Integer
Declare Function cAddL Lib "t2win-16.dll" (array() As Long, ByVal nValue As Long) As Integer
Declare Function cAddS Lib "t2win-16.dll" (array() As Single, ByVal nValue As Single) As Integer
Declare Function cAddTime Lib "t2win-16.dll" (ByVal Hr As Integer) As Integer
Declare Function cAddTwoTimes Lib "t2win-16.dll" (ByVal Time1 As String, ByVal Time2 As String) As String
Declare Function cAlign Lib "t2win-16.dll" (Txt As String, ByVal TypeAlign As Integer, ByVal NewLength As Integer) As String
Declare Function cAllSubDirectories Lib "t2win-16.dll" (ByVal lpBaseDirectory As String, nDir As Integer) As String
Declare Function cAndToken Lib "t2win-16.dll" (ByVal Txt As String, ByVal Token As String) As Integer
Declare Function cAndTokenIn Lib "t2win-16.dll" (ByVal Txt As String, ByVal Token As String, ByVal Separator As String) As Integer
Declare Function cArabicToRoman Lib "t2win-16.dll" (Var As Variant) As String
Declare Sub cArrangeDesktopIcons Lib "t2win-16.dll" ()
Declare Function cArrayOnDisk Lib "t2win-16.dll" (ByVal FILE As String, array() As Any, ByVal GetPut As Integer) As Long
Declare Function cArrayPrm Lib "t2win-16.dll" (array() As Any, nArray As Any) As Integer
Declare Function cArrayStringOnDisk Lib "t2win-16.dll" (ByVal FILE As String, array() As String, ByVal GetPut As Integer, rRecords As Long) As Long
Declare Function cArrayToComboBox Lib "t2win-16.dll" (ByVal hWnd As Integer, array() As String) As Integer
Declare Function cArrayToListBox Lib "t2win-16.dll" (ByVal hWnd As Integer, array() As String) As Integer
Declare Function cB2I Lib "t2win-16.dll" (ByVal Txt As String) As Integer
Declare Function cB2L Lib "t2win-16.dll" (ByVal Txt As String) As Long
Declare Function cBaseConversion Lib "t2win-16.dll" (ByVal Num As String, ByVal RadixIn As Integer, ByVal RadixOut As Integer) As String
Declare Function cBetween Lib "t2win-16.dll" (Var As Variant, Var1 As Variant, Var2 As Variant) As Integer
Declare Function cBigAdd Lib "t2win-16.dll" (Num1 As String, Num2 As String) As String
Declare Function cBigDiv Lib "t2win-16.dll" (Num1 As String, Num2 As String) As String
Declare Function cBigMul Lib "t2win-16.dll" (Num1 As String, Num2 As String) As String
Declare Function cBigNum Lib "t2win-16.dll" (ByVal n1 As String, ByVal op As Integer, ByVal n2 As String) As String
Declare Function cBigSub Lib "t2win-16.dll" (Num1 As String, Num2 As String) As String
Declare Function cBigFmt Lib "t2win-16.dll" (Num As String, ByVal Length As Integer) As String
Declare Function cBlockCharFromLeft Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As String
Declare Function cBlockCharFromRight Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As String
Declare Sub cCenterWindow Lib "t2win-16.dll" (ByVal hWnd As Integer)
Declare Sub cChangeChars Lib "t2win-16.dll" (Txt As String, CharSet As String, NewCharSet As String)
Declare Sub cChangeCharsUntil Lib "t2win-16.dll" (Txt As String, CharSet As String, NewCharSet As String, nUntil As String)
Declare Sub cChangeTaskName Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal Text As String)
Declare Function cChDir Lib "t2win-16.dll" (ByVal lpDir As String) As Integer
Declare Function cChDrive Lib "t2win-16.dll" (ByVal lpDrive As String) As Integer
Declare Function cCheckChars Lib "t2win-16.dll" (Txt As String, CharSet As String) As Integer
Declare Function cCheckMinuteChange Lib "t2win-16.dll" () As Integer
Declare Function cCheckNumericity Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cCheckSecondChange Lib "t2win-16.dll" () As Integer
Declare Function cCheckTime Lib "t2win-16.dll" (ByVal Hr As Integer, ByVal Hr1 As Integer, ByVal Hr2 As Integer) As Integer
Declare Function cCheckWait Lib "t2win-16.dll" (ByVal nTimer As Integer) As Integer
Declare Function cCloseAllEditForm Lib "t2win-16.dll" () As Integer
Declare Function cHashMD5 Lib "t2win-16.dll" (Text As String) As String
Declare Function cCmpFileAttribute Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String) As Integer
Declare Function cCmpFileContents Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String, ByVal Sensitivity As Integer) As Integer
Declare Function cCmpFileSize Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String) As Integer
Declare Function cCmpFileTime Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String) As Integer
Declare Sub cCnvASCIItoEBCDIC Lib "t2win-16.dll" (Txt As String)
Declare Sub cCnvEBCDICtoASCII Lib "t2win-16.dll" (Txt As String)
Declare Function cCombination Lib "t2win-16.dll" (ByVal nItems As Integer, ByVal mTimes As Integer) As Double
Declare Function cComboFiles Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal Attributes As Long, ByVal FilePathMask As String) As Integer
Declare Function cComboSearchDir Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal StartPath As String, ByVal FileMask As String) As Long
Declare Function cComboSearchFile Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal StartPath As String, ByVal FileMask As String) As Long
Declare Function cComboSearchFileAttrib Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal StartPath As String, ByVal FileMask As String, ByVal iSearchAttribute As Integer) As Long
Declare Function cCompact Lib "t2win-16.dll" (Txt As String) As String
Declare Function cCompareTypeString Lib "t2win-16.dll" Alias "cTypesCompare" (TypeSrc As Any, ByVal Dst As String, ByVal lenTypeSrc As Integer) As Integer
Declare Function cCompareStringType Lib "t2win-16.dll" Alias "cTypesCompare" (ByVal Src As String, TypeDst As Any, ByVal lenTypeSrc As Integer) As Integer
Declare Function cCompress Lib "t2win-16.dll" (Txt As String) As String
Declare Function cCompressTab Lib "t2win-16.dll" (Txt As String, ByVal nTab As Integer) As String
Declare Sub cCtl3D Lib "t2win-16.dll" (ByVal Ctl As Control, ByVal LeftTopColor As Long, ByVal RightBottomColor As Long, ByVal Thickness As Integer)
Declare Function cConvert Lib "t2win-16.dll" (Value As String, ByVal MaskFrom As String, ByVal MaskTo As String, ByVal Size As Integer) As String
Declare Function cCount Lib "t2win-16.dll" (Txt As String, Separator As String) As Integer
Declare Function cCountDirectories Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cCountFiles Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cCountI Lib "t2win-16.dll" (array() As Integer, ByVal Value As Integer) As Long
Declare Function cCountL Lib "t2win-16.dll" (array() As Long, ByVal Value As Long) As Long
Declare Function cCountS Lib "t2win-16.dll" (array() As Single, ByVal Value As Single) As Long
Declare Function cCountD Lib "t2win-16.dll" (array() As Double, ByVal Value As Double) As Long
Declare Function cCplAlpha Lib "t2win-16.dll" (Txt As String) As String
Declare Function cCplDigit Lib "t2win-16.dll" (Txt As String) As String
Declare Function cCreateAndFill Lib "t2win-16.dll" (ByVal Length As Integer, Txt As String) As String
Declare Function cCreateBits Lib "t2win-16.dll" (ByVal nBits As Integer) As String
Declare Function cCurrentTime Lib "t2win-16.dll" () As Integer
Declare Function cCutFile Lib "t2win-16.dll" (ByVal SourceFile As String, ByVal TargetFile1 As String, ByVal TargetFile2 As String, ByVal CutPosition As Long) As Long
Declare Function cCVB Lib "t2win-16.dll" (Value As String) As Integer
Declare Function cCVC Lib "t2win-16.dll" (Value As String) As Currency
Declare Function cCVD Lib "t2win-16.dll" (Value As String) As Double
Declare Function cCVI Lib "t2win-16.dll" (Value As String) As Integer
Declare Function cCVL Lib "t2win-16.dll" (Value As String) As Long
Declare Function cCVS Lib "t2win-16.dll" (Value As String) As Single
Declare Function cCVSMBF Lib "t2win-16.dll" (Value As String) As Single
Declare Function cDAClear Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY) As Integer
Declare Function cDAClearCol Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, ByVal sheet As Long) As Integer
Declare Function cDAClearRow Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal sheet As Long) As Integer
Declare Function cDAClearSheet Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal sheet As Long) As Integer
Declare Sub cDAClose Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal DeleteFile As Integer)
Declare Function cDACreate Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal CreateOrUse As Integer) As Integer
Declare Function cDAGet Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long) As Variant
Declare Sub cDAGetType Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cDAPut Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, Var As Variant)
Declare Sub cDAPutType Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cDArGet Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, Var As Variant)
Declare Sub cDArGetType Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, nType As Any)
Declare Sub cDArPut Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, Var As Variant)
Declare Sub cDArPutType Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, nType As Any)
Declare Function cDAsClearCol Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long) As Integer
Declare Function cDAsClearRow Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long) As Integer
Declare Sub cDAsGet Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cDAsGetType Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Sub cDAsPut Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cDAsPutType Lib "t2win-16.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Function cDateToScalar Lib "t2win-16.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer) As Long
Declare Function cDayOfWeek Lib "t2win-16.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer, ByVal nISO As Integer) As Integer
Declare Function cDayOfYear Lib "t2win-16.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer) As Integer
Declare Function cDaysInMonth Lib "t2win-16.dll" (ByVal nYear As Integer, ByVal nMonth As Integer) As Integer
Declare Sub cDecrI Lib "t2win-16.dll" (Value As Integer)
Declare Sub cDecrL Lib "t2win-16.dll" (Value As Long)
Declare Function cDecrypt Lib "t2win-16.dll" (Txt As String, Password As String, ByVal level As Integer) As String
Declare Function cDeleteSubString Lib "t2win-16.dll" (ByVal Txt As String, ByVal SubString As String, ByVal Sensitivity As Integer) As String
Declare Function cDeviationD Lib "t2win-16.dll" (array() As Double) As Double
Declare Function cDeviationI Lib "t2win-16.dll" (array() As Integer) As Double
Declare Function cDeviationL Lib "t2win-16.dll" (array() As Long) As Double
Declare Function cDeviationS Lib "t2win-16.dll" (array() As Single) As Double
Declare Sub cDisableCtlRedraw Lib "t2win-16.dll" (Obj As Object)
Declare Sub cDisableFI Lib "t2win-16.dll" (Obj As Object)
Declare Sub cDisableForm Lib "t2win-16.dll" (ByVal hWnd As Integer)
Declare Sub cDisableRedraw Lib "t2win-16.dll" (ByVal hWnd As Integer)
Declare Function cDOSGetMediaID Lib "t2win-16.dll" (ByVal nDrive As String, MEDIAID As tagMEDIAID) As Integer
Declare Function cDOSGetVolumeLabel Lib "t2win-16.dll" (ByVal nDrive As String) As String
Declare Function cDOSSetMediaID Lib "t2win-16.dll" (ByVal nDrive As String, MEDIAID As tagMEDIAID) As Integer
Declare Function cDOSSetVolumeLabel Lib "t2win-16.dll" (ByVal nDrive As String, ByVal nVolumeLabel As String) As Integer
Declare Sub cEnableCtlRedraw Lib "t2win-16.dll" (Obj As Object)
Declare Sub cEnableFI Lib "t2win-16.dll" (Obj As Object)
Declare Sub cEnableForm Lib "t2win-16.dll" (ByVal hWnd As Integer)
Declare Sub cEnableRedraw Lib "t2win-16.dll" (ByVal hWnd As Integer)
Declare Function cEncrypt Lib "t2win-16.dll" (Txt As String, Password As String, ByVal level As Integer) As String
Declare Function cEXEnameActiveWindow Lib "t2win-16.dll" () As String
Declare Function cEXEnameWindow Lib "t2win-16.dll" (ByVal hModule As Integer) As String
Declare Function cEXEnameTask Lib "t2win-16.dll" (ByVal nFilename As String) As String
Declare Function cExitWindowsAndExecute Lib "t2win-16.dll" (ByVal lpszExe As String, ByVal lpszParams As String) As Integer
Declare Function cExpandTab Lib "t2win-16.dll" (Txt As String, ByVal nTab As Integer) As String
Declare Function cExtract Lib "t2win-16.dll" (ByVal Txt As String, ByVal Key As String, ByVal FieldSep As String, ByVal Sensitivity As Integer) As String
Declare Function cExtractIsolate Lib "t2win-16.dll" (ByVal Txt As String, ByVal Key As String, ByVal FieldSep As String, ByVal LeftOrRight As Integer, ByVal Sensitivity As Integer) As String
Declare Function cFileChangeChars Lib "t2win-16.dll" (ByVal nFilename As String, CharSet As String, NewCharSet As String, ByVal nFileTemp As String) As Long
Declare Function cFileCompress Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFileCompressTab Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String, ByVal nTab As Integer) As Long
Declare Function cFileCopy Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFileCRC32 Lib "t2win-16.dll" (ByVal lpFilename As String, ByVal Mode As Integer) As Long
Declare Function cFileDateCreated Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileDecrypt Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String, Password As String, ByVal level As Integer) As Long
Declare Function cFileDrive Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileEncrypt Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String, Password As String, ByVal level As Integer) As Long
Declare Function cFileExpand Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFileExpandTab Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String, ByVal nTab As Integer) As Long
Declare Function cFileFilter Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String, Filter As String) As Long
Declare Function cFileFilterNot Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String, Filter As String) As Long
Declare Function cFileForceCopy Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String, ByVal HeaderOrNot As Integer) As Long
Declare Function cFileGetAttrib Lib "t2win-16.dll" (ByVal nFilename As String, nFileAttribute As Any) As Integer
Declare Function cFileLastDateAccess Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastDateModified Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastTimeAccess Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastTimeModified Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileLineCount Lib "t2win-16.dll" (ByVal lpFilename As String) As Long
Declare Function cFileMerge Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String, ByVal fileTo As String) As Long
Declare Function cFileMergeExt Lib "t2win-16.dll" (FileArray() As String, ByVal TargetFile As String) As Long
Declare Function cFilePathExists Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cFileResetAllAttrib Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetArchive Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetFlag Lib "t2win-16.dll" (ByVal nFilename As String, ByVal nStatus As Integer) As Integer
Declare Function cFileResetHidden Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetReadOnly Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetSystem Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSearch Lib "t2win-16.dll" (ByVal nFilename As String, ByVal Search As String, ByVal Sensitivity As Integer) As Long
Declare Function cFileSearchAndReplace Lib "t2win-16.dll" (ByVal nFilename As String, ByVal Search As String, ByVal Replace As String, ByVal nFileTemp As String, ByVal Sensitivity As Integer) As Long
Declare Function cFileSearchCount Lib "t2win-16.dll" (ByVal nFilename As String, ByVal Search As String, ByVal Sensitivity As Integer) As Long
Declare Function cFileSetAllAttrib Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetArchive Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetAttrib Lib "t2win-16.dll" (ByVal nFilename As String, nFileAttribute As Any) As Integer
Declare Function cFileSetFlag Lib "t2win-16.dll" (ByVal nFilename As String, ByVal nStatus As Integer) As Integer
Declare Function cFileSetHidden Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetReadOnly Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetSystem Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cFilesInDirectory Lib "t2win-16.dll" (ByVal nFilename As String, ByVal FirstNext As Integer) As String
Declare Function cFilesInDirOnDisk Lib "t2win-16.dll" (ByVal nFile As String, ByVal nFilename As String, ByVal nAttribute As Integer) As Integer
Declare Function cFilesInDirToArray Lib "t2win-16.dll" (ByVal nFilename As String, ByVal nAttribute As Integer, array() As String) As Integer
Declare Function cFilesInfoInDir Lib "t2win-16.dll" (ByVal nFilename As String, FILEINFO As tagFILEINFO, ByVal FirstNext As Integer) As String
Declare Function cFileSize Lib "t2win-16.dll" (ByVal lpFilename As String) As Long
Declare Function cFileSort Lib "t2win-16.dll" (ByVal FileIn As String, ByVal FileOut As String, ByVal SortMethod As Integer, ByVal RecordLength As Long, ByVal KeyOffset As Long, ByVal KeyLength As Long, rRecords As Integer) As Long
Declare Function cFilesSize Lib "t2win-16.dll" (ByVal nFilename As String) As Double
Declare Function cFilesSizeOnDisk Lib "t2win-16.dll" (ByVal nFilename As String) As Double
Declare Function cFilesSlack Lib "t2win-16.dll" (ByVal nFilename As String, Size1 As Double, Size2 As Double) As Integer
Declare Function cFileStatistics Lib "t2win-16.dll" (ByVal nFilename As String, nLines As Long, nWords As Long, nChars As Long) As Long
Declare Function cFileTimeCreated Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cFileToComboBox Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal nFile As String) As Integer
Declare Function cFileToListBox Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal nFile As String) As Integer
Declare Function cFileToUpper Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFileToLower Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFileUUCP Lib "t2win-16.dll" (ByVal FileNameIn As String, ByVal FileNameOut As String, ByVal Mode As Integer, ByVal HeaderOrNot As Integer) As Long
Declare Sub cFill Lib "t2win-16.dll" (Txt As String, Fill As String)
Declare Function cFillD Lib "t2win-16.dll" (array() As Double, ByVal nValue As Double) As Integer
Declare Function cFillI Lib "t2win-16.dll" (array() As Integer, ByVal nValue As Integer) As Integer
Declare Function cFillL Lib "t2win-16.dll" (array() As Long, ByVal nValue As Long) As Integer
Declare Function cFillS Lib "t2win-16.dll" (array() As Single, ByVal nValue As Single) As Integer
Declare Function cFillIncrD Lib "t2win-16.dll" (array() As Double, ByVal nValue As Double, ByVal Increment As Double) As Integer
Declare Function cFillIncrI Lib "t2win-16.dll" (array() As Integer, ByVal nValue As Integer, ByVal Increment As Integer) As Integer
Declare Function cFillIncrL Lib "t2win-16.dll" (array() As Long, ByVal nValue As Long, ByVal Increment As Long) As Integer
Declare Function cFillIncrS Lib "t2win-16.dll" (array() As Single, ByVal nValue As Single, ByVal Increment As Single) As Integer
Declare Function cFilterBlocks Lib "t2win-16.dll" (Txt As String, Delimitor As String) As String
Declare Function cFilterChars Lib "t2win-16.dll" (Txt As String, CharSet As String) As String
Declare Function cFilterFirstChars Lib "t2win-16.dll" (Txt As String, CharSet As String) As String
Declare Function cFilterNotChars Lib "t2win-16.dll" (Txt As String, CharSet As String) As String
Declare Function cFindBitReset Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As Integer
Declare Function cFindBitSet Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As Integer
Declare Function cFindFileInEnv Lib "t2win-16.dll" (ByVal lpFilename As String, ByVal lpEnv As String) As Integer
Declare Function cFindFileInPath Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cFloppyInfo Lib "t2win-16.dll" (ByVal nDrive As String, nHeads As Integer, nCylinders As Integer, nSectors As Integer) As Integer
Declare Function cFraction Lib "t2win-16.dll" (ByVal nValue As Double, nNumerator As Double, nDenominator As Double) As Double
Declare Function cFromBinary Lib "t2win-16.dll" (Text As String) As String
Declare Function cFromBinary2 Lib "t2win-16.dll" (Text As String, Bin As String) As String
Declare Function cFromHexa Lib "t2win-16.dll" (Text As String) As String
Declare Function cFromZ9 Lib "t2win-16.dll" (Text As String) As String
Declare Function cFullPath Lib "t2win-16.dll" (ByVal nFilename As String) As String
Declare Function cFXpicture Lib "t2win-16.dll" (ByVal Method As Integer, ByVal hdc1 As Integer, ByVal hbitmap As Integer, ByVal parameter As Integer, ByVal delay As Integer) As Integer
Declare Function cGet Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As String
Declare Function cGetAscTime Lib "t2win-16.dll" (ByVal nLanguage As Integer) As String
Declare Function cGetBit Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As Integer
Declare Function cGetBitB Lib "t2win-16.dll" (ByVal Value As Byte, ByVal Position As Integer) As Integer
Declare Function cGetBitD Lib "t2win-16.dll" (ByVal Value As Double, ByVal Position As Integer) As Integer
Declare Function cGetBitI Lib "t2win-16.dll" (ByVal Value As Integer, ByVal Position As Integer) As Integer
Declare Function cGetBitL Lib "t2win-16.dll" (ByVal Value As Long, ByVal Position As Integer) As Integer
Declare Function cGetBitS Lib "t2win-16.dll" (ByVal Value As Single, ByVal Position As Integer) As Integer
Declare Function cGetBlock Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer, ByVal Length As Integer) As String
Declare Function cGetChangeTaskName Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal Text As String) As String
Declare Function cGetClassName Lib "t2win-16.dll" (ByVal hWnd As Integer) As String
Declare Function cGetCountry Lib "t2win-16.dll" () As String
Declare Function cGetCountryCode Lib "t2win-16.dll" () As String
Declare Function cGetCtlCaption Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlClass Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlContainer Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlDataField Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlForm Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlIndex Lib "t2win-16.dll" (Obj As Object) As Integer
Declare Function cGetCtlName Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlNameIndex Lib "t2win-16.dll" (Obj As Object) As String
Declare Sub cGetCtlRect Lib "t2win-16.dll" (ByVal Ctl As Control, RECT As Any)
Declare Sub cGetCtlRectTwips Lib "t2win-16.dll" (ByVal Ctl As Control, RECT As Any)
Declare Function cGetCtlTag Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCtlTagSized Lib "t2win-16.dll" (Obj As Object, ByVal nSize As Integer) As String
Declare Function cGetCtlText Lib "t2win-16.dll" (Obj As Object) As String
Declare Function cGetCurrency Lib "t2win-16.dll" () As String
Declare Function cGetCurrentDrive Lib "t2win-16.dll" () As String
Declare Function cGetDateFormat Lib "t2win-16.dll" () As String
Declare Function cGetDateSeparator Lib "t2win-16.dll" () As String
Declare Function cGetDefaultCurrentDir Lib "t2win-16.dll" () As String
Declare Function cGetDefaultPrinter Lib "t2win-16.dll" () As String
Declare Function cGetDevices Lib "t2win-16.dll" () As String
Declare Function cGetDiskClusterSize Lib "t2win-16.dll" (ByVal lpDrive As String) As Double
Declare Function cGetDiskFree Lib "t2win-16.dll" (ByVal lpDrive As String) As Double
Declare Function cGetDiskSpace Lib "t2win-16.dll" (ByVal lpDrive As String) As Double
Declare Function cGetDiskUsed Lib "t2win-16.dll" (ByVal lpDrive As String) As Double
Declare Function cGetDriveCurrentDir Lib "t2win-16.dll" (ByVal lpDrive As String) As String
Declare Function cGetDriveType Lib "t2win-16.dll" (ByVal lpDrive As String) As Integer
Declare Function cGetFileVersion Lib "t2win-16.dll" (ByVal FileName As String, ByVal nFonction As Integer) As String
Declare Function cGetFileVersionInfo Lib "t2win-16.dll" (ByVal FileName As String, FILEVERSIONINFO As Any) As Integer
Declare Function cGetFullNameInEnv Lib "t2win-16.dll" (ByVal lpFilename As String, ByVal lpEnv As String) As String
Declare Function cGetFullNameInPath Lib "t2win-16.dll" (ByVal lpFilename As String) As String
Declare Function cGetHourFormat Lib "t2win-16.dll" () As String
Declare Function cGetHwnd Lib "t2win-16.dll" (Obj As Object) As Integer
Declare Function cGetIn Lib "t2win-16.dll" (Txt As String, Separator As String, ByVal Position As Integer) As String
Declare Function cGetIni Lib "t2win-16.dll" (ByVal AppName As String, ByVal szItem As String, ByVal szDefault As String, ByVal InitFile As String) As String
Declare Function cGetInPart Lib "t2win-16.dll" (Txt As String, Separator As String, ByVal Position As Integer) As String
Declare Function cGetInPartR Lib "t2win-16.dll" (Txt As String, Separator As String, ByVal Position As Integer) As String
Declare Function cGetInR Lib "t2win-16.dll" (Txt As String, Separator As String, ByVal Position As Integer) As String
Declare Function cGetLanguage Lib "t2win-16.dll" () As String
Declare Function cGetListSeparator Lib "t2win-16.dll" () As String
Declare Function cGetLongDay Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nDay As Integer) As String
Declare Function cGetLongMonth Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nMonth As Integer) As String
Declare Function cGetNetConnection Lib "t2win-16.dll" (ByVal lpDrive As String, ErrCode As Integer) As String
Declare Function cGetPid Lib "t2win-16.dll" () As Integer
Declare Function cGetPrinterPorts Lib "t2win-16.dll" () As String
Declare Function cGetSectionItems Lib "t2win-16.dll" (ByVal Section As String, ByVal InitFile As String, nItems As Integer) As String
Declare Function cGetShortDay Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nDay As Integer) As String
Declare Function cGetShortMonth Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nMonth As Integer) As String
Declare Function cGetSmallDay Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nDay As Integer) As String
Declare Function cGetSystemDirectory Lib "t2win-16.dll" () As String
Declare Function cGetTaskName Lib "t2win-16.dll" (ByVal hWnd As Integer) As String
Declare Function cGetTimeSeparator Lib "t2win-16.dll" () As String
Declare Function cGetTinyDay Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nDay As Integer) As String
Declare Function cGetTinyMonth Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal nMonth As Integer) As String
Declare Function cGetVersion Lib "t2win-16.dll" () As Single
Declare Function cGetWindowsDirectory Lib "t2win-16.dll" () As String
Declare Function cGetWinINI Lib "t2win-16.dll" (ByVal Info As Integer) As String
Declare Function cGetWinSection Lib "t2win-16.dll" (ByVal Section As String) As String
Declare Function cGiveBitPalindrome Lib "t2win-16.dll" () As String
Declare Function cGZIPFileCompress Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cGZIPFileExpand Lib "t2win-16.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cGZIPStringCompress Lib "t2win-16.dll" (Txt As String) As String
Declare Function cGZIPStringExpand Lib "t2win-16.dll" (Txt As String) As String
Declare Function cH2I Lib "t2win-16.dll" (ByVal Txt As String) As Integer
Declare Function cH2L Lib "t2win-16.dll" (ByVal Txt As String) As Long
Declare Function cHideAllEditForm Lib "t2win-16.dll" () As Integer
Declare Function cHideDebugForm Lib "t2win-16.dll" () As Integer
Declare Function cHourTo Lib "t2win-16.dll" (Txt As String) As Variant
Declare Function cI2B Lib "t2win-16.dll" (ByVal Value As Integer) As String
Declare Function cIfInStr Lib "t2win-16.dll" (Txt As String, Operator As String) As String
Declare Sub cIncrI Lib "t2win-16.dll" (Value As Integer)
Declare Sub cIncrL Lib "t2win-16.dll" (Value As Long)
Declare Function cInsertBlocks Lib "t2win-16.dll" (Txt As String, Insert As String) As String
Declare Function cInsertBlocksBy Lib "t2win-16.dll" (Txt As String, Insert As String, Delimitor As String) As String
Declare Function cInsertByMask Lib "t2win-16.dll" (Txt As String, Mask As String, Insert As String) As String
Declare Function cInsertChars Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer, Insert As String) As String
Declare Function cInStr Lib "t2win-16.dll" (ByVal StartPosition As Integer, ByVal Txt As String, ByVal Search As String, ByVal Sensitivity As Integer) As Integer
Declare Function cIntoBalance Lib "t2win-16.dll" (Var As Variant) As String
Declare Function cIntoBalanceFill Lib "t2win-16.dll" (Var As Variant) As String
Declare Function cIntoDate Lib "t2win-16.dll" (ByVal nDate As Long) As String
Declare Function cIntoDateFill Lib "t2win-16.dll" (ByVal nDate As Long) As String
Declare Function cIntoDateNull Lib "t2win-16.dll" (ByVal nDate As Long) As String
Declare Function cIntoFixHour Lib "t2win-16.dll" (Var As Variant, ByVal Length As Integer, ByVal fillZero As Integer, ByVal Centime As Integer) As String
Declare Function cIntoHour Lib "t2win-16.dll" (Var As Variant) As String
Declare Function cIntoVarHour Lib "t2win-16.dll" (Var As Variant) As String
Declare Function cIsAlnum Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsAlpha Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsAscii Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsBalance Lib "t2win-16.dll" (ByVal nHour As Long, ByVal nMinute As Integer, ByVal nSecond As Integer) As Integer
Declare Function cIsBitPalindrome Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsCsym Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsCsymf Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsDate Lib "t2win-16.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer) As Integer
Declare Function cIsDigit Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsFileArchive Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileEmpty Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileFlag Lib "t2win-16.dll" (ByVal nFilename As String, ByVal nStatus As Integer) As Integer
Declare Function cIsFileHidden Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileNormal Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFilenameValid Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileReadOnly Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileSubDir Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileSystem Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileVolId Lib "t2win-16.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFormEnabled Lib "t2win-16.dll" (ByVal hWnd As Integer) As Integer
Declare Function cIsHour Lib "t2win-16.dll" (ByVal nHour As Integer, ByVal nMinute As Integer, ByVal nSecond As Integer) As Integer
Declare Function cIsISBN Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsLeapYear Lib "t2win-16.dll" (ByVal nYear As Integer) As Integer
Declare Function cIsLower Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsPalindrome Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsPunct Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsSerial Lib "t2win-16.dll" (ByVal File1 As String) As Integer
Declare Function cIsSpace Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsUpper Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cIsXdigit Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cKillDir Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillDirFilesAll Lib "t2win-16.dll" (ByVal lpDir As String, ByVal lpMask As String) As Integer
Declare Function cKillDirs Lib "t2win-16.dll" (ByVal lpDir As String, ByVal HeaderDirectory As Integer) As Integer
Declare Function cKillFile Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillFileAll Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillFiles Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillFilesAll Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cL2B Lib "t2win-16.dll" (ByVal Value As Long) As String
Declare Function cListFiles Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal Attributes As Long, ByVal FilePathMask As String) As Integer
Declare Function cListSearchDir Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal StartPath As String, ByVal FileMask As String) As Long
Declare Function cListSearchFile Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal StartPath As String, ByVal FileMask As String) As Long
Declare Function cListSearchFileAttrib Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal StartPath As String, ByVal FileMask As String, ByVal iSearchAttribute As Integer) As Long
Declare Function cLFill Lib "t2win-16.dll" (ByVal Txt As String, ByVal CharToFill As String, ByVal Length As Integer) As String
Declare Function cLngMsgBox Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal Message As String, ByVal Button As Long, ByVal title As String) As Integer
Declare Sub cLngBoxMsg Lib "t2win-16.dll" Alias "cLngMsgBox" (ByVal nLanguage As Integer, ByVal Message As String, ByVal Button As Long, ByVal title As String)
Declare Function cLngInpBox Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal Message As String, ByVal title As String, ByVal Default As String) As String
Declare Sub cLngSysMenu Lib "t2win-16.dll" (ByVal nLanguage As Integer, ByVal hWnd As Integer)
Declare Function cLrc Lib "t2win-16.dll" (Txt As String) As String
Declare Function cLSetIn Lib "t2win-16.dll" (ByVal Txt As String, ByVal Separator As String, ByVal Position As Integer, ByVal StringToInsert As String) As String
Declare Function cMakeDir Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cMakeMultipleDir Lib "t2win-16.dll" (ByVal lpFilename As String) As Integer
Declare Function cMakePath Lib "t2win-16.dll" (ByVal nDrive As String, ByVal nDir As String, ByVal nFilename As String, ByVal Ext As String) As String
Declare Function cMatchTable Lib "t2win-16.dll" (ByVal Txt As String, ByVal Match As String, ByVal Separator As String, ByVal Sensitivity As Integer) As Integer
Declare Sub cMatrixAdd Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayB() As Double, ArrayC() As Double)
Declare Function cMatrixCoFactor Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ByVal Row As Integer, ByVal Col As Integer) As Double
Declare Function cMatrixCompare Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double) As Integer
Declare Sub cMatrixCopy Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double)
Declare Function cMatrixDet Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double) As Double
Declare Function cMatrixFill Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ByVal nInit As Integer) As Integer
Declare Function cMatrixInv Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double) As Integer
Declare Function cMatrixMinor Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ByVal Row As Integer, ByVal Col As Integer) As Double
Declare Sub cMatrixMul Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayB() As Double, ArrayC() As Double)
Declare Sub cMatrixSub Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayB() As Double, ArrayC() As Double)
Declare Function cMatrixSymToeplitz Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double) As Integer
Declare Sub cMatrixTranspose Lib "t2win-16.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double)
Declare Function cMax Lib "t2win-16.dll" (Var1 As Variant, Var2 As Variant) As Variant
Declare Function cMaxD Lib "t2win-16.dll" (array() As Double) As Double
Declare Function cMaxI Lib "t2win-16.dll" (array() As Integer) As Integer
Declare Function cMaxL Lib "t2win-16.dll" (array() As Long) As Long
Declare Function cMaxS Lib "t2win-16.dll" (array() As Single) As Single
Declare Function cMaxNotXD Lib "t2win-16.dll" (array() As Double, ByVal ValueNotToReturn As Double) As Double
Declare Function cMaxNotXI Lib "t2win-16.dll" (array() As Integer, ByVal ValueNotToReturn As Integer) As Integer
Declare Function cMaxNotXL Lib "t2win-16.dll" (array() As Long, ByVal ValueNotToReturn As Long) As Long
Declare Function cMaxNotXS Lib "t2win-16.dll" (array() As Single, ByVal ValueNotToReturn As Single) As Single
Declare Function cMDAClear Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY) As Integer
Declare Function cMDAClearCol Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, ByVal sheet As Long) As Integer
Declare Function cMDAClearRow Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal sheet As Long) As Integer
Declare Function cMDAClearSheet Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal sheet As Long) As Integer
Declare Sub cMDAClose Lib "t2win-16.dll" (MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal DeleteFile As Integer)
Declare Function cMDACreate Lib "t2win-16.dll" (MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal CreateOrUse As Integer) As Integer
Declare Function cMDAGet Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long) As Variant
Declare Sub cMDAGetType Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cMDAPut Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, Var As Variant)
Declare Sub cMDAPutType Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cMDArGet Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, Var As Variant)
Declare Sub cMDArGetType Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, nType As Any)
Declare Sub cMDArPut Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, Var As Variant)
Declare Sub cMDArPutType Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, nType As Any)
Declare Function cMDAsClearCol Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long) As Integer
Declare Function cMDAsClearRow Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long) As Integer
Declare Sub cMDAsGet Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cMDAsGetType Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Sub cMDAsPut Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cMDAsPutType Lib "t2win-16.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Function cMeanD Lib "t2win-16.dll" (array() As Double) As Double
Declare Function cMeanI Lib "t2win-16.dll" (array() As Integer) As Double
Declare Function cMeanL Lib "t2win-16.dll" (array() As Long) As Double
Declare Function cMeanS Lib "t2win-16.dll" (array() As Single) As Double
Declare Function cMin Lib "t2win-16.dll" (Var1 As Variant, Var2 As Variant) As Variant
Declare Function cMinD Lib "t2win-16.dll" (array() As Double) As Double
Declare Function cMinI Lib "t2win-16.dll" (array() As Integer) As Integer
Declare Function cMinL Lib "t2win-16.dll" (array() As Long) As Long
Declare Function cMinS Lib "t2win-16.dll" (array() As Single) As Single
Declare Function cMinNotXD Lib "t2win-16.dll" (array() As Double, ByVal ValueNotToReturn As Double) As Double
Declare Function cMinNotXI Lib "t2win-16.dll" (array() As Integer, ByVal ValueNotToReturn As Integer) As Integer
Declare Function cMinNotXL Lib "t2win-16.dll" (array() As Long, ByVal ValueNotToReturn As Long) As Long
Declare Function cMinNotXS Lib "t2win-16.dll" (array() As Single, ByVal ValueNotToReturn As Single) As Single
Declare Function cMixChars Lib "t2win-16.dll" (Txt As String) As String
Declare Function cMKB Lib "t2win-16.dll" (ByVal Value As Integer) As String
Declare Function cMKC Lib "t2win-16.dll" (ByVal Value As Currency) As String
Declare Function cMKD Lib "t2win-16.dll" (ByVal Value As Double) As String
Declare Function cMKI Lib "t2win-16.dll" (ByVal Value As Integer) As String
Declare Function cMKL Lib "t2win-16.dll" (ByVal Value As Long) As String
Declare Function cMKN Lib "t2win-16.dll" (ByVal Value As String) As String
Declare Function cMKS Lib "t2win-16.dll" (ByVal Value As Single) As String
Declare Function cMKSMBF Lib "t2win-16.dll" (ByVal Value As Single) As String
Declare Function cMod10 Lib "t2win-16.dll" (ByVal Text As String) As Integer
Declare Function cMod10R Lib "t2win-16.dll" (ByVal Text As String) As Integer
Declare Function cMod11 Lib "t2win-16.dll" (ByVal Text As String) As Integer
Declare Function cMod11R Lib "t2win-16.dll" (ByVal Text As String) As Integer
Declare Function cMod137 Lib "t2win-16.dll" (ByVal Text As String) As Integer
Declare Function cMod137R Lib "t2win-16.dll" (ByVal Text As String) As Integer
Declare Function cModuleFind Lib "t2win-16.dll" (MODULEENTRY As Any, ByVal ModuleName As String) As Integer
Declare Function cModules Lib "t2win-16.dll" (MODULEENTRY As Any, ByVal FirstNext As Integer) As Integer
Declare Function cMorse Lib "t2win-16.dll" (ByVal morse As String) As String
Declare Sub cMultiTasksKeys95 Lib "t2win-16.dll" (ByVal nStatus As Integer)
Declare Function cNexthWnd Lib "t2win-16.dll" (ByVal hWnd As Integer) As Integer
Declare Function cNumDigit Lib "t2win-16.dll" (Txt As String) As Integer
Declare Function cOneCharFromLeft Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As String
Declare Function cOneCharFromRight Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As String
Declare Function cOrToken Lib "t2win-16.dll" (ByVal Txt As String, ByVal Token As String) As Integer
Declare Function cOrTokenIn Lib "t2win-16.dll" (ByVal Txt As String, ByVal Token As String, ByVal Separator As String) As Integer
Declare Function cPatternMatch Lib "t2win-16.dll" (ByVal Txt As String, ByVal Pattern As String) As Integer
Declare Function cPatternExtMatch Lib "t2win-16.dll" (ByVal Txt As String, ByVal Pattern As String) As Integer
Declare Function cProperName Lib "t2win-16.dll" (Txt As String) As String
Declare Function cProperName2 Lib "t2win-16.dll" (Txt As String, ByVal TokenToUse As String, ByVal Options As Integer) As String
Declare Sub cPutIni Lib "t2win-16.dll" (ByVal AppName As String, ByVal szItem As String, ByVal szDefault As String, ByVal InitFile As String)
Declare Function cRcsCountFileDir Lib "t2win-16.dll" (ByVal FileOrDir As Integer, ByVal FirstFileOrDir As String, ByVal MaskDir As String, ByVal Recurse As Integer) As Long
Declare Function cRcsFilesSize Lib "t2win-16.dll" (ByVal FirstDir As String, ByVal MaskDir As String, ByVal Recurse As Integer) As Double
Declare Function cRcsFilesSizeOnDisk Lib "t2win-16.dll" (ByVal FirstDir As String, ByVal MaskDir As String, ByVal Recurse As Integer) As Double
Declare Function cRcsFilesSlack Lib "t2win-16.dll" (ByVal FirstDir As String, ByVal MaskDir As String, ByVal Recurse As Integer, Size1 As Double, Size2 As Double) As Integer
Declare Function cReadBasisTimer Lib "t2win-16.dll" () As Long
Declare Function cReadCtlLanguage Lib "t2win-16.dll" (Frm As Form, ByVal Property As Integer, ByVal FileLanguage As String) As Integer
Declare Function cReadCtlLanguageExt Lib "t2win-16.dll" (Frm As Form, ByVal Property As Integer, ByVal FileLanguage As String) As Integer
Declare Function cReadTimer Lib "t2win-16.dll" (ByVal nTimer As Integer) As Long
Declare Function cRebootSystem Lib "t2win-16.dll" () As Integer
Declare Function cRegistrationKey Lib "t2win-16.dll" (ByVal RegString As String, ByVal RegCode As Long) As Long
Declare Function cRemoveBlockChar Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer, ByVal Length As Integer) As String
Declare Function cRemoveOneChar Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer) As String
Declare Function cRenameFile Lib "t2win-16.dll" (ByVal lpFilename1 As String, ByVal lpFilename2 As String) As Integer
Declare Sub cResetCapture Lib "t2win-16.dll" ()
Declare Function cResizeString Lib "t2win-16.dll" (Txt As String, ByVal NewLength As Integer) As String
Declare Function cResizeStringAndFill Lib "t2win-16.dll" (Txt As String, ByVal NewLength As Integer, Fill As String) As String
Declare Function cRestartWindows Lib "t2win-16.dll" () As Integer
Declare Function cReverse Lib "t2win-16.dll" (Txt As String) As String
Declare Sub cReverseAllBits Lib "t2win-16.dll" (Txt As String)
Declare Sub cReverseAllBitsByChar Lib "t2win-16.dll" (Txt As String)
Declare Function cReverseSortD Lib "t2win-16.dll" (array() As Double) As Integer
Declare Function cReverseSortI Lib "t2win-16.dll" (array() As Integer) As Integer
Declare Function cReverseSortL Lib "t2win-16.dll" (array() As Long) As Integer
Declare Function cReverseSortS Lib "t2win-16.dll" (array() As Single) As Integer
Declare Function cReverseSortStr Lib "t2win-16.dll" (Txt As String, ByVal nItem As Integer, ByVal ItemLength As Integer) As Integer
Declare Function cRFill Lib "t2win-16.dll" (ByVal Txt As String, ByVal CharToFill As String, ByVal Length As Integer) As String
Declare Sub cRndInit Lib "t2win-16.dll" (ByVal nRnd As Long)
Declare Function cRnd Lib "t2win-16.dll" () As Double
Declare Function cRndD Lib "t2win-16.dll" () As Double
Declare Function cRndI Lib "t2win-16.dll" () As Integer
Declare Function cRndL Lib "t2win-16.dll" () As Long
Declare Function cRndS Lib "t2win-16.dll" () As Single
Declare Function cRomanToArabic Lib "t2win-16.dll" (Txt As String) As Variant
Declare Function cRSetIn Lib "t2win-16.dll" (ByVal Txt As String, ByVal Separator As String, ByVal Position As Integer, ByVal StringToInsert As String) As String
Declare Function cRUBYdecrypt Lib "t2win-16.dll" (Text As String, Key As String, ByVal Mode As Integer) As String
Declare Function cRUBYencrypt Lib "t2win-16.dll" (Text As String, Key As String, ByVal Mode As Integer) As String
Declare Function cRUBYdecryptFile Lib "t2win-16.dll" (ByVal FileIn As String, ByVal FileOut As String, Key As String, ByVal Mode As Integer) As Long
Declare Function cRUBYencryptFile Lib "t2win-16.dll" (ByVal FileIn As String, ByVal FileOut As String, Key As String, ByVal Mode As Integer) As Long
Declare Function cSaveCtlLanguage Lib "t2win-16.dll" (Frm As Form, ByVal Property As Integer, ByVal FileLanguage As String) As Integer
Declare Function cSaveCtlLanguageExt Lib "t2win-16.dll" (Frm As Form, ByVal Property As Integer, ByVal FileLanguage As String) As Integer
Declare Sub cScalarToDate Lib "t2win-16.dll" (ByVal Scalar As Long, nYear As Integer, nMonth As Integer, nDay As Integer)
Declare Sub cScalarToTime Lib "t2win-16.dll" (ByVal Scalar As Long, nHour As Integer, nMin As Integer, nSec As Integer)
Declare Function cScrollL Lib "t2win-16.dll" (Txt As String) As String
Declare Function cScrollR Lib "t2win-16.dll" (Txt As String) As String
Declare Function cSearchI Lib "t2win-16.dll" (array() As Integer, ByVal Value As Integer) As Long
Declare Function cSearchL Lib "t2win-16.dll" (array() As Long, ByVal Value As Long) As Long
Declare Function cSearchS Lib "t2win-16.dll" (array() As Single, ByVal Value As Single) As Long
Declare Function cSearchD Lib "t2win-16.dll" (array() As Double, ByVal Value As Double) As Long
Declare Function cSearchDir Lib "t2win-16.dll" (ByVal lpStartPath As String, ByVal lpFileMask As String, ByVal lpFileResult As String) As Long
Declare Function cSearchFile Lib "t2win-16.dll" (ByVal lpStartPath As String, ByVal lpFileMask As String, ByVal lpFileResult As String) As Long
Declare Function cSearchFileAttrib Lib "t2win-16.dll" (ByVal lpStartPath As String, ByVal lpFileMask As String, ByVal iSearchAttribute As Integer, ByVal lpFileResult As String) As Long
Declare Sub cSetAllBits Lib "t2win-16.dll" (Txt As String, ByVal Value As Integer)
Declare Sub cSetBit Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer, ByVal Value As Integer)
Declare Sub cSetBitToFalse Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer)
Declare Sub cSetBitToTrue Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer)
Declare Sub cSetBitB Lib "t2win-16.dll" (Value As Byte, ByVal Position As Integer, ByVal BitValue As Integer)
Declare Sub cSetBitD Lib "t2win-16.dll" (Value As Double, ByVal Position As Integer, ByVal BitValue As Integer)
Declare Sub cSetBitI Lib "t2win-16.dll" (Value As Integer, ByVal Position As Integer, ByVal BitValue As Integer)
Declare Sub cSetBitL Lib "t2win-16.dll" (Value As Long, ByVal Position As Integer, ByVal BitValue As Integer)
Declare Sub cSetBitS Lib "t2win-16.dll" (Value As Single, ByVal Position As Integer, ByVal BitValue As Integer)
Declare Sub cSetCapture Lib "t2win-16.dll" (ByVal hWnd As Integer)
Declare Sub cSetCtlCaption Lib "t2win-16.dll" (Obj As Object, ByVal Text As String)
Declare Sub cSetCtlDataField Lib "t2win-16.dll" (Obj As Object, ByVal Text As String)
Declare Sub cSetCtlTag Lib "t2win-16.dll" (Obj As Object, ByVal Text As String)
Declare Sub cSetCtlText Lib "t2win-16.dll" (Obj As Object, ByVal Text As String)
Declare Function cSetD Lib "t2win-16.dll" (array() As Double, ByVal nValue As Double) As Integer
Declare Sub cSetDefaultSeparator Lib "t2win-16.dll" (Separator As String)
Declare Function cSetHandleCount Lib "t2win-16.dll" (ByVal nHandle As Integer) As Integer
Declare Function cSetI Lib "t2win-16.dll" (array() As Integer, ByVal nValue As Integer) As Integer
Declare Function cSetL Lib "t2win-16.dll" (array() As Long, ByVal nValue As Long) As Integer
Declare Function cSerialGet Lib "t2win-16.dll" (ByVal FILE As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialInc Lib "t2win-16.dll" (ByVal FILE As String, ByVal Increment As Long) As Integer
Declare Function cSerialPut Lib "t2win-16.dll" (ByVal FILE As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialRmv Lib "t2win-16.dll" (ByVal FILE As String) As Integer
Declare Function cSetS Lib "t2win-16.dll" (array() As Single, ByVal nValue As Single) As Integer
Declare Sub cSetWait Lib "t2win-16.dll" (ByVal nTimer As Integer, ByVal nValue As Long)
Declare Function cSgn Lib "t2win-16.dll" (ByVal Value As Integer) As Integer
Declare Function cShiftLeftD Lib "t2win-16.dll" (Darray() As Double, ByVal nValue As Double) As Integer
Declare Function cShiftLeftI Lib "t2win-16.dll" (Iarray() As Integer, ByVal nValue As Integer) As Integer
Declare Function cShiftLeftL Lib "t2win-16.dll" (Larray() As Long, ByVal nValue As Long) As Integer
Declare Function cShiftLeftS Lib "t2win-16.dll" (Sarray() As Single, ByVal nValue As Single) As Integer
Declare Function cShiftRightD Lib "t2win-16.dll" (Darray() As Double, ByVal nValue As Double) As Integer
Declare Function cShiftRightI Lib "t2win-16.dll" (Iarray() As Integer, ByVal nValue As Integer) As Integer
Declare Function cShiftRightL Lib "t2win-16.dll" (Larray() As Long, ByVal nValue As Long) As Integer
Declare Function cShiftRightS Lib "t2win-16.dll" (Sarray() As Single, ByVal nValue As Single) As Integer
Declare Sub cShowWindow Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal Method As Integer, ByVal interval As Integer)
Declare Function cSleep Lib "t2win-16.dll" (ByVal delay As Long) As Integer
Declare Function cSortD Lib "t2win-16.dll" (array() As Double) As Integer
Declare Function cSortI Lib "t2win-16.dll" (array() As Integer) As Integer
Declare Function cSortL Lib "t2win-16.dll" (array() As Long) As Integer
Declare Function cSortS Lib "t2win-16.dll" (array() As Single) As Integer
Declare Function cSortStr Lib "t2win-16.dll" (Txt As String, ByVal nItem As Integer, ByVal ItemLength As Integer) As Integer
Declare Function cSortTypedArray Lib "t2win-16.dll" (TypedArray() As Any, ConfigArray As tagCONFIGARRAY) As Integer
Declare Function cSpellMoney Lib "t2win-16.dll" (ByVal Value As Double, ByVal Units As String, ByVal Cents As String) As String
Declare Function cSplitFile Lib "t2win-16.dll" (ByVal SourceFile As String, ByVal TargetFiles As String, ByVal PartSize As Long) As Long
Declare Function cSplitPath Lib "t2win-16.dll" (ByVal nFilename As String, SPLITPATH As Any) As Integer
Declare Sub cStartBasisTimer Lib "t2win-16.dll" ()
Declare Sub cStartTimer Lib "t2win-16.dll" (ByVal nTimer As Integer)
Declare Sub cStartWait Lib "t2win-16.dll" (ByVal nTimer As Integer)
Declare Sub cStopBasisTimer Lib "t2win-16.dll" ()
Declare Function cStopTimer Lib "t2win-16.dll" (ByVal nTimer As Integer) As Long
Declare Function cStringCompress Lib "t2win-16.dll" (Txt As String) As String
Declare Function cStringCRC32 Lib "t2win-16.dll" (Txt As String) As Long
Declare Function cStringExpand Lib "t2win-16.dll" (Txt As String) As String
Declare Function cStringReplace Lib "t2win-16.dll" (ByVal Txt As String, ByVal Pattern As String, ByVal Sensitivity As Integer) As String
Declare Function cStringSAR Lib "t2win-16.dll" (ByVal Txt As String, ByVal Search As String, ByVal Replace As String, ByVal Sensitivity As Integer) As String
Declare Sub cStringToType Lib "t2win-16.dll" Alias "cTypesCopy" (ByVal Src As String, TypeDst As Any, ByVal lenTypeSrc As Integer)
Declare Function cSubDirectory Lib "t2win-16.dll" (ByVal nFilename As String, ByVal FirstNext As Integer) As String
Declare Function cSumD Lib "t2win-16.dll" (array() As Double) As Double
Declare Function cSumI Lib "t2win-16.dll" (array() As Integer) As Double
Declare Function cSumL Lib "t2win-16.dll" (array() As Long) As Double
Declare Function cSumS Lib "t2win-16.dll" (array() As Single) As Double
Declare Sub cSysMenuChange Lib "t2win-16.dll" (ByVal hWnd As Integer, ByVal Position As Integer, ByVal NewMessage As String)
Declare Sub cSwapD Lib "t2win-16.dll" (swap1 As Double, swap2 As Double)
Declare Sub cSwapI Lib "t2win-16.dll" (swap1 As Integer, swap2 As Integer)
Declare Sub cSwapL Lib "t2win-16.dll" (swap1 As Long, swap2 As Long)
Declare Sub cSwapS Lib "t2win-16.dll" (swap1 As Single, swap2 As Single)
Declare Sub cSwapStr Lib "t2win-16.dll" (swap1 As String, swap2 As String)
Declare Function cTaskFind Lib "t2win-16.dll" (TASKENTRY As Any, ByVal hTask As Integer) As Integer
Declare Function cTasks Lib "t2win-16.dll" (TASKENTRY As Any, ByVal FirstNext As Integer) As Integer
Declare Function cTimeBetween Lib "t2win-16.dll" (ByVal Hr1 As Integer, ByVal Hr2 As Integer) As Integer
Declare Function cTimerClose Lib "t2win-16.dll" (ByVal TimerHandle As Integer) As Integer
Declare Function cTimerOpen Lib "t2win-16.dll" () As Integer
Declare Function cTimerRead Lib "t2win-16.dll" (ByVal TimerHandle As Integer) As Long
Declare Function cTimerStart Lib "t2win-16.dll" (ByVal TimerHandle As Integer) As Integer
Declare Function cTimeToScalar Lib "t2win-16.dll" (ByVal nHour As Integer, ByVal nMin As Integer, ByVal nSec As Integer) As Long
Declare Function cToBinary Lib "t2win-16.dll" (Text As String) As String
Declare Function cToBinary2 Lib "t2win-16.dll" (Text As String, Bin As String) As String
Declare Sub cToggleAllBits Lib "t2win-16.dll" (Txt As String)
Declare Sub cToggleBit Lib "t2win-16.dll" (Txt As String, ByVal Position As Integer)
Declare Function cToHexa Lib "t2win-16.dll" (Text As String) As String
Declare Function cTokenIn Lib "t2win-16.dll" (Txt As String, Separator As String, ByVal Position As Integer) As String
Declare Function cToZ9 Lib "t2win-16.dll" (Text As String) As String
Declare Function cTrueBetween Lib "t2win-16.dll" (Var As Variant, Var1 As Variant, Var2 As Variant) As Integer
Declare Function cTruncatePath Lib "t2win-16.dll" (ByVal nFilename As String, ByVal NewLength As Integer) As String
Declare Sub cTypeClear Lib "t2win-16.dll" (TypeSrc As Any, ByVal lenTypeSrc As Integer)
Declare Function cTypeMid Lib "t2win-16.dll" (TypeSrc As Any, ByVal offset As Integer, ByVal Length As Integer) As String
Declare Function cTypesCompare Lib "t2win-16.dll" (Type1 As Any, Type2 As Any, ByVal lenType1 As Integer) As Integer
Declare Sub cTypesCopy Lib "t2win-16.dll" (TypeSrc As Any, TypeDst As Any, ByVal lenTypeSrc As Integer)
Declare Function cTypeTransfert Lib "t2win-16.dll" (TypeSrc As Any, ByVal lenTypeSrc As Integer) As String
Declare Sub cTypeToString Lib "t2win-16.dll" Alias "cTypesCopy" (TypeSrc As Any, ByVal Dst As String, ByVal lenTypeSrc As Integer)
Declare Function cUncompact Lib "t2win-16.dll" (Txt As String) As String
Declare Function cUnHideAllEditForm Lib "t2win-16.dll" () As Integer
Declare Function cUnHideDebugForm Lib "t2win-16.dll" () As Integer
Declare Function cUniqueFileName Lib "t2win-16.dll" (Txt As String) As String
Declare Sub cUnloadDLL Lib "t2win-16.dll" (ByVal hMod As Integer)
Declare Function cWalkThruWindow Lib "t2win-16.dll" (Class As String, Caption As String, OwnerHwnd As Integer, OwnerClass As String, OwnerCaption As String, ByVal FirstNext As Integer) As Integer
Declare Function cWeekOfYear Lib "t2win-16.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer, ByVal nISO As Integer) As Integer

Declare Sub cPushID Lib "t2win-16.dll" (IDArray As Integer, ByVal nID As Integer)
Declare Sub cPopID Lib "t2win-16.dll" (IDArray As Integer, ByVal nID As Integer)
Declare Sub cPopLastID Lib "t2win-16.dll" (IDArray As Integer)
Declare Function cGetID Lib "t2win-16.dll" (IDArray As Integer, ByVal nPosition As Integer) As Integer
Declare Sub cClearID Lib "t2win-16.dll" (IDArray As Integer)

' File I/O, direct routines issued from C functionnalities
Declare Function cFopen Lib "t2win-16.dll" (ByVal FILE As String, ByVal Mode As String) As Long
Declare Function cFclose Lib "t2win-16.dll" (ByVal IOstream As Long) As Integer
Declare Function cFgetc Lib "t2win-16.dll" (ByVal IOstream As Long) As Integer
Declare Function cFputc Lib "t2win-16.dll" (ByVal char As Integer, ByVal IOstream As Long) As Integer
Declare Function cFputs Lib "t2win-16.dll" (ByVal Txt As String, ByVal IOstream As Long) As Integer
Declare Function cFgets Lib "t2win-16.dll" (Txt As String, ByVal Length As Integer, ByVal IOstream As Long) As Integer
Declare Function cFwrite Lib "t2win-16.dll" (Txt As String, ByVal IOstream As Long) As Integer
Declare Function cFread Lib "t2win-16.dll" (Txt As String, ByVal Length As Integer, ByVal IOstream As Long) As Integer
Declare Function cFcloseall Lib "t2win-16.dll" () As Integer
Declare Function cFflush Lib "t2win-16.dll" (ByVal IOstream As Long) As Integer
Declare Function cFflushall Lib "t2win-16.dll" () As Integer
Declare Function cFeof Lib "t2win-16.dll" (ByVal IOstream As Long) As Integer
Declare Function cFerror Lib "t2win-16.dll" (ByVal IOstream As Long) As Integer
Declare Sub cFclearerr Lib "t2win-16.dll" (ByVal IOstream As Long)
Declare Function cFseek Lib "t2win-16.dll" (ByVal IOstream As Long, ByVal offset As Long, ByVal origin As Integer) As Integer
Declare Function cFtell Lib "t2win-16.dll" (ByVal IOstream As Long) As Long
Declare Sub cFrewind Lib "t2win-16.dll" (ByVal IOstream As Long)

' Functions for calculating interest rate
Declare Function cAtoF Lib "t2win-16.dll" (ByVal Interest As Double, ByVal n As Integer) As Double
Declare Function cAtoFC Lib "t2win-16.dll" (ByVal Rates As Double, ByVal n As Integer) As Double
Declare Function cAtoP Lib "t2win-16.dll" (ByVal Interest As Double, ByVal n As Integer) As Double
Declare Function cAtoPC Lib "t2win-16.dll" (ByVal Rates As Double, ByVal n As Integer) As Double
Declare Function cFtoA Lib "t2win-16.dll" (ByVal Interest As Double, ByVal n As Integer) As Double
Declare Function cFtoAC Lib "t2win-16.dll" (ByVal Rates As Double, ByVal n As Integer) As Double
Declare Function cFtoP Lib "t2win-16.dll" (ByVal Interest As Double, ByVal n As Integer) As Double
Declare Function cFtoPC Lib "t2win-16.dll" (ByVal Rates As Double, ByVal n As Integer) As Double
Declare Function cPtoA Lib "t2win-16.dll" (ByVal Interest As Double, ByVal n As Integer) As Double
Declare Function cPtoAC Lib "t2win-16.dll" (ByVal Rates As Double, ByVal n As Integer) As Double
Declare Function cPtoF Lib "t2win-16.dll" (ByVal Interest As Double, ByVal n As Integer) As Double
Declare Function cPtoFC Lib "t2win-16.dll" (ByVal Rates As Double, ByVal n As Integer) As Double

' Functions for calculating 2-D geometry
Declare Sub cV2Add Lib "t2win-16.dll" (u As tagVECTOR2, v As tagVECTOR2, w As tagVECTOR2)
Declare Sub cV2Sub Lib "t2win-16.dll" (u As tagVECTOR2, v As tagVECTOR2, w As tagVECTOR2)
Declare Sub cV2Combine Lib "t2win-16.dll" (u As tagVECTOR2, ByVal c1 As Double, v As tagVECTOR2, ByVal c2 As Double, w As tagVECTOR2)
Declare Sub cV2Copy Lib "t2win-16.dll" (u As tagVECTOR2, w As tagVECTOR2)
Declare Function cV2Dot Lib "t2win-16.dll" (u As tagVECTOR2, v As tagVECTOR2) As Double
Declare Function cV2Length Lib "t2win-16.dll" (u As tagVECTOR2) As Double
Declare Function cV2LengthSquared Lib "t2win-16.dll" (u As tagVECTOR2) As Double
Declare Sub cV2LinearIp Lib "t2win-16.dll" (lo As tagVECTOR2, hi As tagVECTOR2, ByVal alpha As Double, w As tagVECTOR2)
Declare Sub cV2Mul Lib "t2win-16.dll" (u As tagVECTOR2, v As tagVECTOR2, w As tagVECTOR2)
Declare Sub cV2Neg Lib "t2win-16.dll" (u As tagVECTOR2)
Declare Sub cV2Normalized Lib "t2win-16.dll" (u As tagVECTOR2)
Declare Sub cV2Ortho Lib "t2win-16.dll" (u As tagVECTOR2, w As tagVECTOR2)
Declare Sub cV2ScaledNewLength Lib "t2win-16.dll" (u As tagVECTOR2, ByVal newlen As Double)
Declare Function cV2SegmentLength Lib "t2win-16.dll" (p As tagVECTOR2, q As tagVECTOR2) As Double

' Functions for calculating 3-D geometry
Declare Sub cV3Add Lib "t2win-16.dll" (u As tagVECTOR3, v As tagVECTOR3, w As tagVECTOR3)
Declare Sub cV3Sub Lib "t2win-16.dll" (u As tagVECTOR3, v As tagVECTOR3, w As tagVECTOR3)
Declare Sub cV3Combine Lib "t2win-16.dll" (u As tagVECTOR3, ByVal c1 As Double, v As tagVECTOR3, ByVal c2 As Double, w As tagVECTOR3)
Declare Sub cV3Copy Lib "t2win-16.dll" (u As tagVECTOR3, w As tagVECTOR3)
Declare Sub cV3Cross Lib "t2win-16.dll" (u As tagVECTOR3, v As tagVECTOR3, w As tagVECTOR3)
Declare Function cV3Dot Lib "t2win-16.dll" (u As tagVECTOR3, v As tagVECTOR3) As Double
Declare Function cV3Length Lib "t2win-16.dll" (u As tagVECTOR3) As Double
Declare Function cV3LengthSquared Lib "t2win-16.dll" (u As tagVECTOR3) As Double
Declare Sub cV3LinearIp Lib "t2win-16.dll" (lo As tagVECTOR3, hi As tagVECTOR3, ByVal alpha As Double, w As tagVECTOR3)
Declare Sub cV3Mul Lib "t2win-16.dll" (u As tagVECTOR3, v As tagVECTOR3, w As tagVECTOR3)
Declare Sub cV3Neg Lib "t2win-16.dll" (u As tagVECTOR3)
Declare Sub cV3Normalized Lib "t2win-16.dll" (u As tagVECTOR3)
Declare Sub cV3ScaledNewLength Lib "t2win-16.dll" (u As tagVECTOR3, ByVal newlen As Double)
Declare Function cV3SegmentLength Lib "t2win-16.dll" (p As tagVECTOR3, q As tagVECTOR3) As Double

' Functions for Huge String management
Declare Function cHugeStrAdd Lib "t2win-16.dll" (ByVal hsHandle As Integer, hsText As String) As Integer
Declare Function cHugeStrAddress Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Long
Declare Function cHugeStrAppend Lib "t2win-16.dll" (ByVal hsHandle As Integer, hsText As String) As Integer
Declare Function cHugeStrBlocks Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Long
Declare Function cHugeStrClear Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Integer
Declare Function cHugeStrCreate Lib "t2win-16.dll" (ByVal hsSize As Long) As Integer
Declare Function cHugeStrFree Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Integer
Declare Function cHugeStrGetNP Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Long
Declare Function cHugeStrGetWP Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Long
Declare Function cHugeStrLength Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Long
Declare Function cHugeStrMid Lib "t2win-16.dll" (ByVal hsHandle As Integer, ByVal hsStart As Long, ByVal hsLength As Long) As String
Declare Function cHugeStrNext Lib "t2win-16.dll" (ByVal hsHandle As Integer, ByVal hsNext As Long) As String
Declare Function cHugeStrOnDisk Lib "t2win-16.dll" (ByVal hsHandle As Integer, ByVal hsFile As String, ByVal hsGetPut As Integer) As Long
Declare Function cHugeStrRead Lib "t2win-16.dll" (ByVal hsHandle As Integer, ByVal hsBlock As Long) As String
Declare Function cHugeStrSetNP Lib "t2win-16.dll" (ByVal hsHandle As Integer, ByVal hsPtr As Long) As Integer
Declare Function cHugeStrSetWP Lib "t2win-16.dll" (ByVal hsHandle As Integer, ByVal hsPtr As Long) As Integer
Declare Function cHugeStrSize Lib "t2win-16.dll" (ByVal hsHandle As Integer) As Long

' Functions for Huge Memory Array management
Declare Function cHMAClear Lib "t2win-16.dll" (HMA As tagHMA) As Integer
Declare Function cHMAClearCol Lib "t2win-16.dll" (HMA As tagHMA, ByVal Col As Long, ByVal sheet As Long) As Integer
Declare Function cHMAClearRow Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal sheet As Long) As Integer
Declare Function cHMAClearSheet Lib "t2win-16.dll" (HMA As tagHMA, ByVal sheet As Long) As Integer
Declare Function cHMACreate Lib "t2win-16.dll" (HMA As tagHMA) As Integer
Declare Function cHMAFree Lib "t2win-16.dll" (HMA As tagHMA) As Integer
Declare Function cHMAGet Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long) As Variant
Declare Sub cHMAGetType Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cHMAPut Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, Var As Variant)
Declare Sub cHMAPutType Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cHMArGet Lib "t2win-16.dll" (HMA As tagHMA, ByVal Col As Long, Var As Variant)
Declare Sub cHMArGetType Lib "t2win-16.dll" (HMA As tagHMA, ByVal Col As Long, nType As Any)
Declare Sub cHMArPut Lib "t2win-16.dll" (HMA As tagHMA, ByVal Col As Long, Var As Variant)
Declare Sub cHMArPutType Lib "t2win-16.dll" (HMA As tagHMA, ByVal Col As Long, nType As Any)
Declare Sub cHMAsGet Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cHMAsGetType Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Sub cHMAsPut Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cHMAsPutType Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Function cHMAsClearCol Lib "t2win-16.dll" (HMA As tagHMA, ByVal Col As Long) As Integer
Declare Function cHMAsClearRow Lib "t2win-16.dll" (HMA As tagHMA, ByVal Row As Long) As Integer
Declare Function cHMAOnDisk Lib "t2win-16.dll" (HMA As tagHMA, ByVal hsFile As String, ByVal hsGetPut As Integer) As Long

' functions for accessing OCX and VBX custom controls
Declare Sub cObjectMethodByPos Lib "t2win-16.dll" (Obj As Object, ByVal Property As Integer, lpPut As Variant)
Declare Function cObjectGetPropertyByPos Lib "t2win-16.dll" (Obj As Object, ByVal Property As Integer) As Variant
Declare Sub cObjectPutPropertyByPos Lib "t2win-16.dll" (Obj As Object, ByVal Property As Integer, lpPut As Variant)
Declare Sub cObjectMethodByName Lib "t2win-16.dll" (Obj As Object, ByVal Property As String, lpPut As Variant)
Declare Function cObjectGetPropertyByName Lib "t2win-16.dll" (Obj As Object, ByVal Property As String) As Variant
Declare Sub cObjectPutPropertyByName Lib "t2win-16.dll" (Obj As Object, ByVal Property As String, lpPut As Variant)

' Mail and News processing

Public Const BTOA_CANT_OPEN_SOURCE = -1
Public Const BTOA_CANT_OPEN_TARGET = -2

Declare Function cBtoA Lib "t2win-16.dll" (ByVal FileIn As String, ByVal FileOut As String) As Long
Declare Function cAtoB Lib "t2win-16.dll" (ByVal FileIn As String) As Long

' constants for error processing

Public Const MNRET_OK = 0       'everything went fine
Public Const MNRET_IOERR = 1    'I/O Error - examine errno
Public Const MNRET_NOMEM = 2    'not enough memory
Public Const MNRET_ILLVAL = 3   'illegal value for operation
Public Const MNRET_NODATA = 4   'decoder didn't find any data
Public Const MNRET_NOEND = 5    'encoded data wasn't ended properly
Public Const MNRET_UNSUP = 6    'unsupported function (encoding)
Public Const MNRET_EXISTS = 7   'file exists (decoding)
Public Const MNRET_CONT = 8     'continue -- special from ScanPart
Public Const MNRET_CANCEL = 9   'operation canceled

' constants for OptionNO in cMNGetOption and cMNSetOption

Public Const MNOPT_VERSION = 0         'version number MAJOR.MINORplPATCH (ro)
Public Const MNOPT_FAST = 1            'assumes only one part per file
Public Const MNOPT_DUMBNESS = 2        'switch off the program's intelligence
Public Const MNOPT_BRACKPOL = 3        'give numbers in [] higher precendence
Public Const MNOPT_VERBOSE = 4         'generate informative messages
Public Const MNOPT_DESPERATE = 5       'try to decode incomplete files
Public Const MNOPT_IGNREPLY = 6        'ignore RE:plies (off by default)
Public Const MNOPT_OVERWRITE = 7       'whether it's OK to overwrite ex. files
Public Const MNOPT_SAVEPATH = 8        'prefix to save-files on disk
Public Const MNOPT_IGNMODE = 9         'ignore the original file mode
Public Const MNOPT_DEBUG = 10          'print messages with FILE/LINE info
Public Const MNOPT_ERRNO = 14          'get last error code for UURET_IOERR (ro)
Public Const MNOPT_PROGRESS = 15       'retrieve progress information
Public Const MNOPT_USETEXT = 16        'handle text messages
Public Const MNOPT_PREAMB = 17         'handle Mime preambles/epilogues
Public Const MNOPT_TINYB64 = 18        'detect short B64 outside of Mime
Public Const MNOPT_ENCEXT = 19         'extension for single-part encoded files

' constants for TypeOfEncoding in cMNEncode and cMNWalkInList

Public Const MN_UU_ENCODED = 1         'UUencoded data
Public Const MN_B64ENCODED = 2         'Mime-Base64 data
Public Const MN_XX_ENCODED = 3         'XXencoded data
Public Const MN_BH_ENCODED = 4         'Binhex encoded
Public Const MN_PT_ENCODED = 5         'Plain-Text encoded (MIME)
Public Const MN_QP_ENCODED = 6         'Quoted-Printable (MIME)

' constants for Mime Headers in cMNEncode
Public Const MNHDR_NONE = 0            'No MIME headers (use standard headers)
Public Const MNHDR_SIMPLE = 1          'Simple MIME (no addressing)
Public Const MNHDR_MAIL = 2            'MIME E-mail format
Public Const MNHDR_NEWS = 3            'MIME News format

' constants for FileState (may be OR'ed) in cMNWalkInList

Public Const MNSTATE_READ = 0          'Read in, but not further processed
Public Const MNSTATE_MISPART = 1       'Missing Part(s) detected
Public Const MNSTATE_NOBEGIN = 2       'No 'begin' found
Public Const MNSTATE_NOEND = 4         'No 'end' found
Public Const MNSTATE_NODATA = 8        'File does not contain valid uudata
Public Const MNSTATE_OK = 16           'All Parts found, ready to decode
Public Const MNSTATE_ERROR = 32        'Error while decoding
Public Const MNSTATE_DECODED = 64      'Successfully decoded
Public Const MNSTATE_TMPFILE = 128     'Temporary decoded file exists

Declare Function cMNInitialize Lib "t2win-16.dll" () As Long
Declare Function cMNShutdown Lib "t2win-16.dll" () As Long
Declare Function cMNGetOption Lib "t2win-16.dll" (ByVal OptionNo As Long, LongVal As Long, StringVal As String) As Integer
Declare Function cMNSetOption Lib "t2win-16.dll" (ByVal OptionNo As Long, ByVal LongVal As Long, ByVal StringVal As String) As Integer
Declare Function cMNEncode Lib "t2win-16.dll" (ByVal FileIn As String, ByVal FileOut As String, ByVal NameInFile As String, ByVal TypeOfEncoding As Long, ByVal linesperfile As Long, ByVal MimeHeaders As Integer, ByVal Sender As String, ByVal Receiver As String, ByVal Subject As String) As Long
Declare Function cMNLoadInList Lib "t2win-16.dll" (ByVal FileName As String, ByVal DeleteAfterDecoding As Long) As Long
Declare Function cMNCountInList Lib "t2win-16.dll" () As Long
Declare Function cMNFirstInList Lib "t2win-16.dll" (Ptr As Long) As Integer
Declare Function cMNWalkInList Lib "t2win-16.dll" (ByVal Ptr As Long, FileName As String, TypeOfEncoding As Integer, FileState As Long, NextPtr As Long) As Integer
Declare Function cMNGetSubjectInList Lib "t2win-16.dll" (ByVal Ptr As Long) As String
Declare Function cMNGetMimeIDInList Lib "t2win-16.dll" (ByVal Ptr As Long) As String
Declare Function cMNGetMimeContentInList Lib "t2win-16.dll" (ByVal Ptr As Long) As String
Declare Function cMNRenameInList Lib "t2win-16.dll" (ByVal Ptr As Long, ByVal NewFileName As String) As Integer
Declare Function cMNDecodeFromList Lib "t2win-16.dll" (ByVal Ptr As Long, FileState As Long, ErrorCodeForDecodeOperation As Long, ErrorCodeForMoveOperation As Long) As Long


