VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Project INI Test Form"
   ClientHeight    =   5490
   ClientLeft      =   3360
   ClientTop       =   1935
   ClientWidth     =   3390
   Height          =   5895
   Left            =   3300
   LinkTopic       =   "Form1"
   ScaleHeight     =   5490
   ScaleWidth      =   3390
   Top             =   1590
   Width           =   3510
   Begin Frame Frame1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Test Project INI"
      Height          =   5160
      Left            =   210
      TabIndex        =   5
      Top             =   165
      Width           =   2940
      Begin CommandButton Command2 
         Caption         =   "Read Project INI"
         Height          =   375
         Left            =   465
         TabIndex        =   4
         Top             =   4590
         Width           =   1950
      End
      Begin TextBox Text4 
         Height          =   300
         Left            =   165
         TabIndex        =   10
         TabStop         =   0   'False
         Top             =   4140
         Width           =   2580
      End
      Begin CommandButton Command1 
         Caption         =   "Save to Project INI"
         Height          =   375
         Left            =   480
         TabIndex        =   3
         Top             =   2760
         Width           =   1950
      End
      Begin TextBox Text3 
         Height          =   300
         Left            =   180
         TabIndex        =   2
         Top             =   2295
         Width           =   2580
      End
      Begin TextBox Text2 
         Height          =   300
         Left            =   150
         TabIndex        =   1
         Top             =   1515
         Width           =   2580
      End
      Begin TextBox Text1 
         Height          =   300
         Left            =   150
         TabIndex        =   0
         Top             =   720
         Width           =   2580
      End
      Begin Label Label4 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Entry ="
         ForeColor       =   &H000000FF&
         Height          =   345
         Left            =   165
         TabIndex        =   9
         Top             =   3855
         Width           =   2655
      End
      Begin Label Label3 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Entry ="
         ForeColor       =   &H000000FF&
         Height          =   345
         Left            =   180
         TabIndex        =   8
         Top             =   1995
         Width           =   2655
      End
      Begin Label Label2 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Entry Name"
         ForeColor       =   &H000000FF&
         Height          =   345
         Left            =   150
         TabIndex        =   7
         Top             =   1215
         Width           =   2655
      End
      Begin Label Label1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "[SECTION] Name"
         ForeColor       =   &H000000FF&
         Height          =   345
         Left            =   120
         TabIndex        =   6
         Top             =   390
         Width           =   2655
      End
   End
End
    Option Explicit

    Dim Section$
    Dim Entry$
    Dim EntryData$
    Dim ProjectINIpath$

Sub Command1_Click ()

    ' The following gets current directory and assures your ini file will be
    ' created in this directory.
    
    ' If ProjectINIpath$ does not specify a directory, test.ini will be created in
    ' your Windows   directory -- should not do this unless there is a
    ' specific reason for file to be in Windows directory.
    ProjectINIpath$ = CurDir$ & "\" & "test.ini"
    
    ' Custom is upper case for section headings -- improves human readability of large files
    Section$ = UCase$(Trim$(Text1.Text))
    
    ' Entry name can be any string.  Practice is that words are separated as Test_String
    ' rather than using a space.
    Entry$ = Trim$(Text2.Text)
    
    ' As above, Entry Data can be any string.  The INI read function limits string to 255
    ' characters with no imbeded nulls.  An entry can be removed by letting
    ' EntryData$ = "" -- a null string.
    EntryData$ = Trim$(Text3.Text)
    
    ' This is just for demo application, although you want to be sure you send
    ' valid data to ini file.
    If Section$ = "" Or Entry$ = "" Then
        MsgBox "Oops!"
        Exit Sub
    End If
    
    WriteProjectINI Section$, Entry$, EntryData$, ProjectINIpath$

    Dim dummy As Integer    ' just for this test display
    dummy = Shell("notepad " & ProjectINIpath$, 1)

End Sub

Sub Command2_Click ()

    Dim ReturnString$

    ReturnString$ = ReadProjectINI$(Section$, Entry$, ProjectINIpath$)

    Text4.Text = ReturnString$

    ' As you can see, recovery of an entry in your ini file is quite simple.  In this
    ' example we supplied the same values to the ReadProjectINI$ function as were used
    ' to write to the file by declaring the variables as form wide in scope.
    ' You can also simply use the appropriate string values such as "TEST" instead of
    ' Section$ = "TEST".  For that matter, "test" would also work as the
    ' parameters supplied to the function are not case sensitive.

    ' I would also mention that if your entry data is not found, the function returns
    ' a null string.   so, you could test for returned data by doing something
    ' like the following:

    ' if ReturnString = "" then
        ' do something here
    ' end if

    ' As you are often wanted to get a numeric value to initialize some Variable,
    ' you can do something like what is shown below:

    ' MyVariable = Val(ReadProjectINI$(Section$, Entry$, ProjectINIpath$))
    ' This reads your ini file, returns a number string which is converted to a
    ' numeric value and assigned to MyVariable.


End Sub

Sub Form_Paint ()

    Text1.SetFocus

End Sub

