Option Explicit
Global Const MODAL = 1
Global Const WM_USER = &H400
Global Const EM_SETREADONLY = (WM_USER + 31)
Global Const GWW_HWNDPARENT = (-8)
Global Const BUTTON_FACE = &H8000000F
Global Const WINDOW_BACKGROUND = &H80000005

Global Const REG_SZ = 1
Global Const HKEY_CLASSES_ROOT = &H80000000
Global Const HKEY_CURRENT_USER = &H80000001
Global Const HKEY_LOCAL_MACHINE = &H80000002
Global Const HKEY_USERS = &H80000003

Declare Function GetVersion Lib "Kernel" () As Long
Declare Function GetWinFlags Lib "Kernel" () As Long
Declare Function SendMessage Lib "User" (ByVal hWnd%, ByVal Msg%, ByVal wParam%, lParam As Any) As Long
Declare Function SetWindowWord Lib "User" (ByVal hWnd%, ByVal nIndex%, ByVal wNewWord%) As Integer

Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%, ByVal lpFileName$) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpValue$, ByVal lpFileName$) As Integer

Declare Function RegCreateKey Lib "shell.dll" (ByVal hKey&, ByVal SubKey$, pHKey&) As Long
Declare Function RegSetValue Lib "shell.dll" (ByVal hKey&, ByVal SubKey$, ByVal StrType&, ByVal KeyValue$, ByVal KeyStrLen&) As Long
Declare Function RegCloseKey Lib "shell.dll" (ByVal hKey&) As Long
Declare Function RegQueryValue Lib "shell.dll" (ByVal hKey&, ByVal SubKey$, ByVal ReturnString$, RetLen&) As Long

Function GetPos (sFormName$, iLeft%, iTop%) As Integer

    Dim iResult As Integer
    Dim sBuffer As String
    Dim sIniFile As String
    Dim sKeyName As String
    Dim sNull As String
    Dim sResult As String

    ' Assume this function will succeed
    ' (Okay, so I'm an optimist!)
    GetPos = False

    ' Are we running under a 32-bit OS?
    If OS32() Then
	' If so, use Registry
	sKeyName = "Software\Infotech\API Demo\" & sFormName
	sResult = RegistryGet(sKeyName & "\Left")
	If Len(sResult) Then
	    iLeft = Val(sResult)
	    iTop = Val(RegistryGet(sKeyName & "\Top"))
	Else
	    GetPos = True
	End If
    Else
	' If not, use INI file
	sBuffer = String$(255, 0)
	sIniFile = App.EXEName & ".ini"
	iResult = GetPrivateProfileString(sFormName, "Left", sNull, sBuffer, Len(sBuffer), sIniFile)
	If iResult Then
	    iLeft = Val(Left$(sBuffer, iResult))
	    iResult = GetPrivateProfileString(sFormName, "Top", sNull, sBuffer, Len(sBuffer), sIniFile)
	    iTop = Val(Left$(sBuffer, iResult))
	Else
	    GetPos = True
	End If
    End If

End Function

Function OS32 ()

    Dim iLoVer As Integer
    Dim iHiVer As Integer
    Dim iVer As Integer
    Dim iResult As Integer
    Dim lResult As Long

    OS32 = False

    ' The following will be True
    ' under Windows NT
    lResult = GetWinFlags()
    If (lResult And &H4000) > 0 Then
	OS32 = True
	Exit Function
    End If

    ' This code identifies Win95
    iResult = (GetVersion() And &HFFFF&)
    iHiVer = iResult And &HFF
    iLoVer = iResult \ 256
    iVer = (iHiVer * 100) + iLoVer
    If iVer >= 395 Then OS32 = True

End Function

Function RegistryGet (sKeyName As String) As String

    Dim lBufLen As Long
    Dim lResult As Long
    Dim sBuffer As String

    lBufLen = 255
    sBuffer = String$(lBufLen, 32)
    lResult = RegQueryValue(HKEY_CURRENT_USER, sKeyName, sBuffer, lBufLen)
    RegistryGet = RTrim$(sBuffer)

End Function

Function RegistryInit (sKeyName As String) As Long

    Dim hKey As Long
    Dim lResult As Long

    lResult = RegCreateKey(HKEY_CURRENT_USER, sKeyName, hKey&)
    RegistryInit = hKey&

End Function

Function RegistrySet (hKey As Long, sItem As String, sValue As String) As Long

    RegistrySet = RegSetValue&(hKey, sItem, REG_SZ, sValue, Len(sItem))

End Function

Sub SavePos (sFormName$, ByVal iLeft%, ByVal iTop%)

    Dim hKey As Long
    Dim lResult As Long
    Dim sIniFile As String
    Dim sKeyName As String

    If OS32() Then
	sKeyName = "Software\Infotech\API Demo\" & sFormName
	hKey = RegistryInit(sKeyName)
	If hKey Then
	    lResult = RegistrySet(hKey, "Left", LTrim$(Str$(iLeft)))
	    lResult = RegistrySet(hKey, "Top", LTrim$(Str$(iTop)))
	    lResult = RegCloseKey(hKey)
	End If
    Else
	sIniFile = App.EXEName & ".INI"
	lResult = WritePrivateProfileString(sFormName, "Left", LTrim$(Str$(iLeft)), sIniFile)
	lResult = WritePrivateProfileString(sFormName, "Top", LTrim$(Str$(iTop)), sIniFile)
    End If

End Sub

