Option Explicit

'constants
Global Const WINSTATE_NORMAL = 0
Global Const WINSTATE_MINIMIZED = 1
Global Const WINSTATE_MAXIMIZED = 2

Global Const MODAL = 1
Global Const MODLESS = 0

Global Const MOUSE_DEFAULT = 0
Global Const MOUSE_CROSS = 2
Global Const MOUSE_MOVE = 5
Global Const MOUSE_HOURGLASS = 11

Global Const WM_USER = &H400
Global Const EM_GETSEL = WM_USER + 0
Global Const EM_SETSEL = WM_USER + 1
Global Const EM_GETRECT = WM_USER + 2
Global Const EM_SETRECT = WM_USER + 3
Global Const EM_LINEINDEX = WM_USER + 11
Global Const EM_LINELENGTH = WM_USER + 17
Global Const EM_GETLINE = WM_USER + 20

Global Const DB_LANG_GENERAL = ";LANGID=0x0809;CP=1252;COUNTRY=0"
' Field Data Types
Global Const DB_BOOLEAN = 1
Global Const DB_BYTE = 2
Global Const DB_INTEGER = 3
Global Const DB_LONG = 4
Global Const DB_CURRENCY = 5
Global Const DB_SINGLE = 6
Global Const DB_DOUBLE = 7
Global Const DB_DATE = 8
Global Const DB_TEXT = 10
Global Const DB_LONGBINARY = 11
Global Const DB_MEMO = 12

'defined types
Type TableSpec          'field specs for a db table
    strName As String
    intType As Integer
    intSize As Integer
End Type

Type IndexSpec          'index specs for a db table
    strName As String
    strDesc As String
    intPrim As Integer
    intUniq As Integer
End Type

Sub BuildFileList (strDirName As String, strFiles() As String)
    'this will take all of the file names  in strDirName and put them into strFiles
    'be sure to dimention the array before calling this (use dim strFiles(0) as string)
    'make sure strDirName ends with a '\'
    Dim strFileName As String
    ReDim strFiles(0)
   
    strFileName = Dir$(strDirName, 6)  ' 6 indicates normal hidden and special files
    Do Until strFileName = ""
	If strFiles(UBound(strFiles)) <> "" Then    ' increase dimention if last field is filled
	    ReDim Preserve strFiles(UBound(strFiles) + 1)' use preserve to keep old entries
	End If
	strFiles(UBound(strFiles)) = strFileName 'add it to the array
	strFileName = Dir$ 'get the next filename from the list
    Loop
End Sub

Function CountOf (strMain, strDelim) As Integer
' count the number of strDelim in strMain
Dim intCount As Integer
Dim intLpCnt As Integer
Dim intCharPos As Integer
Dim intMainLen As Integer
Dim intDelimLen As Integer

'initialize
intCount = 0
intMainLen = Len(strMain)
intDelimLen = Len(strDelim)
CountOf = 0
intCharPos = 1

If strDelim = "" Then Exit Function

Do
    intCharPos = InStr(intCharPos, strMain, strDelim)
    If intCharPos = 0 Then
	Exit Do
    End If
    intCount = intCount + 1
    intCharPos = intCharPos + intDelimLen
Loop

CountOf = intCount

End Function

Function CreateTable (dbOpen As Database, strTableName As String, udtFSpecs() As TableSpec, udtISpecs() As IndexSpec) As Integer
    'creates a new table in an open database
    'if the table exists, it is removed and rebuilt

'declarations
Dim tblNew As New TableDef
Dim fldNew As Field
Dim indNew As Index
Dim intLpCnt As Integer

'inititalization
CreateTable = False

'main()

    'search to see if table exists
    On Error GoTo errKillTable
    dbOpen.TableDefs.Refresh
    For intLpCnt = 0 To dbOpen.TableDefs.Count - 1
	If UCase(dbOpen.TableDefs(intLpCnt).Name) = UCase(strTableName) Then
	    dbOpen.TableDefs.Delete dbOpen.TableDefs(strTableName)
	    Exit For
	    DoEvents
	End If
    Next
    
    On Error GoTo errTableCreate
    'create the tabledef
    tblNew.Name = strTableName

    'create the first field in the tabledef
    Set fldNew = New Field
    fldNew.Name = udtFSpecs(0).strName
    fldNew.Type = udtFSpecs(0).intType
    fldNew.Size = udtFSpecs(0).intSize
    tblNew.Fields.Append fldNew
    
    'append the tabledef to the database
    dbOpen.TableDefs.Append tblNew
    
    'now add all other fields
    For intLpCnt = 1 To UBound(udtFSpecs)
	Set fldNew = New Field
	fldNew.Name = udtFSpecs(intLpCnt).strName
	fldNew.Type = udtFSpecs(intLpCnt).intType
	fldNew.Size = udtFSpecs(intLpCnt).intSize
	dbOpen.TableDefs(tblNew.Name).Fields.Append fldNew
	DoEvents
    Next intLpCnt

    CreateTable = True

    ' add the indecies
    On Error GoTo errIndexCreate
    For intLpCnt = 0 To UBound(udtISpecs)
	If udtISpecs(intLpCnt).strName = "" Then Exit For
	Set indNew = New Index
	indNew.Name = udtISpecs(intLpCnt).strName
	indNew.Fields = udtISpecs(intLpCnt).strDesc
	indNew.Unique = udtISpecs(intLpCnt).intUniq
	indNew.Primary = udtISpecs(intLpCnt).intPrim
	dbOpen.TableDefs(tblNew.Name).Indexes.Append indNew
	DoEvents
ndIndexCreate:
    Next intLpCnt
    dbOpen.TableDefs.Refresh
ndCreateTable:

Exit Function

errKillTable:
    MsgBox "Could not remove table '" & strTableName & "'"
    Resume ndCreateTable

errTableCreate:
    MsgBox "Could not create table '" & strTableName & "'.  Err# " & Err & " - " & Error$(Err)
    'dbOpen.TableDefs.Delete dbOpen.TableDefs(strTableName)
    On Error Resume Next
    Resume ndCreateTable

errIndexCreate:
    On Error Resume Next
    If Err <> 9 Then
	MsgBox "Index '" & udtISpecs(intLpCnt).strName & "' not created!"
	Resume ndIndexCreate
    Else
	Resume ndCreateTable
    End If

End Function

Function GetField (strMain As String, intPos As Integer, strDelim As String) As String
'return the intPos string of strMain delimited by strDelim
Dim intMainLen As Integer
Dim intDelimLen As Integer
Dim intFieldCnt As Integer
Dim strOutPut As String
Dim strParsing As String
Dim intCharPos As Integer
Dim intLastPos As Integer

If intPos = 0 Then
    GetField = strMain
    Exit Function
End If

'initialize
GetField = ""
intMainLen = Len(strMain)
intDelimLen = Len(strDelim)
intLastPos = 1
intFieldCnt = 1
strOutPut = ""
strParsing = ""

intCharPos = 1
Do
    intCharPos = InStr(intCharPos, strMain, strDelim)
    If intCharPos = 0 Then
	If intFieldCnt = intPos Then
	    strOutPut = Mid$(strMain, intLastPos)
	End If
	Exit Do
    End If
    If intFieldCnt = intPos Then
	strOutPut = Mid$(strMain, intLastPos, intCharPos - intLastPos)
	Exit Do
    End If
    intLastPos = intCharPos + intDelimLen
    intCharPos = intCharPos + 1
    intFieldCnt = intFieldCnt + 1
Loop

If intFieldCnt = intPos Then GetField = strOutPut

    
End Function

Function isValidFile (strPath As String) As Integer
    'checks for valid existing filespec
    Dim strRC As String
    Dim intValid As Integer
    
    On Error GoTo ErrIsValidFile
    intValid = False
    If Right$(strPath, 1) <> "\" Then
	strRC = Dir$(strPath)
	If strRC <> "" Then
	    strRC = Dir$
	    If strRC = "" Then intValid = True
	End If
    End If
NDIsValidFile:
    isValidFile = intValid
Exit Function
ErrIsValidFile:
    Resume NDIsValidFile
End Function

Function IsValidPath (strPath As String) As Integer
    'checks for valid existing path
    Dim strRC As String
    Dim intValid As Integer
    
    On Error GoTo ErrIsValidPath
    intValid = False
    If Right$(strPath, 1) = "\" Then
	strRC = Dir$(strPath)
	If strRC <> "" Then
	    intValid = True
	End If
    End If
NDIsValidPath:
    IsValidPath = intValid
Exit Function
ErrIsValidPath:
    Resume NDIsValidPath
End Function

Function JulianDate (dblDate As Double) As Integer
    'returns julian date for dlbDate
    Dim dblJan1 As Double   'january 1st of whatever year
    Dim intJulian As Integer
    Dim strYear As String 'year for conversion

    strYear = Format$(dblDate, "yyyy")
    dblJan1 = CVDate("01/01/" & strYear)
    intJulian = DateDiff("y", dblJan1, dblDate)
    JulianDate = intJulian + 1
End Function

Function Numerics (strTest As String) As String
    'given a string, returns only the characters that are numbers
Dim strRtn As String
Dim strTemp As String
Dim intTestLen As Integer
Dim intLpCnt As Integer

    strRtn = ""
    intTestLen = Len(strTest)
    For intLpCnt = 1 To intTestLen
	strTemp = Mid$(strTest, intLpCnt, 1)
	If IsNumeric(strTemp) Then
	    strRtn = strRtn & strTemp
	End If
    Next intLpCnt
    Numerics = strRtn
End Function

Function Replace (strMain As String, strOld As String, strNew As String, intTimes As Integer) As String
'replace strOld with strNew in strMain intTimes times
'if intTimes is 0 replace all
Dim intMainLen As Integer
Dim intOldLen As Integer
Dim intNewLen As Integer
Dim intReplCnt As Integer
Dim intCharCnt As Integer
Dim intLastPos As Integer
Dim intReplFlag As Integer
Dim strOutPut As String

If strOld = "" Then
    Replace = strMain
    Exit Function
End If

'initialize
intMainLen = Len(strMain)
intOldLen = Len(strOld)
intNewLen = Len(strNew)
intReplCnt = 0
strOutPut = ""
Replace = ""
intCharCnt = 1
intLastPos = 1

If intTimes < 0 Then
    MsgBox "Invalid paramater passed."
    Replace = strMain
    Exit Function
End If

Do
    If intReplCnt <> 0 Then
	If intReplCnt = intTimes Then
	    strOutPut = strOutPut & Mid$(strMain, intLastPos)
	    Exit Do
	End If
    End If
    intCharCnt = InStr(intCharCnt, strMain, strOld)
    If intCharCnt = 0 Then
	strOutPut = strOutPut & Mid$(strMain, intLastPos)
	Exit Do
    End If
    strOutPut = strOutPut & Mid$(strMain, intLastPos, (intCharCnt - intLastPos)) & strNew
    intLastPos = intCharCnt + intOldLen
    intCharCnt = intCharCnt + intOldLen
    intReplCnt = intReplCnt + 1
    
Loop

Replace = strOutPut

End Function

Sub sleep (intTime As Integer)
Dim dblTime As Double
    dblTime = Timer
    Do Until Timer > dblTime + intTime
	DoEvents
    Loop
End Sub

Function StringCompress (strMain As String, strChar As String) As String
Dim strNew As String
Dim strTemp As String * 1
Dim intSizeOf As Integer
Dim intLpCnt As Integer
    'squeezes multiple occurances of strChar into one
    On Error Resume Next
strNew = strMain
Do
    intLpCnt = InStr(strNew, strChar & strChar)
    If intLpCnt = 0 Then Exit Do
    strNew = Mid$(strNew, 1, intLpCnt) & Mid(strNew, intLpCnt + 2)
Loop
StringCompress = strNew
End Function

