Option Explicit

Global intXferStop As Integer

'ini file management
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lpFileName As String) As Integer
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lplFileName As String) As Integer
Global intMachineCnt As Integer

Function ftpcommand (CtlData As String) As Integer
    On Error Resume Next
    
    If GetField(CtlData, 1, " ") = "PASS" Then
        frmClient.txtStatus.Text = frmClient.txtStatus.Text & Chr$(13) & Chr$(10) & "<local>PASS " & String$(Len(CtlData) - 5, "*")
    Else
        frmClient.txtStatus.Text = frmClient.txtStatus.Text & Chr$(13) & Chr$(10) & "<local>" & CtlData
    End If
    frmClient.txtStatus.SelStart = Len(frmClient.txtStatus.Text)

    'append a carriage return and linefeed to the data
    CtlData = CtlData & Chr$(13) & Chr$(10)
    'set the transmit buffer length to the length of the string
    frmClient.Socket1.SendLen = Len(CtlData)
    'send the data
    frmClient.Socket1.SendData = CtlData

    'check for errors
    If Err <> 0 Then
        ftpcommand = False
    Else
        ftpcommand = True
    End If

End Function

Function FTPConnect (HostName As String)
    Dim CtlData As String, Reply As Integer

    FTPConnect = False
    If HostName = "" Then Exit Function

    'internet address family
    frmClient.Socket1.AddressFamily = AF_INET
    'internet protocol
    frmClient.Socket1.Protocol = IPPROTO_IP
    'streaming socket (most reliable way to send data)
    frmClient.Socket1.Type = SOCK_STREAM
    'connect to ftp port on remote host (port 21)
    frmClient.Socket1.RemotePort = IPPORT_FTP
    'set remote host name
    frmClient.Socket1.HostName = HostName
    'transfer data in ascii
    frmClient.Socket1.Binary = False
    'use 1024 byte packets to pass data
    frmClient.Socket1.BufferSize = 1024
    'turn on socket block (synchronous transmission)
    'will not return control to caller until process is complete
    frmClient.Socket1.Blocking = True

    On Error Resume Next
    'call the socket connect
    frmClient.Socket1.Action = SOCKET_CONNECT
    If Err Then
        MsgBox Error$
        Exit Function
    End If

    'get the results from the connect
    Reply = FTPResult(CtlData)
    
    'if connect resulted in 220 then fine,
    'otherwise close the socket
    If Reply = 220 Then
        FTPConnect = True
    Else
        frmClient.Socket1.Action = SOCKET_CLOSE
    End If

End Function

Sub FTPGetDirectory ()
    Dim CtlData As String
    Dim Buffer As String
    Dim intRC As Integer
    Dim intLpCnt As Integer
    Dim intDirCnt As Integer
    Dim strLine As String
    Dim strPerm As String
    Dim strFName As String
    Dim strFSize As String
    
    'clear the list and caption
    frmClient.lstRemFiles.Clear
    frmClient.lblRemPath.Caption = ""

    'send the command PWD (Present Working Directory) to remote
    If Not ftpcommand("PWD") Then Exit Sub
    'code 257 - got directory
    If Left$(Str$(FTPResult(CtlData)), 3) <> " 25" Then Exit Sub

    'parse directory out of returned string
    CtlData = Mid$(CtlData, 2, InStr(CtlData, " ") - 3)
    frmClient.lblRemPath.Caption = CtlData
    
    'If ftpcommand("SYST") Then intRC = FTPResult(CtlData)

    'get the file list
    If Not FTPListen(0) Then Exit Sub 'listen in ascii
    If Not ftpcommand("LIST") Then Exit Sub
    'code 150 - starting transfer
    If Left$(Str(FTPResult(CtlData)), 2) <> " 1" Then
        frmClient.Socket2.Action = SOCKET_CLOSE
        Exit Sub
    End If
    'start accepting listing in second socket
    frmClient.Socket2.Action = SOCKET_ACCEPT
    On Error Resume Next
    
    If Err Then
        MsgBox Error$
        frmClient.Socket2.Action = SOCKET_CLOSE
        Exit Sub
    End If
    Buffer = ""
    Do
        'size of packet to recieve
        frmClient.Socket2.RecvLen = 4092
'        frmClient.Socket2.RecvLen = 512
        'receive the data packet
        Buffer = Buffer & frmClient.Socket2.RecvData
        If Err Then
            MsgBox Error$
            Exit Do
        End If
        If frmClient.Socket2.RecvLen = 0 Then Exit Do
        'permit other system operations
        DoEvents
    Loop
    'close the secondary socket
    frmClient.Socket2.Action = SOCKET_CLOSE
    'wait for close verification
    intRC = FTPResult(CtlData)

    intDirCnt = CountOf(Buffer, Chr$(13))
    For intLpCnt = 1 To intDirCnt
        strLine = StringCompress(GetField(Buffer, intLpCnt, Chr$(13) & Chr$(10)), " ")
        strPerm = GetField(strLine, 1, " ")
        If Len(strPerm) = 10 And (Mid$(strPerm, 2, 1) = "-" Or Mid$(strPerm, 2, 1) = "r") Then
        'buffer is a unix type ls -l output
'drwx------   4 owner      group         512 Aug 11 11:25 DiretoryName
'-rwxr-xr-x   1 owner      group         501 Jun 26 09:09 FileName
            strFName = GetField(strLine, 9, " ")
            strFSize = GetField(strLine, 5, " ")
            If strFName <> "." Then 'ignore present directory
                If UCase(Left$(strPerm, 1)) = "D" Then
                    'put brackets around directories
                    frmClient.lstRemFiles.AddItem "<" & strFName & ">"
                Else
                    frmClient.lstRemFiles.AddItem strFName
                    frmClient.lstRemFiles.ItemData(frmClient.lstRemFiles.NewIndex) = strFSize
                End If
            End If
        Else
        'buffer is something else
            If Not (strPerm = "total" And GetField(strLine, 3, " ") = "") Then
                strFName = GetField(strLine, 1, " ")
                'take the heading off of it
                intRC = InStr(strFName, ".")
                If intRC <> 0 Then
                    strFName = Mid$(strFName, intRC + 1, Len(strFName))
                End If
                strFSize = GetField(strLine, 6, " ")
                frmClient.lstRemFiles.AddItem strFName
                frmClient.lstRemFiles.ItemData(frmClient.lstRemFiles.NewIndex) = strFSize
            End If
        End If
        If intLpCnt Mod 5 = 0 Then
            frmClient.lstRemFiles.TopIndex = intLpCnt - 5
            frmClient.lstRemFiles.Refresh
        End If
    Next intLpCnt
    frmClient.lstRemFiles.TopIndex = 0
End Sub

Function FTPGetFile (RemoteFile As String, LocalFile As String)
    Dim CtlData As String, Buffer As String
    Dim Result As Integer
    Dim intMode As Integer
    Dim lngFSize As Long
    Dim lngXSize As Long
    Dim intLpCnt As Integer
    Dim strFHold As String

    FTPGetFile = False

    If RemoteFile = "" Or LocalFile = "" Then Exit Function
    'do not permit exit or refresh at this time
    'frmClient.MousePointer = MOUSE_HOURGLASS
    frmClient.cmdLocRef.Enabled = False
    frmClient.cmdRemRef.Enabled = False
    frmClient.FileMenu.Enabled = False
    frmClient.mnuSession.Enabled = False
    intXferStop = False
    frmClient.lblXferText.Caption = "Retrieving file '" & RemoteFile & "' ( ? bytes)"
    frmClient.pnlXferGauge.FloodPercent = 0
    frmClient.pnlXferStat.Visible = True
    'start listening for the remote machine connection
    If frmClient.rdoAscii.Value Then
        intMode = 0
    Else
        intMode = 1
    End If
    If Not FTPListen(intMode) Then
        frmClient.cmdLocRef.Enabled = True
        frmClient.cmdRemRef.Enabled = True
        frmClient.FileMenu.Enabled = True
        frmClient.mnuSession.Enabled = True
        frmClient.pnlXferStat.Visible = False
        frmClient.MousePointer = MOUSE_DEFAULT
        MsgBox "Could not get remote system to respond."
        Exit Function
    End If
    'tell the remote host which file we want to retrieve
    If Not ftpcommand("RETR " & RemoteFile) Then
        frmClient.cmdLocRef.Enabled = True
        frmClient.cmdRemRef.Enabled = True
        frmClient.FileMenu.Enabled = True
        frmClient.mnuSession.Enabled = True
        frmClient.pnlXferStat.Visible = False
        frmClient.MousePointer = MOUSE_DEFAULT
        frmClient.Socket2.Action = SOCKET_CLOSE
        MsgBox "Could not open file on remote system. - No transfer"
        Exit Function
    End If
    'code 150 - starting transfer
    If Left$(Str(FTPResult(CtlData)), 2) <> " 1" Then
        frmClient.cmdLocRef.Enabled = True
        frmClient.cmdRemRef.Enabled = True
        frmClient.FileMenu.Enabled = True
        frmClient.mnuSession.Enabled = True
        frmClient.pnlXferStat.Visible = False
        frmClient.MousePointer = MOUSE_DEFAULT
        frmClient.Socket2.Action = SOCKET_CLOSE
        MsgBox "Could not initiate transfer from remote system."
        Exit Function
    End If
    
    frmClient.txtStatus.Text = frmClient.txtStatus.Text & Chr$(13) & Chr$(10) & "<Comment>Opening retrieval socket."
    frmClient.txtStatus.SelStart = Len(frmClient.txtStatus.Text)
    'give remote time to initiate transfer
    sleep (1)
    'start accepting file in second socket
    frmClient.Socket2.Action = SOCKET_ACCEPT
    DoEvents
    If Not frmClient.Socket2.Connected Then
        frmClient.cmdLocRef.Enabled = True
        frmClient.cmdRemRef.Enabled = True
        frmClient.FileMenu.Enabled = True
        frmClient.mnuSession.Enabled = True
        frmClient.pnlXferStat.Visible = False
        frmClient.MousePointer = MOUSE_DEFAULT
        frmClient.Socket2.Action = SOCKET_ABORT
        frmClient.pnlXferStat.Visible = False
        MsgBox "Remote system is not accepting file requests."
        Exit Function
    End If
    On Error Resume Next
    frmClient.txtStatus.Text = frmClient.txtStatus.Text & Chr$(13) & Chr$(10) & "<Comment>Retrieving file length."
    frmClient.txtStatus.SelStart = Len(frmClient.txtStatus.Text)
    'look up file size
    strFHold = GetField(RemoteFile, (CountOf(RemoteFile, "/") + 1), "/")
    strFHold = GetField(strFHold, (CountOf(strFHold, "\") + 1), "\")
    lngFSize = 1
    For intLpCnt = 0 To frmClient.lstRemFiles.ListCount - 1
        If strFHold = frmClient.lstRemFiles.List(intLpCnt) Then
            lngFSize = frmClient.lstRemFiles.ItemData(intLpCnt)
            Exit For
        End If
    Next intLpCnt
    lngXSize = 0
    frmClient.lblXferText.Caption = "Retrieving file '" & RemoteFile & "' (" & lngFSize & " bytes)"
    frmClient.pnlXferGauge.FloodPercent = lngXSize
    frmClient.pnlXferStat.Visible = True
    
    'open file for writing
    Open LocalFile For Binary As #1
    If Err Then
        MsgBox Error$
        frmClient.Socket2.Shutdown = 0
        frmClient.Socket2.Action = SOCKET_CLOSE
        frmClient.pnlXferStat.Visible = False
        Exit Function
    End If

    FTPGetFile = True
    
    'loop through loading file
    Do
        'size of packet to recieve
        frmClient.Socket2.RecvLen = 4096
        'receive the data packet
        Buffer = frmClient.Socket2.RecvData
        lngXSize = lngXSize + Len(Buffer)
        If Int((lngXSize / lngFSize) * 100) < 101 Then
            frmClient.pnlXferGauge.FloodPercent = Int((lngXSize / lngFSize) * 100)
        End If
        If Err Then
            FTPGetFile = False
            MsgBox Error$
            Exit Do
        End If
        If intXferStop Then
            FTPGetFile = False
            'if they exit, stop the transaction
            MsgBox "Transfer stopped by user."
            'frmClient.Socket1.Action = SOCKET_ABORT
            frmClient.Socket2.Shutdown = 0
            frmClient.Socket2.Action = SOCKET_ABORT
            Exit Do
        End If
        'did we hit EOF?
        If frmClient.Socket2.RecvLen = 0 Then Exit Do
        'append packet to file
        Put #1, , Buffer
        'permit other system operations
        DoEvents
    Loop

    'close the data file
    Close #1
    'if user cancelled, destroy partial file
    If intXferStop Then
        Kill LocalFile
    Else
        frmClient.pnlXferGauge.FloodPercent = 100
    End If
    'close the secondary socket
    frmClient.Socket2.Action = SOCKET_CLOSE
    'wait for close verification
    Result = FTPResult(CtlData)

    'turn controls on
        frmClient.cmdLocRef.Enabled = True
        frmClient.cmdRemRef.Enabled = True
        frmClient.FileMenu.Enabled = True
        frmClient.mnuSession.Enabled = True
        frmClient.pnlXferStat.Visible = False
        frmClient.MousePointer = MOUSE_DEFAULT
End Function

Function FTPListen (intMode As Integer)
    Dim Port As Integer, Address As String
    Dim Reply As Integer, CtlData As String
    Dim I As Integer, P As Integer

    'connect a second socket to the remote host
    'to listen for and execute remote commands
    'in essence, set up a server connection
    FTPListen = False
    
    'internet address
    frmClient.Socket2.AddressFamily = AF_INET
    'will be receiveing in binary
    frmClient.Socket2.Binary = True
    'synchronous connection
    frmClient.Socket2.Blocking = True
    'do not buffer data
    frmClient.Socket2.BufferSize = 0
    'accept from any remote address
    frmClient.Socket2.HostAddress = INADDR_ANY
    'connect to any available port
    frmClient.Socket2.LocalPort = IPPORT_ANY
    'internet protocol
    frmClient.Socket2.Protocol = IPPROTO_TCP
    'set timeout for 60 seconds
    frmClient.Socket2.Timeout = 200000
    'streaming socket
    frmClient.Socket2.Type = SOCK_STREAM
    'start listening
    frmClient.Socket2.Action = SOCKET_LISTEN

    'listen will set these two to valid port and address
    Port = frmClient.Socket2.LocalPort
    'we use the address from the first socket, they should be the same
    Address = frmClient.Socket1.LocalAddress

    'convert . to , in address
    For I = 1 To 3
        P = InStr(Address, ".")
        If P <> 0 Then Mid$(Address$, P, 1) = ","
    Next I
    
    'tell remote system which port gets the data
    CtlData = "PORT " & Address & "," & (Port \ 256) & "," & (Port Mod 256)
    If Not ftpcommand(CtlData) Then GoTo OpenFailed
    
    'code 200 -command understood
    If FTPResult(CtlData) <> 200 Then GoTo OpenFailed
    
    'transfer in binary or ascii?
    If intMode = 1 Then
        CtlData = "TYPE I"  'binary
    Else
        CtlData = "TYPE A"  'ascii
    End If
    
    If Not ftpcommand(CtlData) Then GoTo OpenFailed
    'code 2?? -command understood
    If Left$(Str$(FTPResult(CtlData)), 2) <> " 2" Then GoTo OpenFailed
    
    FTPListen = True
    Exit Function

OpenFailed:
    'disconnect new socket on error
    If frmClient.Socket2.Listening Then frmClient.Socket2.Action = SOCKET_CLOSE
    Exit Function
End Function

Function FTPLogin (Username As String, Password As String) As Integer
    Dim CtlData As String, Reply As Integer
    Dim Counter As Integer
    
    FTPLogin = False

    'check receive buffer
    If frmClient.Socket1.IsReadable Then
        Reply = FTPResult(CtlData)
    End If

    'clear all connect messages out of receive buffer
    While Reply = 220 And frmClient.Socket1.IsReadable
        Reply = FTPResult(CtlData)
    Wend

    'send the user command with the user id to remote host
    CtlData = "USER " & Username
    If Not ftpcommand(CtlData) Then Exit Function
    'check the response from remote host
    Reply = FTPResult(CtlData)

    'code 331 means ready for password
    If Reply = 331 Then
        'send the pass command and the password
        CtlData = "PASS " & Password
        If Not ftpcommand(CtlData) Then Exit Function
        'check the response
        Reply = FTPResult(CtlData)
    End If
    
    'get all login messages out of receive buffer
    While Reply = 230 And frmClient.Socket1.IsReadable
        Reply = FTPResult(CtlData)
    Wend

    'code 230 - logon accepted
    If Reply = 230 Then
        FTPLogin = True
    Else
        MsgBox "Invalid user name or password"
    End If

End Function

Function FTPPutFile (LocalFile As String, RemoteFile As String)
    Dim CtlData As String, Buffer As String * 4096
    Dim Result As Integer, Size As Long
    Dim intMode As Integer
    Dim lngXSize As Long, lngFSize As Long

    'write the file onto the remote host

    FTPPutFile = False

    If RemoteFile = "" Or LocalFile = "" Then Exit Function
    'start listening for remote host
    If frmClient.rdoAscii.Value Then
        intMode = 0
    Else
        intMode = 1
    End If
    Err = 0
    If Not FTPListen(intMode) Then Exit Function
    intXferStop = False
    'do not permit exit or refresh at this time
    frmClient.cmdLocRef.Enabled = False
    frmClient.cmdRemRef.Enabled = False
    frmClient.FileMenu.Enabled = False
    frmClient.mnuSession.Enabled = False
    Size = FileLen(LocalFile)
    lngFSize = Size
    lngXSize = 0
    frmClient.lblXferText.Caption = "Sending file '" & LocalFile & "' (" & lngFSize & " bytes)"
    frmClient.pnlXferGauge.FloodPercent = lngXSize
    frmClient.pnlXferStat.Visible = True
    sleep (3)
    'tell remote host to store this file
    If Not ftpcommand("STOR " & RemoteFile) Then
        GoSub scrn_Reset
        Exit Function
    End If
    'If intXferStop Then
    '    GoSub scrn_Reset
    '    Exit Function
    'End If
    sleep (3)
    'code 150 -command accepted
    If Left$(Str(FTPResult(CtlData)), 2) <> " 1" Then
        GoSub scrn_Reset
        Exit Function
    End If
    'If intXferStop Then
    '    GoSub scrn_Reset
    '    Exit Function
    'End If
    
    On Error Resume Next
    'start accepting commands from remote host
    frmClient.Socket2.Action = SOCKET_ACCEPT
    
    If Err Then
        frmClient.Socket2.Action = SOCKET_CLOSE
        MsgBox Error$
        Exit Function
    End If
    
    'open the file for reading
    Open LocalFile For Binary As #1

    If Err Then
        frmClient.Socket2.Action = SOCKET_CLOSE
        MsgBox Error$
        Exit Function
    End If

    FTPPutFile = True
    'send file in 4096 byte packets (buffer)
    Do
        Get #1, , Buffer
        'set transmit length to size of packet
        If Size < Len(Buffer) Then
            frmClient.Socket2.SendLen = Size
            Size = 0
        Else
            frmClient.Socket2.SendLen = Len(Buffer)
            Size = Size - Len(Buffer)
        End If
        'send packet
        frmClient.Socket2.SendData = Buffer
        If Err > 0 Then
            FTPPutFile = False
            MsgBox Error$
            Exit Do
        End If
        lngXSize = lngXSize + Len(Buffer)
        frmClient.pnlXferGauge.FloodPercent = Int((lngXSize / lngFSize) * 100)
        If intXferStop Then
            FTPPutFile = False
            MsgBox "Transfer stopped by user."
            Size = 0
        End If
        'if file is empty, we're done
        If Size = 0 Then Exit Do
        'allow other system events to fire
        DoEvents
    Loop
    If Not intXferStop Then
        frmClient.pnlXferGauge.FloodPercent = 100
    End If

    'close local file
    Close #1
    frmClient.cmdLocRef.Enabled = True
    frmClient.cmdRemRef.Enabled = True
    frmClient.FileMenu.Enabled = True
    frmClient.mnuSession.Enabled = True
    frmClient.pnlXferStat.Visible = False
    'close secondary socket
    frmClient.Socket2.Action = SOCKET_CLOSE
    'verify socket close
    Result = FTPResult(CtlData)
Exit Function
scrn_Reset:
    frmClient.cmdLocRef.Enabled = True
    frmClient.cmdRemRef.Enabled = True
    frmClient.FileMenu.Enabled = True
    frmClient.mnuSession.Enabled = True
    frmClient.pnlXferStat.Visible = False
    'frmClient.Socket2.Shutdown = 1
    'frmClient.Socket2.Action = SOCKET_FLUSH
    'frmClient.Socket2.Action = SOCKET_ABORT
    Err = 0
    'frmClient.Socket2.Action = SOCKET_CLOSE
Return
End Function

Function FTPResult (CtlData As String) As Integer
    Dim SockData As String, Reply As Integer

    'receive 255 bytes at a time
    frmClient.Socket1.RecvLen = 255
    'load sockdata with data from socket
    SockData = frmClient.Socket1.RecvData
    'print the data to the status window
    frmClient.txtStatus.Text = frmClient.txtStatus.Text & Chr$(13) & Chr$(10) & SockData
    frmClient.txtStatus.SelStart = Len(frmClient.txtStatus.Text)

    'reply is the first 3 characters (should be numeric)
    Reply = Val(Left$(SockData, 3))
    If Mid$(SockData, 4, 1) = "-" Then
        Do
            frmClient.Socket1.RecvLen = 255
            'check for longer warning message and clear the buffer
            SockData = frmClient.Socket1.RecvData
            If Val(Left$(SockData, 3)) = Reply Then Exit Do
            frmClient.txtStatus.Text = frmClient.txtStatus.Text & Chr$(13) & Chr$(10) & SockData
            frmClient.txtStatus.SelStart = Len(frmClient.txtStatus.Text)
        Loop
    End If
    CtlData = Right$(SockData, Len(SockData) - InStr(SockData, " "))
    
    FTPResult = Reply
End Function

