VERSION 2.00
Begin Form IconEx 
   AutoRedraw      =   -1  'True
   BackColor       =   &H00FFFFFF&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "IconViewer"
   ClientHeight    =   4875
   ClientLeft      =   1620
   ClientTop       =   1890
   ClientWidth     =   4515
   Height          =   5565
   Icon            =   0
   Left            =   1560
   MaxButton       =   0   'False
   ScaleHeight     =   4875
   ScaleWidth      =   4515
   Top             =   1260
   Width           =   4635
   Begin TextBox Text1 
      BackColor       =   &H00400000&
      Enabled         =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H0000FFFF&
      Height          =   420
      Left            =   0
      TabIndex        =   20
      Text            =   "Christian Germelmann, CIS:100520,2644"
      Top             =   2220
      Visible         =   0   'False
      Width           =   4515
   End
   Begin CheckBox PatternCheck 
      Caption         =   "IC&L"
      Height          =   255
      Index           =   3
      Left            =   3420
      TabIndex        =   19
      Top             =   1890
      Value           =   1  'Checked
      Width           =   615
   End
   Begin CheckBox ExcludeCheck 
      Caption         =   "E&xclude empty Libraries"
      Height          =   315
      Left            =   1860
      TabIndex        =   17
      Top             =   4425
      Width           =   2475
   End
   Begin FileListBox FileSource 
      Archive         =   0   'False
      Height          =   420
      Left            =   2640
      Pattern         =   "*.ico;*.exe;*.dll;*.icl"
      TabIndex        =   16
      TabStop         =   0   'False
      Top             =   3480
      Visible         =   0   'False
      Width           =   1575
   End
   Begin ListBox FileList 
      Height          =   4320
      Left            =   180
      TabIndex        =   1
      Top             =   360
      Width           =   1575
   End
   Begin CheckBox PatternCheck 
      Caption         =   "&DLL"
      Height          =   255
      Index           =   2
      Left            =   3420
      TabIndex        =   12
      Top             =   1620
      Value           =   1  'Checked
      Width           =   615
   End
   Begin CheckBox PatternCheck 
      Caption         =   "&EXE"
      Height          =   255
      Index           =   1
      Left            =   3420
      TabIndex        =   11
      Top             =   1350
      Value           =   1  'Checked
      Width           =   615
   End
   Begin CheckBox PatternCheck 
      Caption         =   "&ICO"
      Height          =   255
      Index           =   0
      Left            =   3420
      TabIndex        =   10
      Top             =   1080
      Value           =   1  'Checked
      Width           =   615
   End
   Begin HScrollBar IconScroll 
      Enabled         =   0   'False
      Height          =   240
      LargeChange     =   10
      Left            =   2100
      Max             =   1
      Min             =   1
      MousePointer    =   10  'Up Arrow
      TabIndex        =   7
      Top             =   1875
      Value           =   1
      Width           =   975
   End
   Begin DriveListBox DriveList 
      Height          =   315
      Left            =   1860
      TabIndex        =   5
      Top             =   3960
      Width           =   2475
   End
   Begin DirListBox DirList 
      Height          =   1155
      Left            =   1860
      TabIndex        =   3
      Top             =   2520
      Width           =   2475
   End
   Begin PictureBox ExIcon 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      ClipControls    =   0   'False
      Height          =   510
      Left            =   2340
      MousePointer    =   10  'Up Arrow
      ScaleHeight     =   480
      ScaleWidth      =   480
      TabIndex        =   8
      Top             =   1320
      Width           =   510
   End
   Begin Label Copyright 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "Copyright 1995 by Christian Germlemann, Am Glaskopf 26, D-35039 Marburg, Germany [CompuServe 100520,2644]"
      Height          =   15
      Left            =   -100
      TabIndex        =   21
      Top             =   -100
      Visible         =   0   'False
      Width           =   15
   End
   Begin Label FileCount 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Height          =   195
      Left            =   1080
      TabIndex        =   18
      Top             =   120
      Width           =   675
   End
   Begin Label TopLabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Path:"
      Height          =   195
      Index           =   3
      Left            =   1860
      TabIndex        =   15
      Top             =   120
      Width           =   465
   End
   Begin Label TopLabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "&Directories:"
      Height          =   195
      Index           =   2
      Left            =   1860
      TabIndex        =   2
      Top             =   2280
      Width           =   990
   End
   Begin Label TopLabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Dri&ves:"
      Height          =   195
      Index           =   1
      Left            =   1860
      TabIndex        =   4
      Top             =   3720
      Width           =   615
   End
   Begin Label TopLabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "&Files:"
      Height          =   195
      Index           =   0
      Left            =   180
      TabIndex        =   0
      Top             =   120
      Width           =   465
   End
   Begin Label SubLabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Extensions"
      Height          =   195
      Index           =   1
      Left            =   3300
      TabIndex        =   9
      Top             =   840
      Width           =   930
   End
   Begin Label SubLabel 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "I&con"
      Height          =   195
      Index           =   0
      Left            =   2400
      TabIndex        =   6
      Top             =   840
      Width           =   390
   End
   Begin Label IconCount 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Left            =   2550
      TabIndex        =   14
      Top             =   1080
      Width           =   75
   End
   Begin Shape Shape1 
      Height          =   1515
      Left            =   1860
      Shape           =   4  'Rounded Rectangle
      Top             =   720
      Width           =   2475
   End
   Begin Label Path 
      Alignment       =   2  'Center
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   1860
      TabIndex        =   13
      Top             =   360
      Width           =   2475
   End
   Begin Menu M_Exit 
      Caption         =   "&Exit"
   End
   Begin Menu M_About 
      Caption         =   "&About "
   End
End
' This example application shows...                        '
'                                                          '
'        How To Extract Icons From Files                   '
'        ===============================                   '
'                                                          '
' This application extracts icons from any EXE-, DLL- or   '
' ICO-file. If there are more than one icon in a file you  '
' may cycle all icons with a scroll bar control.           '
'                                                          '
' Browsing the code you will find a lot more...            '
'                                                          '

'                                                          '
' As well as you I'm always interested in how to do things '
' in VisualBasic which do not belong to 'normal' tasks.    '
' If there is anything special that could be useful for    '
' a lof of programmers - just drop it as well in the Forum '
' on CompuServe you found this here...                     '
'                                                          '
' From:     Christian Germelmann                           '
'           Promenade 58                                   '
'           37431 Bad Lauterberg                           '
'           Phone +49 5524 999731                          '
'           100520.2644@compuserve.com                     '
'           ChGTools@aol.com                               '
'                                                          '


Option Explicit

Dim i%                      ' =  Dim i As Integer
Dim retInt%                 ' =  Dim retInt As Integer
Dim FilePath$               ' =  Dim FilePath As String
Dim IconMaxCount%           ' =  Dim IconMaxCount As Integer
Dim Color%                  ' =  Dim Color As Integer
Dim Pattern%(3)             ' =  Dim Pattern(3) As Integer

Const Ext_ICO$ = ".ICO"     ' Define constants for file endings ' with '.' to
Const Ext_EXE$ = ".EXE"     ' check whether there's a correct file extension.
Const Ext_DLL$ = ".DLL"
Const Ext_ICL$ = ".ICL"

Declare Sub ShellAbout Lib "SHELL" Alias "#22" (ByVal hWnd%, ByVal TitelText$, ByVal DialogText$, ByVal BildhWnd%)
Declare Function ExtractIcon% Lib "SHELL" Alias "#34" (ByVal hInst%, ByVal lpszExeName$, ByVal iIcon%)

'*'Declare Function DrawIcon% Lib "USER" Alias "#84" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal hIcon%)
Declare Sub DrawIcon Lib "USER" Alias "#84" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal hIcon%)
Declare Function LoadString% Lib "USER" Alias "#176" (ByVal hInstance%, ByVal wID%, ByVal lpBuffer$, ByVal nBufferMax%)

Declare Function GetModuleHandle% Lib "KERNEL" Alias "#47" (ByVal lpModuleName$)
Declare Function GetProfileString% Lib "KERNEL" Alias "#58" (ByVal lpApplicationName$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpReturnedString$, ByVal nSize%)


''                                                                        ''
'' The below Function Declarations do EXACTLY the same as the above       ''
'' (but with full declarations of the variables).                         ''
''                                                                        ''

''Declare Sub ShellAbout Lib "SHELL" (ByVal hWnd%, ByVal TitelText As String, ByVal DialogText As String, ByVal BildhWnd As Integer)
''Declare Function ExtractIcon Lib "SHELL" (ByVal hInst As Integer, ByVal lpszExeName As String, ByVal iIcon As Integer) As Integer
''
''Declare Function DrawIcon Lib "USER" (ByVal hDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal hIcon As Integer) As Integer
''Declare Function LoadString Lib "USER" (ByVal hInstance As Integer, ByVal wID As Integer, ByVal lpBuffer As Any, ByVal nBufferMax As Integer) As Integer
''
''Declare Function GetModuleHandle Lib "KERNEL" (ByVal lpModuleName As String) As Integer
''Declare Function GetProfileString Lib "KERNEL" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Integer) As Integer

'
' Adds a '\' to a file path in case it's missing.
'
Function Backslash$ (ByVal FileName$)

    If Right$(FileName, 1) <> "\" Then
            Backslash = UCase$(FileName + "\")
        Else
            Backslash = UCase$(FileName)
    End If

End Function

'
' Retrieves the language code from the WIN.INI.
' For Germany this is 'deu'.
' For England it is 'eng', for USA it is 'enu'.
' To get your own language setting just look into the WIN.INI,
' section [intl], key [sLanguage].
'
Function Deutsch% ()

Dim sLanguage$, NumBytes%
sLanguage = String$(255, 0)

    NumBytes = GetProfileString("intl", "sLanguage", "", sLanguage, Len(sLanguage))
    sLanguage = Left$(sLanguage, NumBytes)
    
    If InStr(1, LCase$(sLanguage), "deu", 1) Then Deutsch = True    ' Windows is >deutsch<

End Function

Sub DirList_Change ()

    ResetIcon
    
    Path = DirList.Path
    FileSource.Path = DirList.Path

End Sub

Sub DriveList_Change ()
       
    On Error Resume Next
    
    DirList.Path = DriveList.Drive

    If Err = False Then Exit Sub

    ' A message text from the COMMDLG.DLL is used...
    ' (This is a way to make it international !)
    Dim Msg$
    Msg = GetCommdlgString(404)
    Msg = Left$(Msg, InStr(Msg, "%c") - 1) + UCase(Left$(DriveList, 1)) + Mid$(Msg, InStr(Msg, "%c") + 2)
    Beep
    DriveList = DirList
    DoEvents
    MsgBox Msg, 48, UCase$(GetUserString(78))
    
    Exit Sub

End Sub

Sub ExcludeCheck_Click ()

    FileSource_PathChange

End Sub

'
' In case you want to pass the icon to the Windows clipboard
' by doubleclicking the icon, simply remove the apostrophes...
'
Sub ExIcon_DblClick ()

'   ExIcon.Picture = ExIcon.Image
'   ClipBoard.SetData ExIcon.Picture

End Sub

Sub ExIcon_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)

Select Case Button
    Case 1
        Color = Color + 1
        If Color > 15 Then Color = 0

    Case 2
        Color = Color - 1
        If Color < 0 Then Color = 15
End Select

        ExIcon.BackColor = QBColor(Color)
        ShowIcon

        'ExIcon.Picture = ExIcon.Image
        'ExIcon.Refresh

End Sub

Sub FileList_Click ()

Screen.MousePointer = 11

    ResetIcon
    
    FilePath = Backslash(DirList.Path) + FileList.List(FileList.ListIndex)   ' FileSource.FileName
    
    Select Case UCase(Right$(FilePath, 4))   ' Check FileExtensions
        Case Ext_EXE, Ext_DLL, Ext_ICL
            IconMaxCount = ExtractIcon(Me.hWnd, FilePath, -1)
            If IconMaxCount > 0 Then
                ExIcon.Enabled = True
                IconCount.Visible = True
                IconScroll.Value = 1
                IconScroll.Max = IconMaxCount
                IconScroll.Enabled = (IconMaxCount > 1)
                ShowIcon
            End If
        Case Ext_ICO
            ExIcon.Enabled = True
            IconCount.Visible = False
            ExIcon.Picture = LoadPicture(FilePath)
    End Select

Screen.MousePointer = 0

End Sub

Sub FileSource_PathChange ()
    
    Pattern(0) = False
    Pattern(1) = False
    Pattern(2) = False
    Pattern(3) = False
    
    FileSource_PatternChange
    
    PatternCheck(0).Enabled = Pattern(0)
    PatternCheck(1).Enabled = Pattern(1)
    PatternCheck(2).Enabled = Pattern(2)
    PatternCheck(3).Enabled = Pattern(3)

    ExcludeCheck.Enabled = Not (Pattern(1) = False And Pattern(2) = False And Pattern(3) = False)

End Sub

Sub FileSource_PatternChange ()

Screen.MousePointer = 11

Dim LibraryPath$
    FileList.Clear
    
    For i = 0 To FileSource.ListCount - 1
        Select Case ExcludeCheck
            Case 1
                LibraryPath = Backslash(DirList.Path) + FileSource.List(i)
                If ExtractIcon(Me.hWnd, LibraryPath, -1) Or UCase(Right$(FilePath, 4)) = Ext_ICO Then
                    FileList.AddItem FileSource.List(i)
                End If
            Case 0
                    FileList.AddItem FileSource.List(i)
        End Select
        Select Case UCase(Right$(FileSource.List(i), 4))
            Case Ext_ICO: Pattern(0) = True
            Case Ext_EXE: Pattern(1) = True
            Case Ext_DLL: Pattern(2) = True
            Case Ext_ICL: Pattern(3) = True
        End Select
        ' If you prefer 'If...Then' instead:
'        If UCase(Right$(FileSource.List(i), 4)) = Ext_ICO Then Pattern(0) = True
'        If UCase(Right$(FileSource.List(i), 4)) = Ext_EXE Then Pattern(1) = True
'        If UCase(Right$(FileSource.List(i), 4)) = Ext_DLL Then Pattern(2) = True
'        If UCase(Right$(FileSource.List(i), 4)) = Ext_ICL Then Pattern(3) = True
    Next i
    
        FileCount = "[" & FileList.ListCount & "]"

Screen.MousePointer = 0

End Sub

Sub Form_Load ()

    ' Do not allow to run IconEx more than once.
    If App.PrevInstance Then End
    
    App.Title = Caption + " is running..."
    
    ' If you change the country, change the texts here:
    If Deutsch() Then
        App.Title = Caption + " luft..."
        M_Exit.Caption = "&Ende"
        M_About.Caption = "&ber "
        TopLabel(0) = "&Dateien:"
        TopLabel(1) = "&Laufwerke:"
        TopLabel(2) = "&Verzeichnisse:"
        TopLabel(3) = "Pfad:"
        SubLabel(1) = "&Endungen"
        ExcludeCheck.Caption = "keine leeren &Bibliotheken"
    End If

    ' Move the Menu.Caption to the right edge of the menu bar.
    M_About.Caption = Chr$(8) + M_About.Caption + " "
        
Move (Screen.Width - Width) * .44, (Screen.Height - Height) * .5
    
    DirList_Change
    
    FileSource_PathChange

DoEvents

Show

End Sub

Sub Form_QueryUnload (Cancel As Integer, UnloadMode As Integer)

    If MsgBox(GetCommdlgString(259), 32 + 4, Caption) = 7 Then
        Cancel = True
        Exit Sub
    End If

'end

End Sub

'
' This routine fetches strings from the COMMDLG.DLL.
' (see 'GetModuleString')
'
Function GetCommdlgString$ (StringNumber%)

    GetCommdlgString = GetModuleString("COMMDLG", StringNumber)

End Function

'
' This routine fetches strings from a Windows Library.
' As long as you know the module name you can obtain
' any string from any module (if it is actually loaded).
'
Function GetModuleString$ (ModuleName$, StringNumber%)
 
Dim Text$, NumBytes%
Text = String$(255, 0)
    
    NumBytes = LoadString(GetModuleHandle(ModuleName), StringNumber, Text, Len(Text))
    Text = Left$(Text, NumBytes)

    GetModuleString = Text

End Function

'
' This routine fetches strings from the USER.EXE.
' (see 'GetModuleString')
'
Function GetUserString$ (StringNumber%)

    GetUserString = GetModuleString("USER", StringNumber)

End Function

Sub IconScroll_Change ()

    ShowIcon

End Sub

Sub IconScroll_Scroll ()

    ShowIcon

End Sub

'
' Here is how to use the original Windows-AboutBox !
'
' With this AboutBox you can even achieve the Team List
' of the Windows 'Inventors'. Try the following:
'  1. Select ABOUT from the menubar,
'  2. Hold down Shif+Ctrl an doubleclick the Windows-Symbol,
'  3. Close the AboutBox with the OK-button,
'  4. Repeat steps 1 through 3 until you give up...
'
Sub M_About_Click ()

    ' If you give IconEx it's own icon, it will appear in the AboutBox !!!
    ShellAbout hWnd, Caption + " v1.02", "Copyright  1995-1996 by Ch.Germelmann", Icon  ' or: CLng(Icon)


End Sub

Sub M_Exit_Click ()

    ' Don't walk through Form_QueryUnload...
    End

End Sub

'
' Never CUT a full path name but use a routine like this here...
'
Sub Path_Change ()

    Dim TotalLength%, RestLength%
    TotalLength = 24
     
    RestLength = TotalLength - 15
    
    If Len(DirList) > TotalLength Then
        Path = Left$(DirList, InStr(4, DirList, "\")) + "..." + Mid$(Right$(DirList, RestLength), InStr(Right$(DirList, RestLength), "\"))
    End If

End Sub

Sub PatternCheck_Click (Index As Integer)

Dim NewPattern$

    ' Get new pattern...
    For i = 0 To 3
        If PatternCheck(i).Value Then
            NewPattern = NewPattern + "*." + PickString((PatternCheck(i).Caption)) + ";"
        End If
    Next i
    
    ' Validate pattern --> may not become "" (empty string)
    If NewPattern > "" Then
            'If Pattern(Index) Then
                FileSource.Pattern = Left$(NewPattern, Len(NewPattern) - 1) ' remove ";"
            'End If
        Else
            PatternCheck(Index).Value = 1
    End If

ResetIcon

End Sub

'
' Cut the '&' out of the control test.
'
Function PickString$ (Extension$)

Dim Pos%
Pos = InStr(Extension, "&")     ' Pos is always >0.

    PickString = Left$(Extension, Pos - 1) + Right$(Extension, 4 - Pos)  ' Len(Extension) is always 4.

End Function

Sub ResetIcon ()
    
    IconCount = "0 / 0"
    ExIcon.Picture = LoadPicture()
    ExIcon.BackColor = QBColor(15)
    Color = 15
    ExIcon.Picture = ExIcon.Image
    IconScroll.Enabled = False
    ExIcon.Enabled = False

End Sub

Sub ShowIcon ()
    
Dim hIcon%

    IconCount = IconScroll.Value & " / " & IconMaxCount
    
    ExIcon.Picture = LoadPicture()

    hIcon = ExtractIcon(Me.hWnd, FilePath, IconScroll.Value - 1)
    '*'retInt = DrawIcon(ExIcon.hDC, 0, 0, hIcon)
    DrawIcon ExIcon.hDC, 0, 0, hIcon

    ExIcon.Picture = ExIcon.Image

End Sub

