'NW4XBIND.BAS - Visual Basic Interface File for Netware 4.X SDK
'   Contains Function defination and type declarations for Bindery Access
'Created by Joseph A. DiVito - Seton Hall University
'Requirments - NONE
'Corresponds to NWBINDRY.H in the Netware SDK

'Bindery object types
Global Const OT_WILD = -1                   ' Matches any type
Global Const OT_UNKNOWN = 0                 ' Unknown object type
Global Const OT_USER = &H100                ' The object is a "user"
Global Const OT_USER_GROUP = &H200          ' A group of users
Global Const OT_PRINT_QUEUE = &H300         ' Services print queues
Global Const OT_FILE_SERVER = &H400     ' The object serves files
Global Const OT_JOB_SERVER = &H500
Global Const OT_GATEWAY = &H600
Global Const OT_PRINT_SERVER = &H700
Global Const OT_ARCHIVE_QUEUE = &H800
Global Const OT_ARCHIVE_SERVER = &H900      ' Services backup jobs
Global Const OT_JOB_QUEUE = &HA00
Global Const OT_ADMINISTRATION = &HB00
Global Const OT_NAS_SNA_GATEWAY = &H2100
Global Const OT_NACS = &H2300
Global Const OT_REMOTE_BRIDGE_SERVER = &H2600
Global Const OT_TCPIP_GATEWAY = &H2700
Global Const OT_GATE = &H2900
Global Const OT_TIME_SYNCHRONIZATION_SERVER = &H2D00
Global Const OT_ARCHIVE_SRV = &H2E00
Global Const OT_ADVERTISING_PRINT_SERVER = &H4700
Global Const OT_BTRIEVE_VAP_NLM_5XX = &H4B00
Global Const OT_SQL_VAP_NLM = &H4C00
Global Const OT_XTREE_NETWORK = &H4D00
Global Const OT_BTRIEVE_VAP_NLM_4XX = &H5000
Global Const OT_PRINT_QUEUE_USER = &H5300
Global Const OT_X25_GATEWAY = &H5800
Global Const OT_WAN_COPY = &H7200
Global Const OT_TES_NETWARE_VMS = &H7A00
Global Const OT_NETWARE_ACCESS_SERVER = &H9800
Global Const OT_PORTABLE_NETWARE = &H9E00
Global Const OT_COMPAQ_IDA_STATUS_MONITOR = &HAC00

' Bindery security definitions
Global Const BS_ANY_READ = &H0       ' Readable by anyone
Global Const BS_LOGGED_READ = &H1    ' Must be logged in to read
Global Const BS_OBJECT_READ = &H2    ' Readable by same object or super
Global Const BS_SUPER_READ = &H3     ' Readable by supervisor only
Global Const BS_BINDERY_READ = &H4   ' Readable only by the bindery
Global Const BS_ANY_WRITE = &H0      ' Writeable by anyone
Global Const BS_LOGGED_WRITE = &H10  ' Must be logged in to write
Global Const BS_OBJECT_WRITE = &H20  ' Writeable by same object or super
Global Const BS_SUPER_WRITE = &H30   ' Writeable only by the supervisor
Global Const BS_BINDERY_WRITE = &H40 ' Writeable by the bindery only

' Attributes of objects and properties in the bindery
Global Const BF_STATIC = &H0
Global Const BF_DYNAMIC = &H1
Global Const BF_ITEM = &H0
Global Const BF_SET = &H2

Type Property_Value
    PropertyValue As String * 127
    'PropertyValue(32) As Long
End Type

Declare Function NWAddObjectToSet Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal memberName$, ByVal memberType%) As Integer
Declare Function NWChangeObjectPassword Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal oldPassword$, ByVal newPassword$) As Integer
Declare Function NWChangeObjectSecurity Lib "NWCALLS.DLL" (ByVal CoOnnID%, ByVal objectName$, ByVal objectType%, ByVal newObjectSecurity%) As Integer
Declare Function NWChangePropertySecurity Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal newPropertySecurity%) As Integer
Declare Function NWCloseBindery Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWCreateObject Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal objectFlag%, ByVal objectSecurity%) As Integer
Declare Function NWCreateProperty Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal propertyFlags%, ByVal propertySecurity%) As Integer
Declare Function NWDeleteObject Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%) As Integer
Declare Function NWDeleteObjectFromSet Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal memberName$, ByVal memberType%) As Integer
Declare Function NWDeleteProperty Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$) As Integer
Declare Function NWGetBinderyAccessLevel Lib "NWCALLS.DLL" (ByVal ConnID%, securityAccessLevel%, objectID&) As Integer
Declare Function NWGetObjectDiskSpaceLeft Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal binderyObjectID%, systemElapsedTime&, unusedDiskBlocks&, restrictionEnforced%) As Integer
Declare Function NWGetObjectID Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, objectID&) As Integer
Declare Function NWGetObjectName Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectID&, ByVal objectName$, objectType%) As Integer
Declare Function NWIsObjectInSet Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal memberName$, ByVal memberType%) As Integer
Declare Function NWOpenBindery Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
'propertyValue is a 128-byte array
Declare Function NWReadPropertyValue Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal segmentNumber%, PropertyValue As Property_Value, moreSegments%, propertyFlags%) As Integer
Declare Function NWRenameObject Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal newObjectName$, ByVal objectType%) As Integer
Declare Function NWScanObject Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal searchObjectName$, ByVal searchObjectType%, objectID&, ByVal objectName$, objectType%, objectHasProperties%, objectFlag%, objectSecurity%) As Integer
Declare Function NWScanObjectTrusteePaths Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectID&, ByVal volumeNumber%, sequenceNumber%, trusteeAccessMask%, ByVal trusteePathName$) As Integer
Declare Function NWScanProperty Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal searchPropertyName$, sequenceNumber&, ByVal propertyName$, propertyFlags%, propertySecurity%, propertyHasValue%, moreProperties) As Integer
Declare Function NWVerifyObjectPassword Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal password$) As Integer
'propertyValue is a 128-byte array
Declare Function NWWritePropertyValue Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal segmentNumber%, PropertyValue As Property_Value, ByVal moreSegments%) As Integer
Declare Function NWDisallowObjectPassword Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal disallowedPassword$) As Integer
Declare Function NWGetObjectEffectiveRights Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectID&, ByVal dirHandle%, ByVal path$, rightsMask%) As Integer

