'NW4XCALL.BAS - All function related the the NWCALLS.DLL
'   Contains all the Types, Function and Sub declaration necessary
'   to call the NWCALLS.DLL
'April 4, 1995 Version 0.1
'Created by Joseph A. DiVito - Seton Hall University
'Includes some type decalration help from Novell's first release of NIVB

Type DATE_AND_TIME
    year As String * 1
    month As String * 1
    date As String * 1
    hour As String * 1
    minute As String * 1
    second As String * 1
    day As String * 1
End Type

Type CONNECT_INFO
    ConnID As Integer
    connectFlags As Integer
    sessionID As Integer
    connNumber As Integer
    serverAddr As String * 12
    serverType As Integer
    ServerName As String * 48
    clientType As Integer
    clientName As String * 48
End Type

Type CONN_USE
    systemElapsedTime As Long
    bytesRead As String * 6
    bytesWritten As String * 6
    totalRequestPackets As Long
End Type

Type CONN_LIST
    ListOfConnections(125) As Integer
End Type

Type NWINET_ADDR
    networkAddr As String * 4
    netNodeAddr As String * 6
    socket As Integer
    connType As Integer  '3.11 and above only: 0=not in use, 2=NCP, 3=AFP
End Type

Type PROPERTY_VALUE
    'PropertyValue As String * 127
    propertyValue(32) As Long
End Type

Type DSK_CACHE_STATS
    systemElapsedTime As Long
    cacheBufferCount As Integer
    cacheBufferSize As Integer
    dirtyCacheBuffers As Integer
    cacheReadRequests As Long
    cacheWriteRequests As Long
    cacheHits As Long
    cacheMisses As Long
    physicalReadRequests As Long
    physicalWriteRequests As Long
    physicalReadErrors As Integer
    physicalWriteErrors As Integer
    cacheGetRequests As Long
    cacheFullWriteRequests As Long
    cachePartialWriteRequests As Long
    backgroundDirtyWrites As Long
    backgroundAgedWrites As Long
    totalCacheWrites As Long
    cacheAllocations As Long
    thrashingCount As Integer
    LRUBlockWasDirtyCount As Integer
    readBeyondWriteCount As Integer
    fragmentedWriteCount As Integer
    cacheHitOnUnavailCount As Integer
    cacheBlockScrappedCount As Integer
End Type

Type DSK_CHANNEL_STATS
    systemElapsedTime As Long
    channelState As Integer
    channelSyncState As Integer
    driverType As String * 1
    driverMajorVersion As String * 1
    driverMinorVersion As String * 1
    driverDescription As String * 65
    IOAddr1 As Integer
    IOAddr1Size As Integer
    IOAddr2 As Integer
    IOAddr2Size As Integer
    sharedMem1Seg As String * 3
    sharedMem1Off As Integer
    sharedMem2Seg As String * 3
    sharedMem2Off As Integer
    interrupt1Used As String * 1
    interrupt1 As String * 1
    interrupt2Used As String * 1
    interrupt2 As String * 1
    DMAChannel1Used As String * 1
    DMAChannel1 As String * 1
    DMAChannel2Used As String * 1
    DMAChannel2 As String * 1
    reserved2 As Integer
    configDescription As String * 80
End Type

Type DRV_MAP_TABLE
    systemElapsedTime As Long
    SFTLevel As String * 1
    logicalDriveCount As String * 1
    physicalDriveCount As String * 1
    diskChannelTable As String * 5
    pendingIOCommands As Integer
    mappingTable As String * 32
    driveMirrorTable As String * 32
    deadMirrorTable As String * 32
    remirroredDrive As String * 1
    reserved As String * 1
    remirroredBlock As Long
    SFTErrorTable As String * 120
End Type

Type SERVER_LAN_IO_STATS
    systemElapsedTime As Long
    maxRoutingBuffersAvail As Integer
    maxRoutingBuffersUsed As Integer
    routingBuffersInUse As Integer
    totalFileServicePackets As Long
    fileServicePacketsBuffered As Integer
    invalidConnPacketCount As Long
    badLogicalConnCount As Long
    packetsRcvdDuringProcCount As Integer
    reprocessedRequestCount As Integer
    badSequenceNumberPacketCount As Integer
    duplicateReplyCount As Integer
    acknowledgementsSent As Integer
    badRequestTypeCount As Integer
    attachDuringProcCount As Integer
    attachWhileAttachingCount As Integer
    forgedDetachRequestCount As Integer
    badConnNumberOnDetachCount As Long
    detachDuringProcCount As Integer
    repliesCanceledCount As Integer
    hopCountDiscardCount As Integer
    unknownNetDiscardCount As Integer
    noDGroupBufferDiscardCount As Integer
    outPacketNoBufferDiscardCount As Integer
    IPXNotMyNetworkCount As Integer
    NetBIOSPropagationCount As Long
    totalOtherPackets As Long
    totalRoutedPackets As Long
End Type

Type NW_FS_INFO
    systemElapsedTime As Long
    processorType As String * 1
    reserved As String * 1
    serviceProcessCount As String * 1
    serverUtilizationPercent As String * 1
    maxBinderyObjectsAvail As Integer
    maxBinderyObjectsUsed As Integer
    binderyObjectsInUse As Integer
    serverMemoryInK As Integer
    dynamicAreaCount As Integer
    dynamicSpace1 As Long
    maxUsedDynamicSpace1 As Long
    dynamicSpaceInUse1 As Long
    dynamicSpace2 As Long
    maxUsedDynamicSpace2 As Long
    dynamicSpaceInUse2 As Long
    dynamicSpace3 As Long
    maxUsedDynamicSpace3 As Long
    dynamicSpaceInUse3 As Long
End Type

Type FILESYS_STATS
    systemElapsedTime As Long
    maxOpenFiles As Integer
    maxFilesOpen As Integer
    currOpenFiles As Integer
    totalFilesOpened As Long
    totalReadRequests As Long
    totalWriteRequests As Long
    currChangedFATSectors As Integer
    totalChangedFATSectors As Long
    FATWriteErrors As Integer
    fatalFATWriteErrors As Integer
    FATScanErrors As Integer
    maxIndexFilesOpened As Integer
    currOpenIndexedFiles As Integer
    attachedIndexFiles As Integer
    availableindexFiles As Integer
End Type

Type NWLAN_CONFIG
    networkAddress As Long
    hostAddress1 As Long
    hostAddress2 As Integer
    LANDriverInstalled As String * 1
    optionNumber As String * 1
    configurationText1 As String * 80
    configuratinoText2 As String * 80
End Type

Type PHYS_DSK_STATS
    systemElapsedTime As Long
    diskChannel As String * 1
    diskRemovable As String * 1
    driveType As String * 1
    controllerDriverNumber As String * 1
    controllerNumber As String * 1
    controllerType As String * 1
    driveSize As Long
    driveCylinders As Integer
    driveHeads As String * 1
    sectorsPerTrack As String * 1
    IOErrorCount As Integer
    hotFixStart As Long
    hotFixSize As Integer
    hotFixSizeAvailable As Integer
    hotFixDisabled As String * 1
End Type

Type VERSION_INFO
    ServerName As String * 48
    netwareVersion As String * 1
    netwareSubVersion As String * 1
    maxConnectionsSupported As Long
    ConnectionsInUse As Long
    maxVolumesSupported As Integer
    revisionLevel As String * 1
    SFTLevel As String * 1
    TTSLevel As String * 1
    peakConnectionsUsed As Long
    AccountingVersion As String * 1
    VAPVersion As String * 1
    QueueingVersion As String * 1
    PrintServerVersion As String * 1
    VirtualConsoleVersion As String * 1
    securityRestrictionLevel As String * 1
    internetBridgeSupport As String * 1
End Type


'Bindery object types
Global Const OT_WILD = -1                   ' Matches any type
Global Const OT_UNKNOWN = 0                 ' Unknown object type
Global Const OT_USER = &H100                ' The object is a "user"
Global Const OT_USER_GROUP = &H200          ' A group of users
Global Const OT_PRINT_QUEUE = &H300         ' Services print queues
Global Const OT_FILE_SERVER = &H400     ' The object serves files
Global Const OT_JOB_SERVER = &H500
Global Const OT_GATEWAY = &H600
Global Const OT_PRINT_SERVER = &H700
Global Const OT_ARCHIVE_QUEUE = &H800
Global Const OT_ARCHIVE_SERVER = &H900      ' Services backup jobs
Global Const OT_JOB_QUEUE = &HA00
Global Const OT_ADMINISTRATION = &HB00
Global Const OT_NAS_SNA_GATEWAY = &H2100
Global Const OT_NACS = &H2300
Global Const OT_REMOTE_BRIDGE_SERVER = &H2600
Global Const OT_TCPIP_GATEWAY = &H2700
Global Const OT_GATE = &H2900
Global Const OT_TIME_SYNCHRONIZATION_SERVER = &H2D00
Global Const OT_ARCHIVE_SRV = &H2E00
Global Const OT_ADVERTISING_PRINT_SERVER = &H4700
Global Const OT_BTRIEVE_VAP_NLM_5XX = &H4B00
Global Const OT_SQL_VAP_NLM = &H4C00
Global Const OT_XTREE_NETWORK = &H4D00
Global Const OT_BTRIEVE_VAP_NLM_4XX = &H5000
Global Const OT_PRINT_QUEUE_USER = &H5300
Global Const OT_X25_GATEWAY = &H5800
Global Const OT_WAN_COPY = &H7200
Global Const OT_TES_NETWARE_VMS = &H7A00
Global Const OT_NETWARE_ACCESS_SERVER = &H9800
Global Const OT_PORTABLE_NETWARE = &H9E00
Global Const OT_COMPAQ_IDA_STATUS_MONITOR = &HAC00

' Bindery security definitions
Global Const BS_ANY_READ = &H0       ' Readable by anyone
Global Const BS_LOGGED_READ = &H1    ' Must be logged in to read
Global Const BS_OBJECT_READ = &H2    ' Readable by same object or super
Global Const BS_SUPER_READ = &H3     ' Readable by supervisor only
Global Const BS_BINDERY_READ = &H4   ' Readable only by the bindery
Global Const BS_ANY_WRITE = &H0      ' Writeable by anyone
Global Const BS_LOGGED_WRITE = &H10  ' Must be logged in to write
Global Const BS_OBJECT_WRITE = &H20  ' Writeable by same object or super
Global Const BS_SUPER_WRITE = &H30   ' Writeable only by the supervisor
Global Const BS_BINDERY_WRITE = &H40 ' Writeable by the bindery only

' Attributes of objects and properties in the bindery
Global Const BF_STATIC = &H0
Global Const BF_DYNAMIC = &H1
Global Const BF_ITEM = &H0
Global Const BF_SET = &H2

Global Const CONNECTION_AVAILABLE = &H1
Global Const CONNECTION_PRIVATE = &H2                  'obsolete
Global Const CONNECTION_LOGGED_IN = &H4
Global Const CONNECTION_LICENSED = &H4
Global Const CONNECTION_BROADCAST_AVAILABLE = &H8
Global Const CONNECTION_ABORTED = &H10
Global Const CONNECTION_REFUSE_GEN_BROADCAST = &H20
Global Const CONNECTION_BROADCASTS_DISABLED = &H40
Global Const CONNECTION_PRIMARY = &H80
Global Const CONNECTION_NDS = &H100
Global Const CONNECTION_PNW = &H4000
Global Const CONNECTION_AUTHENTICATED = &H8000         'obsolete

'the following are for NWGetConnInfo
'ALL is VLM, OS2 and NT - NOT NETX
Global Const NW_CONN_TYPE = 1             'returns WORD (VLM)
Global Const NW_CONN_BIND = &H31
Global Const NW_CONN_NDS = &H32
Global Const NW_CONN_PNW = &H33
Global Const NW_AUTHENTICATED = 3  'returns WORD = 1 if authenticated (ALL)
Global Const NW_PBURST = 4         'returns WORD = 1 if pburst (VLM)
Global Const NW_VERSION = 8        'returns WORD (VLM)
Global Const NW_HARD_COUNT = 9     'returns WORD (VLM)
Global Const NW_CONN_NUM = 13      'returns WORD (ALL)
Global Const NW_TRAN_TYPE = 15     'returns WORD (VLM)
Global Const NW_TRAN_IPX = &H21
Global Const NW_TRAN_TCP = &H22
Global Const NW_SESSION_ID = &H8000      'returns WORD) (VLM)
Global Const NW_SERVER_ADDRESS = &H8001  'returns 12 byte address (ALL)
Global Const NW_SERVER_NAME = &H8002     'returns 48 byte string  (ALL)

'Not really needed in Windows, but suggested before making any NW calls
Declare Function NWCallsInit Lib "NWCALLS.DLL" (ByVal parm1%, ByVal parm%) As Integer

'Function from the NW4XCONN.BAS
Declare Function NWGetConnInfo Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal connType%, conndata$) As Integer
Declare Function NWLockConnection Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWGetConnectionUsageStats Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ConnectionNumber%, StatusBuffer As CONN_USE) As Integer
Declare Function NWGetConnectionInformation Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ConnNum%, ByVal objectName$, ObjectType%, objectID&, loginTime As DATE_AND_TIME) As Integer
'internetAddress needs to be Init. to a 10 Char String
Declare Function NWGetInternetAddress Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ConnNum%, ByVal internetAddress$) As Integer
Declare Function NWGetInetAddr Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ConnNum%, inetAddr As NWINET_ADDR) As Integer
Declare Sub NWGetMaximumConnection Lib "NWCALLS.DLL" (maxConnection%)
Declare Function NWGetConnectionList Lib "NWCALLS.DLL" (ByVal mode%, connListBuffer%, ByVal connListSize%, numConnection%) As Integer
Declare Function NWGetConnectionStatus Lib "NWCALLS.DLL" (ByVal ConnID%, connInfo As CONNECT_INFO, ByVal connInfoSize%) As Integer
Declare Function NWGetDefaultConnectionID Lib "NWCALLS.DLL" (ConnID%) As Integer
Declare Function NWGetObjectConnectionNumbers Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal ObjectType%, numConnections%, connlist As CONN_LIST, ByVal maxConnections%) As Integer
Declare Function NWGetConnListFromObject Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectID&, ByVal searchConnNum&, connListLen%, connlist As CONN_LIST) As Integer
Declare Function NWSetPreferredServer Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWGetPrimaryConnectionID Lib "NWCALLS.DLL" (ConnID%) As Integer
Declare Function NWSetPrimaryConnectionID Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWGetConnectionHandle Lib "NWCALLS.DLL" (ByVal ServerName$, ByVal mode%, Conn%, ByVal Scope%)
'Same Purpose as above function ^^^^^^ but put in for Compatiability
Declare Function NWGetConnectionID Lib "NWCALLS.DLL" (ByVal ServerName$, ByVal mode%, Conn%, ByVal Scope%)
Declare Function NWGetConnectionNumber Lib "NWCALLS.DLL" (ByVal ConnID%, ConnNum%) As Integer
Declare Function NWClearConnectionNumber Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ConnNum%) As Integer
Declare Function NWIsIDInUse Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer

'Functions from the File NW4XBIND.BAS
Declare Function NWAddObjectToSet Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal memberName$, ByVal memberType%) As Integer
Declare Function NWChangeObjectPassword Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal oldPassword$, ByVal newPassword$) As Integer
Declare Function NWChangeObjectSecurity Lib "NWCALLS.DLL" (ByVal CoOnnID%, ByVal objectName$, ByVal objectType%, ByVal newObjectSecurity%) As Integer
Declare Function NWChangePropertySecurity Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal newPropertySecurity%) As Integer
Declare Function NWCloseBindery Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWCreateObject Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal objectFlag%, ByVal objectSecurity%) As Integer
Declare Function NWCreateProperty Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal propertyFlags%, ByVal propertySecurity%) As Integer
Declare Function NWDeleteObject Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%) As Integer
Declare Function NWDeleteObjectFromSet Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal memberName$, ByVal memberType%) As Integer
Declare Function NWDeleteProperty Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$) As Integer
Declare Function NWGetBinderyAccessLevel Lib "NWCALLS.DLL" (ByVal ConnID%, securityAccessLevel%, objectID&) As Integer
Declare Function NWGetObjectDiskSpaceLeft Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal binderyObjectID%, systemElapsedTime&, unusedDiskBlocks&, restrictionEnforced%) As Integer
Declare Function NWGetBinderyObjectID Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, objectID&) As Integer
Declare Function NWGetObjectName Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectID&, ByVal objectName$, objectType%) As Integer
Declare Function NWIsObjectInSet Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal memberName$, ByVal memberType%) As Integer
Declare Function NWOpenBindery Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
'propertyValue is a 128-byte array
Declare Function NWReadPropertyValue Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal segmentNumber%, propertyValue As PROPERTY_VALUE, moreSegments%, propertyFlags%) As Integer
Declare Function NWRenameObject Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal newObjectName$, ByVal objectType%) As Integer
Declare Function NWScanObject Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal searchObjectName$, ByVal searchObjectType%, objectID&, ByVal objectName$, objectType%, objectHasProperties%, objectFlag%, objectSecurity%) As Integer
Declare Function NWScanObjectTrusteePaths Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectID&, ByVal volumeNumber%, sequenceNumber%, trusteeAccessMask%, ByVal trusteePathName$) As Integer
Declare Function NWScanProperty Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal searchPropertyName$, sequenceNumber&, ByVal propertyName$, propertyFlags%, propertySecurity%, propertyHasValue%, moreProperties) As Integer
Declare Function NWVerifyObjectPassword Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal password$) As Integer
'propertyValue is a 128-byte array
Declare Function NWWritePropertyValue Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal segmentNumber%, propertyValue As PROPERTY_VALUE, ByVal moreSegments%) As Integer
Declare Function NWDisallowObjectPassword Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal objectType%, ByVal disallowedPassword$) As Integer
Declare Function NWGetObjectEffectiveRights Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectID&, ByVal dirHandle%, ByVal path$, rightsMask%) As Integer

'Functions from the file NW4XSERV.BAS
Declare Function NWCheckConsolePrivileges Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWCheckNetWareVersion Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal minVersion%, ByVal minSubVersion%, ByVal minRevision%, ByVal minSFT%, ByVal minTTS%, ByVal CompFlag%) As Integer
Declare Function NWDisableFileServerLogin Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWDownFileServer Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal forceFlag%) As Integer
Declare Function NWEnableFileServerLogin Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWGetDiskCacheStats Lib "NWCALLS.DLL" (ByVal ConnID%, cacheStats As DSK_CACHE_STATS) As Integer     '2.x only
Declare Function NWGetDiskChannelStats Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal channelNumber%, channelStats As DSK_CHANNEL_STATS) As Integer     '2.x only
Declare Function NWGetFSDriveMapTable Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal structSize%, driveMappingTable As DRV_MAP_TABLE) As Integer        '2.x only
Declare Function NWGetFileServerDateAndTime Lib "NWCALLS.DLL" (ByVal ConnID%, dateAndTime As DATE_AND_TIME) As Integer
'companyName, revision, and copyrightNotice must be initialized to 80 bytes
'revisionDate must be initialized to 24 bytes
Declare Function NWGetFileServerDescriptionStrings Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal companyName$, ByVal Revision$, ByVal revisionDate$, ByVal copyrightNotice$) As Integer
Declare Function NWGetFileServerLANIOStats Lib "NWCALLS.DLL" (ByVal ConnID%, serverLANIOStats As SERVER_LAN_IO_STATS) As Integer        '2.x only
Declare Function NWGetFileServerLoginStatus Lib "NWCALLS.DLL" (ByVal ConnID%, loginEnabledFlag%) As Integer
Declare Function NWGetFileServerMiscInfo Lib "NWCALLS.DLL" (ByVal ConnID%, miscInfo As NW_FS_INFO) As Integer       '2.x only
Declare Function NWGetFileServerName Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal fileServerName$) As Integer
Declare Function NWGetFileSystemStats Lib "NWCALLS.DLL" (ByVal ConnID%, fileSysStats As FILESYS_STATS) As Integer        '2.x only
Declare Function NWGetFSLANDriverConfigInfo Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal LANBoardNumber%, LANConfig As NWLAN_CONFIG) As Integer    '2.x only
Declare Function NWGetPhysicalDiskStats Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal physDiskNumber%, physDiskStats As PHYS_DSK_STATS) As Integer   '2.x only
Declare Function NWGetFileServerVersionInfo Lib "NWCALLS.DLL" (ByVal ConnID%, serverInfo As VERSION_INFO) As Integer       'documentation says 2.x only, but it works in 3.x
Declare Function NWSetFileServerDateAndTime Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal theYear%, ByVal theMonth%, ByVal theDay%, ByVal theHour%, ByVal thein%, ByVal theSec%) As Integer
Declare Function NWGetFileServerInformation Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ServerName$, MajorVersion%, MinorVersion%, Revision%, MaxxConnections%, MaxConnectionsUsed%, ConnectionsInUse%, NumVolumes%, SFTLevel%, TTSLevel%) As Integer
Declare Function NWGetFileServerExtendedInfo Lib "NWCALLS.DLL" (ByVal ConnID%, AccountingVersion%, VAPVersion%, QueueingVersion%, PrintServerVersion%, VirtualConsoleVersion%, SecurityVersion%, InternetBridgeVersion%) As Integer
Declare Function NWGetFileServerType Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal TypeFlag%, ServerType%) As Integer
Declare Function NWAttachToFileServer Lib "NWCALLS.DLL" (ByVal ServerName$, ByVal ScopeFlag%, ConnID%) As Integer
Declare Function NWDetachFromFileServer Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWLoginToFileServer Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ObjectName$, ByVal ObjectType%, ByVal Password$) As Integer
Declare Function NWLogoutFromFileServer Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
