'NW4XCOMM.BAS
'   Contains Common definations of data type needed across multiple
'   BAS files for the Visual Basic Interface for Netware SDK 4.X
'April 4, 1995 - Version 0.1
'Created by Joseph A. DiVito - Seton Hall University

'The DATA_AND_TIME defination is used in NW41CONN.BAS, NW41SERV.BAS
Type DATE_AND_TIME
    year As String * 1
    month As String * 1
    date As String * 1
    hour As String * 1
    minute As String * 1
    second As String * 1
    day As String * 1
End Type

'Used in NW4XVOL and NW4XDIR.BAS Files
Type DIR_SPACE_INFO
   totalBlocks As Long
   availableBlocks As Long
   purgeableBlocks As Long       'set to zero if a dirHandle is present
   notYetPurgeableBlocks As Long '....when the NWGetDIrSpaceInfo() is called
   totalDirEntries As Long
   availableDirEntries As Long
   reserved As Long
   sectorsPerBlock As String * 1
   volLen As String * 1
   volName As String * 16
End Type

Global Const SUCCESSFUL = 0

'*************************************************************************
'    Begginning of NWCALDEF.H Code from the Netware SDK
'    Converted to Visual Basic Code
'*************************************************************************

Global Const FA_NORMAL = &H0
Global Const FA_READ_ONLY = &H1
Global Const FA_HIDDEN = &H2
Global Const FA_SYSTEM = &H4
Global Const FA_EXECUTE_ONLY = &H8
Global Const FA_DIRECTORY = &H10
Global Const FA_NEEDS_ARCHIVED = &H20
Global Const FA_SHAREABLE = &H80

' Extended file attributes
Global Const FA_TRANSACTIONAL = &H10
Global Const FA_INDEXED = &H20
Global Const FA_READ_AUDIT = &H40
Global Const FA_WRITE_AUDIT = &H80

' the following is a the correct attribute mask list
' The difference between these and the FA_ constants above is that these
'   are in the correct positions. The last four attributes above are 8 bits
'   off. (They need to be shifted 8 bits to the left.)
Global Const A_NORMAL = &H0
Global Const A_READ_ONLY = &H1
Global Const A_HIDDEN = &H2
Global Const A_SYSTEM = &H4
Global Const A_EXECUTE_ONLY = &H8
Global Const A_DIRECTORY = &H10
Global Const A_NEEDS_ARCHIVED = &H20
Global Const A_SHAREABLE = &H80
Global Const A_DONT_SUBALLOCATE = &H800
Global Const A_TRANSACTIONAL = &H1000
Global Const A_INDEXED = &H2000                ' not in the NCP book
Global Const A_READ_AUDIT = &H4000
Global Const A_WRITE_AUDIT = &H8000
Global Const A_IMMEDIATE_PURGE = &H10000
Global Const A_RENAME_INHIBIT = &H20000
Global Const A_DELETE_INHIBIT = &H40000
Global Const A_COPY_INHIBIT = &H80000
Global Const A_FILE_MIGRATED = &H400000
Global Const A_DONT_MIGRATE = &H800000
Global Const A_IMMEDIATE_COMPRESS = &H2000000
Global Const A_FILE_COMPRESSED = &H4000000
Global Const A_DONT_COMPRESS = &H8000000
Global Const A_CANT_COMPRESS = &H20000000

' access rights attributes
Global Const AR_READ = &H1
Global Const AR_WRITE = &H2
Global Const AR_READ_ONLY = &H1
Global Const AR_WRITE_ONLY = &H2
Global Const AR_DENY_READ = &H4
Global Const AR_DENY_WRITE = &H8
Global Const AR_COMPATIBILITY = &H10
Global Const AR_WRITE_THROUGH = &H40
Global Const AR_OPEN_COMPRESSED = &H100

' search attributes
Global Const SA_NORMAL = &H0
Global Const SA_HIDDEN = &H2
Global Const SA_SYSTEM = &H4
Global Const SA_SUBDIR_ONLY = &H10
Global Const SA_SUBDIR_FILES = &H8000
Global Const SA_ALL = &H8006

Global Const MAX_VOL_LEN = 17        ' this includes a byte for null


Global Const USE_NW_WILD_MATCH = 0
Global Const USE_DOS_WILD_MATCH = 1

' Scope specifiers
Global Const GLOBAL_SCOPE = 0
Global Const PRIVATE_SCOPE = 1
Global Const MY_SESSION = 2
Global Const ALL_SESSIONS = 3

' Declarations for Trustee Rights to Directories
Global Const TR_NONE = &H0
Global Const TR_READ = &H1
Global Const TR_WRITE = &H2
Global Const TR_CREATE = &H8
Global Const TR_ERASE = &H10
Global Const TR_ACCESS = &H20
Global Const TR_FILE = &H40
Global Const TR_MODIFY = &H80
Global Const TR_SUPERVISOR = &H100
Global Const TR_NORMAL = &HFF
Global Const TR_ALL = &H1FF

