'NW4XCONN.BAS - Visual Basic Interface for Netware 4.X - Connection Declars.
'   Contains function definations for Netware Server Connectivity, and Info.
'   reagrding those connections.
'Created by Joseph A. DiVito - Seton Hall University
'Requirements - NW4XCOMM.BAS
'Corresponds to NWCONNEC.H in the Netware SDK for C/C++
'Includes some type decalration help from Novell's first release of NIVB

Type CONNECT_INFO
    ConnID As Integer
    connectFlags As Integer
    sessionID As Integer
    connNumber As Integer
    serverAddr As String * 12
    serverType As Integer
    ServerName As String * 48
    clientType As Integer
    clientName As String * 48
End Type

Type CONN_USE
    systemElapsedTime As Long
    bytesRead As String * 6
    bytesWritten As String * 6
    totalRequestPackets As Long
End Type

Type CONN_LIST
    ListOfConnections(125) As Integer
End Type

Type NWINET_ADDR
    networkAddr As String * 4
    netNodeAddr As String * 6
    socket As Integer
    connType As Integer  '3.11 and above only: 0=not in use, 2=NCP, 3=AFP
End Type

Global Const CONNECTION_AVAILABLE = &H1
Global Const CONNECTION_PRIVATE = &H2                  'obsolete
Global Const CONNECTION_LOGGED_IN = &H4
Global Const CONNECTION_LICENSED = &H4
Global Const CONNECTION_BROADCAST_AVAILABLE = &H8
Global Const CONNECTION_ABORTED = &H10
Global Const CONNECTION_REFUSE_GEN_BROADCAST = &H20
Global Const CONNECTION_BROADCASTS_DISABLED = &H40
Global Const CONNECTION_PRIMARY = &H80
Global Const CONNECTION_NDS = &H100
Global Const CONNECTION_PNW = &H4000
Global Const CONNECTION_AUTHENTICATED = &H8000         'obsolete

'the following are for NWGetConnInfo
'ALL is VLM, OS2 and NT - NOT NETX
Global Const NW_CONN_TYPE = 1             'returns WORD (VLM)
Global Const NW_CONN_BIND = &H31
Global Const NW_CONN_NDS = &H32
Global Const NW_CONN_PNW = &H33
Global Const NW_AUTHENTICATED = 3  'returns WORD = 1 if authenticated (ALL)
Global Const NW_PBURST = 4         'returns WORD = 1 if pburst (VLM)
Global Const NW_VERSION = 8        'returns WORD (VLM)
Global Const NW_HARD_COUNT = 9     'returns WORD (VLM)
Global Const NW_CONN_NUM = 13      'returns WORD (ALL)
Global Const NW_TRAN_TYPE = 15     'returns WORD (VLM)
Global Const NW_TRAN_IPX = &H21
Global Const NW_TRAN_TCP = &H22
Global Const NW_SESSION_ID = &H8000      'returns WORD) (VLM)
Global Const NW_SERVER_ADDRESS = &H8001  'returns 12 byte address (ALL)
Global Const NW_SERVER_NAME = &H8002     'returns 48 byte string  (ALL)

Declare Function NWGetConnInfo Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal connType%, conndata$) As Integer
Declare Function NWLockConnection Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
'Below Function for Server 2.2 Only
Declare Function NWGetConnectionUsageStats Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ConnectionNumber%, StatusBuffer As CONN_USE) As Integer
Declare Function NWGetConnectionInformation Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ConnNum%, ByVal objectName$, ObjectType%, objectID&, loginTime As DATE_AND_TIME) As Integer
'internetAddress needs to be Init. to a 10 Char String
Declare Function NWGetInternetAddress Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ConnNum%, ByVal internetAddress$) As Integer
Declare Function NWGetInetAddr Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ConnNum%, inetAddr As NWINET_ADDR) As Integer
Declare Sub NWGetMaximumConnection Lib "NWCALLS.DLL" (maxConnection%)
Declare Function NWGetConnectionList Lib "NWCALLS.DLL" (ByVal mode%, connListBuffer%, ByVal connListSize%, numConnection%) As Integer
Declare Function NWGetConnectionStatus Lib "NWCALLS.DLL" (ByVal ConnID%, connInfo As CONNECT_INFO, ByVal connInfoSize%) As Integer
Declare Function NWGetDefaultConnectionID Lib "NWCALLS.DLL" (ConnID%) As Integer
Declare Function NWGetObjectConnectionNumbers Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectName$, ByVal ObjectType%, numConnections%, connlist As CONN_LIST, ByVal maxConnections%) As Integer
Declare Function NWGetConnListFromObject Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectID&, ByVal searchConnNum&, connListLen%, connlist As CONN_LIST) As Integer
Declare Function NWSetPreferredServer Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWGetPrimaryConnectionID Lib "NWCALLS.DLL" (ConnID%) As Integer
Declare Function NWSetPrimaryConnectionID Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWGetConnectionHandle Lib "NWCALLS.DLL" (ByVal ServerName$, ByVal mode%, Conn%, ByVal Scope%) as Integer
'Same Purpose as above function ^^^^^^ but put in for Compatiability
Declare Function NWGetConnectionID Lib "NWCALLS.DLL" (ByVal ServerName$, ByVal mode%, Conn%, ByVal Scope%) as Integer
Declare Function NWGetConnectionNumber Lib "NWCALLS.DLL" (ByVal ConnID%, ConnNum%) As Integer
Declare Function NWClearConnectionNumber Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ConnNum%) As Integer
Declare Function NWIsIDInUse Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer

