'NW4XDIR.BAS - Visual Basic Interface File for Netware 4.X SDK
'   Contains Function defination and type declarations for Directory
'   Creation, Information Retrieval and Deletion
'Created by Joseph A. DiVito - Seton Hall University
'Requirments - NW4XCOMM.BAS
'Corresponds to NWDIRECT.H in the Netware SDK


'Trustee Access Rights in a network directory
'NOTE: TA_OPEN is obsolete in 3.x

Global Const TA_NONE = &H0
Global Const TA_READ = &H1
Global Const TA_WRITE = &H2
Global Const TA_OPEN = &H4
Global Const TA_CREATE = &H8
Global Const TA_DELETE = &H10
Global Const TA_OWNERSHIP = &H20
Global Const TA_SEARCH = &H40
Global Const TA_MODIFY = &H80
Global Const TA_ALL = &HFB

Type TRUSTEE_INFO
  objectID As Long
  objectRights As Integer
End Type

Declare Function NWAddTrusteeToDirectory Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal dirPath$, ByVal trusteeID&, ByVal rightsMask%) As Integer
Declare Function NWDeleteTrusteeFromDirectory Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal dirPath$, ByVal objectID&) As Integer
Declare Function NWGetEffectiveDirectoryRights Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal dirPath$, rightsMask%) As Integer
Declare Function NWModifyMaximumRightsMask Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal dirPath$, ByVal revokeRightsMask%, ByVal grantRightsMask%) As Integer
Declare Function NWScanDirectoryForTrustees Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle$, ByVal searchDirPath$, sequenceNumber%, ByVal dirName$, dirDateTime&, ownerID&, trusteeIDs&, trusteeRights%) As Integer
Declare Function NWScanDirectoryForTrustees2 Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal searchDirPath$, sequenceNumber&, ByVal dirName$, dirDateTime&, ownerID&, trusteeList As TRUSTEE_INFO) As Integer

'Global Const NWScanDirectoryInformation(a, b, c, d, e, f, g, h) \
'  NWIntScanDirectoryInformation(a, b, c, d, e, f, g, h, 0)

Declare Function NWIntScanDirectoryInformation Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal searchDirPath$, sequenceNumber%, ByVal dirName$, dirDateTime&, ownerID&, rightsMask%, ByVal augmentFlag%) As Integer

'Global Const NWScanDirectoryInformation2(a, b, c, d, e, f, g, h) \
'        NWIntScanDirectoryInformation2(a, b, c, d, e, f, g, h, 0)

Declare Function NWIntScanDirectoryInformation2 Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal searchDirPath$, sequenceNumber%, ByVal dirName$, dirDateTime&, ownerID&, rightsMask%, ByVal augmentFlag) As Integer
Declare Function NWSetDirectoryInformation Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal dirPath$, ByVal dirDateTime&, ByVal ownerID&, ByVal rightsMask%) As Integer
Declare Function NWSaveDirectoryHandle Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal saveBuffer$) As Integer
Declare Function NWRestoreDirectoryHandle Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal saveBuffer$, newDirHandle%, rightsMask%) As Integer
Declare Function NWAllocPermanentDirectoryHandle Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal dirPath$, newDirHandle&, effectiveRights%) As Integer
Declare Function NWAllocTemporaryDirectoryHandle Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal dirPath$, newDirHandle&, rightsMask%) As Integer
Declare Function NWDeallocateDirectoryHandle Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%) As Integer
Declare Function NWSetDirectoryHandlePath Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal sourceDirHandle%, ByVal dirPath$, ByVal destDirHandle%) As Integer
Declare Function NWGetDirectoryHandlePath Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal dirPath$) As Integer
Declare Function NWCreateDirectory Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal dirPath$, ByVal accessMask%) As Integer
Declare Function NWDeleteDirectory Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal dirPath$) As Integer
Declare Function NWRenameDirectory Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal oldDirName$, ByVal newDirName$) As Integer
Declare Function NWSetDirSpaceLimit Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal spaceLimit&) As Integer
'ReturnBuff is a String of Bytes representing Limitations - Init to String * 32
Declare Function NWGetDirSpaceLimitList Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal returnBuff$) As Integer
Declare Function NWGetDirSpaceInfo Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal volNumber%, spaceInfo As DIR_SPACE_INFO) As Integer

Global Const TF_NORMAL = &H0
Global Const TF_READ_ONLY = &H1
Global Const TF_HIDDEN = &H2
Global Const TF_SYSTEM = &H4
Global Const TF_EXECUTE_ONLY = &H8

Global Const TF_DIRECTORY = &H10
Global Const TF_NEEDS_ARCHIVED = &H20
Global Const TF_EXECUTE_CONFIRM = &H40
Global Const TF_SHAREABLE = &H80

Global Const TF_LOW_SEARCH_BIT = &H100
Global Const TF_MID_SEARCH_BIT = &H200
Global Const TF_HI_SEARCH_BIT = &H400
Global Const TF_PRIVATE = &H800

Global Const TF_TRANSACTIONAL = &H1000
Global Const TF_INDEXED = &H2000
Global Const TF_READ_AUDIT = &H4000
Global Const TF_WRITE_AUDIT = &H8000

Global Const TF_PURGE = &H10000
Global Const TF_RENAME_INHIBIT = &H20000
Global Const TF_DELETE_INHIBIT = &H40000
Global Const TF_COPY_INHIBIT = &H80000
Global Const TF_AUDITING_BIT = &H100000

'DIRECTORY ATTRIBUTES

Global Const TD_HIDDEN = TF_HIDDEN
Global Const TD_SYSTEM = TF_SYSTEM
Global Const TD_PURGE = TF_PURGE
Global Const TD_PRIVATE = TF_PRIVATE
Global Const TD_VISIBLE = TF_PRIVATE
Global Const TD_RENAME_INHIBIT = TF_RENAME_INHIBIT
Global Const TD_DELETE_INHIBIT = TF_DELETE_INHIBIT

