'NW4XERR.BAS - Visual Basic Interface File for Netware 4.X SDK
'   Contains type declarations for Most Error Codes
'Created by Joseph A. DiVito - Seton Hall University
'Requirments - NONE
'Corresponds to NWERROR.H in the Netware SDK

'*** Network errors ***
' Decimal values at end of line are 32768 lower than actual

Global Const SHELL_ERROR = &H8800
Global Const VLM_ERROR = &H8800
Global Const ALREADY_ATTACHED = &H8800             ' 0  - Attach attempted to server with valid, existing connection
Global Const INVALID_CONNECTION = &H8801           ' 1  - Request attempted with invalid or non-attached connection handle
Global Const DRIVE_IN_USE = &H8802                 ' 2  - OS/2 only (NOT USED)
Global Const CANT_ADD_CDS = &H8803                 ' 3  - Map drive attempted but unable to add new current directory structure
Global Const BAD_DRIVE_BASE = &H8804               ' 4  - Map drive attempted with invalid path specification
Global Const NET_READ_ERROR = &H8805               ' 5  - Attempt to receive from the selected transport failed
Global Const NET_RECV_ERROR = &H8805               ' 5
Global Const UNKNOWN_NET_ERROR = &H8806            ' 6  - Network send attempted with an un-specific network error
Global Const SERVER_INVALID_SLOT = &H8807          ' 7  - Server request attempted with invalid server connection slot
Global Const BAD_SERVER_SLOT = &H8807              ' 7
Global Const NO_SERVER_SLOTS = &H8808              ' 8  - Attach attempted to server with no connection slots available
Global Const NET_WRITE_ERROR = &H8809              ' 9  - Attempt to send on the selected transport failed
Global Const NET_SEND_ERROR = &H8809               ' 9
Global Const SERVER_NO_ROUTE = &H880A              ' 10 - Attempted to find route to server where no route exists
Global Const BAD_LOCAL_TARGET = &H880B             ' 11 - OS/2 only
Global Const TOO_MANY_REQ_FRAGS = &H880C           ' 12 - Attempted request with too many request fragments specified
Global Const CONNECT_LIST_OVERFLOW = &H880D        ' 13
Global Const BUFFER_OVERFLOW = &H880E              ' 14 - Attempt to receive more data than the reply buffer had room for
Global Const NO_CONN_TO_SERVER = &H880F            ' 15
Global Const NO_CONNECTION_TO_SERVER = &H880F      ' 15 - Attempt to get connection for a server not connected
Global Const NO_ROUTER_FOUND = &H8810              ' 16 - OS/2 only
Global Const BAD_FUNC_ERROR = &H8811               ' 17
Global Const INVALID_SHELL_CALL = &H8811           ' 17 - Attempted function call to non- existent or illegal function
Global Const NOT_SAME_CONNECTION = &H8830          ' 48 - Internal server request attempted accross different server connections
Global Const PRIMARY_CONNECTION_NOT_SET = &H8831   ' 49 - Attempt to retrieve default connection with no primary connection set
Global Const NO_PRIMARY_SET = &H8831               ' 49
Global Const NO_CAPTURE_SET = &H8832               ' 50
Global Const NO_CAPTURE_IN_PROGRESS = &H8832       ' 50 - Capture information requested on port with no capture in progress
Global Const BAD_BUFFER_LENGTH = &H8833            ' 51
Global Const INVALID_BUFFER_LENGTH = &H8833        ' 51 - Used to indicate length which caller requested on a GetDNC or SetDNC was too large
Global Const NO_USER_NAME = &H8834                 ' 52
Global Const NO_NETWARE_PRINT_SPOOLER = &H8835     ' 53 - Capture requested without having the local print spooler installed
Global Const INVALID_PARAMETER = &H8836            ' 54 - Attempted function with an invalid function parameter specified
Global Const CONFIG_FILE_OPEN_FAILED = &H8837      ' 55 - OS/2 only
Global Const NO_CONFIG_FILE = &H8838               ' 56 - OS/2 only
Global Const CONFIG_FILE_READ_FAILED = &H8839      ' 57 - OS/2 only
Global Const CONFIG_LINE_TOO_LONG = &H883A         ' 58 - OS/2 only
Global Const CONFIG_LINES_IGNORED = &H883B         ' 59 - OS/2 only
Global Const NOT_MY_RESOURCE = &H883C              ' 60 - Attempted request made with a parameter using foriegn resource
Global Const DAEMON_INSTALLED = &H883D             ' 61 - OS/2 only
Global Const SPOOLER_INSTALLED = &H883E            ' 62 - Attempted load of print spooler with print spooler already installed
Global Const CONN_TABLE_FULL = &H883F              ' 63
Global Const CONNECTION_TABLE_FULL = &H883F        ' 63 - Attempted to allocate a connection handle with no more local connection table entries
Global Const CONFIG_SECTION_NOT_FOUND = &H8840     ' 64 - OS/2 only
Global Const BAD_TRAN_TYPE = &H8841                ' 65
Global Const INVALID_TRANSPORT_TYPE = &H8841       ' 65 - Attempted function on a connection with an invalid transport selected
Global Const TDS_TAG_IN_USE = &H8842               ' 66 - OS/2 only
Global Const TDS_OUT_OF_MEMORY = &H8843            ' 67 - OS/2 only
Global Const TDS_INVALID_TAG = &H8844              ' 68 - Attempted TDS function with invalid tag
Global Const TDS_WRITE_TRUNCATED = &H8845          ' 69 - Attempted TDS write with buffer that exceeded buffer
Global Const NO_DIRECTORY_SERVICE_CONNECTION = &H8846   ' 70
Global Const SERVICE_BUSY = &H8846                 ' 70 - Attempted request made to partially asynchronous function in busy state
Global Const NO_SERVER_ERROR = &H8847              ' 71 - Attempted connect failed to find any servers responding
Global Const BAD_VLM_ERROR = &H8848                ' 72 - Attempted function call to non-existant or not-loaded overlay
Global Const NETWORK_DRIVE_IN_USE = &H8849         ' 73 - Attempted map to network drive that was already mapped
Global Const LOCAL_DRIVE_IN_USE = &H884A           ' 74 - Attempted map to local drive that was in use
Global Const NO_DRIVES_AVAILABLE = &H884B          ' 75 - Attempted map to next available drive when none were available
Global Const DEVICE_NOT_REDIRECTED = &H884C        ' 76 - The device is not redirected
Global Const NO_MORE_SFT_ENTRIES = &H884D          ' 77 - Maximum number of files was reached
Global Const UNLOAD_ERROR = &H884E                 ' 78 - Attempted unload failed
Global Const IN_USE_ERROR = &H884F                 ' 79 - Attempted re-use of already in use connection entry
Global Const TOO_MANY_REP_FRAGS = &H8850           ' 80 - Attempted request with too many reply fragments specified
Global Const TABLE_FULL = &H8851                   ' 81 - Attempted to add a name into the name table after it was full
Global Const SOCKET_NOT_OPEN = &H8852              ' 82 - Listen was posted on unopened socket
Global Const MEM_MGR_ERROR = &H8853                ' 83 - Attempted enhanced memory operation failed
Global Const SFT3_ERROR = &H8854                   ' 84 - An SFT3 switch occured mid-transfer
Global Const PREFERRED_NOT_FOUND = &H8855          ' 85 - the preferred directory server was not established but another directory server was returned
Global Const DEVICE_NOT_RECOGNIZED = &H8856        ' 86 - used to determine if the device is not used by VISE so pass it on to the next redirector, if any.
Global Const BAD_NET_TYPE = &H8857                 ' 87 - the network type (Bind/NDS) does not match the server version
Global Const ERROR_OPENING_FILE = &H8858           ' 88 - generic open failure error, invalid path, access denied, etc..
Global Const NO_PREFERRED_SPECIFIED = &H8859       ' 89 - no preferred name specified
Global Const ERROR_OPENING_SOCKET = &H885A         ' 90 - error opening a socket
Global Const SHELL_FAILURE = &H88FF
Global Const VLM_FAILURE = &H88FF


' Server Errors

Global Const ERR_INSUFFICIENT_SPACE = &H8901            ' 001
Global Const ERR_BUFFER_TOO_SMALL = &H8977              ' 119
Global Const ERR_VOLUME_FLAG_NOT_SET = &H8978           ' 120 the service requested, not avail. on the selected vol.
Global Const ERR_NO_ITEMS_FOUND = &H8979                ' 121
Global Const ERR_CONN_ALREADY_TEMP = &H897A             ' 122
Global Const ERR_CONN_ALREADY_LOGGED_IN = &H897B        ' 123
Global Const ERR_CONN_NOT_AUTHENTICATED = &H897C        ' 124
Global Const ERR_CONN_NOT_LOGGED_IN = &H897D            ' 125
Global Const NCP_BOUNDARY_CHECK_FAILED = &H897E         ' 126
Global Const ERR_LOCK_WAITING = &H897F                  ' 127
Global Const ERR_LOCK_FAIL = &H8980                     ' 128
Global Const FILE_IN_USE_ERROR = &H8980                 ' 128
Global Const NO_MORE_FILE_HANDLES = &H8981              ' 129
Global Const NO_OPEN_PRIVILEGES = &H8982                ' 130
Global Const IO_ERROR_NETWORK_DISK = &H8983             ' 131
Global Const NO_CREATE_PRIVILEGES = &H8984              ' 132
Global Const NO_CREATE_DELETE_PRIVILEGES = &H8985       ' 133
Global Const CREATE_FILE_EXISTS_READ_ONLY = &H8986      ' 134
Global Const WILD_CARDS_IN_CREATE_FILE_NAME = &H8987    ' 135
Global Const INVALID_FILE_HANDLE = &H8988               ' 136
Global Const NO_SEARCH_PRIVILEGES = &H8989              ' 137
Global Const NO_DELETE_PRIVILEGES = &H898A              ' 138
Global Const NO_RENAME_PRIVILEGES = &H898B              ' 139
Global Const NO_MODIFY_PRIVILEGES = &H898C              ' 140
Global Const SOME_FILES_AFFECTED_IN_USE = &H898D        ' 141
Global Const NO_FILES_AFFECTED_IN_USE = &H898E          ' 142
Global Const SOME_FILES_AFFECTED_READ_ONLY = &H898F     ' 143
Global Const NO_FILES_AFFECTED_READ_ONLY = &H8990       ' 144
Global Const SOME_FILES_RENAMED_NAME_EXISTS = &H8991    ' 145
Global Const NO_FILES_RENAMED_NAME_EXISTS = &H8992      ' 146
Global Const NO_READ_PRIVILEGES = &H8993                ' 147
Global Const NO_WRITE_PRIVILEGES_OR_READONLY = &H8994   ' 148
Global Const FILE_DETACHED = &H8995                     ' 149
Global Const SERVER_OUT_OF_MEMORY = &H8996              ' 150
Global Const ERR_TARGET_NOT_A_SUBDIRECTORY = &H8986     ' 150 can be changed later (note written by server people).
Global Const NO_DISK_SPACE_FOR_SPOOL_FILE = &H8997      ' 151
Global Const VOLUME_DOES_NOT_EXIST = &H8998             ' 152
Global Const DIRECTORY_FULL = &H8999                    ' 153
Global Const RENAMING_ACROSS_VOLUMES = &H899A           ' 154
Global Const BAD_DIRECTORY_HANDLE = &H899B              ' 155
Global Const INVALID_PATH = &H899C                      ' 156
Global Const NO_MORE_TRUSTEES = &H899C                  ' 156
Global Const NO_MORE_DIRECTORY_HANDLES = &H899D         ' 157
Global Const INVALID_FILENAME = &H899E                  ' 158
Global Const DIRECTORY_ACTIVE = &H899F                  ' 159
Global Const DIRECTORY_NOT_EMPTY = &H89A0               ' 160
Global Const DIRECTORY_IO_ERROR = &H89A1                ' 161
Global Const READ_FILE_WITH_RECORD_LOCKED = &H89A2      ' 162
Global Const ERR_TRANSACTION_RESTARTED = &H89A3         ' 163
Global Const ERR_RENAME_DIR_INVALID = &H89A4            ' 164
Global Const ERR_INVALID_OPENCREATE_MODE = &H89A5       ' 165
Global Const ERR_ALREADY_IN_USE = &H89A6                ' 166
Global Const ERR_INVALID_RESOURCE_TAG = &H89A7          ' 167
Global Const ERR_ACCESS_DENIED = &H89A8                 ' 168
Global Const INVALID_DATA_STREAM = &H89BE               ' 190
Global Const INVALID_NAME_SPACE = &H89BF                ' 191
Global Const NO_ACCOUNTING_PRIVILEGES = &H89C0          ' 192
Global Const LOGIN_DENIED_NO_ACCOUNT_BALANCE = &H89C1   ' 193
Global Const LOGIN_DENIED_NO_CREDIT = &H89C2            ' 194
Global Const ERR_TOO_MANY_HOLDS = &H89C3                ' 195
Global Const ACCOUNTING_DISABLED = &H89C4               ' 196
Global Const INTRUDER_DETECTION_LOCK = &H89C5           ' 197
Global Const NO_CONSOLE_OPERATOR = &H89C6               ' 198
Global Const NO_CONSOLE_PRIVILEGES = &H89C6             ' 198
Global Const ERR_Q_IO_FAILURE = &H89D0                  ' 208
Global Const ERR_NO_QUEUE = &H89D1                      ' 209
Global Const ERR_NO_Q_SERVER = &H89D2                   ' 210
Global Const ERR_NO_Q_RIGHTS = &H89D3                   ' 211
Global Const ERR_Q_FULL = &H89D4                        ' 212
Global Const ERR_NO_Q_JOB = &H89D5                      ' 213
Global Const ERR_NO_Q_JOB_RIGHTS = &H89D6               ' 214
Global Const ERR_Q_IN_SERVICE = &H89D7                  ' 215
Global Const PASSWORD_NOT_UNIQUE = &H89D7               ' 215
Global Const ERR_Q_NOT_ACTIVE = &H89D8                  ' 216
Global Const PASSWORD_TOO_SHORT = &H89D8                ' 216
Global Const ERR_Q_STN_NOT_SERVER = &H89D9              ' 217
Global Const LOGIN_DENIED_NO_CONNECTION = &H89D9        ' 217
Global Const ERR_MAXIMUM_LOGINS_EXCEEDED = &H89D9       ' 217
Global Const ERR_Q_HALTED = &H89DA                      ' 218
Global Const UNAUTHORIZED_LOGIN_TIME = &H89DA           ' 218
Global Const UNAUTHORIZED_LOGIN_STATION = &H89DB        ' 219
Global Const ERR_Q_MAX_SERVERS = &H89DB                 ' 219
Global Const ACCOUNT_DISABLED = &H89DC                  ' 220
Global Const PASSWORD_HAS_EXPIRED_NO_GRACE = &H89DE     ' 222
Global Const PASSWORD_HAS_EXPIRED = &H89DF              ' 223
Global Const E_NO_MORE_USERS = &H89E7                   ' 231
Global Const NOT_ITEM_PROPERTY = &H89E8                 ' 232
Global Const WRITE_PROPERTY_TO_GROUP = &H89E8           ' 232
Global Const MEMBER_ALREADY_EXISTS = &H89E9             ' 233
Global Const NO_SUCH_MEMBER = &H89EA                    ' 234
Global Const NOT_GROUP_PROPERTY = &H89EB                ' 235
Global Const NO_SUCH_SEGMENT = &H89EC                   ' 236
Global Const PROPERTY_ALREADY_EXISTS = &H89ED           ' 237
Global Const OBJECT_ALREADY_EXISTS = &H89EE             ' 238
Global Const INVALID_NAME = &H89EF                      ' 239
Global Const WILD_CARD_NOT_ALLOWED = &H89F0             ' 240
Global Const INVALID_BINDERY_SECURITY = &H89F1          ' 241
Global Const NO_OBJECT_READ_PRIVILEGE = &H89F2          ' 242
Global Const NO_OBJECT_RENAME_PRIVILEGE = &H89F3        ' 243
Global Const NO_OBJECT_DELETE_PRIVILEGE = &H89F4        ' 244
Global Const NO_OBJECT_CREATE_PRIVILEGE = &H89F5        ' 245
Global Const NO_PROPERTY_DELETE_PRIVILEGE = &H89F6      ' 246
Global Const NO_PROPERTY_CREATE_PRIVILEGE = &H89F7      ' 247
Global Const NO_PROPERTY_WRITE_PRIVILEGE = &H89F8       ' 248
Global Const NO_FREE_CONNECTION_SLOTS = &H89F9          ' 249
Global Const NO_PROPERTY_READ_PRIVILEGE = &H89F9        ' 249
Global Const NO_MORE_SERVER_SLOTS = &H89FA              ' 250
Global Const TEMP_REMAP_ERROR = &H89FA                  ' 250
Global Const INVALID_PARAMETERS = &H89FB                ' 251
Global Const NO_SUCH_PROPERTY = &H89FB                  ' 251
Global Const ERR_NCP_NOT_SUPPORTED = &H89FB             ' 251
Global Const INTERNET_PACKET_REQT_CANCELED = &H89FC     ' 252
Global Const UNKNOWN_FILE_SERVER = &H89FC               ' 252
Global Const MESSAGE_QUEUE_FULL = &H89FC                ' 252
Global Const NO_SUCH_OBJECT = &H89FC                    ' 252
Global Const LOCK_COLLISION = &H89FD                    ' 253
Global Const BAD_STATION_NUMBER = &H89FD                ' 253
Global Const INVALID_PACKET_LENGTH = &H89FD             ' 253
Global Const UNKNOWN_REQUEST = &H89FD                   ' 253
Global Const BINDERY_LOCKED = &H89FE                    ' 254
Global Const TRUSTEE_NOT_FOUND = &H89FE                 ' 254
Global Const DIRECTORY_LOCKED = &H89FE                  ' 254
Global Const INVALID_SEMAPHORE_NAME_LENGTH = &H89FE     ' 254
Global Const PACKET_NOT_DELIVERABLE = &H89FE            ' 254
Global Const SERVER_BINDERY_LOCKED = &H89FE             ' 254
Global Const SOCKET_TABLE_FULL = &H89FE                 ' 254
Global Const SPOOL_DIRECTORY_ERROR = &H89FE             ' 254
Global Const SUPERVISOR_HAS_DISABLED_LOGIN = &H89FE     ' 254
Global Const TIMEOUT_FAILURE = &H89FE                   ' 254
Global Const BAD_PRINTER_ERROR = &H89FF                 ' 255
Global Const BAD_RECORD_OFFSET = &H89FF                 ' 255
Global Const CLOSE_FCB_ERROR = &H89FF                   ' 255
Global Const FILE_EXTENSION_ERROR = &H89FF              ' 255
Global Const FILE_NAME_ERROR = &H89FF                   ' 255
Global Const HARDWARE_FAILURE = &H89FF                  ' 255
Global Const INVALID_DRIVE_NUMBER = &H89FF              ' 255
Global Const DOS_INVALID_DRIVE = &HF                    ' 255
Global Const INVALID_INITIAL_SEMAPHORE_VALUE = &H89FF   ' 255
Global Const INVALID_SEMAPHORE_HANDLE = &H89FF          ' 255
Global Const IO_BOUND_ERROR = &H89FF                    ' 255
Global Const NO_FILES_FOUND_ERROR = &H89FF              ' 255
Global Const NO_RESPONSE_FROM_SERVER = &H89FF           ' 255
Global Const NO_SUCH_OBJECT_OR_BAD_PASSWORD = &H89FF    ' 255
Global Const PATH_NOT_LOCATABLE = &H89FF                ' 255
Global Const QUEUE_FULL_ERROR = &H89FF                  ' 255
Global Const REQUEST_NOT_OUTSTANDING = &H89FF           ' 255
Global Const SOCKET_ALREADY_OPEN = &H89FF               ' 255
Global Const LOCK_ERROR = &H89FF                        ' 255


' Global Const  NOT_SAME_LOCAL_DRIVE         = &H89F6
' Global Const  TARGET_DRIVE_NOT_LOCAL       = &H89F7
' Global Const  ALREADY_ATTACHED_TO_SERVER   = &H89F8  ' 248
' Global Const  NOT_ATTACHED_TO_SERVER       = &H89F8

