'NW4XMISC.BAS - Visual Basic Interface File for Netware 4.X SDK
'   Contains Function defination and type declarations for the
'   Miscalanious Functions of Netware
'Created by Joseph A. DiVito - Seton Hall University
'Requirments - NW4XCOMM.BAS
'Corresponds to NWMISC.H in the Netware SDK
'Includes some type decalration help from Novell's first release of NIVB

Global Const NW_SHORT_NAME_SERVER = 0
Global Const NW_LONG_NAME_SERVER = 1
Global Const NW_ENCP_SERVER = 1
Global Const NW_EXTENDED_NCP_SERVER = 1

'In the Acutal Include Files the Next 4 Const are actually precluded
'by an "_" character.  However this is not possible in VB
Global Const NETX_COM = &H1
Global Const NETX_VLM = &H2
Global Const REDIR_LOADED = &H4000
Global Const VLM_LOADED = &H8000

Type NW_DATE
    day As String * 1
    month As String * 1
    year As Integer
End Type

Type NW_TIME
    seconds As String * 1
    minutes As String * 1
    hours As Integer
End Type

'Skipping Fragment structures for now.  This will also include
'any function using the TYPE NW_FRAGMENT

Type CONN_TASK
    taskNumber As Integer
    taskState As String * 1
End Type

Type CONN_TASK_INFO
    serverVersion As Integer
    lockState As String * 1
    waitingTaskNumber As Integer
    recordStart As Long
    recordEnd As Long
    volNumber As String * 1
    dirEntry As Long
    nameSpace As String * 1
    dirID As Integer
    lockedName As String * 256
    taskCount As String * 1
    tasks(256) As CONN_TASK
End Type

Type DIR_ENTRY
    volNumber As String * 1
    dirEntry As Long
End Type

Declare Sub NWUnpackDateTime Lib "NWCALLS.DLL" (ByVal dateTime&, sDate As NW_DATE, sTime As NW_TIME)
Declare Sub NWUnpackDate Lib "NWCALLS.DLL" (ByVal packeddate%, sDate As NW_DATE)
Declare Sub NWUnpackTime Lib "NWCALLS.DLL" (ByVal packedtime%, sTime As NW_TIME)
Declare Function NWPackDateTime Lib "NWCALLS.DLL" (sDate As NW_DATE, sTime As NW_TIME) As Long
Declare Function NWPackDate Lib "NWCALLS.DLL" (sDate As NW_DATE) As Integer
Declare Function NWPackTime Lib "NWCALLS.DLL" (sTime As NW_TIME) As Integer

'The following 3 routines are in for compatibility only
'Avoid using them since they only call NWUnpack{Date/Time} anyway
Declare Sub NWConvertDateTime Lib "NWCALLS.DLL" (ByVal dateTime&, sDate As NW_DATE, sTime As NW_TIME)
Declare Sub NWConvertDate Lib "NWCALLS.DLL" (ByVal packeddate%, sDate As NW_DATE)
Declare Sub NWConvertTime Lib "NWCALLS.DLL" (ByVal packedtime%, sTime As NW_TIME)

Declare Function NWWordSwap Lib "NWCALLS.DLL" (ByVal swapWord%) As Integer
Declare Function NWLongSwap Lib "NWCALLS.DLL" (ByVal swapLong&) As Long
Declare Function NWInitDBCS Lib "NWCALLS.DLL" () As Integer
'path should be initialized to String * 255
'dirHandle should be String * 1
Declare Function NWConvertPathToDirEntry Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle$, ByVal path$, dirEntry As DIR_ENTRY) As Integer
Declare Function NWGetTaskInformationByConn Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ConnNum%, taskInfo As CONN_TASK_INFO) As Integer
'majorVer, MinorVer and revision shoudl be Initialized to String * 1
Declare Function NWGetRequestorVersion Lib "NWCALLS.DLL" (ByVal majorVer$, ByVal minorVer$, ByVal revision$) As Integer
'path should be initialized to String * 255
'dirHandle shoudl be String * 1
Declare Function NWIsLNSSupportedOnVolume Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal path$) As Integer
'accessMode and NWHandle should be String * 1
Declare Function NWConvertHandle Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal accessMode$, ByVal NWHandle$, ByVal fileSize&, filehandle%) As Integer
Declare Function NWConvertFileHandle Lib "NWCALLS.DLL" (ByVal filehandle%, ByVal handleType%, ByVal NWHandle$, conn%) As Integer
'NW4ByteHandle shoudl be String * 4 and NW6ByteHandle should be String * 6
Declare Sub NWConvert4Byteto6ByteHandle Lib "NWCALLS.DLL" (ByVal NW4Bytehandle$, ByVal NW6ByteHandle$)
Declare Function NWEndOfJob Lib "NWCALLS.DLL" () As Integer
'Not really needed in Windows, but suggested before making any NW calls
'However I don't even use it :) :)
Declare Function NWCallsInit Lib "NWCALLS.DLL" (ByVal parm1%, ByVal parm%) As Integer
Declare Function NWGetNWCallsState Lib "NWCALLS.DLL" () As Integer
'errormode and prevMode should be String * 1
Declare Function NWSetNetwareErrorMode Lib "NWCALLS.DLL" (ByVal errorMode$, ByVal prevMode$) As Integer
'endofJobStatus and prevStatus should be String * 1
Declare Function NWSetEndOfJobStatus Lib "NWCALLS.DLL" (ByVal endofJobStatus$, ByVal prevStatus$) As Integer
'all below parameter are String * 1
Declare Sub NWGetNWCallsVersion Lib "NWCALLS.DLL" (ByVal majorVer$, ByVal minroVer$, ByVal revLevel$, ByVal betaLevel$)
'accessmode and NWHandle should be String * 1
Declare Function NWConvertHandle Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal accessMode$, ByVal NWHandle$, ByVal fileSize&, filehandle%) As Integer
'handleSize shouls always be equal to 4
Declare Function NWCloseFile Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal NWHandle&, ByVal handleSize%) As Integer
'path shoudl be String * 255 and server shoudl be String * 48
Declare Function NWStripServerOffPath Lib "NWCALLS.DLL" (ByVal path$, ByVal server$) As String













