'NW4XSERV.BAS - Visual Basic Interface File for Netware 4.X SDK
'   Contains Function defination and type declarations for Server Conn.,
'   Stats, rights, volumes (physical and Virtual Info)
'Created by Joseph A. DiVito - Seton Hall University
'Requirements - NW4XCOMM.BAS
'Corresponds to NWSERVER.H in the Netware SDK
'Includes some type decalration help from Novell's first release of NIVB

Type DSK_CACHE_STATS
    systemElapsedTime As Long
    cacheBufferCount As Integer
    cacheBufferSize As Integer
    dirtyCacheBuffers As Integer
    cacheReadRequests As Long
    cacheWriteRequests As Long
    cacheHits As Long
    cacheMisses As Long
    physicalReadRequests As Long
    physicalWriteRequests As Long
    physicalReadErrors As Integer
    physicalWriteErrors As Integer
    cacheGetRequests As Long
    cacheFullWriteRequests As Long
    cachePartialWriteRequests As Long
    backgroundDirtyWrites As Long
    backgroundAgedWrites As Long
    totalCacheWrites As Long
    cacheAllocations As Long
    thrashingCount As Integer
    LRUBlockWasDirtyCount As Integer
    readBeyondWriteCount As Integer
    fragmentedWriteCount As Integer
    cacheHitOnUnavailCount As Integer
    cacheBlockScrappedCount As Integer
End Type

Type DSK_CHANNEL_STATS
    systemElapsedTime As Long
    channelState As Integer
    channelSyncState As Integer
    driverType As String * 1
    driverMajorVersion As String * 1
    driverMinorVersion As String * 1
    driverDescription As String * 65
    IOAddr1 As Integer
    IOAddr1Size As Integer
    IOAddr2 As Integer
    IOAddr2Size As Integer
    sharedMem1Seg As String * 3
    sharedMem1Off As Integer
    sharedMem2Seg As String * 3
    sharedMem2Off As Integer
    interrupt1Used As String * 1
    interrupt1 As String * 1
    interrupt2Used As String * 1
    interrupt2 As String * 1
    DMAChannel1Used As String * 1
    DMAChannel1 As String * 1
    DMAChannel2Used As String * 1
    DMAChannel2 As String * 1
    reserved2 As Integer
    configDescription As String * 80
End Type

Type DRV_MAP_TABLE
    systemElapsedTime As Long
    SFTLevel As String * 1
    logicalDriveCount As String * 1
    physicalDriveCount As String * 1
    diskChannelTable As String * 5
    pendingIOCommands As Integer
    mappingTable As String * 32
    driveMirrorTable As String * 32
    deadMirrorTable As String * 32
    remirroredDrive As String * 1
    reserved As String * 1
    remirroredBlock As Long
    SFTErrorTable As String * 120
End Type

Type SERVER_LAN_IO_STATS
    systemElapsedTime As Long
    maxRoutingBuffersAvail As Integer
    maxRoutingBuffersUsed As Integer
    routingBuffersInUse As Integer
    totalFileServicePackets As Long
    fileServicePacketsBuffered As Integer
    invalidConnPacketCount As Long
    badLogicalConnCount As Long
    packetsRcvdDuringProcCount As Integer
    reprocessedRequestCount As Integer
    badSequenceNumberPacketCount As Integer
    duplicateReplyCount As Integer
    acknowledgementsSent As Integer
    badRequestTypeCount As Integer
    attachDuringProcCount As Integer
    attachWhileAttachingCount As Integer
    forgedDetachRequestCount As Integer
    badConnNumberOnDetachCount As Long
    detachDuringProcCount As Integer
    repliesCanceledCount As Integer
    hopCountDiscardCount As Integer
    unknownNetDiscardCount As Integer
    noDGroupBufferDiscardCount As Integer
    outPacketNoBufferDiscardCount As Integer
    IPXNotMyNetworkCount As Integer
    NetBIOSPropagationCount As Long
    totalOtherPackets As Long
    totalRoutedPackets As Long
End Type

Type NW_FS_INFO
    systemElapsedTime As Long
    processorType As String * 1
    reserved As String * 1
    serviceProcessCount As String * 1
    serverUtilizationPercent As String * 1
    maxBinderyObjectsAvail As Integer
    maxBinderyObjectsUsed As Integer
    binderyObjectsInUse As Integer
    serverMemoryInK As Integer
    dynamicAreaCount As Integer
    dynamicSpace1 As Long
    maxUsedDynamicSpace1 As Long
    dynamicSpaceInUse1 As Long
    dynamicSpace2 As Long
    maxUsedDynamicSpace2 As Long
    dynamicSpaceInUse2 As Long
    dynamicSpace3 As Long
    maxUsedDynamicSpace3 As Long
    dynamicSpaceInUse3 As Long
End Type

Type FILESYS_STATS
    systemElapsedTime As Long
    maxOpenFiles As Integer
    maxFilesOpen As Integer
    currOpenFiles As Integer
    totalFilesOpened As Long
    totalReadRequests As Long
    totalWriteRequests As Long
    currChangedFATSectors As Integer
    totalChangedFATSectors As Long
    FATWriteErrors As Integer
    fatalFATWriteErrors As Integer
    FATScanErrors As Integer
    maxIndexFilesOpened As Integer
    currOpenIndexedFiles As Integer
    attachedIndexFiles As Integer
    availableindexFiles As Integer
End Type

Type NWLAN_CONFIG
    networkAddress As Long
    hostAddress1 As Long
    hostAddress2 As Integer
    LANDriverInstalled As String * 1
    optionNumber As String * 1
    configurationText1 As String * 80
    configuratinoText2 As String * 80
End Type

Type PHYS_DSK_STATS
    systemElapsedTime As Long
    diskChannel As String * 1
    diskRemovable As String * 1
    driveType As String * 1
    controllerDriverNumber As String * 1
    controllerNumber As String * 1
    controllerType As String * 1
    driveSize As Long
    driveCylinders As Integer
    driveHeads As String * 1
    sectorsPerTrack As String * 1
    IOErrorCount As Integer
    hotFixStart As Long
    hotFixSize As Integer
    hotFixSizeAvailable As Integer
    hotFixDisabled As String * 1
End Type

Type VERSION_INFO
    ServerName As String * 48
    netwareVersion As String * 1
    netwareSubVersion As String * 1
    maxConnectionsSupported As Long
    ConnectionsInUse As Long
    maxVolumesSupported As Integer
    revisionLevel As String * 1
    SFTLevel As String * 1
    TTSLevel As String * 1
    peakConnectionsUsed As Long
    AccountingVersion As String * 1
    VAPVersion As String * 1
    QueueingVersion As String * 1
    PrintServerVersion As String * 1
    VirtualConsoleVersion As String * 1
    securityRestrictionLevel As String * 1
    internetBridgeSupport As String * 1
End Type

Declare Function NWCheckConsolePrivileges Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWCheckNetWareVersion Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal minVersion%, ByVal minSubVersion%, ByVal minRevision%, ByVal minSFT%, ByVal minTTS%, ByVal CompFlag%) As Integer
Declare Function NWDisableFileServerLogin Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWDownFileServer Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal forceFlag%) As Integer
Declare Function NWEnableFileServerLogin Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWGetDiskCacheStats Lib "NWCALLS.DLL" (ByVal ConnID%, cacheStats As DSK_CACHE_STATS) As Integer     '2.x only
Declare Function NWGetDiskChannelStats Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal channelNumber%, channelStats As DSK_CHANNEL_STATS) As Integer     '2.x only
Declare Function NWGetFSDriveMapTable Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal structSize%, driveMappingTable As DRV_MAP_TABLE) As Integer        '2.x only
Declare Function NWGetFIleServerDateAndTime Lib "NWCALLS.DLL" (ByVal ConnID%, dateAndTime As DATE_AND_TIME) As Integer
'companyName, revision, and copyrightNotice must be initialized to 80 bytes
'revisionDate must be initialized to 24 bytes
Declare Function NWGetFileServerDescription Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal companyName$, ByVal Revision$, ByVal revisionDate$, ByVal copyrightNotice$) As Integer
Declare Function NWGetFileServerLANIOStats Lib "NWCALLS.DLL" (ByVal ConnID%, serverLANIOStats As SERVER_LAN_IO_STATS) As Integer        '2.x only
Declare Function NWGetFileServerLoginStatus Lib "NWCALLS.DLL" (ByVal ConnID%, loginEnabledFlag%) As Integer
Declare Function NWGetFileServerMiscInfo Lib "NWCALLS.DLL" (ByVal ConnID%, miscInfo As NW_FS_INFO) As Integer       '2.x only
Declare Function NWGetFileServerName Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal fileServerName$) As Integer
Declare Function NWGetFileSystemStats Lib "NWCALLS.DLL" (ByVal ConnID%, fileSysStats As FILESYS_STATS) As Integer        '2.x only
Declare Function NWGetFSLANDriverConfigInfo Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal LANBoardNumber%, LANConfig As NWLAN_CONFIG) As Integer    '2.x only
Declare Function NWGetPhysicalDiskStats Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal physDiskNumber%, physDiskStats As PHYS_DSK_STATS) As Integer   '2.x only
Declare Function NWGetFileServerVersionInfo Lib "NWCALLS.DLL" (ByVal ConnID%, serverInfo As VERSION_INFO) As Integer       'documentation says 2.x only, but it works in 3.x
Declare Function NWSetFileServerDateAndTime Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal theYear%, ByVal theMonth%, ByVal theDay%, ByVal theHour%, ByVal thein%, ByVal theSec%) As Integer
Declare Function NWGetFileServerInformation Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ServerName$, MajorVersion%, MinorVersion%, Revision%, MaxxConnections%, MaxConnectionsUsed%, ConnectionsInUse%, NumVolumes%, SFTLevel%, TTSLevel%) As Integer
Declare Function NWGetFileServerExtendedInfo Lib "NWCALLS.DLL" (ByVal ConnID%, AccountingVersion%, VAPVersion%, QueueingVersion%, PrintServerVersion%, VirtualConsoleVersion%, SecurityVersion%, InternetBridgeVersion%) As Integer
Declare Function NWGetFileServerType Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal TypeFlag%, ServerType%) As Integer
Declare Function NWAttachtoFileServer Lib "NWCALLS.DLL" (ByVal ServerName$, ByVal ScopeFlag%, ConnID%) As Integer
Declare Function NWDetachFromFileServer Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer
Declare Function NWLoginToFileServer Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal ObjectName$, ByVal ObjectType%, ByVal Password$) As Integer
Declare Function NWLogoutFromFileServer Lib "NWCALLS.DLL" (ByVal ConnID%) As Integer





