'NW4XVOL.BAS - Visual Basic for Windows Interface for the Netware SDK v4.X
'     Contains all Function and Type declareations for Access Volume Info
'Created by Joseph A. DiVito of Seton Hall Univeristy
'Requires the NW4XCOMM File

Global Const VINetWare386 = 0
Global Const VINetWare286 = 1
Global Const VINetWare386v30 = 2
Global Const VINetWare386v31 = 3

'/*    define the extended volume information status flag bits  */

Global Const NWSubAllocEnabledBit = &H1
Global Const NWCompressionEnabledBit = &H2
Global Const NWMigrationEnabledBit = &H4
Global Const NWAuditingEnabledBit = &H8
Global Const NWReadOnlyEnabledBit = &H10


Type NWOBJ_REST
    objectID As Long
    restriction As Long
End Type

Type NWVolumeRestrictions
    numberOfEntries As String * 1
    resInfo(12) As NWOBJ_REST
End Type

Type NWVOL_RESTRICTIONS
    numberOfEntries As String * 1
    resInfo(12) As NWOBJ_REST
End Type

Type VOL_STATS
    systemElapsedTime As Long
    volumeNumber As String * 1
    logicalDriveNumber As String * 1
    sectorsPerBlock As Integer
    startingBlock As Integer
    totalBlocks As Integer
    availableBlocks As Integer
    totalDirectorySlots As Integer
    availableDirectorySlots As Integer
    maxDirectorySlotsUsed As Integer
    isHashing As String * 1
    isCaching As String * 1
    isRemovable As String * 1
    isMounted As String * 1
    volumeName As String * 16
End Type

Type NWVolExtendedInfo
    volType As Long
    statusFlag As Long
    sectorSize As Long
    sectorsPerCluster As Long
    volSizeInClusters As Long
    freeClusters As Long
    subAllocFreeableClusters As Long
    freeableLimboSectors As Long
    nonfreeableLimboSectors As Long
    availSubAllocSectors As Long            '* non freeable */
    nonuseableSubAllocSectors As Long
    subAllocClusters As Long
    numDataStreams As Long
    numLimboDataStreams As Long
    oldestDelFileAgeInTicks As Long
    numCompressedDataStreams As Long
    numCompressedLimboDataStreams As Long
    numNoncompressibleDataStreams As Long
    precompressedSectors As Long
    compressedSectors As Long
    numMigratedDataStreams As Long
    migratedSectors As Long
    clustersUsedByFAT As Long
    clustersUsedByDirs As Long
    clustersUsedByExtDirs As Long
    totalDirEntries As Long
    unusedDirEntries As Long
    totalExtDirExtants As Long
    unusedExtDirExtants As Long
    extAttrsDefined As Long
    extAttrExtantsUsed As Long
    DirectoryServicesObjectID As Long
    volLastModifiedDateAndTime As Long
End Type

'Move this function to NW4XDIR.BAS when completed
Declare Function NWGetDirSpaceInfo Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal VolNumber%, spaceInfo As DIR_SPACE_INFO) As Integer

'volumNum should by Init. to String * 1 for all VolNum$'s
Declare Function NWGetDiskUtilization Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal objectID&, ByVal volumeNumber$, usedDirectories%, usedFiles%, usedBlocks%) As Integer
Declare Function NWGetObjDiskRestrictions Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal VolNumber$, ByVal objectID&, restriction&, inUse&) As Integer
Declare Function NWScanVolDiskRestrictions Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal VolNumber$, sequence&, volInfo As NWVolumeRestrictions) As Integer
Declare Function NWScanVolDiskRestrictions2 Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal volNum$, seq&, volInfo As NWVOL_RESTRICTIONS) As Integer
Declare Function NWRemoveObjectDiskRestrictions Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal VolNumber$, ByVal objectID&) As Integer
Declare Function NWSetObjectVolSpaceLimit Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal VolNumber%, ByVal objectID&, ByVal restriction&) As Integer
'VolumeName should be Init to String * 17
Declare Function NWGetVolumeInfoWithHandle Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal dirHandle%, ByVal volName$, totalBlocks%, sectorsPerBlock%, availableBlocks%, totalDirEntries%, availableDirEntries%, volIsRemovableFlag%) As Integer
Declare Function NWGetVolumeInfoWithNumber Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal VolNumber%, ByVal volName$, totalBlocks&, sectorsPerBlock%, availableBlocks%, totalDirEntries%, availableDirEntries%, volIsRemovableFlag%) As Integer
Declare Function NWGetVolumeName Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal volNum%, ByVal volName$) As Integer
Declare Function NWGetVolumeNumber Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal volName$, VolNumber%) As Integer
'Below function for NW 2.2 Only
Declare Function NWGetVolumeStats Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal volumeNumber%, volInfo As VOL_STATS) As Integer
'Below Function for NW 4.X Only
Declare Function NWGetExtendedVolumeInfo Lib "NWCALLS.DLL" (ByVal ConnID%, ByVal VolNumber%, volInfo As NWVolExtendedInfo) As Integer

