DefInt A-Z
'
' Setup various workfields for contexts and handles
'
Global XSize As Integer, YSize As Integer
Global sDC, mDC, hBM

Global Const SRCCOPY = &HCC0020
Global Const CF_BITMAP = 2
Global Const HWND_TOPMOST = -1
Global Const SWP_FLOAT = 3
'
' Prototype the API calls
'
Declare Function BitBlt Lib "GDI" (ByVal hDest, ByVal xDest, ByVal yDest, ByVal w, ByVal h, ByVal hSrc, ByVal Sx, ByVal Sy, ByVal ROp As Long)
Declare Sub StretchBlt Lib "GDI" (ByVal hDest, ByVal xDest, ByVal yDest, ByVal w, ByVal h, ByVal hSrc, ByVal Sx, ByVal Sy, ByVal w, ByVal h, ByVal ROp As Long)
Declare Function CreateDC Lib "GDI" (ByVal Driver As String, ByVal Dev As Any, ByVal Out As Any, ByVal Dat As Any)
Declare Function DeleteDC Lib "GDI" (ByVal hDC)
Declare Function CreateCompatibleBitmap Lib "Gdi" (ByVal hDC, ByVal w, ByVal h)
Declare Function CreateCompatibleDC Lib "Gdi" (ByVal hDC)
Declare Function DeleteObject Lib "Gdi" (ByVal hObject)
Declare Function SelectObject Lib "Gdi" (ByVal hDC, ByVal hObject)
Declare Function OpenClipboard Lib "User" (ByVal hWnd)
Declare Function EmptyClipboard Lib "User" ()
Declare Function CloseClipboard Lib "User" ()
Declare Function SetClipboardData Lib "User" (ByVal bmF, ByVal hBM)
Declare Function GetClipboardData Lib "User" (ByVal bmF)
Declare Sub SetWindowPos Lib "User" (ByVal hWnd, ByVal hIA, ByVal x, ByVal y, ByVal CX, ByVal CY, ByVal wFlags)

Sub Main ()
    
    If App.PrevInstance Then
        Exit Sub
    End If

    'First calculate the screen size
    XSize = (Screen.Width / Screen.TwipsPerPixelX)
    YSize = (Screen.Height / Screen.TwipsPerPixelY)

    'Now get a screen display context
    sDC = CreateDC("DISPLAY", ByVal 0&, ByVal 0&, ByVal 0&)
    If sDC = 0 Then
        MsgBox "Failed create of screen context. Cannot take snapshot"
        Exit Sub
    End If
    
    Load SnapForm

    'Now create a compatible memory display context
    mDC = CreateCompatibleDC(SnapForm.hDC)
    hBM = CreateCompatibleBitmap(SnapForm.hDC, XSize, YSize)
    OldObject = SelectObject(mDC, hBM)
        
    'Copy the screen to the display context
    R = BitBlt(mDC, 0, 0, XSize, YSize, sDC, 0, 0, SRCCOPY)
    
    'Lose the screen display context
    R = DeleteDC(sDC)
    
    SnapForm.Show

End Sub

Sub zIndentControl (P As Control, C As Control)

    P.CurrentX = C.Left - 1
    P.CurrentY = C.Top + C.Height
    P.Line -Step(0, -C.Height - 1), RGB(128, 128, 128)
    P.Line -Step(C.Width + 1, 0), RGB(128, 128, 128)
    P.Line -Step(0, C.Height + 1), RGB(255, 255, 255)
    P.Line -Step(-C.Width - 1, 0), RGB(255, 255, 255)

End Sub

