' ! This is a Visual Basic BAS-file !                     '
' ******************************************************* '
' *          Please download VB_3D.EXE first.           * '
' *     This file is a revision of prior versions.      * '
' *     This module does ONLY contain the revised       * '
' *     parts of code - please pass to EASY3D.BAS.      * '
' ******************************************************* '
'                                                         '
' Now there are MANY 3D routines available for VB.        '
' This one is according to VB_3D.EXE by CIS:100540,2644   '
' which was according to VB3D.ZIP by CIS:100265,1725.     '
'                                                         '
'                                                         '
'                        + + +                            '
'                                                         '
' Feel free to use any part of code from this module.     '
'                                                         '
' Code by: Christian Germelmann                           '
'          35039 Marburg - Germany                        '
'          CIS:100520,2644                                '
'                                                         '

Option Explicit

Dim retInt%, retLng&, hInst%


Global CTRL3D_Registered%
Const GWW_HINSTANCE% = (-6)
Const SEM_NOOPENFILEERRORBOX& = &H8000

Declare Sub ShellAbout Lib "SHELL" Alias "#22" (ByVal hWnd%, ByVal TitelText$, ByVal DialogText$, ByVal BildhWnd%)

Declare Function GetWindowWord% Lib "USER" Alias "#133" (ByVal hWnd%, ByVal nIndex%)
Declare Function GetWindowLong& Lib "USER" Alias "#135" (ByVal hWnd%, ByVal nIndex%)
Declare Function SetWindowLong& Lib "USER" Alias "#136" (ByVal hWnd%, ByVal nIndex%, ByVal dwNewLong&)
Const GWL_STYLE& = (-16)
Const COLOR_BTNFACE& = &H8000000F
Const FIXED_DOUBLE% = 3
Const DS_MODALFRAME& = &H80&

Declare Function GetSystemMenu% Lib "USER" Alias "#156" (ByVal hWnd%, ByVal bRevert%)
Declare Function DeleteMenu% Lib "USER" Alias "#413" (ByVal hMenu%, ByVal nPosition%, ByVal wFlags%)
Const SC_SEPARATOR& = &H0
'Global Const SC_MOVE& = &HF010
Const SC_SIZE& = &HF000
'Global Const SC_MINIMIZE& = &HF020
'Global Const SC_MAXIMIZE& = &HF030
'Global Const SC_NEXTWINDOW& = &HF040
'Global Const SC_PREVWINDOW& = &HF050
Const SC_CLOSE& = &HF060
'Global Const SC_ARRANGE& = &HF110
'Global Const SC_RESTORE& = &HF120
Const SC_TASKLIST& = &HF130

Declare Function SetErrorMode% Lib "KERNEL" Alias "#107" (ByVal wMode As Integer)
Declare Function GetWindowsDirectory% Lib "KERNEL" Alias "#134" (ByVal lpBuffer$, ByVal nSize%)
Declare Function GetSystemDirectory% Lib "KERNEL" Alias "#135" (ByVal lpBuffer$, ByVal nSize%)


' ***********************************************************
' *                      Please note:                       *
' * different from prior releases the 3D.DLLs are no longer *
' *   declared as Functions but as Subs since they do not   *
' *   return any value. This shortens the code as shown.    *
' ***********************************************************

Declare Sub Ctl3dRegister Lib "CTL3D.DLL" Alias "#12" (ByVal hInst%)
Declare Sub Ctl3dUnregister Lib "CTL3D.DLL" Alias "#13" (ByVal hInst%)
Declare Sub Ctl3dAutoSubclass Lib "CTL3D.DLL" Alias "#16" (ByVal hInst%)
Declare Sub Ctl3dSubclassDlgEx Lib "CTL3D.DLL" Alias "#21" (ByVal hWnd%, ByVal Flags&)

Declare Sub Ctl3dRegisterV2 Lib "CTL3DV2.DLL" Alias "#12" (ByVal hInst%)
Declare Sub Ctl3dUnregisterV2 Lib "CTL3DV2.DLL" Alias "#13" (ByVal hInst%)
Declare Sub Ctl3dAutoSubclassV2 Lib "CTL3DV2.DLL" Alias "#16" (ByVal hInst%)
Declare Sub Ctl3dSubclassDlgExV2 Lib "CTL3DV2.DLL" Alias "#21" (ByVal hWnd%, ByVal Flags&)

' **************************************************
' * If you are puzzled by the 'Alias' just scip it *
' **************************************************

'
' Shortens the system menu...
' Put 'CutSystemMenu Me,x' into the 'Form_Load' of every Form you need it for.
' Modify with other given (see GENERAL) variables.
'
Sub CutSystemMenu (Form As Form, Menu%)

Dim hMenu%

    hMenu = GetSystemMenu(Form.hWnd, 0)
    
    If Menu And 1 Then retInt = DeleteMenu(hMenu, SC_SIZE, 0)   ' Form is unsizable...
    If Menu And 2 Then retInt = DeleteMenu(hMenu, SC_CLOSE, 0)  ' No Exit with system menu...

    retInt = DeleteMenu(hMenu, SC_TASKLIST, 0)
    
    ' And not to forget the separators...
    retInt = DeleteMenu(hMenu, SC_SEPARATOR, 0)
    If Menu And 2 Then retInt = DeleteMenu(hMenu, SC_SEPARATOR, 0)

End Sub

Sub Define3D (Form3D As Form)

' If we have 3D...
If CTRL3D_Registered = False Then Exit Sub

' ...allow only FIXED_DOUBLE borders...
If Form3D.BorderStyle <> FIXED_DOUBLE Then Exit Sub

    Form3D.BackColor = COLOR_BTNFACE
     
    ' ...alter the frame so that 3D can affect it...
    retLng = SetWindowLong(Form3D.hWnd, GWL_STYLE, GetWindowLong(Form3D.hWnd, GWL_STYLE) Or DS_MODALFRAME)
        
    ' ...select the proper 3D-DLL and '3D' this form.
    Select Case CTRL3D_Registered
        Case 1: Ctl3dSubclassDlgEx Form3D.hWnd, &H0
        Case 2: Ctl3dSubclassDlgExV2 Form3D.hWnd, &H0
    End Select

End Sub

'
' Replaces old code ! (This one is safer)
'
Function DirExists% (Path$)

' Be sure that there is no terminating backslash
If Right$(Path, 1) = "\" Then Path = Left$(Path, Len(Path) - 1)

On Error Resume Next

    ' ATTR_DIRECTORY = 16
    retInt = Len(Dir$(Path, 16))
    
    If retInt = 0 Or Err Then
            DirExists = False
        Else
            DirExists = (GetAttr(Path) And 16)
    End If

End Function

'
' Replaces old code ! (This one is safer)
'
Function FileExists% (File$)

On Error Resume Next

    ' ATTR_HIDDEN = 2; ATTR_SYSTEM = 4
    ' ATTR_HIDDEN or ATTR_SYSTEM = 6
    retInt = Len(Dir$(File, 6))
    
    If retInt = 0 Or Err Then
            FileExists = False
        Else
            FileExists = Not (GetAttr(File) And 16)
    End If

End Function

Sub Register3D ()
 
' Offer the opportunity to run this application without 3D.
' --> All programs by ChG_Tools bear this (partly) undocumented command
If InStr(1, Command$, "/NO3D", 1) Then Exit Sub

Dim oldErrorMode%

On Error Resume Next

' Windows does NOT display an error message box now
' when it fails to find one of the following files.
oldErrorMode = SetErrorMode(SEM_NOOPENFILEERRORBOX)
    
    'Get the instance handle of the module that owns the window.
    hInst = GetWindowWord(Forms(0).hWnd, GWW_HINSTANCE)
    
        ' Register CTL3D.DLL...
        Ctl3dRegister hInst

    ' ...and if no error occured...
    If Err = 0 Then
            ' ...make it perfect.
            Ctl3dAutoSubclass hInst
            CTRL3D_Registered = 1
        Else
            ' In case we had an error (CTL3D.DLL not found)...
            Err = False
                
                ' ,,,register CTL3DV2.DLL...
                Ctl3dRegisterV2 hInst
            
            ' ...and if no error occured now...
            If Err = 0 Then
                    ' ...make it perfect with this one.
                    Ctl3dAutoSubclassV2 hInst
                    CTRL3D_Registered = 2
            End If
    End If

' Reset the ErrorMode (just to tidy up).
oldErrorMode = SetErrorMode(oldErrorMode)

End Sub

'
' Correct use of the original Windows AboutBox...
'
' And you MUST try again this here:
' Open the box, hold down Shift+Ctrl and doubleclick the Logo, then close the box.
' And play it again... as often as you like ! (...and wonder why...)
' --> To see the original Windows-bitmap exchange 'Icon' against '0&'.
'
Sub ShowAboutBox (Form As Form)

    ShellAbout Form.hWnd, "MyApp", "1st Author's Line" + Chr$(10) + "2nd Author's Line", Form.Icon

End Sub

'
' Not needed in this application.
' Whereever you need the SYSTEM-directory use the 'SysDir()' command.
'
Function SysDir$ ()

Dim GetSysDir$

    GetSysDir = Space(144) ' or 144<
    retInt = GetSystemDirectory(GetSysDir, 144)
    GetSysDir = Left$(GetSysDir, retInt)

SysDir = Backslash(GetSysDir)

End Function

Sub Unregister3D ()

' If we have 3D...
If CTRL3D_Registered = False Then Exit Sub
         
        '...get the instance handle of the module again that owns the window...
        hInst = GetWindowWord(Forms(0).hWnd, GWW_HINSTANCE)
    
        ' ...select the proper 3D-DLL and unregister.
        Select Case CTRL3D_Registered
            Case 1: Ctl3dUnregister hInst
            Case 2: Ctl3dUnregisterV2 hInst
        End Select
        
' >>(Only needed if you swith 3D on and off at runtime)
'    CTRL3D_Registered = False

End Sub

'
' Not needed in this application.
' Whereever you need the WINDOWS-directory use the 'WinDir()' command.
''
Function WinDir$ ()

Dim GetWinDir$

    GetWinDir = Space(144) ' or 144<
    retInt = GetWindowsDirectory(GetWinDir, 144)
    GetWinDir = Left$(GetWinDir, retInt)

WinDir = Backslash(GetWinDir)

End Function

