VERSION 2.00
Begin Form ComboSample 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "The Readonly Combo Sample"
   ClientHeight    =   2250
   ClientLeft      =   1095
   ClientTop       =   1485
   ClientWidth     =   3720
   Height          =   2655
   Icon            =   COMBO.FRX:0000
   Left            =   1035
   MaxButton       =   0   'False
   ScaleHeight     =   2250
   ScaleWidth      =   3720
   Top             =   1140
   Width           =   3840
   Begin ComboBox Combo2 
      Height          =   1350
      Left            =   540
      Style           =   1  'Simple Combo
      TabIndex        =   1
      Text            =   "Combo2"
      Top             =   720
      Width           =   2655
   End
   Begin ComboBox Combo1 
      BackColor       =   &H00FFFFFF&
      Height          =   315
      Left            =   540
      TabIndex        =   0
      Text            =   "Combo1"
      Top             =   240
      Width           =   2655
   End
End
Option Explicit

'                                                         '
' This sample code demonstrates how to make the text box  '
' of a combo readonly. Unfortunately this option is       '
' missing in the property list of a combo box.            '
'                                                         '
' The SetComboReadOnly sub distinguishes dropdown and     '
' simple combos. The drop down list uses a static control '
' instead of an edit control and cannot be edited anyway. '
'                                                         '
' This is just one example out of many on how to add 'new''
' features to controls under Visual Basic.                '
'                                                         '
' Please address your feedback/questions to:              '
'     Christian Germelmann                                '
'     Promenade 58                                        '
'     37431 Bad Lauterberg                                '
'     Germany                                             '
'     CIS: 100520,2644                                    '
'     AOL: ChGTools                                       '
'     http://ourworld.compuserve.com/homepages/Germelmann '
'                                                         '

Dim retLng&

Const GW_CHILD = 5
Const GW_HWNDNEXT = 2

Const GWL_STYLE = -16
Const CBS_SIMPLE = 1

Const WM_USER = &H400
Const EM_SETREADONLY = WM_USER + 31

Declare Function GetWindow% Lib "USER" Alias "#262" (ByVal hWnd%, ByVal wCmd%)
Declare Function GetWindowLong& Lib "USER" Alias "#135" (ByVal hWnd%, ByVal nIndex%)
Declare Function SendMessage& Lib "USER" Alias "#111" (ByVal hWnd%, ByVal wMsg%, ByVal wParam%, lParam As Any)

Private Sub Form_Load ()

    SetComboReadOnly Combo1
    SetComboReadOnly Combo2

    Combo1.AddItem "Combo1 - TestItem#1"
    Combo1.AddItem "Combo1 - TestItem#2"
    Combo1.AddItem "Combo1 - TestItem#3"

    Combo2.AddItem "Combo2 - TestItem#1"
    Combo2.AddItem "Combo2 - TestItem#2"
    Combo2.AddItem "Combo2 - TestItem#3"

End Sub

Private Sub SetComboReadOnly (C As ComboBox)

Dim EditHwnd%

    ' get the first child of a dropdown combo
    EditHwnd = GetWindow(C.hWnd, GW_CHILD)
    
    ' check whether we have a simple combo, if yes get the second child
    If GetWindowLong(C.hWnd, GWL_STYLE) And CBS_SIMPLE Then EditHwnd = GetWindow(EditHwnd, GW_HWNDNEXT)
    
    ' handle the combo's child like a usual edit control
    retLng = SendMessage(EditHwnd, EM_SETREADONLY, 1, 0&)

    ' that's all...

End Sub

