VERSION 5.00
Begin VB.Form ComboSample 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "The Readonly Combo Sample"
   ClientHeight    =   2250
   ClientLeft      =   1095
   ClientTop       =   1485
   ClientWidth     =   3720
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Icon            =   "COMBO.frx":0000
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   2250
   ScaleWidth      =   3720
   Begin VB.ComboBox Combo2 
      Height          =   1350
      Left            =   540
      Style           =   1  'Simple Combo
      TabIndex        =   1
      Text            =   "Combo2"
      Top             =   720
      Width           =   2655
   End
   Begin VB.ComboBox Combo1 
      BackColor       =   &H00FFFFFF&
      Height          =   315
      Left            =   540
      TabIndex        =   0
      Text            =   "Combo1"
      Top             =   240
      Width           =   2655
   End
End
Attribute VB_Name = "ComboSample"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'                                                         '
' This sample code demonstrates how to make the text box  '
' of a combo readonly. Unfortunately this option is       '
' missing in the property list of a combo box.            '
'                                                         '
' The SetComboReadOnly sub distinguishes dropdown and     '
' simple combos. The drop down list uses a static control '
' instead of an edit control and cannot be edited anyway. '
'                                                         '
' This is just one example out of many on how to add 'new''
' features to controls under Visual Basic.                '
'                                                         '
' Please address your feedback/questions to:              '
'     Christian Germelmann                                '
'     Promenade 58                                        '
'     37431 Bad Lauterberg                                '
'     Germany                                             '
'     CIS: 100520,2644                                    '
'     AOL: ChGTools                                       '
'     http://ourworld.compuserve.com/homepages/Germelmann '
'                                                         '

Dim retLng&

Const GW_CHILD = 5
Const GW_HWNDNEXT = 2

Const GWL_STYLE = -16
Const CBS_SIMPLE = 1

Const WM_USER = &H400
Const EM_SETREADONLY = WM_USER + 31

Private Declare Function GetWindow& Lib "user32" Alias "#299" (ByVal hWnd&, ByVal wCmd%)
Private Declare Function GetWindowLong& Lib "user32" Alias "#302" (ByVal hWnd&, ByVal nIndex%)
Private Declare Function SendMessage& Lib "user32" Alias "#449" (ByVal hWnd&, ByVal wMsg&, ByVal wParam&, lParam As Any)

Private Sub Form_Load()

    SetComboReadOnly Combo1
    SetComboReadOnly Combo2

    Combo1.AddItem "Combo1 - TestItem#1"
    Combo1.AddItem "Combo1 - TestItem#2"
    Combo1.AddItem "Combo1 - TestItem#3"

    Combo2.AddItem "Combo2 - TestItem#1"
    Combo2.AddItem "Combo2 - TestItem#2"
    Combo2.AddItem "Combo2 - TestItem#3"

End Sub

Private Sub SetComboReadOnly(C As ComboBox)

Dim EditHwnd&

    ' get the first child of a dropdown combo
    EditHwnd = GetWindow(C.hWnd, GW_CHILD)
    
    ' check whether we have a simple combo, if yes get the second child
    If GetWindowLong(C.hWnd, GWL_STYLE) And CBS_SIMPLE Then EditHwnd = GetWindow(EditHwnd, GW_HWNDNEXT)
    
    ' handle the combo's child like a usual edit control
    retLng = SendMessage(EditHwnd, EM_SETREADONLY, 1, 0&)

    ' that's all...

End Sub

