'==============================================================================
'
'  VBSORT Example - Sort 32-bit Visual Basic arrays
'  Copyright (c) 1997 by PowerBASIC, Inc.  All Rights Reserved.
'
'  Note:  When receiving the Pointer to a Safe Array (PSA) from Visual Basic,
'         you must receive it as a DWORD by reference.  When passing it to the
'         OLE API, you pass it BYVAL.
'
'==============================================================================

$COMPILE DLL
$INCLUDE "VBAPI32.INC"


'------------------------------------------------------------------------------
' SortString - Sort a single-dimension VB string array
'
SUB SortString ALIAS "SortString" (psa AS DWORD) EXPORT

  LOCAL l  AS LONG
  LOCAL u  AS LONG
  LOCAL vb AS DWORD

  l  = vbArrayLBound(psa, 1)
  u  = vbArrayUBound(psa, 1)
  vb = vbArrayFirstElem(psa)

  DIM vba(l to u) AS STRING AT vb

  ARRAY SORT vba()

END SUB


'------------------------------------------------------------------------------
' SortInt - Sort a single-dimension VB integer array
'
SUB SortInt ALIAS "SortInt" (psa AS DWORD) EXPORT

  LOCAL l  AS LONG
  LOCAL u  AS LONG
  LOCAL vb AS DWORD

  l  = vbArrayLBound(psa, 1)
  u  = vbArrayUBound(psa, 1)
  vb = vbArrayFirstElem(psa)

  DIM vba(l to u) AS INTEGER AT vb

  ARRAY SORT vba()

END SUB


'------------------------------------------------------------------------------
' SortLong - Sort a single-dimension VB long integer array
'
SUB SortLong ALIAS "SortLong" (psa AS DWORD) EXPORT

  LOCAL l  AS LONG
  LOCAL u  AS LONG
  LOCAL vb AS DWORD

  l  = vbArrayLBound(psa, 1)
  u  = vbArrayUBound(psa, 1)
  vb = vbArrayFirstElem(psa)

  DIM vba(l to u) AS LONG AT vb

  ARRAY SORT vba()

END SUB


'------------------------------------------------------------------------------
' SortSingle - Sort a single-dimension VB single-precision array
'
SUB SortSingle ALIAS "SortSingle" (psa AS DWORD) EXPORT

  LOCAL l  AS LONG
  LOCAL u  AS LONG
  LOCAL vb AS DWORD

  l  = vbArrayLBound(psa, 1)
  u  = vbArrayUBound(psa, 1)
  vb = vbArrayFirstElem(psa)

  DIM vba(l to u) AS SINGLE AT vb

  ARRAY SORT vba()

END SUB


'------------------------------------------------------------------------------
' SortDouble - Sort a single-dimension VB double-precision array
'
SUB SortDouble ALIAS "SortDouble" (psa AS DWORD) EXPORT

  LOCAL l  AS LONG
  LOCAL u  AS LONG
  LOCAL vb AS DWORD

  l  = vbArrayLBound(psa, 1)
  u  = vbArrayUBound(psa, 1)
  vb = vbArrayFirstElem(psa)

  DIM vba(l to u) AS DOUBLE AT vb

  ARRAY SORT vba()

END SUB


'------------------------------------------------------------------------------
' SortCurrency - Sort a single-dimension VB double-precision array
'
SUB SortCurrency ALIAS "SortCurrency" (psa AS DWORD) EXPORT

  LOCAL l  AS LONG
  LOCAL u  AS LONG
  LOCAL vb AS DWORD

  l  = vbArrayLBound(psa, 1)
  u  = vbArrayUBound(psa, 1)
  vb = vbArrayFirstElem(psa)

  DIM vba(l to u) AS CURRENCY AT vb

  ARRAY SORT vba()

END SUB
