VERSION 4.00
Begin VB.Form frmMain 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Address Book"
   ClientHeight    =   4815
   ClientLeft      =   2565
   ClientTop       =   1950
   ClientWidth     =   7605
   ClipControls    =   0   'False
   Height          =   5505
   Icon            =   "abook.frx":0000
   Left            =   2505
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4815
   ScaleWidth      =   7605
   ShowInTaskbar   =   0   'False
   Top             =   1320
   Width           =   7725
   Begin VB.CommandButton btnSave 
      Caption         =   "&Save"
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   300
      Left            =   6675
      TabIndex        =   34
      Top             =   3225
      Width           =   690
   End
   Begin VB.CheckBox Check1 
      Alignment       =   1  'Right Justify
      Caption         =   "Send Card"
      DataField       =   "SendCard"
      DataSource      =   "dtaAddress"
      Height          =   240
      Left            =   4170
      TabIndex        =   30
      Top             =   3225
      Width           =   1125
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "Notes"
      DataSource      =   "dtaAddress"
      Height          =   1065
      Index           =   16
      Left            =   1350
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   28
      Top             =   3675
      Width           =   6090
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "Birthdate"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   14
      Left            =   5100
      TabIndex        =   26
      Top             =   2775
      Width           =   2280
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "FaxNumber"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   13
      Left            =   5100
      TabIndex        =   24
      Top             =   2400
      Width           =   2280
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "WorkExtension"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   12
      Left            =   5100
      TabIndex        =   22
      Top             =   2025
      Width           =   2280
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "WorkPhone"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   11
      Left            =   5100
      TabIndex        =   20
      Top             =   1650
      Width           =   2280
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "HomePhone"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   10
      Left            =   5100
      TabIndex        =   18
      Top             =   1275
      Width           =   2280
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "EmailAddress"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   9
      Left            =   5100
      TabIndex        =   16
      Top             =   900
      Width           =   2280
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "Country"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   8
      Left            =   5100
      TabIndex        =   14
      Top             =   525
      Width           =   2280
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "PostalCode"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   7
      Left            =   1350
      TabIndex        =   12
      Top             =   3150
      Width           =   2200
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "StateOrProvince"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   6
      Left            =   1350
      TabIndex        =   10
      Top             =   2775
      Width           =   2200
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "City"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   5
      Left            =   1350
      TabIndex        =   9
      Top             =   2400
      Width           =   2200
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "Address"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   4
      Left            =   1350
      TabIndex        =   7
      Top             =   2025
      Width           =   2200
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "Company"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   3
      Left            =   1350
      TabIndex        =   5
      Top             =   1650
      Width           =   2200
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "LastName"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   2
      Left            =   1350
      TabIndex        =   3
      Top             =   1275
      Width           =   2200
   End
   Begin VB.TextBox txtAddress 
      DataField       =   "FirstName"
      DataSource      =   "dtaAddress"
      Height          =   315
      Index           =   1
      Left            =   1350
      TabIndex        =   1
      Top             =   900
      Width           =   2200
   End
   Begin VB.Data dtaAddress 
      BOFAction       =   1  'BOF
      Caption         =   "Addresses"
      Connect         =   "Access"
      DatabaseName    =   "abook.mdb"
      EOFAction       =   1  'EOF
      Exclusive       =   0   'False
      BeginProperty Font 
         name            =   "MS Sans Serif"
         charset         =   0
         weight          =   700
         size            =   8.25
         underline       =   0   'False
         italic          =   0   'False
         strikethrough   =   0   'False
      EndProperty
      Height          =   315
      Left            =   1350
      Options         =   0
      ReadOnly        =   0   'False
      RecordsetType   =   1  'Dynaset
      RecordSource    =   "Select * from Addresses Order by LastName, FirstName"
      Top             =   75
      Width           =   2220
   End
   Begin VB.Label lblAddrId 
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   1  'Fixed Single
      DataField       =   "AddressID"
      DataSource      =   "dtaAddress"
      Height          =   315
      Left            =   1350
      TabIndex        =   33
      Top             =   525
      Width           =   2200
   End
   Begin VB.Label lblStatus 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Ready"
      Height          =   315
      Left            =   3750
      TabIndex        =   32
      Top             =   75
      Width           =   3615
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "City:"
      Height          =   195
      Index           =   5
      Left            =   945
      TabIndex        =   31
      Top             =   2475
      Width           =   300
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Notes:"
      Height          =   195
      Index           =   16
      Left            =   780
      TabIndex        =   29
      Top             =   3750
      Width           =   465
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Birthday:"
      Height          =   195
      Index           =   14
      Left            =   4410
      TabIndex        =   27
      Top             =   2850
      Width           =   615
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "FAX Number:"
      Height          =   195
      Index           =   13
      Left            =   4080
      TabIndex        =   25
      Top             =   2475
      Width           =   945
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Work Extension:"
      Height          =   195
      Index           =   12
      Left            =   3855
      TabIndex        =   23
      Top             =   2100
      Width           =   1170
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Work Phone:"
      Height          =   195
      Index           =   11
      Left            =   4080
      TabIndex        =   21
      Top             =   1725
      Width           =   945
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Home Phone:"
      Height          =   195
      Index           =   10
      Left            =   4050
      TabIndex        =   19
      Top             =   1350
      Width           =   975
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "E-Mail Address:"
      Height          =   195
      Index           =   9
      Left            =   3930
      TabIndex        =   17
      Top             =   975
      Width           =   1095
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Country:"
      Height          =   195
      Index           =   8
      Left            =   4440
      TabIndex        =   15
      Top             =   600
      Width           =   585
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Postal Code:"
      Height          =   195
      Index           =   7
      Left            =   345
      TabIndex        =   13
      Top             =   3225
      Width           =   900
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "State:"
      Height          =   195
      Index           =   6
      Left            =   825
      TabIndex        =   11
      Top             =   2850
      Width           =   420
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Address:"
      Height          =   195
      Index           =   4
      Left            =   630
      TabIndex        =   8
      Top             =   2100
      Width           =   615
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Company:"
      Height          =   195
      Index           =   3
      Left            =   540
      TabIndex        =   6
      Top             =   1725
      Width           =   705
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Last Name:"
      Height          =   195
      Index           =   2
      Left            =   435
      TabIndex        =   4
      Top             =   1350
      Width           =   810
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "First Name:"
      Height          =   195
      Index           =   1
      Left            =   450
      TabIndex        =   2
      Top             =   975
      Width           =   795
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Address ID:"
      Height          =   195
      Index           =   0
      Left            =   420
      TabIndex        =   0
      Top             =   600
      Width           =   825
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileSave 
         Caption         =   "&Save Record"
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuFileSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuEdit 
      Caption         =   "&Edit"
      Begin VB.Menu mnuEditSub 
         Caption         =   "Copy &Address to Clipboard"
         Index           =   0
      End
      Begin VB.Menu mnuEditSub 
         Caption         =   "Copy Name && E-mail ID to Clipboard"
         Index           =   1
      End
   End
   Begin VB.Menu mnuRecord 
      Caption         =   "&Record"
      Begin VB.Menu mnuRecSub 
         Caption         =   "&Add"
         Index           =   0
         Shortcut        =   ^A
      End
      Begin VB.Menu mnuRecSub 
         Caption         =   "&Delete"
         Index           =   1
         Shortcut        =   ^D
      End
      Begin VB.Menu mnuRecSub 
         Caption         =   "-"
         Index           =   2
      End
      Begin VB.Menu mnuRecSub 
         Caption         =   "&First Record"
         Index           =   3
         Shortcut        =   {F6}
      End
      Begin VB.Menu mnuRecSub 
         Caption         =   "&Previous Record"
         Index           =   4
         Shortcut        =   {F7}
      End
      Begin VB.Menu mnuRecSub 
         Caption         =   "&Next Record"
         Index           =   5
         Shortcut        =   {F8}
      End
      Begin VB.Menu mnuRecSub 
         Caption         =   "&Last Record"
         Index           =   6
         Shortcut        =   {F9}
      End
   End
   Begin VB.Menu mnuLook 
      Caption         =   "&Lookup"
      Begin VB.Menu mnuLookSub 
         Caption         =   "by &Last Name"
         Index           =   0
      End
      Begin VB.Menu mnuLookSub 
         Caption         =   "by &First Name"
         Index           =   1
      End
      Begin VB.Menu mnuLookSub 
         Caption         =   "by C&ompany"
         Index           =   2
      End
      Begin VB.Menu mnuLookSub 
         Caption         =   "by &City"
         Index           =   3
      End
      Begin VB.Menu mnuLookSub 
         Caption         =   "by &State"
         Index           =   4
      End
      Begin VB.Menu mnuLookSub 
         Caption         =   "-"
         Index           =   5
      End
      Begin VB.Menu mnuLookSub 
         Caption         =   "from L&ist..."
         Index           =   6
         Shortcut        =   ^L
      End
      Begin VB.Menu mnuLookSub 
         Caption         =   "-"
         Index           =   7
      End
      Begin VB.Menu mnuLookSub 
         Caption         =   "&ALL Records"
         Index           =   8
         Shortcut        =   {F12}
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpSub 
         Caption         =   "&About..."
         Index           =   0
         Shortcut        =   {F1}
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit


Private Sub Command1_Click()
    
End Sub

Private Sub btnSave_Click()
    'when the user clicks the save button, call
    'File|Save. (To jump to this procedure, select 'mnufilesave_click' and press Shift+F2.)
    mnuFileSave_Click
End Sub


Private Sub dtaAddress_Reposition()
    'This code executes everytime we are repositioned to a new record.
    'This is a good place to set up the form to reflect the current
    'operational status.
    
    'For example, if you're creating a new record, the form needs to be
    'configured differently than if you had just landed on an existing record.
    'The goal here is to configure the Record navigation items to match the
    'buttons on the Data control itself.

    Dim X As Integer, NewRec As Integer
    
    If dtaAddress.EditMode = 2 Then  ' You're editing a new record.
        Stat "Editing NEW Record"
        mnuFileSave.Enabled = True
        'disable add, delete menu items
        For X = 0 To 1: mnuRecSub(X).Enabled = False: Next X
        
    Else ' you landed on an existing record.
        mnuFileSave.Enabled = False
        'enable add, delete menu items
        For X = 0 To 1: mnuRecSub(X).Enabled = True: Next X
        Stat "Ready"
    End If
    btnSave.Enabled = mnuFileSave.Enabled
    
    'enable/disable record navigation functions
    'depending on where you are in the recordset
    
    If dtaAddress.Recordset.BOF Then 'you're BEFORE the first record
        Beep
        mnuRecSub(4).Enabled = False ' disable 'previous' record
        Stat "FIRST record."
    ElseIf dtaAddress.Recordset.EOF Then ' you're AFTER the last record!
        Beep
        mnuRecSub(5).Enabled = False  ' disable 'next' record
        Stat "LAST record."
    Else
        For X = 3 To 6: mnuRecSub(X).Enabled = True: Next X 'enable 'em all
    End If
   
End Sub
Private Sub dtaAddress_Validate(Action As Integer, Save As Integer)
    'validate all data in this record before moving on...
    Dim X As Integer
    For X = 0 To Me.Controls.Count - 1
        
        'only validate controls which are textboxes
        If TypeOf Me.Controls(X) Is TextBox Then
            
            Select Case Me.Controls(X).Index
                Case 0, 1, 2, 5
                    ' check to ensure all required fields are filled in, i.e. not empty if its data has been changed...
                    If Me.Controls(X).Text = "" And Me.Controls(X).DataChanged Then
                        MsgBox "Data Missing in field '" & lblAddress(Me.Controls(X).Index) & "'", vbExclamation
                        Action = vbDataActionCancel
                        Exit Sub
                    End If
                
                Case 10, 11, 13 ' check format of phone numbers
                    If txtAddress(8) = "USA" Then ' only check the format of USA phone numbers
                        If Not Me.Controls(X).Text Like ("(###) ###-####") And _
                         Me.Controls(X).Text <> "" Then ' phone doesn't match USA format
                            If MsgBox("Unknown Phone Number format in " & lblAddress(Me.Controls(X).Index) & " field.  " _
                             & Me.Controls(X).Text & " does not appear to be a U.S. phone number. Is this correct?", _
                                vbQuestion & vbYesNo) = vbNo Then
                                Action = vbDataActionCancel ' this is the line of code which cancels the move to the next record.
                                Exit Sub
                            End If
                        End If
                    End If
                End Select
        End If
    Next X

End Sub



Private Sub Form_Load()
'This event procedure simply centers the form
'and sets the background color of lblAddrID to
'match the current textbox color for this system.
'This makes the label look like a read-only text box.
    
    Center Me
    lblAddrId.BackColor = txtAddress(1).BackColor
End Sub


Private Sub Form_Unload(Cancel As Integer)
    End
End Sub


Private Sub mnuEditSub_Click(Index As Integer)
'The Edit menu gives you two functions - copy the address to
'the clipboard or copy the name and email address. This uses
'the ClipBoard.SetText method.

    Dim t As String
    
    Select Case Index
        Case 0 ' copy address to clipboard
            t = Trim$(txtAddress(1)) & " " & Trim(txtAddress(2)) & vbCrLf
            t = t & Trim$(txtAddress(4)) & vbCrLf
            t = t & Trim$(txtAddress(5)) & ", " & Trim(txtAddress(6)) & " " & Trim(txtAddress(7))
 
        Case 1 ' copy name, email ID to clipboard
            t = Trim(txtAddress(1)) & " " & Trim(txtAddress(2)) & ", " & Trim(txtAddress(9))
    End Select
    
    Clipboard.SetText t
    Stat "Data Copied to Clipboard."
    
End Sub

Private Sub mnuFileExit_Click()
    End
End Sub

Private Sub mnuFileSave_Click()
'When the user clicks "Save" from the "File" menu we use
'the UpdateRecord method of the data control to save the data.
    dtaAddress.UpdateRecord
    Stat "Record Saved"
End Sub

Private Sub mnuHelpSub_Click(Index As Integer)
    frmHelp.Show vbModal
End Sub

Private Sub mnuLookSub_Click(Index As Integer)
'When the user clicks an entry from the "Lookup" menu, anything can happen! <g>
'If the Index is less than 5 that means the user is looking for data by a specific
'database field. This sub gets the field name from the menu and asks the user
'what value to search for. It then creates an SQL query which searches for any
'matching records.

'If the user clicks the sixth item on the menu a form pops up with a grid displaying
'every record in the current Data Control RecordSet. Once the user chooses a record
'it is displayed in the main form.

'Lastly, if the user selects the last item in the list the data control re-fetches
'ALL records in the database.
    
    Dim Prompt As String, Title As String, Default As String, l As Integer
    Dim Sought As String, Field As String, SQL As String
        
    Dim MyCriteria As String
    
    Select Case Index
    Case Is < 5 'look up by something...
        'get the prompt and caption for the InputBox
        'by getting text from the menu caption
        
        Prompt = Mid$(mnuLookSub(Index).Caption, 4) 'strip out leading "by "
        
        'find and strip the ampersand (&)
        l = InStr(Prompt, "&")
        If l <> 0 Then Prompt = Left$(Prompt, l - 1) & Mid$(Prompt, l + 1)

        Title = "Search by " & Prompt
        Prompt = "Enter all or part of the " & Prompt & " to search for:"
        Default = ""
        Sought = InputBox(Prompt, Title, Default)
        If Sought = "" Then Exit Sub ' user canceled ------------->
        
        'if you get this far, the user entered search criteria...
        Select Case Index
            Case 0: Field = "Lastname"
            Case 1: Field = "Firstname"
            Case 2: Field = "Company"
            Case 3: Field = "City"
            Case 4: Field = "State"
            'ignore case 5, which can't happen
        End Select
        
        'Create the Structured Query Language (SQL) statement which will
        'be used to query the database
        SQL = "Select * from Addresses where " & Field & " LIKE '" & Sought & "*'"
        Debug.Print SQL
        
        dtaAddress.RecordSource = SQL
        dtaAddress.Refresh
        
    Case 5 ' menu separator - can't happen
    Case 6 ' lookup by list
        Load frmList
        frmList.dtaHidden.DatabaseName = dtaAddress.DatabaseName
        frmList.dtaHidden.RecordSource = dtaAddress.RecordSource
        frmList.dtaHidden.Refresh
        frmList.Caption = "Lookup List: " & dtaAddress.RecordSource
        frmList.Show vbModal
        
    Case 7 ' menu separator - can't happen
    Case 8 ' lookup all records
        SQL = "Select * from Addresses Order by LastName, FirstName"
        dtaAddress.RecordSource = SQL
        dtaAddress.Refresh
    End Select
    
End Sub



Private Sub mnuRecSub_Click(Index As Integer)

'These menu items let the user navigate through
'records manually. In most cases this simply involves
'invoking various methods of the Data Control.
    
    Select Case Index
        Case 0 'add
            dtaAddress.Recordset.AddNew
            txtAddress(1).SetFocus
            Stat "Editing NEW Record"
        
        Case 1 ' delete
            If MsgBox("Delete this Record?", vbQuestion + vbYesNo) = vbYes Then dtaAddress.Recordset.Delete
            dtaAddress.Recordset.MovePrevious
        
        Case 3 ' first
            dtaAddress.Recordset.MoveFirst
        
        Case 4 ' previous
            dtaAddress.Recordset.MovePrevious
            If dtaAddress.Recordset.BOF Then
                Beep
                dtaAddress.Recordset.MoveFirst
            End If
        
        Case 5 ' next
            dtaAddress.Recordset.MoveNext
            If dtaAddress.Recordset.EOF Then
                Beep
                dtaAddress.Recordset.MoveLast
            End If
        Case 6 ' last
            dtaAddress.Recordset.MoveLast
    End Select

End Sub


Private Sub txtAddress_Change(Index As Integer)
'The txtAddress text boxes are members of a control array. Thus, if *any*
'one textbox changes, the record has been changed. This makes sure the
'"Save" button and the "Save" item in the '"File" menu are enabled.

    mnuFileSave.Enabled = True
    btnSave.Enabled = True
End Sub

Private Sub txtAddress_GotFocus(Index As Integer)
'Whenever any textbox in the txtAddress control array receives the focus,
'select all text in the textbox. This is a great example of how control
'arrays can reduce the amount of code you need to write.

    Sel txtAddress(Index) ' select all text in this control
    Stat "Editing " & lblAddress(Index)
    
End Sub


Private Sub txtAddress_LostFocus(Index As Integer)
    Dim Temp As String
    If Index = 10 Or Index = 11 Or Index = 13 Then 'format the phone number
        If txtAddress(8) = "USA" And txtAddress(Index).Text Like "##########" Then
            ' you have a USA phone number with no formatting. Format it.
            Temp = "(" & Left$(txtAddress(Index), 3) & ") "
            Temp = Temp & Mid$(txtAddress(Index), 4, 3) & "-"
            Temp = Temp & Mid$(txtAddress(Index), 7)
            txtAddress(Index) = Temp
        End If
    End If
    
    
    'Whenever a textbox loses focus, we reset the status panel to 'Ready.'
    Stat "Ready"
End Sub


