VERSION 4.00
Begin VB.Form Form1 
   Appearance      =   0  'Flat
   BackColor       =   &H00C0C0C0&
   Caption         =   "Mini MDI - Metafile Viewer"
   ClientHeight    =   5070
   ClientLeft      =   2520
   ClientTop       =   2715
   ClientWidth     =   7455
   BeginProperty Font 
      name            =   "MS Sans Serif"
      charset         =   1
      weight          =   700
      size            =   8.25
      underline       =   0   'False
      italic          =   0   'False
      strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Height          =   5760
   Icon            =   "STYLE.frx":0000
   Left            =   2460
   LinkTopic       =   "Form1"
   ScaleHeight     =   338
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   497
   Top             =   2085
   Width           =   7575
   Begin VB.PictureBox Pix 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   1980
      Index           =   0
      Left            =   3675
      ScaleHeight     =   130
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   108
      TabIndex        =   0
      Top             =   1515
      Width           =   1650
   End
   Begin Threed.SSPanel pnlSplit 
      Height          =   4185
      Left            =   2835
      TabIndex        =   1
      Top             =   90
      Width           =   90
      _version        =   65536
      _extentx        =   159
      _extenty        =   7382
      _stockprops     =   15
      backcolor       =   -2147483633
      bevelwidth      =   2
      borderwidth     =   0
      roundedcorners  =   0   'False
      mousepointer    =   9
   End
   Begin Threed.SSPanel pnlTitle 
      Height          =   435
      Left            =   2970
      TabIndex        =   8
      Top             =   75
      Width           =   3585
      _version        =   65536
      _extentx        =   6324
      _extenty        =   767
      _stockprops     =   15
      backcolor       =   -2147483633
      borderwidth     =   0
      roundedcorners  =   0   'False
      autosize        =   3
   End
   Begin Threed.SSPanel pnlFrame 
      Height          =   345
      Index           =   2
      Left            =   105
      TabIndex        =   6
      Top             =   780
      Width           =   2625
      _version        =   65536
      _extentx        =   4630
      _extenty        =   609
      _stockprops     =   15
      backcolor       =   -2147483633
      borderwidth     =   0
      bevelouter      =   1
      roundedcorners  =   0   'False
      autosize        =   3
      Begin VB.DriveListBox drvList 
         Appearance      =   0  'Flat
         Height          =   315
         Left            =   15
         TabIndex        =   7
         Top             =   15
         Width           =   2595
      End
   End
   Begin Threed.SSPanel pnlFrame 
      Height          =   1185
      Index           =   1
      Left            =   105
      TabIndex        =   4
      Top             =   1230
      Width           =   2625
      _version        =   65536
      _extentx        =   4630
      _extenty        =   2090
      _stockprops     =   15
      backcolor       =   -2147483633
      borderwidth     =   0
      bevelouter      =   1
      roundedcorners  =   0   'False
      autosize        =   3
      Begin VB.DirListBox dirList 
         Appearance      =   0  'Flat
         Height          =   1155
         Left            =   15
         TabIndex        =   5
         Top             =   15
         Width           =   2595
      End
   End
   Begin Threed.SSPanel pnlFrame 
      Height          =   1230
      Index           =   0
      Left            =   105
      TabIndex        =   2
      Top             =   2535
      Width           =   2625
      _version        =   65536
      _extentx        =   4630
      _extenty        =   2170
      _stockprops     =   15
      backcolor       =   -2147483633
      borderwidth     =   0
      bevelouter      =   1
      roundedcorners  =   0   'False
      autosize        =   3
      Begin VB.FileListBox fileList 
         Appearance      =   0  'Flat
         Height          =   1200
         Left            =   15
         Pattern         =   "*.wmf"
         TabIndex        =   3
         Top             =   15
         Width           =   2595
      End
   End
   Begin VB.Label Label1 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BackStyle       =   0  'Transparent
      Caption         =   "File Spec: *.WMF"
      ForeColor       =   &H80000008&
      Height          =   210
      Left            =   120
      TabIndex        =   9
      Top             =   495
      Width           =   2205
   End
   Begin VB.Menu mnuWindowH 
      Caption         =   "&Window"
      WindowList      =   -1  'True
      Begin VB.Menu mnuWindow 
         Caption         =   "&Snap Off Image (or Double-Click)"
         Enabled         =   0   'False
         Index           =   0
      End
      Begin VB.Menu mnuWindow 
         Caption         =   "&Cascade"
         Index           =   1
      End
      Begin VB.Menu mnuWindow 
         Caption         =   "Tile &Vertically"
         Index           =   2
      End
      Begin VB.Menu mnuWindow 
         Caption         =   "Tile &Horizontally"
         Index           =   3
      End
      Begin VB.Menu mnuWindow 
         Caption         =   "&Arrange Icons"
         Index           =   4
      End
      Begin VB.Menu mnuWindow 
         Caption         =   "Hide All Snap &Offs"
         Index           =   5
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Const STATE_NORMAL = 0
Const STATE_FLOAT = 1
Dim xPictureName(10) As String
Dim iPixStyleOld(10) As Long, iPixStyle(10) As Long, iPixState(10) As Integer
Dim iPixIndex As Integer

Private Sub dirList_Change()

    fileList.Path = dirList.Path ' When the directory path changes, update the file list box path
    ChDir dirList.Path           ' Set the current working directory to the new path.

End Sub

Private Sub drvList_Change()

    On Error Resume Next
    dirList.Path = drvList.Drive    ' When drive changes, update path of directory list box
    If Err Then
        MsgBox Error, 48
        drvList.Drive = Left$(dirList.Path, 2)
        Exit Sub
    End If
    ChDrive drvList.Drive             ' and set the current working drive to the new drive.

End Sub

Private Sub fileList_Click()

    If (fileList.ListIndex >= 0) Then
        xPictureName(0) = fileList.Path & "\" & fileList.FileName
        Pix(0).Picture = LoadPicture()
        Pix(0).Picture = LoadPicture(xPictureName(0))
        pnlTitle.Caption = xPictureName(0)
        mnuWindow(0).Enabled = True
    End If

End Sub

Private Sub Form_DblClick()

    'Pix(0).Visible = Not Pix(0).Visible

End Sub

Private Sub Form_Resize()

    Dim xNewFrameSize As Integer
    Dim xMinimumWidth As Single, xMinimumHeight As Single

    'Resize all of the window elements
    If WindowState <> 1 Then
        xMinimumWidth = (pnlSplit.Left + GetSystemMetrics(SM_CXFRAME) * 2) * Screen.TwipsPerPixelX + 2000
        If Width < xMinimumWidth Then
            Width = xMinimumWidth
        End If
        xMinimumHeight = (GetSystemMetrics(SM_CYCAPTION) + GetSystemMetrics(SM_CYMENU) + GetSystemMetrics(SM_CYFRAME) * 2) * Screen.TwipsPerPixelY + 4000
        If Height < xMinimumHeight Then
            Height = xMinimumHeight
        End If
        'Resize the splitter
        pnlSplit.Move pnlSplit.Left, 0, pnlSplit.Width, ScaleHeight
        'Resize the file lists
        xNewFrameSize = (ScaleHeight - pnlFrame(1).Top - 100) / 2 - 4
        If xNewFrameSize < 20 Then xNewFrameSize = 19
        pnlFrame(1).Height = xNewFrameSize
        pnlFrame(0).Top = pnlFrame(1).Top + pnlFrame(1).Height + 4
        pnlFrame(0).Height = xNewFrameSize
        'Resize the title and base image
        pnlTitle.Left = pnlSplit.Left + pnlSplit.Width
        pnlTitle.Move pnlTitle.Left, 0, ScaleWidth - pnlTitle.Left, pnlTitle.Height
        Pix(0).Move pnlTitle.Left, pnlTitle.Top + pnlTitle.Height, pnlTitle.Width, ScaleHeight - pnlTitle.Top - pnlTitle.Height
    End If

End Sub

Private Sub mnuWindow_Click(Index As Integer)

    Select Case Index
        Case 0  'Snap off
            Pix_DblClick 0
        Case 1
            xCascadeWindows
        Case 2
            xTileWindows MDITILE_VERTICAL
        Case 3
            xTileWindows MDITILE_HORIZONTAL
        Case 4
            xArrangeIcons
        Case 5
            xShowHideAllchildren (mnuWindow(5).Checked)
    End Select

End Sub

Private Sub Pix_DblClick(Index As Integer)
'   Double-click on the picture snaps the picture off

    If Index = 0 Then
        If Len(xPictureName(0)) Then
            If iPixIndex < 10 Then
                iPixIndex = iPixIndex + 1
                Load Pix(iPixIndex)
                xMakePixFloat iPixIndex, STATE_FLOAT
                Pix(iPixIndex).Move Pix(iPixIndex).Left + 30, Pix(iPixIndex).Top + 30, Pix(iPixIndex).Width - 60, Pix(iPixIndex).Height - 60
                Pix(iPixIndex).ZOrder 0
                Pix(iPixIndex).Visible = True
                'Clear out the zero'th image
                Pix(0).Picture = LoadPicture()
                xPictureName(0) = ""
                pnlTitle.Caption = ""
                'Unselect the previously selected item
                fileList.Selected(fileList.ListIndex) = False
                'Gray out the snap off menu item
                mnuWindow(0).Enabled = False
            End If
        End If
    End If
    
End Sub

Private Sub Pix_Resize(Index As Integer)

    'Don't allow the window to fall behind other stuff
    If IsIconic(Pix(Index).hWnd) Then
        Pix(Index).ZOrder 0
    End If

End Sub

Private Sub pnlSplit_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)

    pnlSplit.Tag = "X"

End Sub

Private Sub pnlSplit_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    Dim xNewLeft As Integer

    If Len(pnlSplit.Tag) Then
        xNewLeft = pnlSplit.Left + (X / Screen.TwipsPerPixelX)
        If xNewLeft > 100 Then
            pnlSplit.Move xNewLeft, 0, pnlSplit.Width, ScaleHeight
        End If
    End If

End Sub

Private Sub pnlSplit_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)

    'Clear the drag status
    pnlSplit.Tag = ""
    
    'Adjust the visual elements
    pnlTitle.Left = pnlSplit.Left + pnlSplit.Width
    pnlTitle.Move pnlTitle.Left, 0, ScaleWidth - pnlTitle.Left, pnlTitle.Height
    Pix(0).Left = pnlTitle.Left
    Pix(0).Width = pnlTitle.Width

    For I% = 0 To 2
        pnlFrame(I%).Width = pnlSplit.Left - (pnlFrame(I%).Left * 2)
    Next

End Sub

Private Sub xArrangeIcons()

    ArrangeIconicWindows hWnd

End Sub

Private Sub xCascadeWindows()
'   This function cascades all non-minimized windows

    Dim xOffset As Integer

    xOffset = GetSystemMetrics(SM_CYCAPTION) + GetSystemMetrics(SM_CYBORDER)

    For I% = 1 To iPixIndex
        'If window hasn't been closed
        If Pix(I%).hWnd Then
            'If window isn't minimized
            If (IsIconic(Pix(I%).hWnd)) Or (Not Pix(I%).Visible) Then
            Else
                xWindow = xWindow + 1
                'Position the window
                Pix(I%).Move xWindow * xOffset, xWindow * xOffset
                'Bring it to the front
                Pix(I%).ZOrder
            End If
        End If
    Next
        
End Sub

Private Sub xEnableDisableAll(xFlag As Integer)
'   This routine enables/disables all controls on the
'   form that are not independantly sizeable. This
'   function does alter the enabled state of controls
'   so watch out. Otherwise you will have to save
'   references to the controls and restore from there.

    Dim xStyle As Long

    On Error Resume Next
    For I% = 0 To Controls.Count - 1
        If Controls(I%).hWnd Then
            'If the style is sizeable (WS_THICKFRAME)
            xStyle = GetWindowLong(Controls(I%).hWnd, GWL_STYLE)
            If (xStyle And WS_THICKFRAME) Then
            Else
                Controls(I%).Enabled = xFlag
            End If
        End If
    Next

End Sub

Private Sub xMakePixFloat(Index As Integer, S As Integer)

    If S = STATE_FLOAT Then
        'Alter the state of the window to floating
        iPixStyleOld(Index) = GetWindowLong(Pix(Index).hWnd, GWL_STYLE)
        iPixStyle(Index) = iPixStyleOld(Index) And Not WS_MAXIMIZEBOX Or WS_CAPTION Or WS_SYSMENU Or WS_THICKFRAME Or WS_MINIMIZEBOX
    Else
        iPixStyle(Index) = iPixStyleOld(Index)
    End If
    
    'Update the style
    R& = SetWindowLong(Pix(Index).hWnd, GWL_STYLE, iPixStyle(Index))
    
    'For the redraw
    Pix(Index).Move Pix(Index).Left, Pix(Index).Top, Pix(Index).Width, Pix(Index).Height - 1
    Pix(Index).Move Pix(Index).Left, Pix(Index).Top, Pix(Index).Width, Pix(Index).Height + 1
    
    'Update the icon for the floating window
    If S = STATE_FLOAT Then
        xPictureName(Index) = xPictureName(0)
        SetWindowText Pix(Index).hWnd, xPictureName(Index)
        I% = LoadIcon(0, IDI_QUESTION)
        RR% = SetClassWord(Pix(Index).hWnd, -14, I%)
    End If

End Sub

Private Sub xRestoreWindow(Index As Integer)

    I% = ShowWindow(Pix(Index).hWnd, SW_RESTORE)

End Sub

Private Sub xShowHideAllchildren(xFlag As Integer)
'   This routine shows or hides all the floating
'   child windows. This is not normally allowed under
'   full MDI.

    Dim xStyle As Long

    On Error Resume Next
    For I% = 0 To Controls.Count - 1
        If Controls(I%).hWnd Then
            'If the style is sizeable (WS_THICKFRAME)
            xStyle = GetWindowLong(Controls(I%).hWnd, GWL_STYLE)
            If (xStyle And WS_THICKFRAME) Then
                Controls(I%).Visible = xFlag
                'This is to prevent the child from tiling
                Controls(I%).Enabled = xFlag
            End If
        End If
    Next
    mnuWindow(5).Checked = Not mnuWindow(5).Checked

End Sub

Private Sub xTileWindows(xFlag As Integer)

    xEnableDisableAll False
    TileChildWindows hWnd, (2 Or xFlag)
    xEnableDisableAll True

End Sub

