Attribute VB_Name = "SimonCarter_WindowsLibraryAll"
Option Explicit

Public Const ID_YES = 6
Public Const DBFilter = "Database Files (*.MDB)|*.mdb"
Public Const AllFilter = "All Files (*.*)|*.*"
Public Const ExeFilter = "Executable Files (*.EXE)|*.exe"
Public Win95RegBase As String
Global WS As Workspace
#If Win32 Then
    'SCWL Functions
    Declare Function SCFont Lib "scwl32.dll" (ByRef ThisFont As SCFontStruct) As Integer
    Declare Function ProperString Lib "scwl32.dll" (ByRef S As String) As Integer
    Declare Function GetDirStruct Lib "scwl32.dll" (ByVal Dir As Integer, ListBoxHandle As Integer) As Integer
    Declare Function Soundalike Lib "scwl32.dll" Alias "SoundAlikeA" (ByVal S1 As String, ByVal S2 As String) As Boolean
    Declare Function PentiumBug Lib "scwl32.dll" Alias "PentiumBugA" () As Boolean
    'Return Comm Ports Available
    'Declare Function CommPorts Lib "scwl32.dll" () As Integer 'not available 32 Bit (Yet)
        'CommPorts will be combination of following
    'Comm 1 = 1
    'Comm 2 = 2
    'Comm 3 = 4
    'Comm 4 = 8
    'No comm Ports = 0
    
    'GetHiB & GetLoB Gets The hi and lo bytes from a word
    'Word    0  ..  65535    Unsigned 16-bit (Type of Long Integer)
    Declare Function GetHiB Lib "scwl32.dll" Alias "GetHiBA" (ByVal GetFrom As Integer) As Integer
    Declare Function GetLoB Lib "scwl32.dll" Alias "GetLoBA" (ByVal GetFrom As Integer) As Integer
    
    'GetHiW & GetLoW Gets The hi and lo Words from an Integer
    Declare Function GetHiW Lib "scwl32.dll" Alias "GetHiWA" (ByVal GetFrom As Long) As Long
    Declare Function GetLoW Lib "scwl32.dll" Alias "GetLoWA" (ByVal GetFrom As Long) As Long
    
    Declare Function CursorN Lib "scwl32.dll" Alias "CursorNA" () As Integer
    Declare Function CursorH Lib "scwl32.dll" Alias "CursorHA" () As Integer
    Declare Sub DispMsg Lib "scwl32.dll" Alias "DispMsgA" (ByVal Title As String, ByVal FileName As String)
    Declare Function Showtips Lib "scwl32.dll" Alias "ShowTipsA" (ByVal Title As String, ByVal TipTitle As String, ByVal StringFile As String, ByVal ShowAtStart As Integer) As Integer
    Declare Sub OpenCD Lib "scwl32.dll" Alias "OpenCDA" ()
    Declare Function EditOption Lib "scwl32.dll" Alias "EditOptionA" () As Integer
    Declare Function GetTime Lib "scwl32.dll" Alias "GetTimeA" (RtnTime As String) As Integer
    Declare Function GetPath Lib "scwl32.dll" Alias "GetPathA" (rtnpath As String) As Integer
    Declare Function ShowAbout Lib "scwl32.dll" Alias "showaboutA" (ByVal IcoFile As String, ByVal Title As String, ByVal Version As String) As Boolean
    Declare Function ShowOpen Lib "scwl32.dll" Alias "FOpen" (ByVal Title As String, ByVal Filter As String, ByVal DefaultDir As String, ReturnFile As String) As Integer
    Declare Function ShowSave Lib "scwl32.dll" Alias "FSave" (ByVal Title As String, ByVal Filter As String, ByVal DefaultDir As String, ReturnFile As String) As Integer
    
    Declare Function GetSymbol Lib "scwl32.dll" Alias "GetSymbolA" () As Boolean
    Declare Function GetColor Lib "scwl32.dll" Alias "GetColorA" () As Long
    Declare Sub ShowDisk Lib "scwl32.dll" Alias "ShowDiskA" ()
    Declare Function GetDate Lib "scwl32.dll" Alias "GetDateA" (ByRef rtndate As String) As Integer
    Declare Function GetDateI Lib "scwl32.dll" Alias "GetDateIA" () As Long
    Declare Function GetHwnd Lib "scwl32.dll" Alias "GetHWndA" (ByVal MHwnd As Integer, ByVal WindowTitle As String) As Integer
    Declare Function MemTotal Lib "scwl32.dll" Alias "MemTotalA" () As Long
    Declare Function MemFree Lib "scwl32.dll" Alias "MemFreeA" () As Long
    Declare Sub WrapCursor Lib "scwl32.dll" Alias "WrapCursorA" ()
    Declare Function Percent Lib "scwl32.dll" Alias "PercentA" (ByVal Num As Double, ByVal Total As Double) As Integer
    Declare Sub Today Lib "scwl32.dll" Alias "TodayA" (RtnDay As String)
    Declare Function changetitle Lib "scwl32.dll" Alias "ChangeTitleA" (ByVal MHwnd As Integer, ByVal ExistTitle As String, ByVal newtitle As String) As Integer
    Declare Function ActiveTitle Lib "scwl32.dll" Alias "ActiveTitleA" (returntitle As String) As Integer
    Declare Sub SetActiveTitle Lib "scwl32.dll" Alias "SetActiveTitleA" (ByVal returntitle As String)
    Declare Sub CloseWindows Lib "scwl32.dll" Alias "ExitWinA" (ByVal ExitStyle As Integer)
    Declare Function Logon Lib "scwl32.dll" Alias "LogonA" (ByVal Title As String, ByRef RtnValue As String) As Integer
    Declare Function getini Lib "scwl32.dll" Alias "GetIniA" (ByVal Section As String, ByVal key As String, ByVal Inifile As String, default As String) As Integer
    Declare Function writeini Lib "scwl32.dll" Alias "WriteIniA" (ByVal Section As String, ByVal key As String, ByVal Setting As String, ByVal Inifile As String) As Integer
    Declare Sub OnTop Lib "scwl32.dll" Alias "OnTopA" (ByVal hWnd As Long)
    Declare Sub NotTop Lib "scwl32.dll" Alias "NotTopA" (ByVal hWnd As Integer)
    Declare Function Fileexist Lib "scwl32.dll" Alias "FileExistA" (ByVal FileName As String) As Boolean
    Declare Function ShowHelp Lib "scwl32.dll" Alias "ShowHelpA" (ByVal MHwnd As Integer, ByVal TheHelpFile As String, ByVal TopicNo As Long) As Boolean
    Declare Function Showsearch Lib "scwl32.dll" Alias "ShowSearchA" (ByVal MHwnd As Integer, ByVal TheHelpFile As String) As Boolean
    Declare Function HDFree Lib "scwl32.dll" Alias "HDFreeA" (ByVal DiskNum As Integer) As Long
    Declare Function HDUsed Lib "scwl32.dll" Alias "HDUsedA" (ByVal DiskNum As Integer) As Long
    Declare Function HDTotal Lib "scwl32.dll" Alias "HDTotalA" (ByVal DiskNum As Integer) As Long
    Declare Function CLBFind Lib "scwl32.dll" Alias "CLBFindA" (ByVal CL As Integer, ByVal Handle As Integer, ByVal TextSearch As String) As Integer

    'Windows Functions
    Declare Function GetActiveWindow Lib "user32" () As Integer
    Declare Function GetCursorPos Lib "user32" (lpPoint As POINTAPI) As Long
    Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Long) As Long
    Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long
    Declare Function WindowFromPoint Lib "user32" (ByVal xPoint As Long, ByVal yPoint As Long) As Long
    Declare Function ShowWindow Lib "user32" (ByVal hWnd As Long, ByVal nCmdShow As Long) As Long
    Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
    Declare Function GetWindowsDirectory Lib "kernel32" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
    Declare Function GetSystemDirectory Lib "kernel32" Alias "GetSystemDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long

    
#Else
    Declare Function ProperString Lib "scwl.dll" (ByRef S As String) As Integer
    Declare Function GetDirStruct Lib "scwl.dll" (ByVal Dir As Integer, ListBoxHandle As Integer) As Integer
    Declare Function Soundalike Lib "scwl.dll" (ByVal S1 As String, ByVal S2 As String) As Boolean
    Declare Function IsShareLoaded Lib "scwl.dll" () As Boolean
    Declare Function PentiumBug Lib "scwl.dll" () As Boolean
    'Return Comm Ports Available
    Declare Function CommPorts Lib "scwl.dll" () As Integer
        'CommPorts will be combination of following
    'Comm 1 = 1
    'Comm 2 = 2
    'Comm 3 = 4
    'Comm 4 = 8
    'No comm Ports = 0
    
    'GetHiB & GetLoB Gets The hi and lo bytes from a word
    'Word    0  ..  65535    Unsigned 16-bit (Type of Long Integer)
    Declare Function GetHiB Lib "scwl.dll" (ByVal GetFrom As Integer) As Integer
    Declare Function GetLoB Lib "scwl.dll" (ByVal GetFrom As Integer) As Integer
    
    'GetHiW & GetLoW Gets The hi and lo Words from an Integer
    Declare Function GetHiW Lib "scwl.dll" (ByVal GetFrom As Long) As Long
    Declare Function GetLoW Lib "scwl.dll" (ByVal GetFrom As Long) As Long
    
    Declare Function CursorN Lib "scwl.dll" () As Integer
    Declare Function CursorH Lib "scwl.dll" () As Integer
    Declare Sub DispMsg Lib "scwl.dll" (ByVal Title As String, ByVal FileName As String)
    Declare Function Showtips Lib "scwl.dll" (ByVal Title As String, ByVal TipTitle As String, ByVal StringFile As String, ByVal ShowAtStart As Integer) As Integer
    Declare Sub OpenCD Lib "scwl.dll" ()
    Declare Function EditOption Lib "scwl.dll" () As Integer
    Declare Function GetTime Lib "scwl.dll" (RtnTime As String) As Integer
    Declare Function GetPath Lib "scwl.dll" (rtnpath As String) As Integer
    Declare Function ShowAbout Lib "scwl.dll" (ByVal IcoFile As String, ByVal Title As String, ByVal Version As String) As Boolean
    Declare Function ShowOpen Lib "scwl.dll" (ByVal Title As String, ByVal Filter As String, ByVal DefaultDir As String, ReturnFile As String) As Integer
    Declare Function ShowSave Lib "scwl.dll" (ByVal Title As String, ByVal Filter As String, ByVal DefaultDir As String, ReturnFile As String) As Integer
    Declare Sub ShowTip Lib "scwl.dll" (ByVal tiptext As String)
    
    Declare Function GetSymbol Lib "scwl.dll" () As Boolean
    Declare Function GetColor Lib "scwl.dll" () As Long
    Declare Sub ShowStart Lib "scwl.dll" (ByVal PictureFile As String)
    Declare Sub ClearStart Lib "scwl.dll" ()
    Declare Sub ShowRes Lib "scwl.dll" ()
    Declare Sub ShowDisk Lib "scwl.dll" ()
    Declare Function GetDate Lib "scwl.dll" (ByRef rtndate As String) As Integer
    Declare Function GetDateI Lib "scwl.dll" () As Long
    Declare Function GetHwnd Lib "scwl.dll" (ByVal MHwnd As Integer, ByVal WindowTitle As String) As Integer
    Declare Function MemTotal Lib "scwl.dll" () As Long
    Declare Function MemFree Lib "scwl.dll" () As Long
    Declare Sub WrapCursor Lib "scwl.dll" ()
    Declare Function Percent Lib "scwl.dll" (ByVal Num As Double, ByVal Total As Double) As Integer
    Declare Sub Today Lib "scwl.dll" (RtnDay As String)
    Declare Function changetitle Lib "scwl.dll" (ByVal MHwnd As Integer, ByVal ExistTitle As String, ByVal newtitle As String) As Integer
    Declare Function ActiveTitle Lib "scwl.dll" (returntitle As String) As Integer
    Declare Sub SetActiveTitle Lib "scwl.dll" (ByVal returntitle As String)
    Declare Sub CloseWindows Lib "scwl.dll" Alias "ExitWin" (ByVal ExitStyle As Integer)
    Declare Function Logon Lib "scwl.dll" (ByVal Title As String, RtnValue As String) As Integer
    Declare Function getini Lib "scwl.dll" (ByVal Section As String, ByVal key As String, ByVal Inifile As String, default As String) As Integer
    Declare Function writeini Lib "scwl.dll" (ByVal Section As String, ByVal key As String, ByVal Setting As String, ByVal Inifile As String) As Integer
    Declare Sub OnTop Lib "scwl.dll" (ByVal hWnd As Integer)
    Declare Sub NotTop Lib "scwl.dll" (ByVal hWnd As Integer)
    Declare Function Fileexist Lib "scwl.dll" (ByVal FileName As String) As Integer
    Declare Function ShowHelp Lib "scwl.dll" (ByVal MHwnd As Integer, ByVal TheHelpFile As String, ByVal TopicNo As Long) As Boolean
    Declare Function Showsearch Lib "scwl.dll" (ByVal MHwnd As Integer, ByVal TheHelpFile As String) As Boolean
    Declare Function GetRes Lib "scwl.dll" (ByVal restype As Integer) As Integer
    Declare Function HDFree Lib "scwl.dll" (ByVal DiskNum As Integer) As Long
    Declare Function HDUsed Lib "scwl.dll" (ByVal DiskNum As Integer) As Long
    Declare Function HDTotal Lib "scwl.dll" (ByVal DiskNum As Integer) As Long
    Declare Function CLBFind Lib "scwl.dll" (ByVal CL As Integer, ByVal Handle As Integer, ByVal TextSearch As String) As Integer
    
    Declare Function TotLines Lib "cdl36sc.dll" (ByVal MLEHwnd As Integer) As Long
    Declare Sub TextPos Lib "cdl36sc.dll" (ByVal editwnd As Integer, LPPopint As POINTAPI)
    Declare Sub DrawRulerX Lib "cdl36sc.dll" (ByVal picwnd As Integer)
    Declare Sub DrawRulerXT Lib "cdl36sc.dll" (ByVal picwnd As Integer, ByVal LeftMargin As Double, ByVal RightMargin As Double, ByVal RulerWidth As Double, ByVal FromNumber As Integer, ByVal ToNumber As Integer)
    Declare Sub TabStop Lib "cdl36sc.dll" (ByVal picwnd As Integer, ByVal Position As Integer, ByVal TabChar As Integer)
    Declare Sub Paintpic Lib "cdl36sc.dll" (ByVal DHDC As Integer)
    Declare Function ScrollPos Lib "cdl36sc.dll" (ByVal SCrollHwnd As Integer) As Integer

    Declare Function GetWindowsDirectory Lib "Kernel" Alias "getwindowsdirectory" (ByVal p$, ByVal S%) As Integer
    Declare Function GetSystemDirectory Lib "Kernel" (ByVal p$, ByVal S%) As Integer
    Declare Function GetVersion Lib "Kernel" () As Long
    Declare Function sndPlaySound Lib "MMSYSTEM" (ByVal lpszSoundName As String, ByVal uFlags As Integer) As Integer
    Declare Function GetModuleUsage Lib "Kernel" (ByVal hModule As Integer) As Integer
    Declare Sub Yield Lib "Kernel" ()
    Declare Function GetPrivateProfileString Lib "Kernel" (ByVal AppName$, ByVal KeyName$, ByVal keydefault$, ByVal ReturnString$, ByVal NumBytes As Integer, ByVal FileName$) As Integer
    Declare Function WritePrivateProfileString Lib "Kernel" (ByVal AppName$, ByVal KeyName$, ByVal keydefault$, ByVal FileName$) As Integer
    Declare Function ShowWindow% Lib "User" (ByVal Handle As Integer, ByVal Cmd As Integer)
    'Declare Sub GetCursorPos Lib "User" (lpPoint As POINTAPI)
    Declare Function GetActiveWindow Lib "User" () As Integer
    Declare Function WindowFromPoint Lib "User" (ByVal lpPointY As Integer, ByVal lpPointX As Integer) As Integer
    'Declare Function ShowWindow Lib "User" (ByVal hWnd As Integer, ByVal nCmdShow As Integer) As Integer
    Public Declare Sub GetCursorPos Lib "User" (lpPoint As POINTAPI)
    Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, ByVal lParam As Any) As Long
#End If

   Type ConvertPOINTAPI  ' Used by WM_SYSCOMMAND - converts mouse location.
      xy As Long
   End Type


Global Const WM_LBUTTONUP = &H202
Global Const WM_SYSCOMMAND = &H112
Global Const MOUSE_MOVE = &HF012

Global Const SND_SYNC = &H0                 '  play synchronously (default)
Global Const SND_ASYNC = &H1                '  play asynchronously
Global Const SND_NODEFAULT = &H2            '  don't use default sound
Global Const SND_MEMORY = &H4               '  lpszSoundName points to a memory file
Global Const SND_LOOP = &H8                 '  loop the sound until next sndPlaySound
Global Const SND_NOSTOP = &H10              '  don't stop any currently playing sound



Type RulerXT
    LM As Integer
    RM As Integer
    Width As Integer
End Type
Global Const ExitWin_Normal = &H1
Global Const ExitWin_Restart = &H2
Global Const ExitWin_Reboot = &H3
Global Const SW_SHOWNOACTIVATE = 4

Type SCFontStruct
    Name As String * 40
    len As Integer
    Size As Integer
    Bold As Boolean
    Italic As Boolean
    Color As Long
    Underline As Boolean
    StrikeOut As Boolean
End Type



Type POINTAPI       ' Stores location of cursor
    X As Integer
    Y As Integer
End Type
Public ShowingTip As Boolean
Type ODI
      Filter As String
      Title As String
      HelpFile As String
      TopicNo As Long
End Type

Type LogonType
    Name As String * 40
    Password As String * 40
    Result As Integer
End Type


' Key Codes
Global Const KEY_SHIFT = &H10
Global Const KEY_CONTROL = &H11

Global Const KEY_F1 = &H70
Global Const KEY_F2 = &H71
Global Const KEY_F3 = &H72
Global Const KEY_F4 = &H73
Global Const KEY_F5 = &H74
Global Const KEY_F6 = &H75
Global Const KEY_F7 = &H76
Global Const KEY_F8 = &H77
Global Const KEY_F9 = &H78
Global Const KEY_F10 = &H79
Global Const KEY_F11 = &H7A
Global Const KEY_F12 = &H7B


Function PlaySound(FileName As String, play As Integer)
Dim Rt As Integer, play_type
Rt = Fileexist(FileName)
If Rt <> 0 Then 'File does not exist so exit function
    PlaySound = Rt
    Exit Function
End If
Select Case play
Case 1
    play_type = &H0
Case 2
    play_type = &H1
Case 3
    play_type = &H2
Case 4
    play_type = &H8
Case 5
    play_type = &H10
Case Else
    MsgBox "Invalid Play Type", 64, "SC Play Sound"
    PlaySound = 1
    Exit Function
End Select
#If Win16 Then
    Rt = sndPlaySound(FileName, play_type)
#End If
    PlaySound = 0
End Function


Function systemdirectory() As String
Dim WinPath As String
    WinPath = String(145, Chr(0))
    systemdirectory = Left(WinPath, GetSystemDirectory(WinPath, Len(WinPath)))

End Function


Function windowsdirectory() As String
Dim WinPath As String
    WinPath = String(145, Chr(0))
    windowsdirectory = Left(WinPath, GetWindowsDirectory(WinPath, Len(WinPath)))
End Function


Function WindowsVersion()
#If Win32 Then

#Else
    Dim ver As Long, winver As Long
    ver = GetVersion()
    winver = ver And &HFFFF&
    WindowsVersion = Format((winver Mod 256) + ((winver \ 256) / 100), "Fixed")
#End If
End Function


#If Win16 Then
Function dosversion()
Dim ver As Long, dosver As Long
    ver = GetVersion()
    dosver = ver \ &H10000
    dosversion = Format((dosver \ 256) + ((dosver Mod 256) / 100), "Fixed")
End Function

#End If
Sub CenterForm(NameOfForm As Form)
    Dim FormLeft As Integer
    Dim FormTop As Integer
    FormLeft = (Screen.Width - NameOfForm.Width) / 2
    FormTop = (Screen.Height - NameOfForm.Height) / 2
    NameOfForm.Move FormLeft, FormTop
End Sub

Public Function ShortenPath(LenOfPath As Integer, Path As String) As String
Dim I As Integer, Rt, NewPath As String, OldPath As String, UsePath As String
NewPath = Left$(Path, 3) & "..."
OldPath = Mid$(Path, 4)
StartShortenPath:
If Len(OldPath) > (LenOfPath - 6) Then
    OldPath = Mid$(OldPath, 4)
    Do While Not Left$(OldPath, 1) = "\"
        OldPath = Mid$(OldPath, 2)
    Loop
    UsePath = NewPath & OldPath
Else
    UsePath = Path
End If
If Len(UsePath) > LenOfPath Then GoTo StartShortenPath
ShortenPath = UsePath
End Function


Function GetWinIni(Section As String, key As String, Optional IniReturn As Variant) As String
Dim RetVal As String, AppName As String, worked As Integer
    RetVal = String$(255, 0)
    worked = GetPrivateProfileString(Section, key, "", RetVal, Len(RetVal), "Win.ini")
    If worked = 0 Then
        If IsMissing(IniReturn) Then GetWinIni = "" Else GetWinIni = CStr(IniReturn)
    Else
        GetWinIni = Left(RetVal, worked)
    End If
End Function



Public Function MyPath() As String
Dim Path As String
Path = App.Path
If Not Right$(Path, 1) = "\" Then Path = Path & "\"
MyPath = Path
End Function


Public Function StripU(TextToStrip As String)
Dim Rt, ToReturn As String, ThisChar As String, I As Integer
For I = 1 To Len(TextToStrip)
    ThisChar = Mid$(TextToStrip, I, 1)
    If ThisChar = "&" Then
    
    Else
        ToReturn = ToReturn & ThisChar
    End If
Next I
StripU = ToReturn
End Function


Public Function WriteMyIni(Section As String, key As String, Setting As String, Optional FileIni As Variant)
Dim Rt, TheIniFile As String
'which inifile to use
If IsMissing(FileIni) Then
    TheIniFile = Inifile
Else
    TheIniFile = CStr(FileIni)
End If
#If Win32 Then
    On Error Resume Next
    Call SaveSetting(Left$(TheIniFile, (InStr(1, TheIniFile, ".") - 1)), Section, key, Setting)
    If Err <> 0 Then
        MsgBox "Error Writing to System Registry", 64, Title$
    End If
    'rt = WritePrivateProfileString(Section, key, Setting, TheIniFile)
#Else
    Rt = WritePrivateProfileString(Section, key, Setting, TheIniFile)
#End If
End Function



Public Function IsDataBase(DataBaseName) As Integer
Err = 0
On Local Error Resume Next
Dim DummyDb As Database, IsDataBaseTries As Integer
Dim Nl, rtnInt As Integer
Nl = Chr$(13)
IsDatabaseStart: 'Start Point

Set DummyDb = OpenDatabase(DataBaseName)
If Err <> 0 Then
    IsDataBaseTries = IsDataBaseTries + 1
    IsDataBase = Err
    If IsDataBaseTries > 1 Then
        GoTo IsDatabaseEP 'already attempted to open DataBase once so quit trying
    End If
    IsDataBase = Err
    Select Case Err
    Case 3049 'needs repairing
        Select Case MsgBox(DataBaseName & Nl & "Needs repairing or is not a valid Database." & Nl & Nl & "Do you want to attempt a repair.", 16 + 4, Title$)
        Case ID_YES
            Err = 0
            DBEngine.RepairDatabase DataBaseName
            If Err = 3056 Then
                MsgBox DataBaseName & " Could Not Be Repaired." & Nl & "It May not be a Valid Database", 16, Title$
                GoTo IsDatabaseEP
            Else
                GoTo IsDatabaseStart
            End If
        Case Else
            GoTo IsDatabaseEP
        End Select
    Case 3048 'cant open any more databases
    
    Case 3005 'invalid Database name
    
    Case 3025 'cant open any more files
    
    Case 3000 ' Unknown Error
        GoTo IsDatabaseEP
    Case Else 'Untrapped DB Errors
        MsgBox "Unknown Problem With " & DataBaseName & ".", 16, Title$
        GoTo IsDatabaseEP
    End Select
    
Else
    IsDataBase = 0
    DummyDb.Close
End If


IsDatabaseEP: 'Exit Point
On Error Resume Next
DummyDb.Close

End Function


Public Function gs(StringNo As Integer, Optional ToInsert As Variant)
Dim ReturnStr As String, ThisString As String, I As Integer, Insert As Boolean
On Error GoTo GSErr
If IsMissing(ToInsert) Then Insert = False Else Insert = True
ThisString = LoadResString(StringNo)
I = InStr(1, ThisString, "%1")
If I > 0 And Insert = True Then
    ReturnStr = Left$(ThisString, I - 1) & ToInsert & Mid$(ThisString, I + 2)
Else
    ReturnStr = ThisString
End If
gs = ReturnStr
GSEP: 'exit point
If ReturnStr = "" Then ReturnStr = "Could Not Load Text"
Exit Function

GSErr:
MsgBox Error$ & Chr$(13) & Chr$(13) & Err, 16, Title$
GoTo GSEP
End Function


Public Function JustPath(ToChange As String)
Dim Rtn As String
Rtn = ToChange
Do While Not Right$(Rtn, 1) = "\"
    Rtn = Left$(Rtn, Len(Rtn) - 1)
Loop
JustPath = Rtn

End Function


Function getbluff(blufflen As Integer)
Dim I, bluff_string, this_asc, this_char
bluff_string = ""
For I = 1 To blufflen
    this_asc = Int((200 * Rnd) + 1)
    this_char = Chr$(this_asc)
    bluff_string = bluff_string & this_char
Next I
getbluff = bluff_string
End Function




Public Sub showtt(Help$)
    Dim lpPoint As POINTAPI ' Cursor Point variable
    Dim ret As Integer
    If Len(Help$) <> 0 Then
        ' Make sure help form is invisible:
        'tooltips.Hide
        ' Change caption of label:
        'tooltips.Label1.Caption = Help$
        ' Get the cursor position
        Call GetCursorPos(lpPoint)
        ' Offset the form from the cursor
        If Screen.ActiveForm.Top <= Screen.Height - 700 Then
            'tooltips.Top = (lpPoint.Y + 18) * Screen.TwipsPerPixelY
            'tooltips.Left = (lpPoint.X - 2) * Screen.TwipsPerPixelY
        Else
            'tooltips.Top = (lpPoint.Y - 18) * Screen.TwipsPerPixelY
            'tooltips.Left = (lpPoint.X - 2) * Screen.TwipsPerPixelY
        End If
        ' Adjust width and height of form to label
        'tooltips.Width = tooltips.Label1.Width + (4 * Screen.TwipsPerPixelX)
        'tooltips.Height = tooltips.Label1.Height + 4 * Screen.TwipsPerPixelY
        ' Make sure form is on top:
        'tooltips.ZOrder
        ' Show form without the focus:
        'ret = ShowWindow(tooltips.hwnd, SW_SHOWNOACTIVATE)
    Else
        ' Hide the form:
        'tooltips.Hide
    End If
End Sub



Public Sub CWSpace()
Dim Nl, PW As String, PN As String, ThisLogon As LogonType
On Error Resume Next
Nl = Chr$(13)
PN = "admin"
PW = "" 'Null
GoTo CWSpaceNormal

CWSpaceSelect:
ThisLogon = UserLogon("Tel-PARS 3 Logon")
If ThisLogon.Result <> 0 Then
    'End
Else
    PW = LTrim(RTrim(ThisLogon.Password))
    PN = LTrim(RTrim(ThisLogon.Name))
End If

CWSpaceNormal:
DBEngine.DefaultPassword = PW
DBEngine.DefaultUser = PN
Set WS = DBEngine.CreateWorkspace("Tel-PARS3", PN, PW)
If Err <> 0 Then
    If Err = 3028 Then
        'ClearStart
        MsgBox gs(1011) & gs(1013) & Nl & "Select New MDW File and Restart Tel-PARS.", 16, Title$, MyPath & FileHelp, 310
        SpecifySystemMDA
        'End
    ElseIf Err = 3044 Then
        'ClearStart
        MsgBox gs(1012) & Nl & Nl & "Press F1 For Help", 16, Title$, FileHelp, 840
        SpecifySystemMDA
        'End
    ElseIf Err = 3029 Then
        MsgBox "Wrong Account Name/Password", 16, Title$
        GoTo CWSpaceSelect
    Else
        MsgBox "Create Workspace Error" & Nl & Nl & Error$ & Nl & Err & gs(1500), 32, Title$, FileHelp, 20
        'End
    End If
End If
End Sub





Function DiskSpace(Disk As String, diskoption As Integer, ReturnStyle As Integer) As Variant
'This Function deals with Diskspace Free/Used/Total
'within scwl.dll
Dim DiskNo As Integer, Bytes As Long, BytesConversion As Double

'calculate diskno 1 = A, 2 = B and so on
DiskNo = Asc(UCase$(Disk)): DiskNo = DiskNo - 64
If DiskNo < 1 Or DiskNo > 26 Then
    'optional you could put code here to make
    'default drive the C drive
    
    'else exit because invalid drive letter
    'rem following if making default drive
    DiskSpace = -10000
    Exit Function
End If

'bytes will receive the total bytes for the diskoption selected
Select Case diskoption 'this option will be used/free/total
Case 2 'Total Disk Space
    Bytes = HDTotal(DiskNo)
Case 1 'Free Disk Space
    Bytes = HDFree(DiskNo)
Case Else 'used disk space
    Bytes = HDUsed(DiskNo)
End Select

'check to see if drive number exists
If Bytes = -1 Then 'drive is invalid
    DiskSpace = -1
    Exit Function
End If

'returnstyle = bytes,kbytes,mbytes
Select Case ReturnStyle
Case 2 'bytes
    DiskSpace = Bytes 'return bytes as is
Case 1 'mbytes convert bytes to mega bytes
    BytesConversion = Bytes / 1024
    BytesConversion = BytesConversion / 1024
    'place code here to convert bytesconversion to so many decimal places
    DiskSpace = BytesConversion
Case Else 'kbytes convert bytes to kilobytes
    BytesConversion = Bytes / 1024
    'place code here to convert bytesconversion to so many decimal places
    DiskSpace = BytesConversion
End Select
End Function

Function GetMyIni(Section, key, Optional DefaultReturn As Variant, Optional FileIni As Variant) As Variant
Dim ReturnString As String, Result As String, TheIniFile As String, RetVal As Integer
    
'buffer up return string
ReturnString = String(1000, 0)

'which inifile to use
If IsMissing(FileIni) Then
    TheIniFile = Inifile
Else
    TheIniFile = CStr(FileIni)
End If
#If Win32 Then
    'Make the call 32 Bit (Win 95/NT)
    If Win95RegBase = "" Then 'use VB call to reg location "[HKEY_CURRENT_USER\Software\VB and VBA Program Settings\"
        If IsMissing(DefaultReturn) Then
            ReturnString = GetSetting(Left$(TheIniFile, (InStr(1, TheIniFile, ".") - 1)), Section, key, "")
        Else
            ReturnString = GetSetting(Left$(TheIniFile, (InStr(1, TheIniFile, ".") - 1)), Section, key, "")
            If ReturnString = "" Then ReturnString = CStr(DefaultReturn)
        End If
    Else 'use win api calls to proper location
    
    End If
    GetMyIni = ReturnString
#Else
    'make call to dll
    If IsMissing(DefaultReturn) Then
        RetVal = GetPrivateProfileString(Section, key, "", ReturnString, Len(ReturnString), TheIniFile)
    Else
        RetVal = GetPrivateProfileString(Section, key, CStr(DefaultReturn), ReturnString, Len(ReturnString), TheIniFile)
    End If
    
    'calculate result and send back
    If RetVal <> 0 Then 'worked
        GetMyIni = Left$(ReturnString, RetVal)
    Else
        If IsMissing(DefaultReturn) Then GetMyIni = "" Else GetMyIni = DefaultReturn
    End If
#End If

End Function

Function HelpProc(FormName As Form, Optional TopicNo As Variant) As Boolean
'shows help topic or search box in winhelp
'declare a global declaration for Filehelp in declarations section
Dim Result As Boolean, ThisTopic As Long
'if topicno is not sent assume search
If IsMissing(TopicNo) Then
    Result = Showsearch(FormName.hWnd, FileHelp)
Else
    ThisTopic = CLng(TopicNo)
    Result = ShowHelp(FormName.hWnd, FileHelp, ThisTopic)
End If
HelpProc = Result
End Function
Function decp(ToChange, decplaces) As String
decp = ToChange
End Function

Public Sub StartMDWCheck()
'Check IniSeting To See If MDW Database Exists
Dim BadMDW As Boolean, Rt, Nl
Nl = Chr$(13)
StartMDWCheck:
BadMDW = False
#If Win32 Then
    Rt = GetMyIni(Left$(Inifile, (InStr(1, Inifile, ".") - 1)) & "\Engines\Jet", "SystemDB", "")
#Else
    Rt = GetMyIni("Options", "SystemDB", "")
#End If
If Rt = "" Then BadMDW = True 'no system file BadMDW = true
If Not Rt = "" Then
    If Fileexist(Rt) = 1 Then BadMDW = True
End If
If BadMDW = True Then
    'Splash.Hide 'This is Tel-PARS3 splash screen rem out in another project
    MsgBox "There Is No System.MDW File Specified." & Chr$(13) & "If You Wish to Continue You Must Select A MDW File'", 16, Title$, FileHelp, 310
    SpecifySystemMDA
    'Splash.Show: Splash.Refresh
    'frmmain.Refresh
    BadMDW = False
    GoTo StartMDWCheck
End If
'setup database workspace
On Error Resume Next
#If Win32 Then
    DBEngine.IniPath = "HKEY_CURRENT_USER\Software\VB and VBA Program Settings\" & Left$(Inifile, (InStr(1, Inifile, ".") - 1)) ' & "\Engines\Jet"
#Else
    DBEngine.IniPath = Inifile 'inifile should point to Tel-PARS3.INI (no path)
#End If
If Err <> 0 Then
    MsgBox "Error connecting To System Database" & Chr$(13) & Error$ & Nl & Err, 16, Title$, FileHelp, 310
End If
CWSpace

End Sub

Public Function OpenProc(Optional Title As Variant, Optional Filter As Variant) As String
'This Procedur eCan Be Used To Get A FileName From The
'Open Dialog Box Within scwl.DLL
Dim Result As Integer, TheTitle As String, ThePath As String, TheFilter As String, ReturnFile As String

'Set Title
If IsMissing(Title) Then
    TheTitle = "Open..." 'default title
Else
    'if blank String Sent Then A GPF Fault will occur
    If Title = "" Then Title = "Open..."
    TheTitle = Title 'Set Title
End If

'Set Filter
If IsMissing(Filter) Then
    TheFilter = "All Files (*.*)|*.*" 'default filter
Else
    'If TheFilter = "" then a GPF Will Occur
    If Filter = "" Then Filter = "All Files (*.*)|*.*"
    TheFilter = Filter 'Set filter
End If

'Set Up Default Path for Open
ThePath = CurDir 'could be app.path

'Buffer out string to receive filename
ReturnFile = String(255, 0)

'Make call to dll
Result = ShowOpen(TheTitle, TheFilter, ThePath, ReturnFile)
If Result = -1 Then 'user cancelled
    OpenProc = ""
Else ' Then 'user selected a file
    OpenProc = UCase$(Left$(Trim$(ReturnFile), Result)) 'return filename to caller of function
End If
    
End Function

Public Function SaveProc(Optional Title As Variant, Optional Filter As Variant) As String
'This Procedur eCan Be Used To Get A FileName From The
'Open Dialog Box Within scwl.DLL
Dim Result As Integer, TheTitle As String, ThePath As String, TheFilter As String, ReturnFile As String

'Set Title
If IsMissing(Title) Then
    TheTitle = "Save As..." 'default title
Else
    'if blank String Sent Then A GPF Fault will occur
    If Title = "" Then Title = "Save As..."
    TheTitle = Title 'Set Title
End If

'Set Filter
If IsMissing(Filter) Then
    TheFilter = "All Files (*.*)|*.*" 'default filter
Else
    'If TheFilter = "" then a GPF Will Occur
    If Filter = "" Then Filter = "All Files (*.*)|*.*"
    TheFilter = Filter 'Set filter
End If

'Set Up Default Path for Open
ThePath = CurDir 'could be app.path

'Buffer out string to receive filename
ReturnFile = String(255, 0)

'Make call to dll
Result = ShowSave(TheTitle, TheFilter, ThePath, ReturnFile)
If Result = -1 Then 'user selected a file
    SaveProc = "" 'user cancelled or error
Else
    SaveProc = Left$(ReturnFile, Result) 'return filename to caller of function
End If
    

End Function

Public Sub AboutBox(Title As String, Version As String, Optional Icon As Variant)
'this sub routine will display an about box from
'scwl.dll
Dim TheIcon As String

'about box has default icon so it doesnot need one
'icon is a base ico file
If Not IsMissing(Icon) Then
    If Fileexist(Icon) = True Then
        TheIcon = Icon
    Else
        'if no icon exists must send something in the string else
        'will cause a GPF
        TheIcon = "NoIcon"
    End If
Else
    TheIcon = "NoIcon"
End If

'display the about box
    Call ShowAbout(TheIcon, Title, Version)

End Sub

Public Function GetWinHwnd(NameOfForm As Form, TitleOfProg As String) As Integer
'this function will get the handle of a window by giving the title
'of the window
Dim Result As Integer
'if blank title (i.e. "" is sent a GPF will occur
If TitleOfProg = "" Then
    GetWinHwnd = -1
    Exit Function
End If

'send call
Result = GetHwnd(NameOfForm.hWnd, TitleOfProg)

'any number less than 1 indicates it could not find the title
'send result back
GetWinHwnd = Result

End Function

Public Function GetPerc(Number As Double, Optional Total As Variant)
'this function will calculate a percentage
'both parameters must be sent as double and returns integer

Dim TheTotal As Double, Result As Integer

If IsMissing(Total) Then 'check total is a number
    'default to work out percent is 100
    TheTotal = 100
Else 'convert total to a double
    TheTotal = CDbl(Total)
End If

If Not IsNumeric(Total) Then
    TheTotal = 100
End If

Result = Percent(Number, TheTotal)

End Function
Function UserLogon(Optional Title As Variant) As LogonType
'this function will display a default logon screen
'in scwl.dll.  When a programmer makes this call
'you should process userlogon.result first.  if result = 0
'then the user pressed ok else user pressed cancel

Dim ThisLogon As LogonType, TheTitle As String, ReturnString As String, Result As Integer

'buffer out returnstring
ReturnString = String(255, 0)

'check title
If IsMissing(Title) Then
    TheTitle = "Logon..."
Else
    'cant send blank string (i.e. "" ) else GPF will occur
    If Title = "" Then TheTitle = "Logon..."
    TheTitle = Title
End If

'make call to logon
Result = Logon(TheTitle, ReturnString)
If Result = -1 Then ''user cancelled
    ThisLogon.Result = -1
    UserLogon = ThisLogon
Else
    ThisLogon.Name = Left$(ReturnString, InStr(1, ReturnString, "#") - 1)
    ThisLogon.Password = Mid$(ReturnString, (InStr(1, ReturnString, "#") + 1), Result - (InStr(1, ReturnString, "#")))
    ThisLogon.Result = 0
    UserLogon = ThisLogon
End If

End Function




Public Function SpecifySystemMDA()
Dim Rt As String
Rt = OpenProc("Select Tel-PARS MDW File", "System Files (*.MDW)|*.mdw|" & AllFilter)
    If Rt = "" Then
        'End 'cant continue so end
    Else
        #If Win32 Then
            Rt = WriteMyIni(Left$(Inifile, (InStr(1, Inifile, ".") - 1)) & "\Engines\Jet", "SystemDB", UCase$(Rt))
        #Else
            Rt = WriteMyIni("Options", "SystemDB", CStr(Rt))
        #End If
    End If
End Function

Public Function SetPermissionsFull(DBase As String, Tble As String) As Integer
On Error GoTo SetPermissionsFullErr
SetPermissionsFull = 0
Dim PermissionDB As Database, PermissionDOC As Document
Set PermissionDB = DBEngine.Workspaces(WS.Name).OpenDatabase(DBase, True)
Set PermissionDOC = PermissionDB.Containers("Tables").Documents(Tble)
Debug.Print PermissionDOC.Permissions
PermissionDOC.UserName = "admin" 'WS.UserName
PermissionDOC.Permissions = dbSecFullAccess

SetPermissionsFullEP:
On Local Error Resume Next
PermissionDB.Close
Exit Function

SetPermissionsFullErr:
SetPermissionsFull = Err
MsgBox Error$ & Chr$(13) & Err
GoTo SetPermissionsFullEP

End Function

Public Function LastPath(ExtractFrom As String)
Dim ThisChar As String, RetStr As String, strStore As String
Dim I As Integer
'Returns the last folder/dir from a path statement from ExtractFrom
strStore = ExtractFrom
Do While Len(ExtractFrom) > 1
    ThisChar = Right$(strStore, 1)
    If Not ThisChar = "\" Then
        RetStr = ThisChar & RetStr
        strStore = Left$(strStore, Len(strStore) - 1)
    Else
        Exit Do
    End If
Loop
LastPath = RetStr


End Function

Public Function AddBack(PathToAddto As String) As String
'adds a backslash '\' to the string passed
Dim rtnstr As String
rtnstr = PathToAddto
If Not Right$(rtnstr, 1) = "\" Then rtnstr = rtnstr & "\"
AddBack = rtnstr
End Function

Public Sub mp(NewMousePointer As Integer)
Screen.MousePointer = NewMousePointer
DoEvents
End Sub

Public Function JustExtension(GetExtFrom As String) As String
Dim RetStr As String, I As Integer, ThisChar As String, ExtensionText As String
ExtensionText = GetExtFrom
For I = 1 To Len(GetExtFrom)
    ThisChar = Right$(ExtensionText, 1)
    ExtensionText = Left$(ExtensionText, Len(ExtensionText) - 1)
    If ThisChar = "." Then
        Exit For
    Else
        RetStr = ThisChar & RetStr
    End If
Next I
JustExtension = RetStr

End Function

Public Function JustFileName(FName As String) As String
Dim I As Integer, ThisFile As String
On Local Error Resume Next
ThisFile = FName
Do While InStr(1, ThisFile, "\") > 0
    ThisFile = Mid$(ThisFile, 2)
Loop
JustFileName = ThisFile
End Function
