Attribute VB_Name = "modSaver"
Option Explicit
Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type
Type Size
        cx As Long
        cy As Long
End Type

Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Declare Function SetTextColor Lib "gdi32" (ByVal hdc As Long, ByVal crColor As Long) As Long
Declare Function IsWindow Lib "user32" (ByVal hwnd As Long) As Long
Declare Function ReleaseDC Lib "user32" (ByVal hwnd As Long, ByVal hdc As Long) As Long
Declare Function GetWindowRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Declare Function TextOut Lib "gdi32" Alias "TextOutA" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal lpString As String, ByVal nCount As Long) As Long
Declare Function SetBkMode Lib "gdi32" (ByVal hdc As Long, ByVal nBkMode As Long) As Long
Declare Function GetTextExtentPoint Lib "gdi32" Alias "GetTextExtentPointA" (ByVal hdc As Long, ByVal lpszString As String, ByVal cbString As Long, lpSize As Size) As Long
Declare Function SetBkColor Lib "gdi32" (ByVal hdc As Long, ByVal crColor As Long) As Long
Declare Function CreateCompatibleBitmap Lib "gdi32" (ByVal hdc As Long, ByVal nWidth As Long, ByVal nHeight As Long) As Long
Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hdc As Long) As Long
Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long
Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Declare Function GetDesktopWindow Lib "user32" () As Integer
Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal xSrc As Integer, ByVal ySrc As Integer, ByVal dwRop As Long) As Integer
Declare Function OpenClipboard Lib "user32" (ByVal hwnd As Long) As Long
Declare Function CloseClipboard Lib "user32" () As Long
Declare Function SetClipboardData Lib "user32" (ByVal wFormat As Long, ByVal hMem As Long) As Long
Declare Function EmptyClipboard Lib "user32" () As Long

Public Const SRCCOPY = &HCC0020
   ' procedure for drawing to the preview window
Sub DoPreview(hwnd As Long)
      ' if we're already drawing exit
   If App.PrevInstance Then End
   Dim cr As Long, hdc As Long
   Dim r As Integer, g As Integer, b As Integer
   Dim rct As RECT, cxWnd As Integer, cyWnd As Integer
   Dim cx As Integer, cy As Integer, sz As Size
   Dim hDir As Boolean, vDir As Boolean
  Dim sDesc As String
      ' get the size of the window
   Call GetWindowRect(hwnd, rct)
   cxWnd = rct.Right - rct.Left
   cyWnd = rct.Bottom - rct.Top
      ' while we need to draw
   While IsWindow(hwnd)
         ' get and initialize hdc of prev window
      hdc = GetDC(hwnd)
      r = Rnd * 255
      g = Rnd * 255
      b = Rnd * 255
      cr = RGB(r, g, b)
      cr = SetTextColor(hdc, cr)
      Call SetBkMode(hdc, 2)
      Call SetBkColor(hdc, RGB(0, 0, 0))
         ' get text we need to write and size of text
      sDesc = GetSetting("VBSaver", "Settings", "Text", "VB Saver Example")
      Call GetTextExtentPoint(hdc, sDesc, Len(sDesc), sz)
         ' calculate position and direction
      If cx + sz.cx > cxWnd Then
         hDir = False
      Else
         If cx < 10 Then
            hDir = True
         End If
      End If
     If cy + sz.cy > cyWnd Then
         vDir = False
      Else
         If cy < 10 Then
            vDir = True
         End If
      End If
      cx = cx + IIf(hDir, 1, -1)
      cy = cy + IIf(vDir, 1, -1)
         ' draw text in window
       Call TextOut(hdc, cx, cy, sDesc, Len(sDesc))
       Call ReleaseDC(hwnd, hdc)
         ' check for any events
      DoEvents
    Wend
   End
End Sub
Sub main()
   Dim iPos As Integer
   iPos = InStr(LCase$(Command$), "p")
      ' if preview
   If iPos > 0 Then
      DoPreview (CLng(Mid$(Command$, iPos + 1)))
   Else
         ' if config
      If InStr(Command$, "c") Then
          frmConfig.Show
          Exit Sub
      End If
         ' else save the screen!!!
      frmSaver.Show
   End If
End Sub
