VERSION 4.00
Begin VB.Form Form1 
   Caption         =   "Classes & Collections Demo"
   ClientHeight    =   6030
   ClientLeft      =   2445
   ClientTop       =   1620
   ClientWidth     =   6720
   Height          =   6435
   Left            =   2385
   LinkTopic       =   "Form1"
   ScaleHeight     =   6030
   ScaleWidth      =   6720
   Top             =   1275
   Width           =   6840
   Begin VB.CommandButton cmdEdit 
      Caption         =   "Edit"
      Height          =   405
      Left            =   5580
      TabIndex        =   10
      Top             =   2310
      Width           =   975
   End
   Begin VB.CommandButton cmdDelete 
      Caption         =   "Delete"
      Height          =   405
      Left            =   5580
      TabIndex        =   9
      Top             =   2700
      Width           =   975
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   405
      Left            =   5640
      TabIndex        =   5
      Top             =   5610
      Width           =   975
   End
   Begin VB.TextBox txtYearBorn 
      Height          =   300
      Left            =   3690
      TabIndex        =   3
      Top             =   330
      Width           =   675
   End
   Begin VB.CommandButton cmdSave 
      Caption         =   "Save"
      Height          =   405
      Left            =   5550
      TabIndex        =   4
      Top             =   390
      Width           =   975
   End
   Begin VB.TextBox txtLastName 
      Height          =   300
      Left            =   2040
      TabIndex        =   2
      Top             =   330
      Width           =   1485
   End
   Begin VB.TextBox txtFirstName 
      Height          =   300
      Left            =   450
      TabIndex        =   1
      Top             =   330
      Width           =   1365
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "First Name"
      Height          =   195
      Left            =   720
      TabIndex        =   8
      Top             =   90
      Width           =   750
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Year Born"
      Height          =   195
      Left            =   3630
      TabIndex        =   7
      Top             =   90
      Width           =   705
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Last Name"
      Height          =   195
      Left            =   2310
      TabIndex        =   6
      Top             =   90
      Width           =   765
   End
   Begin MSGrid.Grid grdNames 
      Height          =   4245
      Left            =   60
      TabIndex        =   0
      Top             =   1440
      Width           =   5415
      _version        =   65536
      _extentx        =   9551
      _extenty        =   7488
      _stockprops     =   77
      backcolor       =   16777215
      scrollbars      =   2
      mouseicon       =   "DEMO.frx":0000
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
'***********************************************************
' Purpose: Demonstrate use of classes and collections.
' Author: Bob Roth, QNE International

Option Explicit

'***************************************************
'-- Collections
    Dim colNames As New Collection      '-- will contain all the names
    Dim colDeletes As New Collection    '-- will contain all the deleted names
'***************************************************
'-- Database & tables
    Dim dbBiblio As Database
   ' Dim tblAuthors As Table

'-- Globals
    Dim vCurrentId As Variant
    
'-- Constants for testing
    Const TEST = False
    Const LOAD_TIME = False

'*************************************************
' Purpose:  Delete the marked grid row
Private Sub cmdDelete_Click()
    If grdNames.Row <= 0 Then
        MsgBox "No record selected"
        Exit Sub
    End If
    
'-- object for adding a class to the deleted records collection
    Dim Obj As New Names
    
'-- add a class to the deleted records collection
    If colNames(grdNames.Row).lAu_Id > 0 Then
        Obj.lAu_Id = colNames(grdNames.Row).lAu_Id
        colDeletes.Add Obj, GetIDNumber()
    End If
    
'-- remove the class from the collection
    colNames.Remove grdNames.Row
    
'-- remove the line from the grid
    grdNames.RemoveItem grdNames.Row
    Call LoadGrid
End Sub

Private Sub cmdEdit_Click()
    If grdNames.Row <= 0 Then
        MsgBox "No record selected"
        Exit Sub
    End If
        
    '-- load the class into the text boxes
      txtLastName = colNames(grdNames.Row).sLastName
      txtFirstName = colNames(grdNames.Row).sFirstName
      txtYearBorn = CStr(colNames(grdNames.Row).iYearBorn)
    
    '-- save Id Number of class
        vCurrentId = colNames(grdNames.Row).sIDNo
    
    '-- remove the line from the grid
        grdNames.RemoveItem grdNames.Row
End Sub

'****************************************************
' Purpose:  Exit the program and update the database
Private Sub cmdExit_Click()
    Dim Obj As Object
    Dim mySQL As String

'-- Delete the records in the delete collection
    For Each Obj In colDeletes
        If Obj.lAu_Id > 0 Then
            mySQL = "DELETE * FROM Authors where Au_Id = " & Obj.lAu_Id
            dbBiblio.Execute mySQL, dbFailOnError
        End If
    Next
    
'-- clear the collection
    Set colDeletes = Nothing
    
    For Each Obj In colNames
    '-- only need to and/or add update the changed items
        If Obj.bUpdatedFlag = True And Obj.lAu_Id > 0 Then  '-- changed if Au_Id > 0
            mySQL = "Update Authors  Set Author = "
            mySQL = mySQL & Chr(34) & Obj.CreateName & Chr(34)
            mySQL = mySQL & " , [Year Born] = " & Obj.iYearBorn
            mySQL = mySQL & " Where Au_Id = " & Obj.lAu_Id
            dbBiblio.Execute mySQL, dbFailOnError
        ElseIf Obj.bUpdatedFlag = True And Obj.lAu_Id = 0 Then    '-- new record
            mySQL = "INSERT INTO authors (Author,[Year Born])"
            mySQL = mySQL & " VALUES (" & Chr(34) & Obj.CreateName & Chr(34)
            mySQL = mySQL & ", " & Obj.iYearBorn & ")"
            dbBiblio.Execute mySQL, dbFailOnError
        End If
    Next
    Set colNames = Nothing
    End
End Sub


Private Sub cmdSave_Click()
    Dim Obj As New Names
    Dim vBeginTime  As Variant
    Dim vEndTime  As Variant

'-- if editing an entry
    If vCurrentId <> "" Then
        colNames(vCurrentId).sLastName = StrConv(txtLastName, vbProperCase)
        colNames(vCurrentId).sFirstName = StrConv(txtFirstName, vbProperCase)
        colNames(vCurrentId).iYearBorn = Val(txtYearBorn)
        colNames(vCurrentId).bUpdatedFlag = True

'-- if new entry
    Else
        With Obj
            .sLastName = StrConv(txtLastName, vbProperCase)
            .sFirstName = StrConv(txtFirstName, vbProperCase)
            .iYearBorn = Val(txtYearBorn)
            .bUpdatedFlag = True
            .sIDNo = GetIDNumber()
        End With
  '  vBeginTime = Timer
        
        Call AddToCollection(Obj)
    End If
    
    txtLastName = ""
    txtFirstName = ""
    txtYearBorn = ""
    
    Call LoadGrid
'    vEndTime = Timer
'        MsgBox "Add to collection time = " & vEndTime - vBeginTime
    
    vCurrentId = ""
End Sub

Private Sub Form_Load()
    Set dbBiblio = Workspaces(0).OpenDatabase("c:\vb\biblio.mdb")
    grdNames.Cols = 3
    grdNames.Rows = 1
    grdNames.ColWidth(0) = 2000
    grdNames.ColWidth(1) = 2000
    grdNames.ColWidth(2) = 800
    grdNames.Width = 4800
    grdNames.FixedCols = 0
    Call LoadCollection

End Sub

'*******************************************************************
' Purpose:  Load the records into a sorted collection
Private Sub LoadCollection()
    Dim sWork As String
    Dim clsNames As New Names
    Dim rsSelect As Recordset
    Dim dBeginTime As Variant
    Dim dEndTime As Variant
    Dim Msg As String
    Dim iCount As Integer
    Dim sFirstName As String
    Dim sLastName As String
    Dim i As Integer
    Dim sName As String
    
    Dim sAdd As String
    If LOAD_TIME = True Then dBeginTime = Timer
    sWork = "Select * from AUTHORS where Au_Id > 0"
    
    If TEST = True Then sWork = sWork & " order by Author "
    
    Set rsSelect = dbBiblio.OpenRecordset(sWork, dbOpenDynaset)
    Do While Not rsSelect.EOF
    
    If TEST = True Then
        sName = Trim(rsSelect!author)
        i = InStr(sName, ",")
        If i > 0 Then
            sLastName = Mid(sName, 1, i - 1)
            sFirstName = Trim(Mid(sName, i + 1))
        Else
            i = InStr(sName, " ")
            If i > 0 Then
                sLastName = Mid(sName, 1, i - 1)
                sFirstName = Trim(Mid(sName, i + 1))
            End If
        End If
        sAdd = ""
        sAdd = sFirstName & vbTab
        sAdd = sAdd & sLastName & vbTab
        If Not IsNull(rsSelect![year born]) Then sAdd = sAdd & Trim(Str(rsSelect![year born]))
        grdNames.AddItem sAdd
    Else
        With clsNames
           .lAu_Id = rsSelect!au_id
            .ParseName (rsSelect!author)
            If Not IsNull(rsSelect![year born]) Then
                .iYearBorn = rsSelect![year born]
            Else
                .iYearBorn = 0
            End If
            .sIDNo = GetIDNumber()
            Call AddToCollection(clsNames)
            iCount = iCount + 1
        End With
        Set clsNames = Nothing
    End If
        rsSelect.MoveNext
    Loop
    
    If TEST <> True Then Call LoadGrid
    If LOAD_TIME = True Then
        dEndTime = Timer
        Msg = "Elapsed seconds: " & dEndTime - dBeginTime & vbCrLf _
            & "Number of records: " & iCount
        MsgBox Msg
    End If
End Sub

'*****************************************************************
' Purpose:  Add to collection in name sort
' Input:    class to add
Private Sub AddToCollection(clsAdd As Names)
        Dim iCount As Integer
        Dim iStart As Integer
        Dim iIncrement As Integer
        Dim iList As Integer
        Dim iPoint As Integer
        Dim iBegin As Integer
        Dim iEnd As Integer
        Dim iBase As Integer
        
        iCount = colNames.Count
            
    '-- collection is empty
         If iCount = 0 Then
            colNames.Add clsAdd, clsAdd.sIDNo
            Exit Sub
        End If
    '-- first and last sequence cases
        If UCase(clsAdd.sLastName) <= UCase(colNames(1).sLastName) Then
            If UCase(clsAdd.sFirstName) >= UCase(colNames(1).sFirstName) Then
                colNames.Add clsAdd, clsAdd.sIDNo, after:=1
            Else
                colNames.Add clsAdd, clsAdd.sIDNo, before:=1
            End If
            Exit Sub
        ElseIf UCase(clsAdd.sLastName) >= UCase(colNames(iCount).sLastName) Then
            colNames.Add clsAdd, clsAdd.sIDNo, after:=iCount
            Exit Sub
        End If
    
    '-- insert in collection using binary search
        iStart = iCount / 2
        iBase = 1
        iEnd = iCount
        iStart = 1
        iList = (iEnd - iBase) / 2
    
    Do While 1
    '-- decide which way to move the bracket
        '-- name to be inserted < list entry
        If UCase(clsAdd.sLastName) > UCase(colNames(iList).sLastName) Then
            iBase = iList
        '-- name to be inserted > list entry
       
        ElseIf UCase(clsAdd.sLastName) < UCase(colNames(iList).sLastName) Then
            iEnd = iList
        '-- name to be inserted = list entry
        ElseIf UCase(clsAdd.sLastName) = UCase(colNames(iList).sLastName) Then
            If UCase(clsAdd.sFirstName) >= UCase(colNames(iList).sFirstName) Then
                    colNames.Add clsAdd, clsAdd.sIDNo, after:=iList
                Else
                    colNames.Add clsAdd, clsAdd.sIDNo, before:=iList
            End If
            Exit Do
        End If
        '-- test for name to be inserted between two names in list
        If UCase(clsAdd.sLastName) > UCase(colNames(iList).sLastName) _
            And UCase(clsAdd.sLastName) < UCase(colNames(iList + 1).sLastName) Then
            '-- last names the same
                If UCase(clsAdd.sLastName) = UCase(colNames(iList).sLastName) Then
                    If UCase(clsAdd.sFirstName) >= UCase(colNames(iList).sFirstName) Then
                        colNames.Add clsAdd, clsAdd.sIDNo, after:=iList
                    Else
                        colNames.Add clsAdd, clsAdd.sIDNo, before:=iList
                    End If
                Else
                    colNames.Add clsAdd, clsAdd.sIDNo, after:=iList
                End If
            Exit Do
        End If
        iList = iEnd - (iEnd - iBase) / 2   '-- split the bracket and try again
    Loop
End Sub
'*****************************************************************
' Purpose: Load the collection of names
Private Sub LoadGrid()
    Dim sAdd As String
    Dim Obj As New Names
    grdNames.Rows = 1
    grdNames.Col = 0
    grdNames.Text = "First Name"
    grdNames.Col = 1
    grdNames.Text = "Last Name"
    grdNames.Col = 2
    grdNames.Text = "Yr Brn"
    For Each Obj In colNames
        With Obj
            sAdd = ""
            sAdd = .sFirstName & vbTab
            sAdd = sAdd & .sLastName & vbTab
            sAdd = sAdd & Trim(Str(.iYearBorn))
            grdNames.AddItem sAdd
            If grdNames.Row = 0 Then grdNames.FixedRows = 1
        End With
    Next
End Sub
'*****************************************************************
' Purpose:  Assign an idnumber to the class
Private Function GetIDNumber() As String
    Static iID As Integer
    iID = iID + 1
    GetIDNumber = Format(iID, "00000")
End Function

