Attribute VB_Name = "I2CVB"
   ' **************************************************************************
   ' * ICee95  I2C Bus Driver Version 1.01  For Windows 95 / Vb 4             *
   ' * (c) 1995-1997 Vincent Himpe   All Rights Reserved                      *
   ' * Features  ICee Debugger                                                *
   ' * Released as PUBLIC DOMAIN. Use as you please                           *
   ' *                                                                        *
   ' * This driver is intended for VISUAL Basic version 4.0                   *
   ' * Although it might also run on older                                    *
   ' **************************************************************************
   ' * ICee Debugger.                                                         *
   ' *                                                                        *
   ' * use the command ICEE.Show to pop up the debug window                   *
   ' **************************************************************************

   Global I2Cdta(10), Iceebreak, ICeeTraceSize
   Global I2Cloport, I2Cmidport, I2CHiPort, I2Csavedstatus, scl, SDA
   Global i2cdebug, I2Ctimeout, I2Cdevadr%, i2cresult%, hold

   Sub delay(count)

       ' Notice about this routine.
       ' this routine inserts a delay loop .
       ' VISUAL basic lacks the feature of a microtimer.
       ' There are cleaner approches to do this but this works just fine.
       ' the parameter of 1000 is fine on a 486 DX2-66

       For a = 0 To (count * 1000)   ' adapt this value according to the speed of the CPU
       Next a
   End Sub

   Sub holdsystem() ' Freezes the system so you can read ICee debugger messages
       ' This is a relic from the DOS based drivers.
       ' Under Windows you are responsible for popping up the debugger.

       Call iceemessage(" Press any key to continue ... ")
       DoEvents
       DoEvents
   End Sub

   Sub I2Cclose() ' Closes the I2C driver. This resets the parallel port
       out I2CHiPort, I2Csavedstatus
       out I2Cloport, 127           ' set sda hi all others high (VCC for opto)
       iceemessage "ICee SYS003 :I2C Bus closed "
   End Sub

   Sub I2Cgenstart() ' transmits a start condition
       If i2cdebug = 1 Then
          Call iceemessage("ICee MSG001:  Generating START on bus ")
       End If
       '  start of transmission
       out I2Cloport, 127    ' sda high
       delay hold
       out I2CHiPort, 8    ' scl high
       delay hold
       out I2Cloport, 255  ' sda lo
       delay hold
       out I2Cloport, 255  ' sda lo
       delay hold
       out I2CHiPort, 0    ' scl lo
       delay hold
   End Sub

   Sub I2Cgenstop() ' transmits a stop on the bus
       If i2cdebug = 1 Then
          Call iceemessage("ICee MSG002:  Generating STOP on bus ")
       End If
       out I2Cloport, 255 ' sda lo
       delay hold
       out I2Cloport, 255 ' sda lo
       delay hold
       out I2CHiPort, 8   ' scl hi
       delay hold
       out I2CHiPort, 8   ' scl hi
       delay hold
       out I2Cloport, 127 ' sda hi
       delay hold
       ' // end of stransmission
   End Sub

   Sub I2Cgiveack() ' Gives an ACK to a slave
       out I2CHiPort, 0   ' scl low
       delay hold
       out I2Cloport, 255 ' sda low
       delay hold
       out I2CHiPort, 8   ' scl hi
       delay hold
       out I2CHiPort, 0   ' scl low
       delay hold
       out I2Cloport, 127 ' sda high
       delay hold
       If i2cdebug = 1 Then
       iceemessage "Giving ACK"
       End If

   End Sub

   Sub I2Cinit(timeout) ' aborts transmission and clears bus
       For I2Ca% = 0 To 5
           out I2Cloport, 255 ' set SDA low
           delay hold
           out I2CHiPort, 8   ' set SCL HI
           delay hold
           out I2Cloport, 127 ' bring SDA HIGH
           delay hold
           out I2CHiPort, 0   ' bring SCL Low
           delay hold
       Next I2Ca%
       I2Ctimeout = timeout
       out I2CHiPort, 8
       delay hold
       If i2cdebug = 1 Then
          iceemessage "ICee SYS001: I2C port initialised. Bus cleared and released"
       End If
   End Sub

   Sub I2Cmultiread(adr%, count%) ' performs a multiread from a slave
       adr% = (adr% Or 1) 'make shure adress is odd
       I2Cdevadr% = adr%
       Call I2Cgenstart
       Call I2Ctransmit(adr%)
       Call I2Cwaitforack
       I2Cdevadr% = 0
       For internalloop% = 0 To count%
           Call I2Creceive
           If internalloop% < count% Then ' prevent giving ack on last byte
              Call I2Cgiveack
           End If
           I2Cdta(internalloop%) = i2cresult%
       Next internalloop%
       Call I2Cgenstop
   End Sub

   Sub I2Copen(port%, dbug%) ' Always call this before any other routines !
       Select Case port%
          Case 0
               I2Cloport = &H378
               I2Cmidport = &H379
               I2CHiPort = &H37A
          Case 1
               I2Cloport = &H278
               I2Cmidport = &H279
               I2CHiPort = &H27A

          Case 2
               I2Cloport = &H3BC
               I2Cmidport = &H3BD
               I2CHiPort = &H3BE
       End Select
       I2Csavedstatus = inp(I2CHiPort)
       If dbug% = 1 Then
          i2cdebug = 1
          Else
          i2cdebug = 0
       End If
       If i2cdebug = 1 Then
          iceemessage "ICee SYS002: I2C bus opened on adress " + Hex$(I2Cloport) + "h"
       End If
   End Sub

   Sub I2Cpob() ' puts bits on the bus
       If SDA = 1 Then
          out I2Cloport, 127
          delay hold
       Else
          out I2Cloport, 255
          delay hold
       End If
       If scl = 1 Then
          out I2CHiPort, 8
          delay hold
       Else
          out I2CHiPort, 0
          delay hold
       End If
       If i2cdebug = 1 Then
       End If
   End Sub

   Function I2Cread(adr%) ' reads a byte out of a slave
       adr% = (adr% Or 1) ' make shure adress is odd
       I2Cdevadr% = adr%
       Call I2Cgenstart
       Call I2Ctransmit(adr%)
       Call I2Cwaitforack
       I2Cdevadr% = 0
       Call I2Creceive
       Call I2Cgiveack
       Call I2Cgenstop
       I2Cread = i2cresult%
   End Function

   Sub I2Creceive() ' receives a byte from a slave
       i2cresult% = 0
       out I2Cloport, 127 ' release sda
       delay hold
       For I2Ca% = 7 To 0 Step -1
           I2Cb% = 2 ^ I2Ca%
           out I2CHiPort, 8
           delay hold
           I2Cin% = (inp&(I2Cmidport) And 128)
           out I2CHiPort, 0
           delay hold
           If I2Cin% = 128 Then
              i2cresult% = i2cresult% + I2Cb%
            '  Print "1";
              Else
            '  Print "0";
           End If
          
       Next I2Ca%
       ' Print
       If i2cdebug = 1 Then
          iceemessage "ICee MSG005:  Receiving data from slave :" + Right$("00" + Hex$(i2cresult%), 2) + "h"
       End If

   End Sub

   Sub I2Csettimeout(tme)   ' assigns a timeout value
       I2Ctimeout = tme
   End Sub

   Sub I2Ctransmit(dta%)   ' transmits a byte on the bus
       If i2cdebug = 1 Then
          Call iceemessage("ICee MSG004:  Transmitting data byte on bus ")
       End If
       I2Ca% = 0
       For I2Ca% = 7 To 0 Step -1
           I2Cb% = 2 ^ I2Ca%
           If (dta% And I2Cb%) = I2Cb% Then
              out I2Cloport, 127
              delay hold
           Else
              out I2Cloport, 255
              delay hold
           End If
           out I2CHiPort, 8
           delay hold
           out I2CHiPort, 0
           delay hold
        Next I2Ca%
       out I2Cloport, 127   ' release sda
       delay hold
   End Sub

   Sub I2Cwaitforack()    ' waits for slave acknowledge
       If i2cdebug = 1 Then
          Call iceemessage("ICee MSG003:  Waiting for ACKNOWLEDGE ")
       End If
       out I2Cloport, 127    ' maak SDa hi
       out I2Cloport, 127
       delay hold
       out I2CHiPort, 8    ' maak scl hi
       out I2CHiPort, 8
       delay hold
       acknowledge = 0
       acktimer = 0
       While acknowledge = 0
             acktimer = acktimer + 1
             I2Cmon = (inp&(I2Cmidport) And 128)
             If I2Cmon <> 128 Then
                acknowledge = 1
             End If
             If acktimer = I2Ctimeout Then
                acknowledge = 1
                If I2Cdevadr% <> 0 Then
                       If i2cdebug = 1 Then
                          Call iceemessage("ICee ERR001:  Device is not responding ")
                          
                         Else
                          Beep
                       End If
                   Else
                       If i2cdebug = 1 Then
                          Call iceemessage("ICee ERR002:  No ACK received")
                          
                       Else
                          Beep
                       End If
                End If
             End If
       Wend
       out I2Cloport, 127    ' maak SDa hi
       out I2Cloport, 127
       delay hold
       out I2CHiPort, 0   ' maak scl LO
       out I2CHiPort, 0
       delay hold
   End Sub

   Sub I2Cwrite(adr%, dta%)   ' writes a byte to a slave
       adr% = (adr% And 254) 'make shure adress is even
       I2Cdevadr% = adr%
       Call I2Cgenstart
       Call I2Ctransmit(adr%)
       Call I2Cwaitforack
       I2Cdevadr% = 0
       Call I2Ctransmit(dta%)
       Call I2Cwaitforack
       Call I2Cgenstop
   End Sub

   Function I2Cwwread(adr%, sbadr%)   ' reads with subadress
       adr% = (adr% Or 1) '  make shure adr is odd
       I2Cdevadr% = adr%
       Call I2Cgenstart
       Call I2Ctransmit(adr%)
       Call I2Cwaitforack
       I2Cdevadr% = 0
       Call I2Ctransmit(sbadr%)
       Call I2Cwaitforack
       Call I2Cgenstart
       adr% = adr% + 1
       Call I2Ctransmit(adr%)
       Call I2Creceive
       Call I2Cgenstop
       I2Cwwread = i2cresult%
   End Function

   Sub I2Cwwsend(adr%, sbadr%, dta%)   ' writes with subadress
       adr% = (adr% And 254) '  make shure addr is even
       I2Cdevadr% = adr%
       Call I2Cgenstart
        Call I2Ctransmit(adr%)
       Call I2Cwaitforack
       I2Cdevadr% = 0
       Call I2Ctransmit(sbadr%)
       Call I2Cwaitforack
       Call I2Ctransmit(dta%)
       Call I2Cwaitforack
       Call I2Cgenstop
   End Sub

   Sub ICEEdebugoff() ' Turns off the I2C debugger
       Call iceemessage("ICee95 V1.01 : debugger  DISABLED ")
       i2cdebug = 0
   End Sub

   Sub ICEEdebugon() ' Turns the debugger on
       Call iceemessage("ICee Debugger ENABLED ")
       i2cdebug = 1
   End Sub

   Sub iceemessage(dta$)    ' appends the messages to the debug window
      If i2cdebug = 1 Then
          If Len(dta$) < 50 Then
            dta$ = dta$ + Space$(50 - Len(dta$))
          End If
          ttext$ = ICee.I2Cmonitor.Text
          ttext$ = ttext$ + Chr$(13) + Chr$(10) + dta$
          If Int(Len(ttext$) / 50) > ICeeTraceSize Then
           cutpoint = InStr(ttext$, Chr$(13))
           cutpoint = cutpoint + 1
           ttext$ = Right$(ttext$, Len(ttext$) - cutpoint)
           
           DoEvents
          End If
          ICee.I2Cmonitor.Text = ttext$
          If Iceebreak = True Then
           If Left$(dta$, 8) = "ICee ERR" Then
              ' stop system
              tmpdta$ = "Error trapped" + Chr$(13) + Chr$(10) + dta$
              MsgBox tmpdta$, 16, "ICee Bus Monitor"
           End If
          End If

      End If
   End Sub

