VERSION 5.00
Begin VB.Form frmBlt 
   AutoRedraw      =   -1  'True
   Caption         =   "Transparent Blit"
   ClientHeight    =   3195
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   MousePointer    =   99  'Custom
   ScaleHeight     =   3195
   ScaleWidth      =   4680
   StartUpPosition =   2  'CenterScreen
   Visible         =   0   'False
   WindowState     =   2  'Maximized
End
Attribute VB_Name = "frmBlt"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Transparent Blit
Option Compare Text
Option Explicit

' Win32
Const IMAGE_BITMAP = 0
Const LR_LOADFROMFILE = &H10
Const LR_CREATEDIBSECTION = &H2000
Const SRCCOPY = &HCC0020
Private Type BITMAP
        bmType          As Long
        bmWidth         As Long
        bmHeight        As Long
        bmWidthBytes    As Long
        bmPlanes        As Integer
        bmBitsPixel     As Integer
        bmBits          As Long
End Type

' GDI32
Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Private Declare Function GetObject Lib "gdi32" Alias "GetObjectA" (ByVal hObject As Long, ByVal nCount As Long, lpObject As Any) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
' USER32
Private Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function LoadImage Lib "user32" Alias "LoadImageA" (ByVal hInst As Long, ByVal lpsz As String, ByVal un1 As Long, ByVal n1 As Long, ByVal n2 As Long, ByVal un2 As Long) As Long
Private Declare Function StretchBlt Lib "gdi32" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal dwRop As Long) As Long

'****************** Old starfld code
Private Declare Function SetPixel Lib "gdi32" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal crColor As Long) As Long
Private Declare Function ShowCursor Lib "user32" (ByVal bShow As Long) As Long
Const NumberOfStars = 50    ' Number of stars
Const ResolutionX = 320     ' Width for the display mode
Const ResolutionY = 200     ' Height for the display mode

Dim dd As DirectDraw2               ' DirectDraw object
Dim ddsdFront As DDSURFACEDESC      ' Front surface description
Dim ddsFront As DirectDrawSurface2  ' Front buffer
Dim ddsBack As DirectDrawSurface2   ' Back buffer

Dim ddCaps As DDSCAPS               ' Capabilities for search
Dim lhdc As Long                    ' hDC for back buffer

Dim i As Long
Dim fx As DDBLTFX

Dim blnEnd As Boolean

Private Type TStar
    x As Single     ' x !
    y As Single     ' y !
    Color As Byte   ' Color (intensity)
End Type

Dim aStars(1 To NumberOfStars) As TStar
Dim aDDS(0 To 32) As DirectDrawSurface2 ' Images to blit

' Loads a bitmap in a DirectDraw surface
Private Function CreateDDSFromBitmap(dd As DirectDraw2, ByVal strFile As String) As DirectDrawSurface2
    Dim hbm As Long                 ' Handle on bitmap
    Dim bm As BITMAP                ' Bitmap header
    Dim ddsd As DDSURFACEDESC       ' Surface description
    Dim dds As DirectDrawSurface2   ' Created surface
    Dim hdcImage As Long            ' Handle on image
    Dim lhdc As Long                ' Handle on surface context
    ' Load bitmap
    hbm = LoadImage(ByVal 0&, strFile, IMAGE_BITMAP, 0, 0, LR_LOADFROMFILE Or LR_CREATEDIBSECTION)
    ' Get bitmap info
    GetObject hbm, Len(bm), bm
    ' Fill surface description
    With ddsd
        .dwSize = Len(ddsd)
        .dwFlags = DDSD_CAPS Or DDSD_HEIGHT Or DDSD_WIDTH
        .DDSCAPS.dwCaps = DDSCAPS_OFFSCREENPLAIN
        .dwWidth = bm.bmWidth
        .dwHeight = bm.bmHeight
    End With
    ' Create surface
    dd.CreateSurface ddsd, dds, Nothing
    ' Create memory device
    hdcImage = CreateCompatibleDC(ByVal 0&)
    ' Select the bitmap in this memory device
    SelectObject hdcImage, hbm
    ' Restore the surface
    dds.Restore
    ' Get the surface's DC
    dds.GetDC lhdc
    ' Copy from the memory device to the DirectDrawSurface
    StretchBlt lhdc, 0, 0, ddsd.dwWidth, ddsd.dwHeight, hdcImage, 0, 0, bm.bmWidth, bm.bmHeight, SRCCOPY
    ' Release the surface's DC
    dds.ReleaseDC lhdc
    ' Release the memory device and the bitmap
    DeleteDC hdcImage
    DeleteObject hbm
    ' Returns the new surface
    Set CreateDDSFromBitmap = dds
End Function


Private Sub Form_Load()
    ' Initial stars
    Dim i As Long
    For i = 1 To NumberOfStars
        With aStars(i)
            .x = Rnd * ResolutionX \ 2 - ResolutionX \ 4
            .y = Rnd * ResolutionY \ 2 - ResolutionY \ 4
            .Color = Rnd * 20 + 50
        End With
    Next
    ShowCursor 0
    ' Create the DirectDraw object
    DirectDrawCreate ByVal 0&, dd, Nothing
    ' This app is full screen and will change the display mode
    dd.SetCooperativeLevel Me.hwnd, DDSCL_EXCLUSIVE Or DDSCL_FULLSCREEN
    ' Set the display mode
    dd.SetDisplayMode ResolutionX, ResolutionY, 8, 0, 0
    ' Load images (in a real app don't load the surrounding empty space !)
    For i = 0 To 32
        Set aDDS(i) = CreateDDSFromBitmap(dd, App.Path & "\EXPL" & Format$(i, "00") & ".BMP")
    Next
    ' Fill front buffer description structure...
    With ddsdFront
        ' Structure size
        .dwSize = Len(ddsdFront)
        ' Use DDSD_CAPS and BackBufferCount
        .dwFlags = DDSD_CAPS Or DDSD_BACKBUFFERCOUNT
        ' Primary, flipable surface
        .DDSCAPS.dwCaps = DDSCAPS_PRIMARYSURFACE Or DDSCAPS_FLIP Or DDSCAPS_COMPLEX Or DDSCAPS_SYSTEMMEMORY
        ' One back buffer (you can try 2)
        .dwBackBufferCount = 1
    End With
    ' Create front buffer
    dd.CreateSurface ddsdFront, ddsFront, Nothing
    
    ' Retrieve the back buffer object
    ddCaps.dwCaps = DDSCAPS_BACKBUFFER
    ddsFront.GetAttachedSurface ddCaps, ddsBack
    
    'Render loop
    While Not blnEnd
        DrawNextFrame
        DoEvents
    Wend
    Unload Me
End Sub

' Draw next frame
Private Sub DrawNextFrame()
    Dim t As RECT
    Static Tick As Integer
    On Error Resume Next
    
    ' Clear the back buffer
    With fx
        .dwSize = Len(fx)
        .dwFillColor = RGB(0, 0, 0)
    End With
    t.Top = 0
    t.Left = 0
    t.bottom = ResolutionY
    t.Right = ResolutionX
    ddsBack.Blt t, Nothing, t, DDBLT_COLORFILL, fx
    
    ' Plot the stars (get and release the backbuffer DC)
    ' (in a real app, retrieve the pixel format and work directly on the surface !)
    ddsBack.GetDC lhdc
    If Err = 0 Then
        For i = 1 To NumberOfStars
            With aStars(i)
                SetPixel lhdc, ResolutionX \ 2 + .x, ResolutionY \ 2 + .y, RGB(.Color, .Color, .Color)
            End With
        Next
        ddsBack.ReleaseDC lhdc
    End If
    Tick = (Tick + 1) Mod 33
    ' Restore (not needed ?)
    aDDS(Tick).Restore
    t.Top = 0
    t.Left = 0
    t.bottom = 200
    t.Right = 320
    ' Set the transparent color
    fx.ddckSrcColorkey.dwColorSpaceHighValue = 0
    fx.ddckSrcColorkey.dwColorSpaceLowValue = 0
    fx.dwSize = Len(fx)
    ' Blit the image to the back buffer
    ddsBack.Blt t, aDDS(Tick), t, DDBLT_KEYSRCOVERRIDE, fx
    If Err.Number <> 0 Then
        ' Just in case
        Stop
    End If
    ' Flip the buffers
    Do
        ddsFront.Flip Nothing, 0
        If Err.Number = DDERR_SURFACELOST Then ddsFront.Restore
    Loop Until Err.Number = 0
    
    ' Prepare the stars for the next frame
    For i = 1 To NumberOfStars
        With aStars(i)
            .x = .x * 1.2
            .y = .y * 1.2
            .Color = .Color * 1.2
            If Abs(.x) > ResolutionX \ 2 Or Abs(.y) > ResolutionY \ 2 Then
                .x = Rnd * ResolutionX \ 2 - ResolutionX \ 4
                .y = Rnd * ResolutionY \ 2 - ResolutionY \ 4
                .Color = Rnd * 20 + 50
            End If
        End With
    Next
    Exit Sub
End Sub
' Unload the form
Private Sub Form_KeyPress(KeyAscii As Integer)
    blnEnd = True
End Sub
' Release DirectDraw objects
Private Sub Form_Unload(Cancel As Integer)
    For i = 0 To 32
        Set aDDS(i) = Nothing
    Next
    dd.FlipToGDISurface
    dd.RestoreDisplayMode
    dd.SetCooperativeLevel 0, DDSCL_NORMAL
    Set ddsBack = Nothing
    Set ddsFront = Nothing
    Set dd = Nothing
    ShowCursor 1
End Sub
