VERSION 5.00
Begin VB.Form frmDXTZ 
   BackColor       =   &H00000000&
   Caption         =   "DirectX Test Zone"
   ClientHeight    =   3195
   ClientLeft      =   165
   ClientTop       =   450
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   200
   ScaleMode       =   0  'User
   ScaleWidth      =   320
   StartUpPosition =   3  'Windows Default
End
Attribute VB_Name = "frmDXTZ"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Const Pi = 3.1415927

Dim D3DRM As Direct3DRM
Dim Scene As Direct3DRMFrame
Dim Camera As Direct3DRMFrame
Dim Clipper As DirectDrawClipper
Dim Device As Direct3DRMDevice
Dim Viewport As Direct3DRMViewPort
Dim LightFrame As Direct3DRMFrame
Dim WorldFrame As Direct3DRMFrame
Dim Light As Direct3DRMLight
' Build a small world
Sub BuildWorld()
    Dim aVertices(0 To 8) As D3DVECTOR
    Dim aNormals(0) As D3DVECTOR
    Dim aFaces(1 To 31) As Long
    Dim MeshBuilder As Direct3DRMMeshBuilder
    Dim FaceArray As Direct3DRMFaceArray
    Dim Face As Direct3DRMFace
    Dim Texture As Direct3DRMTexture
    ' Floor vertices
    aVertices(0).x = -50
    aVertices(0).y = 0
    aVertices(0).z = -50
    aVertices(1).x = -50
    aVertices(1).y = 0
    aVertices(1).z = 50
    aVertices(2).x = 50
    aVertices(2).y = 0
    aVertices(2).z = 50
    aVertices(3).x = 50
    aVertices(3).y = 0
    aVertices(3).z = -50
    ' Ceiling vertices
    Dim i As Long
    For i = 0 To 3
        aVertices(4 + i) = aVertices(i)
        aVertices(4 + i).y = 10
    Next
    ' Floor
    aFaces(1) = 4
    aFaces(2) = 0
    aFaces(3) = 1
    aFaces(4) = 2
    aFaces(5) = 3
    ' Ceiling
    aFaces(6) = 4
    aFaces(7) = 7
    aFaces(8) = 6
    aFaces(9) = 5
    aFaces(10) = 4
    ' Front wall
    aFaces(11) = 4
    aFaces(12) = 1
    aFaces(13) = 5
    aFaces(14) = 6
    aFaces(15) = 2
    ' Left wall
    aFaces(16) = 4
    aFaces(17) = 0
    aFaces(18) = 4
    aFaces(19) = 5
    aFaces(20) = 1
    ' Right wall
    aFaces(21) = 4
    aFaces(22) = 2
    aFaces(23) = 6
    aFaces(24) = 7
    aFaces(25) = 3
    ' Back wall
    aFaces(26) = 4
    aFaces(27) = 3
    aFaces(28) = 7
    aFaces(29) = 4
    aFaces(30) = 0
    ' Terminator
    aFaces(31) = 0
    D3DRM.CreateMeshBuilder MeshBuilder
    MeshBuilder.AddFaces 8, aVertices(0), 0, aNormals(0), aFaces(1), Nothing
    ' Perspective-corrected
    MeshBuilder.SetPerspective 1
    MeshBuilder.GetFaces FaceArray
       
    ' Textured floor
    FaceArray.GetElement 0, Face
    D3DRM.LoadTexture App.Path & "\floor.bmp", Texture
    Face.SetTextureCoordinates 0, 0, 16
    Face.SetTextureCoordinates 1, 16, 16
    Face.SetTextureCoordinates 2, 16, 0
    Face.SetTextureCoordinates 3, 0, 0
    Face.SetTexture Texture
    
    ' Textured wall
    FaceArray.GetElement 2, Face
    ' I've written on the wall to find out the good orientation !
    D3DRM.LoadTexture App.Path & "\bricks.bmp", Texture
    Face.SetTextureCoordinates 0, 0, 0
    Face.SetTextureCoordinates 1, 0, 4
    Face.SetTextureCoordinates 2, 40, 4
    Face.SetTextureCoordinates 3, 40, 0
    Face.SetTexture Texture
    
    ' Left wall is red
    FaceArray.GetElement 3, Face
    Face.SetColorRGB 1, 0, 0
    
    ' Right wall is green
    FaceArray.GetElement 4, Face
    Face.SetColorRGB 0, 1, 0
    
    ' Back wall is blue
    FaceArray.GetElement 5, Face
    Face.SetColorRGB 0, 0, 1
    
    WorldFrame.AddVisual MeshBuilder
End Sub
' Camera movements
Private Static Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    Const Sin5 = 8.715574E-02!  ' Sin(5)
    Const Cos5 = 0.9961947!     ' Cos(5)
    On Error GoTo Form_KeyDown_Error
    Select Case KeyCode
        ' Rotate left
        Case vbKeyLeft
            Camera.SetOrientation Camera, -Sin5, 0, Cos5, 0, 1, 0
        ' One step ahead (in the view direction)
        Case vbKeyUp
            Camera.SetPosition Camera, 0, 0, 1!
        ' Rotate right
        Case vbKeyRight
            Camera.SetOrientation Camera, Sin5, 0, Cos5, 0, 1, 0
        ' One step back
        Case vbKeyDown
            Camera.SetPosition Camera, 0, 0, -1
        ' Look down (to fix)
        Case vbKeyPageDown
            Camera.SetOrientation Camera, 0, -Sin5, Cos5, 0, Cos5, 0
        ' Look up (to fix)
        Case vbKeyPageUp
            Camera.SetOrientation Camera, 0, Sin5, Cos5, 0, Cos5, 0
        ' Reset
        Case vbKeyEnd
            Camera.SetOrientation Scene, 0, 0, 1, 0, 1, 0
        Case Else
            Exit Sub
    End Select
    UpdateScreen
    Exit Sub
' Track transient errors (where do they come from ?)
Form_KeyDown_Error:
    Debug.Print Now; " "; Err.Number; " "; Err.Description
    Resume
End Sub
Private Sub Form_Paint()
    UpdateScreen
End Sub
' Resize the viewport (fails if too large on my PC ?!)
Private Sub Form_Resize()
    If Not (Viewport Is Nothing) Then Set Viewport = Nothing
    If Not (Clipper Is Nothing) Then Set Clipper = Nothing
    DirectDrawCreateClipper 0, Clipper, Nothing
    Clipper.SetHWnd 0, hWnd
    D3DRM.CreateDeviceFromClipper Clipper, 0, ScaleWidth, ScaleHeight, Device
    D3DRM.CreateViewport Device, Camera, 0, 0, ScaleWidth, ScaleHeight, Viewport
    Device.SetDither 1
    Device.SetQuality D3DRMLIGHT_ON Or D3DRMFILL_SOLID Or D3DRMSHADE_GOURAUD
    UpdateScreen
End Sub
' Clear Direct3D Retained Mode objects
Private Sub Form_Unload(Cancel As Integer)
    Set WorldFrame = Nothing
    Set Scene = Nothing
    Set Camera = Nothing
    Set Viewport = Nothing
    Set Device = Nothing
    Set D3DRM = Nothing
    Set Clipper = Nothing
End Sub
' Update screen display
Private Sub UpdateScreen()
    On Error GoTo UpdateScreen_Error
    Viewport.Clear
    Viewport.Render Scene
    Device.Update
    Exit Sub
' Keep track of transient errors (!?)
UpdateScreen_Error:
    Debug.Print "UpdateScreen "; Now; " "; Err.Number; " "; Err.Description
    Resume
End Sub

Private Sub Form_Load()
    ' Create the Direct3D Retained Mode object
    Direct3DRMCreate D3DRM
    ' Create the scene frame
    D3DRM.CreateFrame Nothing, Scene
    ' Create the world frame
    D3DRM.CreateFrame Scene, WorldFrame
    ' Create the camera frame
    D3DRM.CreateFrame WorldFrame, Camera
    Camera.SetPosition WorldFrame, 0, 5, 0
    ' Create the light frame
    D3DRM.CreateFrame WorldFrame, LightFrame
    LightFrame.SetPosition WorldFrame, 1, 7, 1
    ' Points toward a corner (can't see spotlight if contained entirely on a face)
    LightFrame.SetOrientation WorldFrame, -1, 0, 1, 0, 1, 0
    ' Create a spotlight
    D3DRM.CreateLightRGB D3DRMLIGHT_SPOT, 1, 1, 1, Light
    Light.SetUmbra Pi / 4
    Light.SetPenumbra Pi / 3
    LightFrame.AddLight Light
    ' Add ambient light to the scene
    Dim AmbientLight As Direct3DRMLight
    D3DRM.CreateLightRGB D3DRMLIGHT_AMBIENT, 0.3, 0.3, 0.3, AmbientLight
    Scene.AddLight AmbientLight
    Set AmbientLight = Nothing
    ' Create a small world
    BuildWorld
End Sub
