Attribute VB_Name = "modCreateGUID"
' modCreateGUID - Create a Globally Unique Identifier (GUID)
' 1997/07/11 Copyright  1997, Larry Rebich, The Bridge, Inc.
'
' Samples:
'   {3201047B-FA1C-11D0-B3F9-004445535400}
'   {0547C3D5-FA24-11D0-B3F9-004445535400}

    Option Explicit
    DefLng A-Z

    ' The following is from Topic: Windows Conferencing API, GUID, MSDN April 1997
    ' typedef struct _GUID {
    '    unsigned long Data1;
    '    unsigned short Data2;
    '    unsigned short Data3;
    '    unsigned char Data4[8];
    '} GUID;
    '
    'Holds a globally unique identifier (GUID), which identifies a particular _
     object class and interface. This identifier is a 128-bit value.
    '
    'For more information about GUIDs, see the Remote Procedure Call (RPC) _
     documentation or the OLE Programmer's Reference.
    '
    'Use the guidgen.exe utility to generate new values.
    'See also CONFDEST, CONFGUID, CONFNOTIFY
    ' 1997 Microsoft Corporation

    Private Type GUID
        Data1 As Long
        Data2 As Integer
        Data3 As Integer
        Data4(0 To 7) As String * 1
    End Type
    
    Declare Function CoCreateGuid Lib "ole32.dll" (tGUIDStructure As GUID) As Long
    
    Const mciLen As Integer = 4     'each part's length

Public Function CreateGUID() As String
    Dim sGUID   As String       'store result here
    Dim tGUID   As GUID         'get into this structure
    If CoCreateGuid(tGUID) = 0 Then 'use API to get the GUID
        With tGUID              'build return string
            sGUID = "{" & PadLeft(Hex(.Data1), mciLen * 2) & "-"
            sGUID = sGUID & PadLeft(Hex(.Data2), mciLen) & "-"
            sGUID = sGUID & PadLeft(Hex(.Data3), mciLen) & "-"
            sGUID = sGUID & FormatGUIDData4(.Data4())
        End With
        sGUID = sGUID & "}"     'ending brace
        CreateGUID = sGUID
    End If
End Function

Private Function FormatGUIDData4(aryData4() As String * 1) As String
    Dim i       As Integer      'loop thru the array
    Dim sGUID   As String       'store result here
    Dim sTemp1  As String       'first part here
    Dim sTemp2  As String       'second part here
    For i = LBound(aryData4()) To UBound(aryData4())   'process string array
        If i < 2 Then           'first part
            sTemp1 = sTemp1 & Hex(Asc(aryData4(i)))
        Else                    'second part
            sTemp2 = sTemp2 & Hex(Asc(aryData4(i)))
        End If
    Next
    sGUID = PadLeft(sTemp1, mciLen) & "-" & PadLeft(sTemp2, mciLen * 3) 'pad left with zeros
    FormatGUIDData4 = sGUID                     'return what we created
End Function

Private Function PadLeft(sString As String, iLen As Integer) As String
' Pad with left zreos if needed
    Dim sTemp As String
    sTemp = Right$(String$(iLen, "0") & sString, iLen)
    PadLeft = sTemp
End Function
