VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CWaitCursor"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'WaitCursor - Wait cursor class demo
'Copyright (c) 1997 SoftCircuits Programming (R)
'Redistributed by Permission.
'
'This Visual Basic 5.0 example program demonstrates how you can use
'a simple class to help you set an hourglass cursor. This class not
'only provides the SetCursor method, which provides a convenient
'method of setting the hourglass cursor (or a custom cursor if you
'like), but it automatically restores the previous cursor when the
'class object is destroyed.
'
'Declare your CWaitCursor object within a subroutine:
'
' Private Sub MySub()
'     Dim wait As New CWaitCursor
'     wait.SetCursor
'
'     'Perform lengthy tasks here
'
' End Sub
'
'Although you can call the Restore method to restore the previous
'cursor, it is not necessary. CWaitCursor guarantees that the cursor
'will be restored when the subroutine terminates, even if the
'subroutine terminates due to an unhandled run-time error!
'
'This program may be distributed on the condition that it is
'distributed in full and unchanged, and that no fee is charged for
'such distribution with the exception of reasonable shipping and media
'charged. In addition, the code in this program may be incorporated
'into your own programs and the resulting programs may be distributed
'without payment of royalties.
'
'This example program was provided by:
' SoftCircuits Programming
' http://www.softcircuits.com
' P.O. Box 16262
' Irvine, CA 92623
Option Explicit

Private m_nPointer As MousePointerConstants

Public Sub SetCursor(Optional nPointer As MousePointerConstants = vbHourglass)
    Screen.MousePointer = nPointer
End Sub

Public Sub Restore()
    Screen.MousePointer = m_nPointer
End Sub

Private Sub Class_Initialize()
   m_nPointer = Screen.MousePointer
End Sub

Private Sub Class_Terminate()
    Restore
End Sub
