VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CWordWrap"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'WordWrap - Printing-with-word-wrap demo for Visual Basic 5
'Copyright (c) 1994-97 SoftCircuits Programming (R)
'Redistributed by Permission.
'
'This demo program demonstrates a technique for printing unformated
'text to the printer. The code is implemented as a class module to
'make it easy to reuse the code in other projects. The code prints the
'text to the printer with word wrap, margins and page headers and
'footers. You can customize the margin settings and header text using
'the class's public members.
'
'Note: The page margins implemented by this code are only close
'approximations and do not take into account the edge of the page that
'the printer cannot print to. For more precise control over margin
'sizes, use GetDeviceCaps to determine the physical page offsets and
'adjust margins accordingly.
'
'At the time this demo was put together, SoftCircuits was working on
'an enhanced version of this code that would be implemented as a VB
'control. This enhanced version will most likely not be free but, if
'you find youself needing better support for text printing, you might
'want to stop by our web site and see what we have to offer.
'
'This program may be distributed on the condition that it is
'distributed in full and unchanged, and that no fee is charged for
'such distribution with the exception of reasonable shipping and media
'charged. In addition, the code in this program may be incorporated
'into your own programs and the resulting programs may be distributed
'without payment of royalties.
'
'This example program was provided by:
' SoftCircuits Programming
' http://www.softcircuits.com
' P.O. Box 16262
' Irvine, CA 92623
Option Explicit

'Default margin values
Private Const MARGIN_LEFT = 720
Private Const MARGIN_RIGHT = 720
Private Const MARGIN_TOP = 1440
Private Const MARGIN_BOTTOM = 1440

'Modifiable parameters
Private m_HeaderText As String
Private m_MarginLeft As Single
Private m_MarginTop As Single
Private m_MarginRight As Single
Private m_MarginBottom As Single

Public Property Let HeaderText(sText As String)
    m_HeaderText = sText
End Property

Public Property Get HeaderText() As String
    HeaderText = m_HeaderText
End Property

'***
'*** Note: Margins are only close approximations
'*** and do not take into account the edge of the
'*** page that the printer cannot print to. For
'*** more precise control over margin sizes, use
'*** GetDeviceCaps to determine the physical page
'*** offsets and adjust margins accordingly.
'***
Public Property Let MarginLeft(nMargin As Single)
    m_MarginLeft = nMargin
End Property

Public Property Get MarginLeft() As Single
    MarginLeft = m_MarginLeft
End Property

Public Property Let MarginTop(nMargin As Single)
    m_MarginTop = nMargin
End Property

Public Property Get MarginTop() As Single
    MarginTop = m_MarginTop
End Property

Public Property Let MarginRight(nMargin As Single)
    m_MarginRight = nMargin
End Property

Public Property Get MarginRight() As Single
    MarginRight = m_MarginRight
End Property

Public Property Let MarginBottom(nMargin As Single)
    m_MarginBottom = nMargin
End Property

Public Property Get MarginBottom() As Single
    MarginBottom = m_MarginBottom
End Property

'Public method to print text
Public Sub PrintText(sText As String)
    Dim i As Integer, j As Integer, sCurrWord As String

    Screen.MousePointer = vbHourglass
    'Initialize first page
    DoNewPage False
    'Print text, word-wrapping as we go
    i = 1
    Do Until i > Len(sText)
        'Get next word
        sCurrWord = ""
        Do Until i > Len(sText) Or Mid$(sText, i, 1) <= " "
            sCurrWord = sCurrWord & Mid$(sText, i, 1)
            i = i + 1
        Loop
        'Check if word will fit on this line
        If (Printer.CurrentX + Printer.TextWidth(sCurrWord)) > (Printer.ScaleWidth - m_MarginRight) Then
            'Send carriage-return line-feed to printer
            Printer.Print
            'Check if we need to start a new page
            If Printer.CurrentY > (Printer.ScaleHeight - m_MarginBottom) Then
                DoNewPage
            Else
                Printer.CurrentX = m_MarginLeft
            End If
        End If
        'Print this word
        Printer.Print sCurrWord;
        'Process whitespace and any control characters
        Do Until i > Len(sText) Or Mid$(sText, i, 1) > " "
            Select Case Mid$(sText, i, 1)
                Case " "        'Space
                    Printer.Print " ";
                Case Chr$(10)   'Line-feed
                    'Send carriage-return line-feed to printer
                    Printer.Print
                    'Check if we need to start a new page
                    If Printer.CurrentY > (Printer.ScaleHeight - m_MarginBottom) Then
                        DoNewPage
                    Else
                        Printer.CurrentX = m_MarginLeft
                    End If
                Case Chr$(9)    'Tab
                    j = (Printer.CurrentX - MARGIN_LEFT) / Printer.TextWidth("0")
                    j = j + (10 - (j Mod 10))
                    Printer.CurrentX = MARGIN_LEFT + (j * Printer.TextWidth("0"))
                Case Else       'Ignore other characters
            End Select
            i = i + 1
        Loop
    Loop
    Printer.EndDoc
    Screen.MousePointer = vbDefault
End Sub

'Prints page header and footer
Private Sub DoNewPage(Optional bEjectPage As Boolean = True)
    Dim Buff As String

    'Start new page if requested
    If bEjectPage Then
        Printer.NewPage
    End If
    'Print page header
    Printer.CurrentY = (m_MarginTop - Printer.TextHeight(m_HeaderText)) / 2
    Printer.CurrentX = (Printer.ScaleWidth - Printer.TextWidth(m_HeaderText)) / 2
    Printer.Print m_HeaderText;
    'Print page footer
    Buff = Format$(Date$, "Short Date")
    Printer.CurrentX = m_MarginLeft
    Printer.CurrentY = Printer.ScaleHeight - (m_MarginBottom / 2)
    Printer.Print Buff;
    Buff = "Page " & CStr(Printer.Page)
    Printer.CurrentX = Printer.ScaleWidth - (Printer.TextWidth(Buff) + m_MarginRight)
    Printer.CurrentY = Printer.ScaleHeight - (m_MarginBottom / 2)
    Printer.Print Buff;
    'Reset position to top of page
    Printer.CurrentX = m_MarginLeft
    Printer.CurrentY = m_MarginTop
End Sub

Private Sub Class_Initialize()
    'Set default properties
    m_MarginLeft = MARGIN_LEFT
    m_MarginRight = MARGIN_RIGHT
    m_MarginTop = MARGIN_TOP
    m_MarginBottom = MARGIN_BOTTOM
    m_HeaderText = "CWordWrap Class"
End Sub
