VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "SocketWrench Finger"
   ClientHeight    =   4050
   ClientLeft      =   1905
   ClientTop       =   1950
   ClientWidth     =   7095
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   8.25
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   4740
   Left            =   1845
   LinkTopic       =   "Form1"
   ScaleHeight     =   4050
   ScaleWidth      =   7095
   Top             =   1320
   Width           =   7215
   Begin TextBox FingerOutput 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Courier New"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   2655
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   4
      TabStop         =   0   'False
      Top             =   600
      Width           =   6855
   End
   Begin TextBox UserName 
      Height          =   285
      Left            =   4440
      TabIndex        =   3
      Top             =   120
      Width           =   2535
   End
   Begin TextBox HostName 
      Height          =   285
      Left            =   840
      TabIndex        =   1
      Top             =   120
      Width           =   2535
   End
   Begin Socket Socket1 
      AutoResolve     =   -1  'True
      Backlog         =   1
      Binary          =   -1  'True
      Blocking        =   -1  'True
      Broadcast       =   0   'False
      BufferSize      =   0
      HostAddress     =   ""
      HostFile        =   ""
      HostName        =   ""
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   120
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Protocol        =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SocketType      =   1
      Timeout         =   0
      Top             =   3480
   End
   Begin CommandButton FingerButton 
      Caption         =   "Finger"
      Default         =   -1  'True
      Height          =   375
      Left            =   3000
      TabIndex        =   5
      Top             =   3480
      Width           =   1215
   End
   Begin Label Label2 
      BackStyle       =   0  'Transparent
      Caption         =   "&Username:"
      Height          =   255
      Left            =   3480
      TabIndex        =   2
      Top             =   120
      Width           =   975
   End
   Begin Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "&System:"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   735
   End
   Begin Menu FileMenu 
      Caption         =   "&File"
      Begin Menu ExitApp 
         Caption         =   "E&xit"
      End
   End
End
Option Explicit

Sub ExitApp_Click ()
    Unload Form1
End Sub

Sub FingerButton_Click ()
    Dim sHostName As String

    sHostName = Trim$(HostName.Text)
    If Len(sHostName) = 0 Then
        MsgBox "A system name must be entered"
        HostName.SetFocus
        Exit Sub
    End If

    If Len(Trim$(UserName.Text)) = 0 Then
        MsgBox "A user name must be entered"
        UserName.SetFocus
        Exit Sub
    End If

    '
    ' Initialize the socket control
    '
    Socket1.AddressFamily = AF_INET
    Socket1.Binary = False
    Socket1.Blocking = False
    Socket1.BufferSize = 1024
    Socket1.LocalPort = IPPORT_ANY
    Socket1.Protocol = IPPROTO_IP
    Socket1.SocketType = SOCK_STREAM
    Socket1.RemotePort = IPPORT_FINGER
    
    Form1.MousePointer = 11 ' Hourglass

    On Error GoTo Failed
    Socket1.HostName = sHostName
    Socket1.Action = SOCKET_CONNECT
    Socket1.Interval = 60000
    On Error GoTo 0

    FingerButton.Enabled = False
    Exit Sub

Failed:
    Form1.MousePointer = 0 ' Default
    MsgBox "Unable to connect to remote host", 48, "Finger"
    Exit Sub

End Sub

Sub Form_Unload (Cancel As Integer)
    If Socket1.Connected Then Socket1.Action = SOCKET_CLOSE
    End
End Sub

Sub Hostname_Change ()
    If Len(HostName.Text) > 0 And Len(UserName.Text) > 0 Then
        FingerButton.Enabled = True
    Else
        FingerButton.Enabled = False
    End If
End Sub

Sub Hostname_GotFocus ()
    HostName.SelStart = 0
    HostName.SelLength = Len(HostName.Text)
End Sub

Sub Socket1_Connect ()
    Dim sUserName As String

    FingerOutput.Text = ""
    sUserName = Trim$(UserName.Text) + Chr$(13) + Chr$(10)
    Socket1.SendLen = Len(sUserName)
    Socket1.SendData = sUserName
End Sub

Sub Socket1_Disconnect ()
    Socket1.Action = SOCKET_CLOSE
    
    FingerButton.Enabled = True
    Form1.MousePointer = 0 ' Default
    HostName.SetFocus
End Sub

Sub Socket1_Read (DataLength As Integer, IsUrgent As Integer)
    FingerOutput.SelStart = 65535
    FingerOutput.SelLength = 0
    
    Socket1.RecvLen = DataLength
    FingerOutput.SelText = Socket1.RecvData
End Sub

Sub Socket1_Timer ()
    Socket1.Interval = 0
    MsgBox "Unable to connect to remote host", 48, "Finger"
    Socket1_Disconnect
End Sub

Sub UserName_Change ()
    If Len(HostName.Text) > 0 And Len(UserName.Text) > 0 Then
        FingerButton.Enabled = True
    Else
        FingerButton.Enabled = False
    End If
End Sub

