VERSION 2.00
Begin Form frmAnimate 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Lumier's Cinema"
   ClientHeight    =   3696
   ClientLeft      =   1140
   ClientTop       =   2028
   ClientWidth     =   4716
   Height          =   4140
   Left            =   1080
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3696
   ScaleWidth      =   4716
   Top             =   1644
   Width           =   4836
   Begin MetaDRAW MDraw 
      Prop110         =   ANIMATE.FRX:0000
      BackColor       =   &H00808080&
      FillColor       =   &H0000FF00&
      FontName        =   "System"
      FontSize        =   0
      Height          =   3132
      Left            =   120
      LineColor       =   &H000000FF&
      LineWidth       =   0
      MouseCursor     =   ANIMATE.FRX:0002
      OrigHeight      =   5760
      OrigWidth       =   5760
      picXSize        =   5760
      picYSize        =   5760
      ScrollBars      =   0  'No scrollers
      ScrollCheck     =   0   'False
      ScrollMouse     =   0   'False
      TabIndex        =   10
      TextColor       =   &H00800000&
      Top             =   120
      Width           =   3252
   End
   Begin VScrollBar scrZoom 
      Height          =   1356
      LargeChange     =   100
      Left            =   3648
      Max             =   400
      Min             =   50
      SmallChange     =   50
      TabIndex        =   3
      Top             =   1344
      Value           =   100
      Width           =   300
   End
   Begin CommandButton btnQuit 
      Caption         =   "&Quit"
      Height          =   375
      Left            =   3555
      TabIndex        =   6
      Top             =   2880
      Width           =   870
   End
   Begin VScrollBar scrSpeed 
      Height          =   1356
      LargeChange     =   100
      Left            =   4128
      Max             =   1
      Min             =   400
      SmallChange     =   10
      TabIndex        =   5
      Top             =   1344
      Value           =   50
      Width           =   300
   End
   Begin Timer MyTimer 
      Enabled         =   0   'False
      Left            =   4320
      Top             =   3264
   End
   Begin PictureBox picBat 
      Enabled         =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.6
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   390
      Left            =   3360
      Picture         =   ANIMATE.FRX:0004
      ScaleHeight     =   372
      ScaleWidth      =   384
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   3168
      Visible         =   0   'False
      Width           =   405
   End
   Begin CommandButton btnStop 
      Caption         =   "S&top"
      Height          =   375
      Left            =   3510
      TabIndex        =   1
      Top             =   540
      Width           =   915
   End
   Begin CommandButton btnStart 
      Caption         =   "&Start"
      Height          =   375
      Left            =   3510
      TabIndex        =   0
      Top             =   90
      Width           =   915
   End
   Begin PictureBox picHor 
      Enabled         =   0   'False
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   9.6
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   390
      Left            =   3840
      Picture         =   ANIMATE.FRX:28DA
      ScaleHeight     =   372
      ScaleWidth      =   384
      TabIndex        =   8
      TabStop         =   0   'False
      Top             =   3168
      Visible         =   0   'False
      Width           =   405
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Double-click mouse  to change picture"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   7.8
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   300
      Left            =   192
      TabIndex        =   9
      Top             =   3360
      Width           =   3984
   End
   Begin Label txtSpeed 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "S&peed"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   7.8
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   300
      Left            =   4032
      TabIndex        =   4
      Top             =   1056
      Width           =   588
   End
   Begin Label txtZoom 
      Alignment       =   2  'Center
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Zoom"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   7.8
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   300
      Left            =   3360
      TabIndex        =   2
      Top             =   1056
      Width           =   684
   End
End
Option Explicit

Dim timStr As Long
Dim nxtObj As Long
Dim cenX As Integer, cenY As Integer
Dim incX As Single, incY As Single
Dim TimerType As Integer, btnType As Integer
Dim picType As Integer

Const MAX_COUNT = 200

Declare Function GetTickCount Lib "User" () As Long

Sub AdjustView (Zm As Single)
    MDraw.Redraw = False
    MDraw.picXSize = MDraw.OrigWidth * Zm
    MDraw.picYSize = MDraw.OrigHeight * Zm
    MDraw.picXOfs = MDraw.picXSize / 2 - (MDraw.Width - Screen.TwipsPerPixelX) / 2
    MDraw.picYOfs = MDraw.picYSize / 2 - (MDraw.Height - Screen.TwipsPerPixelY) / 2
    MDraw.Redraw = True
    cenX = MDraw.picLeft + MDraw.picWidth / 2
    cenY = MDraw.picTop + MDraw.picHeight / 2
End Sub

Sub Animate ()
    If (MDraw.Current <> OBJ_NULL) Then
      MDraw.ObjVisible = False
      MDraw.ObjMove = MOVE_NEXT
    End If
    If (MDraw.Current = OBJ_NULL) Then
        MDraw.ObjMove = MOVE_CONT_FIRST
    End If
    MDraw.ObjVisible = True
End Sub

Sub btnQuit_Click ()
    'SavePicture MDraw.Picture, "hor.wmf"
    Unload Me
End Sub

Sub btnStart_Click ()
    MDraw.EditMode = 0
    MDraw.ObjMove = MOVE_CONT_FIRST
    btnType = 2
    MoveStart 0, 0
    MyTimer.Interval = 10
End Sub

Sub btnStop_Click ()
    AdjustView 1#
    MDraw.ObjMove = MOVE_CONT_FIRST
    btnType = 0
    MoveStart 0, 0
    MyTimer.Interval = 10
    MDraw.EditMode = ED_SELECT
End Sub

Sub Form_Activate ()
    MyTimer.Interval = scrSpeed.Value
End Sub

Sub Form_DblClick ()
    InitPicture (scrZoom.Value)
    btnStart_Click
End Sub

Sub Form_Load ()
    picType = -1
    btnType = -1
    TimerType = 0
    InitPicture (100)
End Sub

Sub Form_Unload (Cancel As Integer)
    End
End Sub

Sub InitPicture (Zm As Integer)
    Select Case picType
    Case 1
      picHor.Picture = MDraw.Picture
      MDraw.Picture = picBat.Picture
      picType = 0
    Case Else
      If picType = 0 Then picBat.Picture = MDraw.Picture
      MDraw.Picture = picHor.Picture
      picType = 1
    End Select
    AdjustView Zm / 100#
    MDraw.ObjMove = MOVE_CONT_FIRST
End Sub

Sub MDraw_DblClick ()
    InitPicture (scrZoom.Value)
    If TimerType > 0 Then btnStart_Click
End Sub

Sub MoveObject ()
    Dim ofsX As Integer, ofsY As Integer
    Dim timCur As Long
    timCur = GetTickCount() - timStr
    If (timCur > MAX_COUNT) Then timCur = MAX_COUNT
    If (btnType = 2) Then
      ofsX = cenX - (MAX_COUNT - timCur) * incX
      ofsY = cenY - (MAX_COUNT - timCur) * incY
    Else
      ofsX = cenX - timCur * incX
      ofsY = cenY - timCur * incY
    End If
    ofsX = ofsX - (MDraw.ObjLeft + MDraw.ObjRight) / 2
    ofsY = ofsY - (MDraw.ObjTop + MDraw.ObjBottom) / 2
    MD_MoveObjects MDraw, ofsX, ofsY, CRD_CHANGE
    If (timCur = MAX_COUNT) Then TimerType = 3
End Sub

Sub MoveStart (ByVal strX As Integer, ByVal strY As Integer)
    If (strX = 0) Then strX = (MDraw.ObjLeft + MDraw.ObjRight) / 2
    If (strY = 0) Then strY = (MDraw.ObjTop + MDraw.ObjBottom) / 2
    If (strX <> cenX) Or (strY <> cenY) Then
      incX = (cenX - strX) / MAX_COUNT
      incY = (cenY - strY) / MAX_COUNT
      TimerType = 1
    Else
      TimerType = 3
      MyTimer_Timer
    End If
    If MDraw.Current <> OBJ_NULL Then
      MDraw.ObjVisible = True
      timStr = GetTickCount()
      MyTimer.Enabled = True
    End If
End Sub

Sub MyTimer_Timer ()
    Select Case TimerType
    Case 0  ' Stop mode
        MyTimer.Enabled = False
    Case 1  ' Move object
        MoveObject
    Case 2  ' Animate
        Animate
    Case 3
        If btnType = 2 Then MDraw.ObjVisible = False
        MDraw.ObjMove = MOVE_NEXT
        If MDraw.Current = OBJ_NULL Then
            MyTimer.Interval = scrSpeed.Value
            TimerType = btnType
        Else
            If btnType = 2 Then
                MoveStart 0, 0
            Else
                MoveStart MDraw.picLeft + Rnd * MDraw.picWidth, MDraw.picTop + Rnd * MDraw.picHeight
            End If
        End If
    End Select
End Sub

Sub scrSpeed_Change ()
    MyTimer.Interval = scrSpeed.Value
End Sub

Sub scrZoom_Change ()
    AdjustView scrZoom.Value / 100
End Sub

Sub scrZoom_Scroll ()
    AdjustView scrZoom.Value / 100
End Sub

