VERSION 2.00
Begin Form frmCreate 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Add objects demo"
   ClientHeight    =   4512
   ClientLeft      =   1428
   ClientTop       =   1104
   ClientWidth     =   5172
   Height          =   4956
   KeyPreview      =   -1  'True
   Left            =   1368
   LinkTopic       =   "Form1"
   ScaleHeight     =   4512
   ScaleWidth      =   5172
   Top             =   720
   Width           =   5292
   Begin MetaDRAW MDraw 
      Prop110         =   CREATE.FRX:0000
      BackColor       =   &H00808080&
      EditMode        =   11  'Select objects
      FillColor       =   &H0000FF00&
      FontName        =   "Times New Roman"
      FontSize        =   0
      Height          =   3372
      Left            =   120
      LineColor       =   &H000000FF&
      LineWidth       =   0
      MarkerSize      =   0
      MouseCursor     =   CREATE.FRX:0002
      OrigHeight      =   3348
      OrigWidth       =   4908
      PictureImage    =   CREATE.FRX:0004
      picXSize        =   4908
      picYSize        =   3348
      ScrollBars      =   0  'No scrollers
      ScrollCheck     =   0   'False
      ScrollMouse     =   0   'False
      TabIndex        =   6
      TextColor       =   &H00800000&
      Top             =   120
      Width           =   4932
   End
   Begin CommandButton btnBounds 
      Caption         =   "&Bounds"
      Height          =   375
      Left            =   4140
      TabIndex        =   4
      Top             =   3600
      Width           =   825
   End
   Begin CommandButton btnChange 
      Caption         =   "&Attrib"
      Height          =   375
      Left            =   3168
      TabIndex        =   3
      Top             =   3600
      Width           =   825
   End
   Begin ComboBox lstType 
      Height          =   300
      Left            =   90
      Style           =   2  'Dropdown List
      TabIndex        =   0
      Top             =   3600
      Width           =   1815
   End
   Begin CommandButton btnClear 
      Caption         =   "&Clear"
      Height          =   375
      Left            =   2070
      TabIndex        =   2
      Top             =   4050
      Width           =   825
   End
   Begin CommandButton btnQuit 
      Caption         =   "&Quit"
      Height          =   375
      Left            =   3510
      TabIndex        =   5
      Top             =   4050
      Width           =   1095
   End
   Begin CommandButton btnAdd 
      Caption         =   "&New"
      Height          =   375
      Left            =   2070
      TabIndex        =   1
      Top             =   3600
      Width           =   825
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "# objects:"
      Height          =   300
      Left            =   192
      TabIndex        =   8
      Top             =   4032
      Width           =   876
   End
   Begin Label lblInfo 
      BackColor       =   &H00C0C0C0&
      Caption         =   "0"
      Height          =   300
      Left            =   1152
      TabIndex        =   7
      Top             =   4032
      Width           =   492
   End
End
Option Explicit

Sub btnAdd_Click ()
    Dim Typ As Integer
    Dim X1 As Integer, X2 As Integer
    Dim Y1 As Integer, Y2 As Integer
    MDraw.Current = OBJ_CONTAINER
    MDraw.ObjSelected = False
    X1 = Int(Rnd * MDraw.picWidth): X2 = Int(Rnd * MDraw.picWidth)
    Y1 = Int(Rnd * MDraw.picHeight): Y2 = Int(Rnd * MDraw.picHeight)
    If Abs(X2 - X1) < MDraw.picWidth / 20 Then
      X1 = X2 - MDraw.picWidth / 20
      If (X1 < MDraw.picLeft) Then
	X1 = MDraw.picLeft: X2 = MDraw.picWidth / 20
      End If
    End If
    If Abs(Y2 - Y1) < MDraw.picHeight / 20 Then
      Y1 = Y2 - MDraw.picHeight / 20
      If (Y1 < MDraw.picTop) Then
	Y1 = MDraw.picTop: Y2 = MDraw.picHeight / 20
      End If
    End If
    Typ = lstType.ListIndex + 1: If Typ = 11 Then Typ = 12
    MDraw.AddItem X1 & " " & Y1 & " " & X2 & " " & Y2, Typ
    
    Select Case Typ
    Case OT_TEXT
      MDraw.Text = "Simple Text"
      MDraw.FontSize = Rnd * MDraw.picHeight / 10 + MDraw.picHeight / 20
    Case OT_ROUNDRECT
      Dim Arr As VB_POINT
      Arr.x = Int(Rnd * Abs(MDraw.ObjRight - MDraw.ObjLeft))
      Arr.y = Int(Rnd * Abs(MDraw.ObjBottom - MDraw.ObjTop))
      MD_SetParams MDraw, 0, 1, Arr, CRD_LOGIC
    Case OT_ARC, OT_PIE, OT_CHORD
      ReDim Arr1(1) As VB_POINT
      Arr1(0).x = Int(Rnd * MDraw.picWidth / 2)
      Arr1(0).y = Int(Rnd * MDraw.picHeight / 2)
      Arr1(1).x = Int(Rnd * MDraw.picWidth / 2)
      Arr1(1).y = Int(Rnd * MDraw.picHeight / 2)
      MD_SetParams MDraw, 0, 2, Arr1(0), CRD_LOGIC
    Case OT_POLYLINE
      Dim sz%, i%
      sz% = Int(Rnd * MDraw.picWidth / 4) + 2
      ReDim Arr2(sz%) As VB_POINT
      For i% = 0 To sz%
	Arr2(i%).x = i * MDraw.picWidth / sz%
	Arr2(i%).y = Int(Rnd * MDraw.picHeight)
      Next i%
      Call MD_SetParams(MDraw, 0, sz% + 1, Arr2(0), CRD_LOGIC)
    Case OT_POLYGON
      ReDim Arr3(50) As VB_POINT
      sz% = Int(Rnd * 48) + 2
      For i% = 0 To sz%
	Arr3(i%).x = Int(Rnd * MDraw.picWidth)
	Arr3(i%).y = Int(Rnd * MDraw.picHeight)
      Next i%
      MD_SetParams MDraw, 2, sz%, Arr3(0), (CRD_LOGIC Or CRD_ADD)
    End Select
End Sub

Sub btnBounds_Click ()
    On Error Resume Next
    Dim bnd As VB_RECT, Res As Integer
    If MDraw.ObjCount(OBJ_SELECTED) > 0 Then
      MDraw.ObjMove = MOVE_SEL_FIRST
    Else
      MDraw.ObjMove = MOVE_CONT_LAST
    End If
    bnd.left = Int(Rnd * MDraw.picWidth)
    bnd.right = Int(Rnd * MDraw.picWidth)
    bnd.top = Int(Rnd * MDraw.picHeight)
    bnd.bottom = Int(Rnd * MDraw.picHeight)
    If Abs(bnd.right - bnd.left) < MDraw.picWidth / 15 Then
      bnd.right = bnd.left + MDraw.picWidth / 15
    End If
    If Abs(bnd.bottom - bnd.top) < MDraw.picHeight / 15 Then
      bnd.bottom = bnd.top + MDraw.picHeight / 15
    End If
    MD_SetBounds MDraw, bnd, CRD_CHANGE
End Sub

Sub btnChange_Click ()
    On Error Resume Next
    If (MDraw.ObjCount(OBJ_SELECTED) > 0) Then
      MDraw.Current = OBJ_SELECTED
    Else
      MDraw.ObjMove = MOVE_CONT_LAST
    End If
    MDraw.BackStyle = Int(Rnd + .5)
    MDraw.BackColor = Int(Rnd * &H1000000)
    MDraw.LineStyle = Int(Rnd * 7)
    MDraw.LineWidth = Int(Rnd * 20)
    MDraw.LineColor = Int(Rnd * &H1000000)
    MDraw.TextColor = Int(Rnd * &H1000000)
    MDraw.FillColor = Int(Rnd * &H1000000)
End Sub

Sub btnClear_Click ()
    MDraw.Clear
    lblInfo.Caption = "0"
End Sub

Sub btnQuit_Click ()
    Unload Me
End Sub

Sub Form_Load ()
    Randomize
    lstType.Clear
    lstType.AddItem " 1 - Line"
    lstType.AddItem " 2 - Rectangle"
    lstType.AddItem " 3 - RoundRect"
    lstType.AddItem " 4 - Ellipse"
    lstType.AddItem " 5 - Arc"
    lstType.AddItem " 7 - Pie"
    lstType.AddItem " 6 - Chord"
    lstType.AddItem " 8 - Polyline"
    lstType.AddItem " 9 - Polygon"
    lstType.AddItem "10 - Text"
    lstType.AddItem "12 - Image"
    lstType.ListIndex = 1
End Sub

Sub MDraw_Change (ChangeType As Integer)
    If ChangeType = CHG_OBJECTADD Then
      lblInfo.Caption = MDraw.ObjCount(OBJ_CONTAINER)
    End If
End Sub

